/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.run;

import com.nvidia.common.util.OS;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperJob;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.run.Runner;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;

public class RebelRunner
extends Runner {
    public RebelRunner(Session session) {
        super(session);
    }

    @Override
    public boolean runWithJob() {
        this.showConsole();
        this.job = new RebelJob("Run Rebel");
        this.job.schedule();
        return true;
    }

    @Override
    public IStatus runWithMonitor(IProgressMonitor monitor) {
        try {
            final Executable exec = this.session.getExecutable();
            ITimelineInterval kernel = this.session.getAnalysis().getActiveScopeInterval();
            SessionFilter filter = new SessionFilter(kernel, this.session);
            String args = filter.getRebelCommandLine();
            SubProgressMonitor launchProgress = new SubProgressMonitor(monitor, 4){

                public void beginTask(String name, int totalWork) {
                }

                public void setTaskName(String name) {
                    super.setTaskName(name);
                }

                public void subTask(String name) {
                    super.subTask(exec.getProgressSubMessage());
                }
            };
            if (System.getenv("VIPER_DEBUG") != null) {
                System.out.println("rebel: " + args);
            }
            FileSystem fs = FileSystem.getFilesystem(exec.getConnectionName());
            File file = fs.runRebelCommandLine(exec, args, "profile", (IProgressMonitor)launchProgress);
            if (launchProgress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (file == null || !file.exists()) {
                throw new ViperException(ViperMessages.ErrorNoReport);
            }
            monitor.worked(1);
            monitor.subTask("Collecting results...");
            this.session.addRebelReport(filter, file.getPath());
            RebelRunner.launchRebelUI(monitor, file);
        }
        catch (ViperException | IOException | CoreException e) {
            ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, ViperMessages.Launch_Fail_Message, (Exception)e);
        }
        return Status.OK_STATUS;
    }

    public static void launchRebelUI(IProgressMonitor monitor, File file) throws IOException, ViperException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        File rebelUI = null;
        try {
            rebelUI = NativeUtils.findRebelExecutableInToolkit(Viper.REBEL_UI_EXE);
            if (rebelUI == null || !rebelUI.exists()) {
                String fileExt = OS.local().equals((Object)OS.Windows) ? ".bat" : "";
                rebelUI = FileUtils.findExecutableOnPath(Viper.REBEL_UI_EXE, fileExt);
            }
            if (rebelUI == null || !rebelUI.exists()) {
                throw new ViperException(String.format(ViperMessages.ErrorExeNotInPath, Viper.REBEL_UI_EXE));
            }
            String toolPath = rebelUI.getAbsolutePath();
            String filePath = file.getCanonicalPath();
            ILaunchConfigurationWorkingCopy workingCopy = null;
            workingCopy = type.newInstance(null, Viper.REBEL_UI_EXE);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", toolPath);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            String args = "\"" + filePath + "\"";
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
            ILaunch launch = workingCopy.launch("run", monitor);
            IProcess[] process = launch.getProcesses();
            if (process == null || process.length == 0) {
                throw new ViperException(String.format("Unable to create process %s", Viper.REBEL_UI_EXE));
            }
            IProcess[] iProcessArray = process;
            int n = process.length;
            int n2 = 0;
            while (n2 < n) {
                int retval;
                IProcess iProcess = iProcessArray[n2];
                if (iProcess.isTerminated() && (retval = iProcess.getExitValue()) != 0) {
                    ViperExceptionHandler.handle(String.valueOf(Viper.REBEL_PRODUCT_NAME) + " failed", String.format("Unable to start %s", Viper.REBEL_PRODUCT_NAME), null);
                }
                ++n2;
            }
        }
        catch (ViperException | CoreException e) {
            ViperExceptionHandler.handle(String.valueOf(Viper.REBEL_PRODUCT_NAME) + " failed", String.format("Unable to start %s", Viper.REBEL_PRODUCT_NAME), (Exception)e);
        }
    }

    private class RebelJob
    extends ViperJob {
        public RebelJob(String name) {
            super(name);
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Running " + Viper.REBEL_COMMAND_LINE_EXE, -1);
            try {
                IStatus iStatus = RebelRunner.this.runWithMonitor(monitor);
                return iStatus;
            }
            finally {
                monitor.done();
                RebelRunner.this.unlockSession(RebelRunner.this.session);
            }
        }
    }
}

