/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import java.util.Collection;
import java.util.Collections;

public class CpuThread
implements Comparable<CpuThread> {
    private int ordinal;
    private boolean isStat;
    private stats stat;
    public static int numStatThreads = 0;

    public boolean equals(Object obj) {
        if (obj instanceof CpuThread) {
            CpuThread other = (CpuThread)obj;
            return this.ordinal == other.ordinal;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.ordinal;
    }

    public boolean isStat() {
        return this.isStat;
    }

    public stats getStat() {
        return this.stat;
    }

    CpuThread(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public CpuThread(stats statistic) {
        this.stat = statistic;
        this.isStat = true;
        switch (this.stat) {
            case AVG: {
                this.ordinal = -3;
                break;
            }
            case MAX: {
                this.ordinal = -1;
                break;
            }
            case MIN: {
                this.ordinal = -2;
                break;
            }
            case TOTAL: {
                this.ordinal = -4;
                break;
            }
            default: {
                this.ordinal = -10;
            }
        }
    }

    public String getTitle() {
        if (this.isStat) {
            switch (this.stat) {
                case AVG: {
                    return "AVG";
                }
                case MAX: {
                    return "MAX";
                }
                case MIN: {
                    return "MIN";
                }
                case TOTAL: {
                    return "TOTAL";
                }
            }
            return "UNKNOWN STAT";
        }
        return "Thread " + Integer.toString(this.ordinal);
    }

    public Integer computeStat(Collection<Integer> hits) {
        if (this.isStat) {
            switch (this.stat) {
                case AVG: {
                    int avg = 0;
                    int nonzero = 0;
                    for (Integer i : hits) {
                        if (i <= 0) continue;
                        avg += i.intValue();
                        ++nonzero;
                    }
                    if (nonzero > 0) {
                        return avg / nonzero;
                    }
                    return 0;
                }
                case MAX: {
                    if (hits.isEmpty()) {
                        return 0;
                    }
                    return Collections.max(hits);
                }
                case MIN: {
                    int min = 0;
                    for (Integer i : hits) {
                        if (i > 0 && min == 0) {
                            min = i;
                        }
                        if (i <= 0 || i >= min) continue;
                        min = i;
                    }
                    return min;
                }
                case TOTAL: {
                    int sum = 0;
                    for (Integer i : hits) {
                        sum += i.intValue();
                    }
                    return sum;
                }
            }
            return 0;
        }
        return new Integer(0);
    }

    public boolean isTotal() {
        return this.stat == stats.TOTAL;
    }

    @Override
    public int compareTo(CpuThread arg0) {
        return Integer.compare(this.ordinal, arg0.ordinal);
    }

    public static enum stats {
        TOTAL,
        MAX,
        MIN,
        AVG;

    }
}

