/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultNVLink;
import com.nvidia.viper.analysis.IAnalysis;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.InstantaneousMetricManager;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import java.util.List;

public class NVLinkAnalysis
implements IAnalysis {
    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        AnalysisResultNVLink result = new AnalysisResultNVLink(AnalysisDescriptor.NVLINK_TOPOLOGY);
        List<ProfileDataModel> pdms = session.getTimelinePdms();
        if (pdms != null && !pdms.isEmpty()) {
            ProfileDataModel pdm = session.getTimelinePdms().get(0);
            long hPdm = pdm.getNativeHandle();
            try {
                int version = NativeCupti.cuptiPDMGetVersion(hPdm);
                if (version < 9) {
                    result = new AnalysisResultNVLink(AnalysisDescriptor.NVLINK_TOPOLOGY_OLD_PDM);
                } else if (pdm.nvLinks != null && !pdm.nvLinks.isEmpty()) {
                    CuptiActivityNvLink nvlinkActivity = pdm.nvLinks.iterator().next();
                    AnalysisDescriptor desc = AnalysisDescriptor.NVLINK_TOPOLOGY;
                    if (nvlinkActivity.nvswitchConnected == 1L) {
                        desc = AnalysisDescriptor.NVSWITCH_TOPOLOGY;
                    }
                    result = new AnalysisResultNVLink(desc);
                    result.setLinks(pdm.nvLinks);
                    InstantaneousMetricManager metricMngr = session.getInstantaneousMetricManager();
                    if (metricMngr != null && metricMngr.isMetricAvailable("nvlink_receive_throughput") && metricMngr.isMetricAvailable("nvlink_transmit_throughput")) {
                        ret = true;
                    }
                } else {
                    result = new AnalysisResultNVLink(AnalysisDescriptor.NVLINK_TOPOLOGY_NOT_SUPPORTED);
                }
            }
            catch (CuptiException cuptiException) {}
        }
        results.add(result);
        return ret;
    }
}

