/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.value.ValueNs;
import com.nvidia.viper.value.ValueNumber;
import com.nvidia.viper.value.ValuePercent;
import java.util.Collection;

public class AnalysisTimeData {
    private long time;
    private long totalTime;

    public AnalysisTimeData(long time, long totalTime) {
        this.time = time;
        this.totalTime = totalTime;
    }

    public long getTime() {
        return this.time;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public double getRatio() {
        if (this.totalTime == 0L) {
            return 0.0;
        }
        return (double)this.time / (double)this.totalTime;
    }

    public static double getAvgRatio(Collection<AnalysisTimeData> values) {
        double avg = 0.0;
        if (values.size() > 0) {
            for (AnalysisTimeData data : values) {
                if (data.totalTime == 0L) continue;
                avg += (double)data.time / (double)data.totalTime;
            }
            avg /= (double)values.size();
        }
        return avg;
    }

    public static long getAvgTime(Collection<AnalysisTimeData> values) {
        long avg = 0L;
        if (values.size() > 0) {
            for (AnalysisTimeData data : values) {
                avg += data.time;
            }
            avg /= (long)values.size();
        }
        return avg;
    }

    public static long getAvgTotalTime(Collection<AnalysisTimeData> values) {
        long avg = 0L;
        if (values.size() > 0) {
            for (AnalysisTimeData data : values) {
                avg += data.totalTime;
            }
            avg /= (long)values.size();
        }
        return avg;
    }

    public static ValueNumber getAvgRatioValue(Collection<AnalysisTimeData> values) {
        double avg = AnalysisTimeData.getAvgRatio(values);
        return new ValueNumber(avg);
    }

    public static ValuePercent getAvgPercentValue(Collection<AnalysisTimeData> values) {
        double avg = AnalysisTimeData.getAvgRatio(values);
        return new ValuePercent(avg * 100.0);
    }

    public static ValueNs getAvgTimeValue(Collection<AnalysisTimeData> values) {
        long avg = AnalysisTimeData.getAvgTime(values);
        return new ValueNs(avg);
    }

    public static ValueNs getAvgTotalTimeValue(Collection<AnalysisTimeData> values) {
        long avg = AnalysisTimeData.getAvgTotalTime(values);
        return new ValueNs(avg);
    }
}

