/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;

public class SortAdapter
extends SortDefinition {
    public SortAdapter(IModelAdapter adapter, Expression expr, String direction) throws AdapterException {
        this.setExpression((IScriptExpression)adapter.adaptExpression(expr));
        this.setSortDirection(SortAdapter.sortDirectionFromModel(direction));
    }

    public SortAdapter(IModelAdapter adapter, SortKeyHandle keyHandle) throws AdapterException {
        ExpressionHandle handle = keyHandle.getExpressionProperty("key");
        if (handle == null) {
            return;
        }
        ScriptExpression expr = adapter.adaptExpression((Expression)handle.getValue());
        this.setExpression((IScriptExpression)expr);
        this.setSortDirection(SortAdapter.sortDirectionFromModel(keyHandle.getDirection()));
        this.setSortStrength(keyHandle.getStrength());
        if (keyHandle.getLocale() != null) {
            this.setSortLocale(keyHandle.getLocale());
        }
    }

    public static int sortDirectionFromModel(String modelDirectionStr) {
        if ("asc".equals(modelDirectionStr)) {
            return 0;
        }
        if ("desc".equals(modelDirectionStr)) {
            return 1;
        }
        return 0;
    }
}

