/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class BasicCache<K, V>
implements Iterable<V> {
    private final Map<K, V> map = new WeakHashMap();

    protected abstract V createNew(K var1);

    public synchronized V get(K key) {
        V ref = this.map.get(key);
        if (ref != null) {
            return ref;
        }
        V newObject = this.createNew(key);
        if (newObject == null) {
            throw new IllegalStateException(String.format("Object should not be null. Key was %s", key));
        }
        this.map.put(key, newObject);
        return newObject;
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }
}

