/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    private static final String KEY_SRC = "isSource";
    private static final String KEY_PREF = "checkPreference";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (KEY_SRC.equals(property)) {
            if (receiver instanceof ITranslationUnit) {
                return ((ITranslationUnit)receiver).isSourceUnit();
            }
            if (receiver instanceof IFile) {
                IFile file = (IFile)receiver;
                return CoreModel.isValidSourceUnitName((IProject)file.getProject(), (String)file.getName());
            }
        } else if (KEY_PREF.equals(property) && expectedValue instanceof String) {
            boolean result = false;
            Pattern pat = Pattern.compile("(.*):(.*)=(.*)");
            Matcher matcher = pat.matcher((String)expectedValue);
            if (matcher.matches()) {
                String pluginId = matcher.group(1);
                String preference = matcher.group(2);
                String wantedValue = matcher.group(3);
                IEclipsePreferences node = InstanceScope.INSTANCE.getNode(pluginId);
                if (wantedValue != null) {
                    String actualValue = node.get(preference, "");
                    result = wantedValue.equals(actualValue) || wantedValue.equals("false") && actualValue.isEmpty();
                } else {
                    try {
                        result = Arrays.asList(node.keys()).contains(preference);
                    }
                    catch (BackingStoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
            return result;
        }
        return false;
    }
}

