/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionWorkingCopy;
import com.nvidia.cuda.ide.remote.internal.ui.connection.SystemType;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public final class ConnectionDetailsPane
extends Composite {
    private IObservableValue connection;
    private final Text hostName;
    private final Text label;
    private final Link link;
    private final Spinner port;
    private final ComboViewer systemType;
    private final Text user;

    private static void bind(DataBindingContext context, IObservableValue selection, PropertyDescriptor<String> property, Text text) {
        IObservableValue modelObservable = ConnectionWorkingCopy.observeConnectionProperty(selection, property);
        context.bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), modelObservable);
    }

    private static void createFiller(Composite parent) {
        Composite filler = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        filler.setLayout((Layout)layout);
        filler.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 5, 1));
    }

    public ConnectionDetailsPane(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(5, false);
        this.setLayout((Layout)gridLayout);
        ConnectionDetailsPane body = this;
        Label lblHostName = new Label((Composite)body, 0);
        lblHostName.setText("Host name:");
        this.hostName = new Text((Composite)body, 2048);
        this.hostName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Label lblUserName = new Label((Composite)body, 0);
        lblUserName.setText("User name:");
        this.user = new Text((Composite)body, 2048);
        this.user.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        ConnectionDetailsPane.createFiller(this);
        Label lblConnectionLabel = new Label((Composite)body, 0);
        lblConnectionLabel.setText("Label:");
        this.label = new Text((Composite)body, 2048);
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        ConnectionDetailsPane.createFiller(this);
        Label typeLabel = new Label((Composite)body, 0);
        typeLabel.setText("System type:");
        Combo systemTypeCombo = new Combo((Composite)body, 2056);
        systemTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.systemType = new ComboViewer(systemTypeCombo);
        this.systemType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.systemType.setInput((Object)SystemType.values());
        Label portLabel = new Label((Composite)body, 0);
        portLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        portLabel.setText("Port number:");
        this.port = new Spinner((Composite)body, 2048);
        this.port.setMaximum(65536);
        this.link = new Link((Composite)body, 0);
        this.link.setText("<a href=\"#\">Use default</a>");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDetailsPane.this.resetPort();
            }
        });
    }

    public void bind(DataBindingContext context, IObservableValue selection) {
        this.connection = selection;
        ConnectionDetailsPane.bind(context, selection, ConnectionWorkingCopy.PROPERTY_LABEL, this.label);
        ConnectionDetailsPane.bind(context, selection, ConnectionWorkingCopy.PROPERTY_HOST, this.hostName);
        ConnectionDetailsPane.bind(context, selection, ConnectionWorkingCopy.PROPERTY_USER, this.user);
        context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.systemType), ConnectionWorkingCopy.observeConnectionProperty(selection, ConnectionWorkingCopy.PROPERTY_SYSTEM_TYPE));
        context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.port), ConnectionWorkingCopy.observeConnectionProperty(selection, ConnectionWorkingCopy.PROPERTY_PORT));
        context.bindValue((IObservableValue)SWTObservables.observeVisible((Control)this.link), (IObservableValue)new IsNotDefaultPort(selection), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        DataBindingUtil.bindEnablement((DataBindingContext)context, (IObservableValue)selection, (Control[])new Control[]{this.hostName, this.label, this.user, this.port, this.systemType.getControl()});
    }

    protected void resetPort() {
        ConnectionWorkingCopy connection;
        if (this.connection != null && (connection = (ConnectionWorkingCopy)this.connection.getValue()) != null) {
            connection.setProperty(ConnectionWorkingCopy.PROPERTY_PORT, null);
        }
    }

    public boolean setFocus() {
        if (this.hostName != null && !this.hostName.isDisposed()) {
            return this.hostName.setFocus();
        }
        return super.setFocus();
    }

    private static final class IsNotDefaultPort
    extends ComputedValue {
        private final IObservableValue selection;

        private IsNotDefaultPort(IObservableValue selection) {
            super(Boolean.class);
            this.selection = selection;
        }

        protected Object calculate() {
            Object value = this.selection.getValue();
            if (value instanceof ConnectionWorkingCopy) {
                SystemType selected = ((ConnectionWorkingCopy)value).getProperty(ConnectionWorkingCopy.PROPERTY_SYSTEM_TYPE);
                Integer port = ((ConnectionWorkingCopy)value).getProperty(ConnectionWorkingCopy.PROPERTY_PORT);
                if (selected != null && !CoreUtil.equals((Object)port, (Object)selected.getDefaultPort())) {
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

