/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;

public class TOCFormatUtil {
    private HashMap<String, NumberFormatter> cachedNumberFormats = new HashMap();
    private HashMap<String, DateFormatter> cachedDateFormats = new HashMap();
    private HashMap<String, StringFormatter> cachedStringFormats = new HashMap();
    private TimeZone timeZone;
    private ULocale locale;

    public TOCFormatUtil(ULocale locale, TimeZone timeZone) {
        this.timeZone = timeZone;
        this.locale = locale;
    }

    private NumberFormatter getNumberFormatter(String format) {
        NumberFormatter formatter = this.cachedNumberFormats.get(format);
        if (formatter == null) {
            formatter = format == null ? new NumberFormatter(this.locale) : new NumberFormatter(format, this.locale);
            this.cachedNumberFormats.put(format, formatter);
        }
        return formatter;
    }

    private StringFormatter getStringFormatter(String format) {
        StringFormatter formatter = this.cachedStringFormats.get(format);
        if (formatter == null) {
            formatter = format == null ? new StringFormatter(this.locale) : new StringFormatter(format, this.locale);
            this.cachedStringFormats.put(format, formatter);
        }
        return formatter;
    }

    private DateFormatter getDateFormatter(String format) {
        DateFormatter formatter = this.cachedDateFormats.get(format);
        if (formatter == null) {
            formatter = format == null ? new DateFormatter(this.locale, this.timeZone) : new DateFormatter(format, this.locale, this.timeZone);
            this.cachedDateFormats.put(format, formatter);
        }
        return formatter;
    }

    private String getStringFormat(IScriptStyle style) {
        if (style == null) {
            return null;
        }
        return style.getStringFormat();
    }

    private String getNumberFormat(IScriptStyle style) {
        if (style == null) {
            return null;
        }
        return style.getNumberFormat();
    }

    private String getDateFormat(IScriptStyle style, Date value) {
        if (style != null) {
            return style.getDateFormat();
        }
        return null;
    }

    protected String localizeValue(Object value, IScriptStyle style) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            String format = this.getNumberFormat(style);
            NumberFormatter fmt = this.getNumberFormatter(format);
            return fmt.format((Number)value);
        }
        if (value instanceof Date) {
            String format = this.getDateFormat(style, (Date)value);
            DateFormatter fmt = this.getDateFormatter(format);
            return fmt.format((Date)value);
        }
        if (value instanceof String) {
            String format = this.getStringFormat(style);
            StringFormatter fmt = this.getStringFormatter(format);
            return fmt.format((String)value);
        }
        return value.toString();
    }
}

