/* registers.c generated by valac 0.52.3, the Vala compiler
 * generated from registers.vala, do not modify */

/* Registers facility functions

   Copyright (c) 2001-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <estr.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef guint Keystroke;

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef void (*BufferWriter) (gpointer user_data);

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

extern gint NUM_REGISTERS;
gint NUM_REGISTERS = 256;
extern ImmutableEstr* regs[256];
ImmutableEstr* regs[256] = {0};
extern glong regnum;
glong regnum = 0L;
extern Buffer* cur_bp;
extern Window* cur_wp;

gboolean insert_register (void);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
void registers_init (void);
static gboolean __lambda119_ (glong uniarg,
                       GeeQueue* args);
gboolean noarg (GeeQueue* args);
void minibuf_write (const gchar* fmt,
                    ...);
Keystroke getkey (gint delay);
#define GETKEY_DEFAULT -1
gboolean int_arg (GeeQueue* args,
                  glong* n);
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_CANCEL (KBD_CTRL | 'g')
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void minibuf_clear (void);
gboolean buffer_warn_if_no_mark (Buffer* self);
gpointer region_ref (gpointer instance);
void region_unref (gpointer instance);
GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_region (GValue* value,
                       gpointer v_object);
void value_take_region (GValue* value,
                        gpointer v_object);
gpointer value_get_region (const GValue* value);
GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
Region* region_calculate (void);
static gboolean ___lambda119__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda120_ (glong uniarg,
                       GeeQueue* args);
gboolean buffer_warn_if_readonly (Buffer* self);
void minibuf_error (const gchar* fmt,
                    ...);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _insert_register_movement_delegate (gpointer self);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
static gboolean ___lambda120__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda121_ (glong uniarg,
                       GeeQueue* args);
void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void __lambda122_ (void);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
void bprintf (const gchar* fmt,
              ...);
static void ___lambda122__buffer_writer (gpointer self);
static gboolean ___lambda121__function (glong uniarg,
                                 GeeQueue* args);

gboolean
insert_register (void)
{
	Buffer* _tmp0_;
	ImmutableEstr* _tmp1_;
	gboolean result = FALSE;
#line 27 "src/registers.vala"
	_tmp0_ = cur_bp;
#line 27 "src/registers.vala"
	_tmp1_ = regs[regnum];
#line 27 "src/registers.vala"
	buffer_insert_estr (_tmp0_, _tmp1_);
#line 28 "src/registers.vala"
	result = TRUE;
#line 28 "src/registers.vala"
	return result;
#line 349 "registers.c"
}

static gboolean
__lambda119_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	glong reg = 0L;
	gboolean result = FALSE;
#line 36 "src/registers.vala"
	ok = TRUE;
#line 37 "src/registers.vala"
	reg = (glong) 1;
#line 38 "src/registers.vala"
	if (noarg (args)) {
#line 39 "src/registers.vala"
		minibuf_write ("Copy to register: ", NULL);
#line 40 "src/registers.vala"
		reg = (glong) getkey (GETKEY_DEFAULT);
#line 369 "registers.c"
	} else {
		glong _tmp0_ = 0L;
		gboolean _tmp1_;
#line 41 "src/registers.vala"
		_tmp1_ = int_arg (args, &_tmp0_);
#line 41 "src/registers.vala"
		reg = _tmp0_;
#line 41 "src/registers.vala"
		if (!_tmp1_) {
#line 42 "src/registers.vala"
			ok = FALSE;
#line 381 "registers.c"
		}
	}
#line 44 "src/registers.vala"
	if (ok) {
#line 45 "src/registers.vala"
		if (reg == ((glong) KBD_CANCEL)) {
#line 46 "src/registers.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 390 "registers.c"
		} else {
			Buffer* _tmp2_;
#line 48 "src/registers.vala"
			minibuf_clear ();
#line 49 "src/registers.vala"
			if (reg < ((glong) 0)) {
#line 50 "src/registers.vala"
				reg = (glong) 0;
#line 399 "registers.c"
			}
#line 51 "src/registers.vala"
			reg %= (glong) NUM_REGISTERS;
#line 54 "src/registers.vala"
			_tmp2_ = cur_bp;
#line 54 "src/registers.vala"
			if (buffer_warn_if_no_mark (_tmp2_)) {
#line 55 "src/registers.vala"
				ok = FALSE;
#line 409 "registers.c"
			} else {
				Buffer* _tmp3_;
				Region* _tmp4_;
				Region* _tmp5_;
				ImmutableEstr* _tmp6_;
#line 57 "src/registers.vala"
				_tmp3_ = cur_bp;
#line 57 "src/registers.vala"
				_tmp4_ = region_calculate ();
#line 57 "src/registers.vala"
				_tmp5_ = _tmp4_;
#line 57 "src/registers.vala"
				_tmp6_ = buffer_get_region (_tmp3_, _tmp5_);
#line 57 "src/registers.vala"
				_immutable_estr_unref0 (regs[reg]);
#line 57 "src/registers.vala"
				regs[reg] = _tmp6_;
#line 57 "src/registers.vala"
				_region_unref0 (_tmp5_);
#line 429 "registers.c"
			}
		}
	}
#line 60 "src/registers.vala"
	result = ok;
#line 60 "src/registers.vala"
	return result;
#line 437 "registers.c"
}

static gboolean
___lambda119__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda119_ (uniarg, args);
#line 33 "src/registers.vala"
	return result;
#line 448 "registers.c"
}

static gboolean
_insert_register_movement_delegate (gpointer self)
{
	gboolean result;
	result = insert_register ();
#line 94 "src/registers.vala"
	return result;
#line 458 "registers.c"
}

static gboolean
__lambda120_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	glong reg = 0L;
	gboolean result = FALSE;
#line 69 "src/registers.vala"
	ok = TRUE;
#line 70 "src/registers.vala"
	_tmp0_ = cur_bp;
#line 70 "src/registers.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 71 "src/registers.vala"
		result = FALSE;
#line 71 "src/registers.vala"
		return result;
#line 479 "registers.c"
	}
#line 73 "src/registers.vala"
	reg = (glong) 1;
#line 74 "src/registers.vala"
	if (noarg (args)) {
#line 75 "src/registers.vala"
		minibuf_write ("Insert register: ", NULL);
#line 76 "src/registers.vala"
		reg = (glong) getkey (GETKEY_DEFAULT);
#line 489 "registers.c"
	} else {
		glong _tmp1_ = 0L;
		gboolean _tmp2_;
#line 77 "src/registers.vala"
		_tmp2_ = int_arg (args, &_tmp1_);
#line 77 "src/registers.vala"
		reg = _tmp1_;
#line 77 "src/registers.vala"
		if (!_tmp2_) {
#line 78 "src/registers.vala"
			ok = FALSE;
#line 501 "registers.c"
		}
	}
#line 80 "src/registers.vala"
	if (ok) {
#line 81 "src/registers.vala"
		if (reg == ((glong) KBD_CANCEL)) {
#line 82 "src/registers.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 510 "registers.c"
		} else {
			glong index = 0L;
			ImmutableEstr* _tmp3_;
#line 84 "src/registers.vala"
			minibuf_clear ();
#line 85 "src/registers.vala"
			reg %= (glong) NUM_REGISTERS;
#line 87 "src/registers.vala"
			index = reg;
#line 88 "src/registers.vala"
			_tmp3_ = regs[index];
#line 88 "src/registers.vala"
			if (_tmp3_ == NULL) {
#line 89 "src/registers.vala"
				minibuf_error ("Register does not contain text", NULL);
#line 90 "src/registers.vala"
				ok = FALSE;
#line 528 "registers.c"
			} else {
				Buffer* _tmp4_;
#line 92 "src/registers.vala"
				funcall ("set-mark-command", NULL, NULL);
#line 93 "src/registers.vala"
				regnum = reg;
#line 94 "src/registers.vala"
				execute_with_uniarg (uniarg, _insert_register_movement_delegate, NULL, NULL, NULL);
#line 95 "src/registers.vala"
				funcall ("exchange-point-and-mark", NULL, NULL);
#line 96 "src/registers.vala"
				_tmp4_ = cur_bp;
#line 96 "src/registers.vala"
				_tmp4_->mark_active = FALSE;
#line 543 "registers.c"
			}
		}
	}
#line 100 "src/registers.vala"
	result = ok;
#line 100 "src/registers.vala"
	return result;
#line 551 "registers.c"
}

static gboolean
___lambda120__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda120_ (uniarg, args);
#line 66 "src/registers.vala"
	return result;
#line 562 "registers.c"
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1351 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1352 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1352 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1353 "glib-2.0.vapi"
	g_strchug (_result_);
#line 1354 "glib-2.0.vapi"
	result = _result_;
#line 1354 "glib-2.0.vapi"
	return result;
#line 583 "registers.c"
}

static void
__lambda122_ (void)
{
	{
		guint i = 0U;
#line 114 "src/registers.vala"
		i = (guint) 0;
#line 593 "registers.c"
		{
			gboolean _tmp0_ = FALSE;
#line 114 "src/registers.vala"
			_tmp0_ = TRUE;
#line 114 "src/registers.vala"
			while (TRUE) {
#line 600 "registers.c"
				ImmutableEstr* _tmp2_;
#line 114 "src/registers.vala"
				if (!_tmp0_) {
#line 604 "registers.c"
					guint _tmp1_;
#line 114 "src/registers.vala"
					i = i + 1;
#line 114 "src/registers.vala"
					_tmp1_ = i;
#line 610 "registers.c"
				}
#line 114 "src/registers.vala"
				_tmp0_ = FALSE;
#line 114 "src/registers.vala"
				if (!(i < ((guint) NUM_REGISTERS))) {
#line 114 "src/registers.vala"
					break;
#line 618 "registers.c"
				}
#line 115 "src/registers.vala"
				_tmp2_ = regs[i];
#line 115 "src/registers.vala"
				if (_tmp2_ != NULL) {
#line 624 "registers.c"
					gchar* s = NULL;
					ImmutableEstr* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gint len = 0;
					Window* _tmp7_;
					gchar* _tmp8_ = NULL;
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
#line 116 "src/registers.vala"
					_tmp3_ = regs[i];
#line 116 "src/registers.vala"
					_tmp4_ = immutable_estr_get_text (_tmp3_);
#line 116 "src/registers.vala"
					_tmp5_ = _tmp4_;
#line 116 "src/registers.vala"
					_tmp6_ = string_chug ((const gchar*) _tmp5_);
#line 116 "src/registers.vala"
					s = _tmp6_;
#line 117 "src/registers.vala"
					_tmp7_ = cur_wp;
#line 117 "src/registers.vala"
					len = MIN (20, MAX (0, ((gint) _tmp7_->ewidth) - 6)) + 1;
#line 119 "src/registers.vala"
					if (g_ascii_isprint ((gchar) i)) {
#line 652 "registers.c"
						gchar* _tmp9_;
#line 119 "src/registers.vala"
						_tmp9_ = g_strdup_printf ("%c", (gint) ((gchar) i));
#line 119 "src/registers.vala"
						_g_free0 (_tmp8_);
#line 119 "src/registers.vala"
						_tmp8_ = _tmp9_;
#line 660 "registers.c"
					} else {
						gchar* _tmp10_;
#line 119 "src/registers.vala"
						_tmp10_ = g_strdup_printf ("\\%o", i);
#line 119 "src/registers.vala"
						_g_free0 (_tmp8_);
#line 119 "src/registers.vala"
						_tmp8_ = _tmp10_;
#line 669 "registers.c"
					}
#line 119 "src/registers.vala"
					bprintf ("Register %s contains ", _tmp8_, NULL);
#line 120 "src/registers.vala"
					_tmp11_ = s;
#line 120 "src/registers.vala"
					_tmp12_ = strlen (_tmp11_);
#line 120 "src/registers.vala"
					_tmp13_ = _tmp12_;
#line 120 "src/registers.vala"
					if (_tmp13_ > 0) {
#line 681 "registers.c"
						const gchar* _tmp14_;
#line 121 "src/registers.vala"
						_tmp14_ = s;
#line 121 "src/registers.vala"
						bprintf ("text starting with\n    %.*s\n", len, _tmp14_, NULL);
#line 687 "registers.c"
					} else {
						const gchar* _tmp15_;
						ImmutableEstr* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
#line 122 "src/registers.vala"
						_tmp15_ = s;
#line 122 "src/registers.vala"
						_tmp16_ = regs[i];
#line 122 "src/registers.vala"
						_tmp17_ = immutable_estr_get_text (_tmp16_);
#line 122 "src/registers.vala"
						_tmp18_ = _tmp17_;
#line 122 "src/registers.vala"
						if (g_strcmp0 (_tmp15_, (const gchar*) _tmp18_) != 0) {
#line 123 "src/registers.vala"
							bprintf ("whitespace\n", NULL);
#line 705 "registers.c"
						} else {
#line 125 "src/registers.vala"
							bprintf ("the empty string\n", NULL);
#line 709 "registers.c"
						}
					}
#line 115 "src/registers.vala"
					_g_free0 (_tmp8_);
#line 115 "src/registers.vala"
					_g_free0 (s);
#line 716 "registers.c"
				}
			}
		}
	}
}

static void
___lambda122__buffer_writer (gpointer self)
{
#line 110 "src/registers.vala"
	__lambda122_ ();
#line 728 "registers.c"
}

static gboolean
__lambda121_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 110 "src/registers.vala"
	write_temp_buffer ("*Registers List*", TRUE, ___lambda122__buffer_writer, NULL);
#line 128 "src/registers.vala"
	result = TRUE;
#line 128 "src/registers.vala"
	return result;
#line 742 "registers.c"
}

static gboolean
___lambda121__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda121_ (uniarg, args);
#line 107 "src/registers.vala"
	return result;
#line 753 "registers.c"
}

void
registers_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
#line 33 "src/registers.vala"
	_tmp0_ = lisp_func_new ("copy-to-register", ___lambda119__function, TRUE, "Copy region into register REGISTER.");
#line 33 "src/registers.vala"
	_tmp1_ = _tmp0_;
#line 33 "src/registers.vala"
	_lisp_func_unref0 (_tmp1_);
#line 66 "src/registers.vala"
	_tmp2_ = lisp_func_new ("insert-register", ___lambda120__function, TRUE, "Insert contents of the user specified register.\n" \
"Puts point before and mark after the inserted text.");
#line 66 "src/registers.vala"
	_tmp3_ = _tmp2_;
#line 66 "src/registers.vala"
	_lisp_func_unref0 (_tmp3_);
#line 107 "src/registers.vala"
	_tmp4_ = lisp_func_new ("list-registers", ___lambda121__function, TRUE, "List defined registers.");
#line 107 "src/registers.vala"
	_tmp5_ = _tmp4_;
#line 107 "src/registers.vala"
	_lisp_func_unref0 (_tmp5_);
#line 783 "registers.c"
}

