/*
 * @(#)xgui.h
 *
 * Copyright 2022  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Widgets and other GUI for Xt Stuff */
#ifndef _xgui_h
#define _xgui_h

#ifndef WINVER
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "xgui.h"
#ifdef HAVE_MOTIF
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/MessageB.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeB.h>
#include <Xm/Label.h>
#include <Xm/SSpinB.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/DialogS.h>
#ifdef MOUSEBITMAPS
#include "pixmaps/mouse-l.xbm"
#include "pixmaps/mouse-r.xbm"
#endif
#elif defined(HAVE_LIB_XAW3DXFT)
#include <X11/Xaw3dxft/Form.h>
#include <X11/Xaw3dxft/Paned.h>
#include <X11/Xaw3dxft/Label.h>
#include <X11/Xaw3dxft/Toggle.h>
#include <X11/Xaw3dxft/Box.h>
#include <X11/Xaw3dxft/Scrollbar.h>
#include <X11/Xaw3dxft/SimpleMenu.h>
#include <X11/Xaw3dxft/MenuButton.h>
#include <X11/Xaw3dxft/SmeBSB.h>
#include <X11/Xaw3dxft/SmeLine.h>
#include <X11/Xaw3dxft/Command.h>
#include <X11/Xaw3dxft/Dialog.h>
#include <X11/Xaw3dxft/AsciiText.h>
#include <X11/Xaw3dxft/Repeater.h>
#undef XtCDelay
#elif defined(HAVE_LIB_XAW3D)
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Paned.h>
#include <X11/Xaw3d/Label.h>
#include <X11/Xaw3d/Toggle.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/Scrollbar.h>
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/MenuButton.h>
#include <X11/Xaw3d/SmeBSB.h>
#include <X11/Xaw3d/SmeLine.h>
#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Dialog.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Repeater.h>
#undef XtCDelay
#elif defined(HAVE_LIB_NEXTAW)
#include <X11/neXtaw/Form.h>
#include <X11/neXtaw/Paned.h>
#include <X11/neXtaw/Label.h>
#include <X11/neXtaw/Toggle.h>
#include <X11/neXtaw/Box.h>
#include <X11/neXtaw/Scrollbar.h>
#undef XtCDelay
#include <X11/neXtaw/SimpleMenu.h>
#include <X11/neXtaw/MenuButton.h>
#include <X11/neXtaw/SmeBSB.h>
#include <X11/neXtaw/SmeLine.h>
#include <X11/neXtaw/Command.h>
#include <X11/neXtaw/Dialog.h>
#include <X11/neXtaw/AsciiText.h>
#include <X11/neXtaw/Repeater.h>
#undef XtCDelay
#elif defined(HAVE_LIB_XAWPLUS)
#include <X11/XawPlus/Form.h>
#include <X11/XawPlus/Paned.h>
#include <X11/XawPlus/Label.h>
#include <X11/XawPlus/Toggle.h>
#include <X11/XawPlus/Box.h>
#include <X11/XawPlus/Scrollbar.h>
#include <X11/XawPlus/SimpleMenu.h>
#include <X11/XawPlus/MenuButton.h>
#include <X11/XawPlus/SmeBSB.h>
#include <X11/XawPlus/SmeLine.h>
#include <X11/XawPlus/Command.h>
#include <X11/XawPlus/Dialog.h>
#include <X11/XawPlus/AsciiText.h>
#include <X11/XawPlus/Repeater.h>
#undef XtCDelay
#elif defined(HAVE_ATHENA) /* HAVE_LIB_XAW */
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Repeater.h>
#undef XtCDelay
#endif
#ifdef HAVE_XPM
#include <X11/xpm.h>
#endif

#define SCROLL_SIZE 100

#ifdef HAVE_MOTIF
#define PAGE_SIZE 30
#elif defined(HAVE_ATHENA)
extern Atom wmDeleteWindow;
#endif
#endif

extern char *progDsp;

extern void usage(char *programName, const char *synopsisHelp);
extern void printVersionOnly(const char *aboutHelp);

extern void concatTitle(char *newTitle, char *title,
	const char *joinString, const char *string, int n);
extern void replaceAll(char *string, char oldString, char newString);

#ifdef HAVE_MOTIF
extern Arg args[10];

extern void updateToggle(Widget menu, Widget *menuItem, Boolean toggle,
	int number, XtCallbackProc callback);
extern void updateRadio(Widget menu, int mode, int size,
	XtCallbackProc callback);

extern void setToggle(Widget w, Boolean state);
extern void setRadio(Widget w, int mode, int choices);
extern void setChanger(Widget w, int value, Boolean spin);
extern void makePosVisible(Widget list_w, int item_no);

extern Widget createQuery(Widget w, const char *title, char *text,
	XtCallbackProc callback);
extern Widget createPause(Widget w, char *title, char *text,
	XtCallbackProc callback);
extern Widget createHelp(Widget w, const char *title, char *text);
extern Widget createScrollHelp(Widget w, char *title, char *text,
	Pixmap pixmap);
extern void createSpinner(Widget parent, Widget *spinner, char *label,
	int value, int min, int max, int size,
	XtCallbackProc callback);
extern void createSlider(Widget parent, Widget *slider, char *label,
	int value, int min, int max, int size, int width,
	XtCallbackProc callback);
void createRadio(Widget parent, Widget **modes,
	const char **list, const char *label, int num,
	XtCallbackProc callback);
extern void createScrollMenu(Widget parent, Widget *menuLabel,
	const char **list, const char *label, int init, int num,
	XtCallbackProc menuCallback);
#elif defined(HAVE_ATHENA)
extern void closePopupPanel(Widget w);
extern void closePopupPanel2(Widget w);
extern void closePopupPanel3(Widget w);
extern void deleteWindowProc(Widget w, XEvent *event, String *pars,
	Cardinal *nPars);

extern void createBlank(char **string, int size, char *defaultString,
	int side);
extern int findMaxLength(char **list, int num);
extern void setLabel(Widget label, int value, int min, int max);
extern void checkBounds(int *value, int min, int *max, Boolean maxFixed);
extern void setScale(Widget slider, Widget label, int value,
	int min, int max, Boolean maxFixed);
extern void setScaleCheck(Widget slider, Widget label, int value,
	int min, int max, Boolean maxFixed);

void setToggle(Widget w, Boolean state);
void setRadio(Widget w, const char *choice);

extern Boolean thumbScroll(XtPointer callData, int *value,
	int min, int max, int width);
extern void menuCheck(Widget parent, Widget menuItem, Boolean value);

extern void createDialog(Widget parent, Widget dialog);
extern void createToggle(Widget parent, Widget *toggle,
	const char *label, int labelSize,
	Boolean value, XtCallbackProc callback);
extern void createSpinner(Widget parent, Widget *digits,
	const char *label, int labelSize,
	int value, int min, int max, Boolean maxFixed,
	XtCallbackProc upCallback, XtCallbackProc downCallback);
extern void createSlider(Widget parent, Widget *digits, Widget *slider,
	const char *label, int labelSize,
	int value, int min, int max, Boolean maxFixed,
	int width, XtCallbackProc scrollCallback, XtCallbackProc jumpCallback);
extern void createRadio(Widget parent, Widget **radio,
	const char **list, const char *label, int labelSize, int init, int num,
	XtCallbackProc menuCallback);
extern void createPopupMenu(Widget parent, Widget *choice,
	const char **list, const char *label, int labelSize, int init, int num,
	XtCallbackProc menuCallback);
extern void createMenu(Widget parent, Widget *menuLabel, Widget previous,
	const char **list, const char *label, int num,
	unsigned long lineMask, Boolean check,
	XtCallbackProc menuCallback);
extern Widget createQuery(Widget w, const char *title, char *text,
	XtCallbackProc callback);
extern void createHelp(Widget parent, Widget *dialogShell, const char *title,
	char *text, XtCallbackProc callback);
extern void createScrollHelp(Widget parent, Widget *dialogShell,
	const char *title,
	char *text, XtCallbackProc callback);
#endif
#endif
