/* X Letters - Catch falling words */
/* Copyright (C) 1998 by
 *   Peter Horvai (peter.horvai@ens.fr)
 *   David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* The two following constants determine the size of the game space,
 * in pixels.  Note that they are intentionally not modifiable through
 * resources, as that would be cheating. */

/* The width of the play area, in pixels */
#define WIDTH 512

/* The height of the play area, in pixels */
#define HEIGHT 512



/* The following four constants are game parameters.  They do not
 * change the ``look'' of the game but rather its ``feel''. */

/* The maximal number of words simultaneously falling */
#define MAXWORDS 256

/* Whether the program should avoid at all cost the collision between
 * two words */
#define NOCOLLIDE 1

/* Whether the program should avoid at all cost the vertical collision
 * between two words (in case the deathmatch sends many words very
 * fast, or during a pause).  This is recommended. */
#define NOVCOLLIDE 1

/* Whether making a mistake will take you back to the last place in
 * the word that matches what you have just typed (rather than right
 * back to the beginning) */
#define CONTEXT 1

/* The duration of a half-level in time units. */
#define LEVELDUR 600



/* The following constants are configuration variables */

/* The file from which non-bonus words are read */
#define WORDFILE "words"
#define WORDPATH "/usr/share/dict:/usr/local/share/dict:/usr/dict:~/dict:~/.:~/share/dict:."

/* The high score file */
#define SCOREFILE "/var/local/games/lib/xletters/scores"
/* ***NOTE*** You are responsible for creating the directory.
 * xletters will create the file if necessary, but it might not have
 * the right owner, so you had better create it too. */
/* note: Makefile.am (make install) creates the directory, but not
   the file */

/* Number of high score entries */
#define SCORELEN 20

/* Whether a single user is allowed to have several entries in the
 * high score table */
#define MULTENT 0



/* The following constants are default values for game resources */

/* The font to use, if not overriden by a resource specification */
#define FONTNAME "-*-fixed-medium-r-normal-*-15-*-*-*-*-*-iso8859-1"

/* The color of the words, if not overriden by a resource
 * specification */
#define WORD_COLOR "Blue"

/* The color of the letters correctly typed, if not overriden by a
 * resource specification */
#define TYPED_COLOR "Red"


/* It is safe to leave the following untouched */

/* The base time unit, in milliseconds - you probably shoudln't change
 * this. */
#define BASETIME 75

/* The application class - you probably shouldn't change this. */
#define APP_CLASS "XLetters"
