/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Pixmap;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;

final class TransparentFilter
extends RGBImageFilter {
    int width;
    int height;
    byte[] pixels;
    int cx;
    int cy;

    TransparentFilter(int n, int n2, Pixmap pixmap) {
        this.cx = n;
        this.cy = n2;
        this.width = pixmap.width;
        this.height = pixmap.height;
        this.pixels = new byte[pixmap.width * pixmap.height];
        if (pixmap.data != null) {
            int n3 = 0;
            while (n3 < pixmap.height) {
                int n4 = 0;
                while (n4 < pixmap.width) {
                    this.pixels[n3 * pixmap.width + n4] = pixmap.data[n3 * pixmap.width + n4] == 0 ? (byte)0 : 1;
                    ++n4;
                }
                ++n3;
            }
        } else {
            int[] nArray = new int[pixmap.width * pixmap.height];
            Image image = pixmap.img;
            PixelGrabber pixelGrabber = null;
            pixelGrabber = new PixelGrabber(image, 0, 0, pixmap.width, pixmap.height, nArray, 0, pixmap.width);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                return;
            }
            int n5 = 0;
            while (n5 < pixmap.height) {
                int n6 = 0;
                while (n6 < pixmap.width) {
                    this.pixels[n5 * pixmap.width + n6] = nArray[n5 * pixmap.width + n6] == -16777216 ? (byte)0 : 1;
                    ++n6;
                }
                ++n5;
            }
            nArray = null;
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        if (this.cx <= n && n < this.cx + this.width && this.cy <= n2 && n2 < this.cy + this.height && this.pixels[(n2 - this.cy) * this.width + (n - this.cx)] == 0) {
            n3 = 0xFFFFFF;
        }
        return n3;
    }
}

