/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Client;
import com.jcraft.weirdx.ClientColormap;
import com.jcraft.weirdx.Colormap16;
import com.jcraft.weirdx.Entry;
import com.jcraft.weirdx.IO;
import com.jcraft.weirdx.LocalEntry;
import com.jcraft.weirdx.RGBTXT;
import com.jcraft.weirdx.Resource;
import com.jcraft.weirdx.Screen;
import com.jcraft.weirdx.SharedColor;
import com.jcraft.weirdx.SharedEntry;
import com.jcraft.weirdx.Visual;
import com.jcraft.weirdx.Window;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Hashtable;

class Colormap
extends Resource {
    private static final int REDMAP = 0;
    private static final int GREENMAP = 1;
    private static final int BLUEMAP = 2;
    private static final int PSEUDOMAP = 3;
    private static final int AllocPrivate = -1;
    private static final int AllocTemporary = -2;
    private static final int DynamicClass = 1;
    private static final int AllocNone = 0;
    private static final int AllocAll = 1;
    private static final int IsDefault = 1;
    private static final int AllAllocated = 2;
    private static final int BeingCreated = 4;
    private static final int StaticGray = 0;
    private static final int GrayScale = 1;
    private static final int StaticColor = 2;
    private static final int PseudoColor = 3;
    private static final int TrueColor = 4;
    private static final int DirectColor = 5;
    private static final int DoRed = 1;
    private static final int DoGreen = 2;
    private static final int DoBlue = 4;
    static IndexColorModel bwicm = null;
    Color[] colors;
    byte[] r;
    byte[] g;
    byte[] b;
    ColorModel cm;
    long icmtime;
    Visual visual;
    Screen screen;
    int[][] pixels;
    int freeRed;
    Entry[] entries;
    int flags;
    static Colormap[] installed;
    static Colormap defaultColormap;
    static Hashtable rgbTable;

    Colormap(int n, Screen screen, Visual visual, int n2, Client client) {
        super(n, 6);
        Resource.add(this);
        this.screen = screen;
        this.visual = visual;
        if (visual.depth.depth == 16) {
            return;
        }
        int n3 = visual.getColormapEntries();
        this.r = new byte[n3];
        this.g = new byte[n3];
        this.b = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.r[n4] = -1;
            this.g[n4] = -1;
            this.b[n4] = -1;
            ++n4;
        }
        this.colors = new Color[n3];
        this.pixels = new int[128][];
        this.entries = new Entry[n3];
        int n5 = 0;
        while (n5 < this.entries.length) {
            this.entries[n5] = new LocalEntry();
            ++n5;
        }
        this.freeRed = n3;
        this.flags = 0;
        if (n == this.screen.defaultColormapId) {
            this.flags |= 1;
        }
        if (n2 == 1) {
            if ((this.visual.clss & 1) != 0) {
                this.flags |= 2;
            }
            int n6 = 0;
            while (n6 < this.entries.length) {
                this.entries[n6].refcnt = -1;
                ++n6;
            }
            this.freeRed = 0;
            this.pixels[client.index] = new int[this.entries.length];
            int n7 = 0;
            while (n7 < this.pixels[client.index].length) {
                this.pixels[client.index][n7] = n7;
                ++n7;
            }
        }
    }

    static Colormap getColormap(int n, Screen screen, Visual visual, int n2, Client client) {
        if (visual.depth.depth == 16) {
            return new Colormap16(n, screen, visual, n2, client);
        }
        return new Colormap(n, screen, visual, n2, client);
    }

    private int alloc() {
        int n = 0;
        while (n < this.colors.length) {
            if (this.colors[n] == null) {
                this.colors[n] = Color.black;
                break;
            }
            ++n;
        }
        if (n == this.colors.length) {
            n = 2;
        }
        return n;
    }

    private void alloc(String string) {
        int n = 0;
        while (n < this.colors.length) {
            if (this.colors[n] == null) break;
            ++n;
        }
        if (n == this.colors.length) {
            return;
        }
        this.alloc(n, (Color)rgbTable.get(string));
        this.mkIcm();
    }

    private void alloc(int n, Color color) {
        this.colors[n] = color;
        this.r[n] = (byte)color.getRed();
        this.g[n] = (byte)color.getGreen();
        this.b[n] = (byte)color.getBlue();
    }

    private void free(int n) {
        if (n < this.colors.length) {
            this.colors[n] = null;
            this.r[n] = -1;
            this.g[n] = -1;
            this.b[n] = -1;
        }
    }

    void freeAll() {
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].refcnt = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.colors.length) {
            this.free(n2);
            ++n2;
        }
    }

    int rgb2pixel(int n) {
        byte by = (byte)(n >> 16 & 0xFF);
        byte by2 = (byte)(n >> 8 & 0xFF);
        byte by3 = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < this.r.length) {
            if (this.r[n2] == by && this.g[n2] == by2 && this.b[n2] == by3) {
                return n2;
            }
            ++n2;
        }
        int n3 = 1000;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.r.length) {
            n5 = 0;
            n6 = this.r[n7] - by;
            if (n6 < 0) {
                n6 *= -1;
            }
            n5 += n6;
            n6 = this.g[n7] - by2;
            if (n6 < 0) {
                n6 *= -1;
            }
            n5 += n6;
            n6 = this.b[n7] - by3;
            if (n6 < 0) {
                n6 *= -1;
            }
            if ((n5 += n6) < n3) {
                n4 = n7;
                n3 = n5;
            }
            ++n7;
        }
        return n4;
    }

    static void reqCreateColormap(Client client) throws IOException {
        IO iO = client.client;
        int n = client.data;
        if (n != 0 && n != 1) {
            client.errorValue = n;
            client.errorReason = 2;
        }
        int n2 = iO.readInt();
        int n3 = iO.readInt();
        Window window = client.lookupWindow(n3);
        if (client.errorReason == 0 && window == null) {
            client.errorValue = n3;
            client.errorReason = 3;
        }
        n3 = iO.readInt();
        client.length -= 4;
        if (client.errorReason != 0) {
            return;
        }
        Visual visual = null;
        Visual[] visualArray = window.screen.visual;
        int n4 = 0;
        while (n4 < visualArray.length) {
            if (visualArray[n4].id == n3) {
                visual = visualArray[n4];
                break;
            }
            ++n4;
        }
        if (visual == null) {
            client.errorValue = n3;
            client.errorReason = 2;
            return;
        }
        if ((visual.clss & 1) == 0 && n != 0 && client != Client.clients[0]) {
            client.errorReason = 9;
            return;
        }
        Colormap.getColormap(n2, window.screen, visual, n, client);
    }

    static void reqStoreColors(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        if ((colormap.visual.clss & 1) == 0) {
            client.errorReason = 11;
            return;
        }
        colormap.storeColors(client, n -= 2);
        if (client.errorReason != 0) {
            return;
        }
        colormap.mkIcm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqUninstallColormap(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        Colormap colormap = (Colormap)Resource.lookupIDByType(n, 6);
        if (colormap == null) {
            client.errorValue = n;
            client.errorReason = 12;
            return;
        }
        if (installed.length == 1) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < installed.length) {
            if (installed[n2] == colormap) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return;
        }
        Colormap[] colormapArray = installed;
        synchronized (colormapArray) {
            Colormap[] colormapArray2 = new Colormap[installed.length - 1];
            colormapArray2[0] = installed[0];
            int n3 = 1;
            while (n3 < installed.length) {
                if (installed[n3] == colormap) {
                    int n4 = n3 + 1;
                    while (n4 < installed.length) {
                        colormapArray2[n4 - 1] = installed[n4];
                        ++n4;
                    }
                    break;
                }
                colormapArray2[n3] = installed[n3];
                ++n3;
            }
            installed = colormapArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqInstallColormap(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        Colormap colormap = (Colormap)Resource.lookupIDByType(n, 6);
        if (colormap == null) {
            client.errorValue = n;
            client.errorReason = 12;
            return;
        }
        Colormap[] colormapArray = installed;
        synchronized (colormapArray) {
            int n2 = 0;
            while (n2 < installed.length) {
                if (installed[n2] == colormap) {
                    return;
                }
                ++n2;
            }
            Colormap[] colormapArray2 = new Colormap[installed.length + 1];
            System.arraycopy(installed, 0, colormapArray2, 0, installed.length);
            colormapArray2[Colormap.installed.length] = colormap;
            installed = colormapArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqListInstalledColormaps(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(1);
            iO.writeShort(1);
            iO.writePad(22);
            int n2 = 1;
            while (n2 != 0) {
                iO.writeInt(Screen.screen[0].defaultColormapId);
                --n2;
            }
            iO.flush();
        }
    }

    static void reqFreeColors(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        n2 = iO.readInt();
        --client.length;
        colormap.freeColors(client, n -= 3, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqAllocColorPlanes(Client client) throws IOException {
        IO iO = client.client;
        int n = client.data;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        int n3 = iO.readShort();
        int n4 = iO.readShort();
        int n5 = iO.readShort();
        int n6 = iO.readShort();
        client.length = 0;
        if (n3 == 0) {
            client.errorValue = 0;
            client.errorReason = 2;
            return;
        }
        colormap.allocColorPlanes(client, n3, n == 1, n4, n5, n6);
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(n3);
            iO.writeShort(n3);
            iO.writePad(2);
            iO.writeInt(0xFF0000);
            iO.writeInt(65280);
            iO.writeInt(255);
            iO.writePad(8);
            while (n3 != 0) {
                iO.writeInt(colormap.alloc());
                --n3;
            }
            iO.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqAllocColorCells(Client client) throws IOException {
        IO iO = client.client;
        int n = client.data;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        short s = (short)iO.readShort();
        short s2 = (short)iO.readShort();
        --client.length;
        if (s == 0) {
            client.errorValue = 0;
            client.errorReason = 2;
            return;
        }
        if (n != 0 && n != 1) {
            client.errorValue = n;
            client.errorReason = 2;
            return;
        }
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = new int[s];
        if (s2 != 0) {
            nArray2 = new int[s2];
        }
        colormap.allocColorCells(client, s, s2, n == 1, nArray, nArray2);
        if (client.errorReason != 0) {
            return;
        }
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(s + s2);
            iO.writeShort(s);
            iO.writeShort(s2);
            iO.writePad(20);
            int n3 = 0;
            while (n3 < nArray.length) {
                iO.writeInt(nArray[n3]);
                ++n3;
            }
            if (s2 != 0) {
                int n4 = 0;
                while (n4 < nArray2.length) {
                    iO.writeInt(nArray2[n4]);
                    ++n4;
                }
            }
            iO.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqLookupColor(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        n2 = iO.readShort();
        iO.readPad(2);
        iO.readByte(client.bbuffer, 0, n2);
        iO.readPad(-n2 & 3);
        client.length = 0;
        n2 = Colormap.chopspace(client.bbuffer, n2);
        if (n2 == 0) {
            client.errorReason = 2;
            return;
        }
        String string = new String(client.bbuffer, 0, n2);
        Color color = (Color)rgbTable.get(string);
        if (color != null) {
            IO iO2 = iO;
            synchronized (iO2) {
                iO.writeByte(1);
                iO.writePad(1);
                iO.writeShort(client.seq);
                iO.writeInt(0);
                n2 = color.getRed();
                iO.writeShort(n2 | n2 << 8);
                n2 = color.getGreen();
                iO.writeShort(n2 | n2 << 8);
                n2 = color.getBlue();
                iO.writeShort(n2 | n2 << 8);
                n2 = color.getRed();
                iO.writeShort(n2 | n2 << 8);
                n2 = color.getGreen();
                iO.writeShort(n2 | n2 << 8);
                n2 = color.getBlue();
                iO.writeShort(n2 | n2 << 8);
                iO.writePad(12);
                iO.flush();
                return;
            }
        }
        IO iO3 = iO;
        synchronized (iO3) {
            iO.writeByte((byte)0);
            iO.writeByte((byte)15);
            iO.writeShort(client.seq);
            iO.writePad(4);
            iO.writeShort(0);
            iO.writeByte((byte)92);
            iO.writePad(21);
            iO.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqAllocColor(Client client) throws IOException {
        Object object;
        IO iO = client.client;
        int n = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n;
            client.errorReason = 12;
            return;
        }
        int n2 = iO.readShort();
        int n3 = iO.readShort();
        int n4 = iO.readShort();
        iO.readPad(2);
        client.length -= 2;
        if ((n2 >> 8 & 0xFF) != 0 || (n3 >> 8 & 0xFF) != 0 || (n4 >> 8 & 0xFF) != 0) {
            n2 = n2 >> 8 & 0xFF;
            n3 = n3 >> 8 & 0xFF;
            n4 = n4 >> 8 & 0xFF;
        } else {
            n2 &= 0xFF;
            n3 &= 0xFF;
            n4 &= 0xFF;
        }
        int n5 = colormap.allocColor(client, n2, n3, n4);
        if (client.errorReason != 0) {
            return;
        }
        if (colormap.visual.depth.depth != 16) {
            object = (LocalEntry)colormap.entries[n5];
            n2 = ((LocalEntry)object).r;
            n3 = ((LocalEntry)object).g;
            n4 = ((LocalEntry)object).b;
            if (((LocalEntry)object).refcnt == 1) {
                colormap.mkIcm();
            }
        }
        object = iO;
        synchronized (object) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(0);
            iO.writeShort(n2 | n2 << 8);
            iO.writeShort(n3 | n3 << 8);
            iO.writeShort(n4 | n4 << 8);
            iO.writePad(2);
            iO.writeInt(n5);
            iO.writePad(12);
            iO.flush();
        }
    }

    static void reqQueryColors(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        int[] nArray = new int[n -= 2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = iO.readInt();
            ++n3;
        }
        client.length = 0;
        colormap.queryColors(client, nArray);
    }

    static void reqStoreNamedColor(Client client) throws IOException {
        IO iO = client.client;
        int n = client.data;
        int n2 = client.length;
        int n3 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n3, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n3;
            client.errorReason = 12;
            return;
        }
        int n4 = iO.readInt();
        int n5 = iO.readShort();
        iO.readPad(2);
        n2 -= 4;
        n2 *= 4;
        iO.readByte(client.bbuffer, 0, n5);
        iO.readPad(n2 -= n5);
        client.length = 0;
        n5 = Colormap.chopspace(client.bbuffer, n5);
        if (n5 == 0) {
            client.errorReason = 2;
            return;
        }
        String string = new String(client.bbuffer, 0, n5);
        Color color = (Color)rgbTable.get(string);
        if (n4 == -1) {
            System.out.println("?? pixel=" + n4);
            n4 = 25;
        }
        int n6 = color.getRed();
        int n7 = color.getGreen();
        int n8 = color.getBlue();
        Color color2 = colormap.colors[n4];
        if (color2 != null && n != 0) {
            if ((n & 1) == 0) {
                n6 = color2.getRed();
            }
            if ((n & 2) == 0) {
                n7 = color2.getGreen();
            }
            if ((n & 4) == 0) {
                n8 = color2.getBlue();
            }
        }
        client.errorReason = colormap.storeColor(client, n4, n6, n7, n8, n);
        if (client.errorReason == 0) {
            colormap.mkIcm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqAllocNamedColor(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        Colormap colormap = (Colormap)Resource.lookupIDByType(n2, 6);
        client.length -= 2;
        if (colormap == null) {
            client.errorValue = n2;
            client.errorReason = 12;
            return;
        }
        int n3 = iO.readShort();
        iO.readPad(2);
        n -= 3;
        n *= 4;
        iO.readByte(client.bbuffer, 0, n3);
        iO.readPad(n -= n3);
        client.length = 0;
        n3 = Colormap.chopspace(client.bbuffer, n3);
        if (n3 == 0) {
            client.errorReason = 2;
            return;
        }
        String string = new String(client.bbuffer, 0, n3);
        Color color = (Color)rgbTable.get(string);
        if (color != null) {
            Object object;
            int n4 = color.getRed();
            int n5 = color.getGreen();
            int n6 = color.getBlue();
            int n7 = colormap.allocColor(client, color.getRed(), color.getGreen(), color.getBlue());
            if (client.errorReason != 0) {
                return;
            }
            if (colormap.visual.depth.depth != 16) {
                object = (LocalEntry)colormap.entries[n7];
                n4 = ((LocalEntry)object).r;
                n5 = ((LocalEntry)object).g;
                n6 = ((LocalEntry)object).b;
                if (((LocalEntry)object).refcnt == 1) {
                    colormap.mkIcm();
                }
            }
            object = iO;
            synchronized (object) {
                iO.writeByte(1);
                iO.writePad(1);
                iO.writeShort(client.seq);
                iO.writeInt(0);
                iO.writeInt(n7);
                iO.writeShort(n4 | n4 << 8);
                iO.writeShort(n5 | n5 << 8);
                iO.writeShort(n6 | n6 << 8);
                iO.writeShort(n4 | n4 << 8);
                iO.writeShort(n5 | n5 << 8);
                iO.writeShort(n6 | n6 << 8);
                iO.writePad(8);
                iO.flush();
                return;
            }
        }
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte((byte)0);
            iO.writeByte((byte)15);
            iO.writeShort(client.seq);
            iO.writePad(4);
            iO.writeShort(0);
            iO.writeByte((byte)85);
            iO.writePad(21);
            iO.flush();
        }
    }

    Color getColor(int n) {
        Color color;
        if (n < 0) {
            n = 255;
        }
        if (this.colors.length <= n) {
            n = 1;
        }
        if ((color = this.colors[n]) == null) {
            color = this.colors[1];
        }
        return color;
    }

    private static int chopspace(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (65 <= byArray[n2] && byArray[n2] <= 90) {
                byArray[n2] = (byte)(97 + byArray[n2] - 65);
            } else if (byArray[n2] == 32) {
                --n;
                int n3 = n2;
                while (n3 < n) {
                    byArray[n3] = byArray[n3 + 1];
                    ++n3;
                }
                --n2;
            }
            ++n2;
        }
        return n;
    }

    static int isMapInstalled(int n, Window window) {
        return 1;
    }

    static void init() {
        if (rgbTable == null) {
            rgbTable = new Hashtable();
            RGBTXT.init(rgbTable);
        }
        if (installed == null) {
            installed = new Colormap[1];
        }
    }

    void delete() throws IOException {
        int n = 0;
        while (n < this.pixels.length) {
            if (this.pixels != null) {
                this.pixels[n] = null;
            }
            ++n;
        }
        this.pixels = null;
        this.entries = null;
    }

    private void freeCell(int n, int n2) {
        switch (n2) {
            default: 
        }
        Entry entry = this.entries[n];
        if (entry.refcnt > 1) {
            --entry.refcnt;
        } else {
            entry.refcnt = 0;
            switch (n2) {
                default: 
            }
            ++this.freeRed;
            this.free(n);
        }
    }

    void freePixels(int n) {
        int[] nArray = this.pixels[n];
        if ((this.visual.clss & 1) != 0 && nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                this.freeCell(nArray[n2], 0);
                ++n2;
            }
        }
        this.pixels[n] = null;
    }

    int allocColor(Client client, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.visual.depth.depth == 16) {
            return 0;
        }
        int n5 = this.visual.clss;
        if ((this.flags & 4) != 0) {
            n5 |= 1;
        }
        switch (n5) {
            case 0: 
            case 2: {
                if (this.visual.getDepth().depth == 1) {
                    n4 = (n + n2 + n3) / 3 == 0 ? 0 : 1;
                    break;
                }
                n4 = (n + n2 + n3) / 3;
                break;
            }
            case 1: 
            case 3: {
                n4 = this.findColor(client, this.entries, n, n2, n3, 3);
                if (client.errorReason == 0) break;
                return n4;
            }
        }
        if (this.pixels[client.index] != null && this.pixels[client.index].length == 1 && (this.id & 0x1FC00000) >> 22 != client.index && (this.flags & 4) == 0) {
            ClientColormap clientColormap = new ClientColormap(Resource.fakeClientId(client), client.index, this.id);
            Resource.add(clientColormap);
        }
        return n4;
    }

    private int findBestPixel(Entry[] entryArray, int n, int n2, int n3, int n4) {
        return 0;
    }

    private int findColor(Client client, Entry[] entryArray, int n, int n2, int n3, int n4) {
        Entry entry;
        boolean bl = false;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        while (n7 < entryArray.length) {
            entry = entryArray[n7];
            if (entry.refcnt > 0) {
                if (entry.eq(n, n2, n3)) {
                    if (client.index >= 0) {
                        ++entry.refcnt;
                    }
                    n6 = n7;
                    break;
                }
            } else if (!bl && entry.refcnt == 0) {
                n5 = n7;
                bl = true;
                if ((this.flags & 4) != 0) break;
            }
            ++n7;
        }
        if (n6 == -1) {
            if (!bl) {
                client.errorReason = 11;
                return n6;
            }
            this.chkLocalEntry(n5);
            entry = entryArray[n5];
            entry.refcnt = client.index >= 0 ? 1 : -2;
            switch (n4) {
                case 3: {
                    ((LocalEntry)entry).r = n;
                    ((LocalEntry)entry).g = n2;
                    ((LocalEntry)entry).b = n3;
                    if (client.index < 0) break;
                    --this.freeRed;
                }
            }
            n6 = n5;
            this.alloc(n6, new Color(n, n2, n3));
        }
        if ((this.flags & 4) != 0 || client.index == -1) {
            return n6;
        }
        switch (n4) {
            case 0: 
            case 3: {
                int[] nArray = this.expand(this.pixels[client.index], 1);
                nArray[nArray.length - 1] = n6;
                this.pixels[client.index] = nArray;
            }
        }
        return n6;
    }

    private void update() {
        if (this.visual.clss != 5) {
            int n = 0;
            while (n < this.entries.length) {
                int n2;
                int n3;
                int n4;
                Entry entry = this.entries[n];
                if (entry.refcnt == 0) {
                    this.free(n);
                }
                if (entry.shared) {
                    n4 = ((SharedEntry)entry).r.color;
                    n3 = ((SharedEntry)entry).g.color;
                    n2 = ((SharedEntry)entry).b.color;
                } else {
                    n4 = ((LocalEntry)entry).r;
                    n3 = ((LocalEntry)entry).g;
                    n2 = ((LocalEntry)entry).b;
                }
                this.alloc(n, new Color(n4, n3, n2));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void allocColorPlanes(Client var1_1, int var2_2, boolean var3_3, int var4_4, int var5_5, int var6_6) throws IOException {
        block16: {
            var10_7 = var1_1.client;
            if ((this.visual.clss & 1) == 0) {
                var1_1.errorReason = 11;
                return;
            }
            var11_8 = null;
            var12_9 = this.pixels[var1_1.index] == null ? 0 : this.pixels[var1_1.index].length;
            var13_10 = new int[var2_2];
            if (this.visual.clss == 5) {
                // empty if block
            }
            if (var12_9 == 0 && (this.id & 532676608) >> 22 != var1_1.index) {
                var11_8 = new ClientColormap(Resource.fakeClientId(var1_1), var1_1.index, this.id);
            }
            if (this.visual.clss == 5 || !(var7_12 = this.allocPseudo(var1_1, var2_2, var4_4 + var5_5 + var6_6, var3_3, var13_10, var14_11 = new int[1]))) break block16;
            var17_13 = 0;
            var16_14 = 0;
            var15_15 = 0;
            var9_16 = 1;
            var18_17 = var4_4;
            ** GOTO lbl24
            {
                var9_16 += var9_16;
                do {
                    if ((var14_11[0] & var9_16) == 0) continue block3;
                    var15_15 |= var9_16;
                    var9_16 += var9_16;
lbl24:
                    // 2 sources

                } while (--var18_17 >= 0);
            }
            var19_18 = var5_5;
            ** GOTO lbl32
            {
                var9_16 += var9_16;
                do {
                    if ((var14_11[0] & var9_16) == 0) continue block5;
                    var16_14 |= var9_16;
                    var9_16 += var9_16;
lbl32:
                    // 2 sources

                } while (--var19_18 >= 0);
            }
            var20_19 = var6_6;
            ** GOTO lbl40
            {
                var9_16 += var9_16;
                do {
                    if ((var14_11[0] & var9_16) == 0) continue block7;
                    var17_13 |= var9_16;
                    var9_16 += var9_16;
lbl40:
                    // 2 sources

                } while (--var20_19 >= 0);
            }
            if (!this.allocShared(var1_1, var13_10, var2_2, var4_4, var5_5, var6_6, var15_15, var16_14, var17_13, var12_9)) {
                this.freeColors(var1_1, var13_10, var14_11[0]);
                var1_1.errorReason = 11;
            } else {
                var21_20 = var10_7;
                synchronized (var21_20) {
                    var10_7.writeByte(1);
                    var10_7.writePad(1);
                    var10_7.writeShort(var1_1.seq);
                    var10_7.writeInt(var2_2);
                    var10_7.writeShort(var2_2);
                    var10_7.writePad(2);
                    var10_7.writeInt(var15_15);
                    var10_7.writeInt(var16_14);
                    var10_7.writeInt(var17_13);
                    var10_7.writePad(8);
                    var22_21 = 0;
                    while (var22_21 < this.pixels.length) {
                        var10_7.writeInt(var13_10[var22_21]);
                        ++var22_21;
                    }
                    var10_7.flush();
                }
            }
        }
        if (var1_1.errorReason == 0 && var11_8 != null) {
            Resource.add(var11_8);
        }
    }

    private boolean allocShared(Client client, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int[] nArray2 = this.pixels[client.index];
        int n9 = n << n2 + n3 + n4;
        int n10 = (n << n2) + (n << n3) + (n << n4);
        SharedColor[] sharedColorArray = new SharedColor[n10];
        int n11 = 0;
        while (n11 < sharedColorArray.length) {
            sharedColorArray[n11] = new SharedColor();
            ++n11;
        }
        int n12 = 0;
        int n13 = 0;
        while (n13 < n) {
            int n14;
            int n15;
            SharedColor sharedColor;
            int n16;
            int n17;
            int n18 = ~(n6 | n7);
            int n19 = nArray[n13] & n18;
            if (n5 != 0) {
                n17 = 0;
                n16 = Colormap.lowbit(n5);
                block2: while (true) {
                    sharedColor = sharedColorArray[n12];
                    ++n12;
                    n15 = 0;
                    while (n15 < n9) {
                        n14 = nArray2[n8 + n15];
                        if ((n14 & n18) == (n19 | n17)) {
                            this.chkShareEntry(n14);
                            ((SharedEntry)this.entries[n14]).r = sharedColor;
                        }
                        ++n15;
                    }
                    if (n17 != n5) {
                        n17 += n16;
                        while (true) {
                            if ((n17 & ~n5) == 0) continue block2;
                            n17 += n17 & ~n5;
                        }
                    }
                    break;
                }
            } else {
                sharedColor = sharedColorArray[n12];
                ++n12;
                n15 = 0;
                while (n15 < n9) {
                    n14 = nArray2[n8 + n15];
                    if ((n14 & n18) == n19) {
                        this.chkShareEntry(n14);
                        ((SharedEntry)this.entries[n14]).r = sharedColor;
                    }
                    ++n15;
                }
            }
            n18 = ~(n5 | n7);
            n19 = nArray[n13] & n18;
            if (n6 != 0) {
                n17 = 0;
                n16 = Colormap.lowbit(n6);
                block6: while (true) {
                    sharedColor = sharedColorArray[n12];
                    ++n12;
                    n15 = 0;
                    while (n15 < n9) {
                        n14 = nArray2[n8 + n15];
                        if ((n14 & n18) == (n19 | n17)) {
                            this.chkShareEntry(n14);
                            ((SharedEntry)this.entries[n14]).g = sharedColor;
                        }
                        ++n15;
                    }
                    if (n17 != n6) {
                        n17 += n16;
                        while (true) {
                            if ((n17 & ~n6) == 0) continue block6;
                            n17 += n17 & ~n6;
                        }
                    }
                    break;
                }
            } else {
                sharedColor = sharedColorArray[n12];
                ++n12;
                n15 = 0;
                while (n15 < n9) {
                    n14 = nArray2[n8 + n15];
                    if ((n14 & n18) == n19) {
                        this.chkShareEntry(n14);
                        ((SharedEntry)this.entries[n14]).g = sharedColor;
                    }
                    ++n15;
                }
            }
            n18 = ~(n5 | n6);
            n19 = nArray[n13] & n18;
            if (n7 != 0) {
                n17 = 0;
                n16 = Colormap.lowbit(n7);
                block10: while (true) {
                    sharedColor = sharedColorArray[n12];
                    ++n12;
                    n15 = 0;
                    while (n15 < n9) {
                        n14 = nArray2[n8 + n15];
                        if ((n14 & n18) == (n19 | n17)) {
                            this.chkShareEntry(n14);
                            ((SharedEntry)this.entries[n14]).b = sharedColor;
                        }
                        ++n15;
                    }
                    if (n17 != n7) {
                        n17 += n16;
                        while (true) {
                            if ((n17 & ~n7) == 0) continue block10;
                            n17 += n17 & ~n7;
                        }
                    }
                    break;
                }
            } else {
                sharedColor = sharedColorArray[n12];
                ++n12;
                n15 = 0;
                while (n15 < n9) {
                    n14 = nArray2[n8 + n15];
                    if ((n14 & n18) == n19) {
                        this.chkShareEntry(n14);
                        ((SharedEntry)this.entries[n14]).b = sharedColor;
                    }
                    ++n15;
                }
            }
            ++n13;
        }
        return true;
    }

    private void chkShareEntry(int n) {
        if (!this.entries[n].shared) {
            this.entries[n] = new SharedEntry();
        }
    }

    private void chkLocalEntry(int n) {
        if (this.entries[n].shared) {
            this.entries[n] = new LocalEntry();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void allocColorCells(Client var1_1, int var2_2, int var3_3, boolean var4_4, int[] var5_5, int[] var6_6) {
        block5: {
            var17_7 = null;
            if ((this.visual.clss & 1) == 0) {
                var1_1.errorReason = 11;
                return;
            }
            if (this.pixels[var1_1.index] == null && (this.id & 532676608) >> 22 != var1_1.index) {
                var17_7 = new ClientColormap(Resource.fakeClientId(var1_1), var1_1.index, this.id);
            }
            if (this.visual.clss == 5 || !(var19_9 = this.allocPseudo(var1_1, var2_2, var3_3, var4_4, var5_5, var18_8 = new int[1]))) break block5;
            var20_10 = 0;
            var11_11 = 1;
            var14_12 = var3_3;
            ** GOTO lbl18
            {
                var11_11 += var11_11;
                do {
                    if ((var18_8[0] & var11_11) == 0) continue block0;
                    var6_6[var20_10] = var11_11;
                    ++var20_10;
                    var11_11 += var11_11;
lbl18:
                    // 2 sources

                } while (--var14_12 >= 0);
            }
        }
        if (var1_1.errorReason == 0 && var17_7 != null) {
            Resource.add(var17_7);
        }
    }

    private boolean allocPseudo(Client client, int n, int n2, boolean bl, int[] nArray, int[] nArray2) {
        int n3 = n << n2;
        if (n2 >= 32 || n3 > this.freeRed || n3 < n) {
            client.errorReason = 11;
            return false;
        }
        int[] nArray3 = new int[n3];
        boolean bl2 = this.allocCP(client, this.entries, n, n2, bl, nArray3, nArray2);
        if (bl2) {
            int[] nArray4 = this.expand(this.pixels[client.index], n3);
            System.arraycopy(nArray3, 0, nArray4, nArray4.length - n3, n3);
            this.pixels[client.index] = nArray4;
            this.freeRed -= n3;
            System.arraycopy(nArray3, 0, nArray, 0, n);
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean allocCP(Client var1_1, Entry[] var2_2, int var3_3, int var4_4, boolean var5_5, int[] var6_6, int[] var7_7) {
        block23: {
            var13_8 = this.visual.nplanes;
            if (var4_4 != 0) break block23;
            var18_9 = 0;
            var19_11 = 0;
            ** GOTO lbl15
            {
                ++var18_9;
                do {
                    if (var18_9 < var2_2.length) {
                        var8_13 = var2_2[var18_9];
                        if (var8_13.refcnt != 0) continue block0;
                    }
                    if (var18_9 == var2_2.length) {
                        var18_9 = -1;
                        break block0;
                    }
                    ++var19_11;
lbl15:
                    // 2 sources

                } while (var19_11 < var3_3);
            }
            if (var18_9 == -1) {
                var1_1.errorReason = 11;
                return false;
            }
            var18_9 = 0;
            var20_14 = 0;
            ** GOTO lbl30
            {
                ++var18_9;
                do {
                    var8_13 = var2_2[var18_9];
                    if (var8_13.refcnt != 0) continue block2;
                    this.chkLocalEntry(var18_9);
                    var8_13.refcnt = -1;
                    var6_6[var20_14] = var18_9;
                    ++var20_14;
lbl30:
                    // 2 sources

                } while (var20_14 < var3_3);
            }
            var7_7[0] = 0;
            return true;
        }
        if (var4_4 > var13_8) {
            var1_1.errorReason = 11;
            return false;
        }
        var16_15 = (1 << var4_4) - 1;
        var10_16 = 1;
        var13_8 -= var4_4 - 1;
        while (--var13_8 >= 0) {
            var18_10 = 0;
            var15_21 = var6_6;
            var14_20 = 0;
            var9_17 = 0;
            var19_12 = this.visual.colormapEntries - var16_15;
            while (var9_17 < var19_12) {
                var12_19 = var9_17;
                var11_18 = var9_17 + var16_15 + var10_16;
                while (var9_17 != var11_18 && var2_2[var9_17].refcnt == 0) {
                    var9_17 += var10_16;
                }
                if (var9_17 == var11_18) {
                    var15_21[var18_10] = var12_19;
                    ++var18_10;
                    if (++var14_20 == var3_3) {
                        block7: while (--var3_3 >= 0) {
                            var9_17 = var6_6[var3_3];
                            var11_18 = var9_17 + var16_15;
                            while (true) {
                                this.chkLocalEntry(var9_17);
                                var2_2[var9_17].refcnt = -1;
                                var2_2[var9_17].shared = false;
                                if (var9_17 == var11_18) continue block7;
                                var15_21[var18_10] = var9_17 += var10_16;
                                ++var18_10;
                            }
                        }
                        var7_7[0] = var16_15;
                        return true;
                    }
                }
                if (((var9_17 = var12_19 + 1) & var16_15) == 0) continue;
                var9_17 += var16_15;
            }
            var16_15 += var16_15;
            var10_16 += var10_16;
        }
        var13_8 = this.visual.nplanes;
        if (var5_5 || var4_4 == 1 || var13_8 < 3) {
            return false;
        }
        var17_22 = ((1 << var4_4 - 1) - 1 << var13_8 - var4_4 + 1) + (1 << var13_8 - var4_4 - 1);
        var16_15 = (3 << var4_4 - 1) - 1;
        while (var16_15 <= var17_22) {
            block24: {
                var9_17 = var16_15 >> 1 & -613566757;
                if (((var9_17 = var16_15 - var9_17 - (var9_17 >> 1 & -613566757)) + (var9_17 >> 3) & -954437177) % 63 != var4_4) break block24;
                var15_21 = var6_6;
                var18_10 = 0;
                var14_20 = 0;
                var19_12 = this.visual.colormapEntries - var16_15;
                var10_16 = Colormap.lowbit(var16_15);
                var9_17 = 0;
                while (var9_17 < var19_12) {
                    block25: {
                        if ((var9_17 & var16_15) != 0) break block25;
                        var11_18 = 0;
                        while (var2_2[var9_17 + var11_18].refcnt == 0) {
                            if (var11_18 == var16_15) break;
                            var11_18 += var10_16;
                            while ((var11_18 & ~var16_15) != 0) {
                                var11_18 += var11_18 & ~var16_15;
                            }
                        }
                        if (var11_18 < var16_15 || var2_2[var9_17 + var16_15].refcnt != 0) break block25;
                        var15_21[var18_10] = var9_17;
                        ++var18_10;
                        if (++var14_20 >= var3_3) ** GOTO lbl118
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            var9_17 = var6_6[var3_3];
                            var11_18 = 0;
                            while (true) {
                                this.chkLocalEntry(var9_17 + var11_18);
                                var2_2[var9_17 + var11_18].refcnt = -1;
                                var2_2[var9_17 + var11_18].shared = false;
                                if (var11_18 == var16_15) continue block13;
                                var11_18 += var10_16;
                                while ((var11_18 & ~var16_15) != 0) {
                                    var11_18 += var11_18 & ~var16_15;
                                }
                                var15_21[var18_10] = var9_17 + var11_18;
                                ++var18_10;
                            }
lbl118:
                            // 2 sources

                            ** while (--var3_3 >= 0)
                        }
lbl119:
                        // 1 sources

                        var7_7[0] = var16_15;
                        return true;
                    }
                    ++var9_17;
                }
            }
            ++var16_15;
        }
        return false;
    }

    private void freeColors(Client client, int n, int n2) throws IOException {
        IO iO = client.client;
        if ((this.flags & 2) != 0) {
            client.errorReason = 10;
            return;
        }
        if (n == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = iO.readInt();
            ++n3;
        }
        client.length = 0;
        this.freeColors(client, nArray, n2);
    }

    void freeColors(Client client, int[] nArray, int n) throws IOException {
        int n2 = 0;
        if ((this.visual.clss | 1) == 5) {
            n2 = 0;
        } else {
            n2 = n & (1 << this.visual.nplanes) - 1;
            this.freeCo(client, 3, nArray, n2);
        }
        if (n != n2) {
            client.errorValue = nArray[0] | n;
            client.errorReason = 2;
        }
    }

    private void freeCo(Client client, int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 255;
        int n7 = 0;
        int[] nArray2 = null;
        int n8 = 0;
        int n9 = 0;
        int n10 = Colormap.lowbit(n2);
        switch (n) {
            default: 
        }
        n6 = -1;
        int n11 = 0;
        n7 = 0;
        int n12 = this.visual.colormapEntries;
        nArray2 = this.pixels[client.index];
        block5: while (true) {
            n4 = 0;
            while (n4 < nArray.length) {
                int n13 = ((nArray[n4] | n8) & n6) >> n7;
                if (n13 >= n12 || (nArray[n4] & n11) != 0) {
                    client.errorValue = nArray[n4] | n8;
                    n5 = 2;
                } else if (nArray2 == null) {
                    n5 = 10;
                } else {
                    n3 = 0;
                    while (n3 < nArray2.length && nArray2[n3] != n13) {
                        ++n3;
                    }
                    if (n3 != nArray2.length) {
                        if ((this.visual.clss & 1) != 0) {
                            this.freeCell(n13, n);
                            nArray2[n3] = -1;
                            ++n9;
                        } else {
                            n5 = 10;
                        }
                    }
                }
                ++n4;
            }
            if (n8 == n2) break;
            n8 += n10;
            while (true) {
                if ((n8 & ~n2) == 0) continue block5;
                n8 += n8 & ~n2;
            }
            break;
        }
        if (n9 != 0) {
            n4 = nArray2.length - n9;
            if (n4 != 0) {
                int[] nArray3 = nArray2;
                int[] nArray4 = nArray2;
                n3 = 0;
                int n14 = 0;
                while (n3 < nArray2.length && n14 < n4) {
                    if (nArray3[n3] != -1) {
                        nArray4[n14] = nArray3[n3];
                        ++n14;
                    }
                    ++n3;
                }
                int[] nArray5 = new int[n4];
                System.arraycopy(nArray2, 0, nArray5, 0, n4);
                nArray2 = nArray5;
            } else {
                nArray2 = null;
            }
            switch (n) {
                case 0: 
                case 3: {
                    this.pixels[client.index] = nArray2;
                }
            }
        }
        if (n5 != 0) {
            client.errorReason = n5;
        }
    }

    private void storeColors(Client client, int n) throws IOException {
        int n2 = 0;
        IO iO = client.client;
        if ((this.visual.clss & 1) == 0 && (this.flags & 4) == 0) {
            client.errorReason = 11;
            return;
        }
        boolean bl = false;
        while (n != 0) {
            int n3 = iO.readInt();
            --n;
            int n4 = iO.readShort();
            int n5 = iO.readShort();
            --n;
            int n6 = iO.readShort();
            int n7 = iO.readByte();
            iO.readPad(1);
            --n;
            if ((n4 >> 8 & 0xFF) != 0 || (n5 >> 8 & 0xFF) != 0 || (n6 >> 8 & 0xFF) != 0) {
                n4 = n4 >> 8 & 0xFF;
                n5 = n5 >> 8 & 0xFF;
                n6 = n6 >> 8 & 0xFF;
            } else {
                n4 &= 0xFF;
                n5 &= 0xFF;
                n6 &= 0xFF;
            }
            n2 = this.storeColor(client, n3, n4, n5, n6, n7);
        }
        client.errorReason = n2;
    }

    private int storeColor(Client client, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = 0;
        if ((this.visual.clss | 1) != 5) {
            boolean bl = true;
            if (n >= this.visual.colormapEntries) {
                client.errorValue = n;
                n6 = 2;
                bl = false;
            } else if (this.entries[n].refcnt != -1) {
                n6 = 11;
                bl = false;
            }
            if (!bl) {
                return n6;
            }
            Entry entry = this.entries[n];
            if ((n5 & 1) != 0) {
                if (!entry.shared) {
                    ((LocalEntry)entry).r = n2;
                }
            } else if (!entry.shared) {
                n2 = ((LocalEntry)entry).r;
            }
            if ((n5 & 2) != 0) {
                if (!entry.shared) {
                    ((LocalEntry)entry).g = n3;
                }
            } else if (!entry.shared) {
                n3 = ((LocalEntry)entry).g;
            }
            if ((n5 & 4) != 0) {
                if (!entry.shared) {
                    ((LocalEntry)entry).b = n4;
                }
            } else if (!entry.shared) {
                n4 = ((LocalEntry)entry).b;
            }
            this.alloc(n, new Color(n2, n3, n4));
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryColors(Client client, int[] nArray) throws IOException {
        IO iO = client.client;
        if ((this.visual.clss & 1) == 0 && this.visual.depth.depth == 16) {
            int n = nArray.length;
            IO iO2 = iO;
            synchronized (iO2) {
                iO.writeByte(1);
                iO.writePad(1);
                iO.writeShort(client.seq);
                iO.writeInt(n * 2);
                iO.writeShort(n);
                iO.writePad(22);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    int n4 = (n3 >> 11 & 0x1F) * 8;
                    iO.writeShort(n4 | n4 << 8);
                    n4 = (n3 >> 5 & 0x3F) * 4;
                    iO.writeShort(n4 | n4 << 8);
                    n4 = (n3 & 0x1F) * 8;
                    iO.writeShort(n4 | n4 << 8);
                    iO.writePad(2);
                    ++n2;
                }
                iO.flush();
                return;
            }
        }
        if ((this.visual.clss | 1) != 5) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] >= this.visual.colormapEntries) {
                    client.errorValue = nArray[n];
                    client.errorReason = 2;
                    return;
                }
                ++n;
            }
            IO iO3 = iO;
            synchronized (iO3) {
                iO.writeByte(1);
                iO.writePad(1);
                iO.writeShort(client.seq);
                iO.writeInt(nArray.length * 2);
                iO.writeShort(nArray.length);
                iO.writePad(22);
                int n5 = 0;
                while (n5 < nArray.length) {
                    Entry entry = this.entries[nArray[n5]];
                    if (!entry.shared) {
                        LocalEntry localEntry = (LocalEntry)entry;
                        iO.writeShort(localEntry.r | localEntry.r << 8);
                        iO.writeShort(localEntry.g | localEntry.g << 8);
                        iO.writeShort(localEntry.b | localEntry.b << 8);
                        iO.writePad(2);
                    }
                    ++n5;
                }
                iO.flush();
            }
        }
    }

    private static int lowbit(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if ((n & 1) != 0) {
                n2 <<= n3;
                break;
            }
            n >>= 1;
            ++n3;
        }
        return n2;
    }

    private int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[n + (nArray == null ? 0 : nArray.length)];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    void mkIcm() {
        if ((this.visual.clss & 1) != 0 || (this.flags & 4) != 0) {
            if (this.visual.depth.depth == 16) {
                return;
            }
            this.cm = new IndexColorModel(this.r.length == 256 ? 8 : 1, this.r.length, this.r, this.g, this.b);
        }
        this.icmtime = System.currentTimeMillis();
    }

    static {
        byte[] byArray = new byte[]{0, -1};
        bwicm = new IndexColorModel(1, 2, byArray, byArray, byArray);
        installed = null;
        defaultColormap = null;
        rgbTable = null;
    }
}

