#### wcch command line options

wcch takes a single mandatory argument : the path to an ELF executable or shared library.

	wcch </path/to/binary>


wcch will generate minimal C header files suitable for compiling C code against the binary given as argument.


#### Example usage of wcch

The following command instructs wcch to generate C headers from the apache2 executable and redirects the output from the standard output to a file named /tmp/apache2.h ready for use as a header in a C application.

	jonathan@blackbox:~$ wcch /usr/sbin/apache2 >/tmp/apache2.h
	jonathan@blackbox:~$ 

Here is the actual content of the generated /tmp/apache2.h file, edited because of its large size:

	/**
	*
	* Automatically generated by the Whitchcraft Compiler Collection 0.0.1
	*
	* 23:17:22 Jul 26 2016
	*
	*/


	/**
	* Imported objects
	**/
	extern void *_dlfcn_hook;
	extern void *daylight;
	extern void *_sys_nerr;
	extern void *getdate_err;
	extern void *__rcmd_errstr;
	extern void *optind;
	extern void *argp_program_version;
	extern void *__free_hook;
	extern void *__tzname;
	extern void *__progname;
	extern void *_environ;
	...
	extern void *ap_hack_ap_build_cont_config;
	extern void *ap_hack_ap_find_etag_weak;
	extern void *ap_hack_ap_hook_get_post_read_request;
	extern void *ap_hack_apr_file_name_get;
	extern void *ap_hack_apr_sdbm_unlock;
	extern void *ap_hack_ap_is_rdirectory;
	extern void *ap_hack_ap_request_has_body;
	extern void *ap_hack_apr_pool_cleanup_run;
	extern void *ap_hack_ap_hook_get_type_checker;
	extern void *ap_hack_apr_global_mutex_pool_get;
	extern void *ap_hack_apr_file_data_set;
	extern void *ap_hack_ap_hook_get_child_status;
	extern void *ap_hack_ap_set_server_protocol;
	extern void *ap_hack_apr_hash_make_custom;
	extern void *ap_hack_ap_malloc;
	extern void *ap_hack_ap_pool_cleanup_set_null;
	extern void *ap_hack_apr_dbm_firstkey;
	extern void *ap_hack_apr_strmatch_precompile;
	...


	/**
	* Imported functions
	**/
	void *dlclose();
	void *dlinfo();
	void *dladdr1();
	void *dlsym();
	void *dladdr();
	void *dlopen();
	void *dlmopen();
	void *dlerror();
	void *dlvsym();
	void *putwchar();
	void *__strspn_c1();
	void *__gethostname_chk();
	void *__strspn_c2();
	void *setrpcent();
	void *__wcstod_l();
	void *__strspn_c3();
	void *epoll_create();
	void *sched_get_priority_min();
	void *__getdomainname_chk();
	void *klogctl();
	void *__tolower_l();
	void *dprintf();
	void *setuid();
	...
	void *ap_mpm_pod_killpg();
	void *ap_register_hooks();
	void *ap_remove_output_filter_byhandle();
	void *ap_hook_create_request();
	void *ap_expr_exec_ctx();
	void *ap_send_http_options();
	void *ap_mpm_set_max_requests();
	void *ap_os_escape_path();
	void *ap_file_walk();
	void *ap_build_cont_config();
	void *ap_start_lingering_close();
	void *ap_hook_generate_log_id();
	void *ap_varbuf_cfg_getline();
	void *ap_hook_test_config();
	void *ap_fcgi_header_to_array();
	void *ap_http_chunk_filter();
	void *ap_random_insecure_bytes();
	void *ap_pcfg_open_custom();
	void *ap_hook_get_auth_checker();
	void *ap_expr_yyfree();
	...
	void *uuid_copy();
	void *uuid_generate();


The functions prototypes and imported objects cover all of the API exported by executables and shared libraries including their recursive dependancies. All the programmable API in the address space. #Witchcraft

#### How is this useful ?

Both gcc and clang will happily use the above mention function prototypes when compiling C code making use of them instead of issuing errors due to missing function prototypes. This is a great feature : it means we can now call those functions from C without actually knowing their exact prototypes (such as arguments number and types).