/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.eventmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.util.KeySensorDevice;
import org.xj3d.device.DeviceManager;

public abstract class DeviceFactory {
    private static final String PROPERTY_FILE = "xj3d-devices.properties";
    private static final String LOAD_DEVICE_PROPERTIES_ERR_MSG = "Error getting device properties";
    protected String toolkitID;
    protected String rendererID;
    protected Object canvas;
    protected Object surface;
    protected ErrorReporter errorReporter;

    protected DeviceFactory() {
    }

    public abstract DeviceManager[] getDeviceManagers();

    public abstract KeySensorDevice getKeySensorDevice();

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    protected List createDevices() {
        final ArrayList arrayList = new ArrayList();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Object object;
                    InputStream inputStream;
                    String string = System.getProperty("user.dir");
                    String string2 = string + File.separator + DeviceFactory.PROPERTY_FILE;
                    String string3 = "config/common/xj3d-devices.properties";
                    try {
                        inputStream = new FileInputStream(string2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        inputStream = ClassLoader.getSystemResourceAsStream(string3);
                    }
                    if (inputStream == null) {
                        object = DeviceFactory.class.getClassLoader();
                        inputStream = ((ClassLoader)object).getResourceAsStream(string3);
                    }
                    if (inputStream == null) {
                        DeviceFactory.this.errorReporter.warningReport("No property file found in " + string3, null);
                    } else {
                        object = new Properties();
                        try {
                            ((Properties)object).load(inputStream);
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            DeviceFactory.this.errorReporter.warningReport("Error reading" + string3, null);
                        }
                        String string4 = "devices." + DeviceFactory.this.toolkitID + "." + DeviceFactory.this.rendererID + ".list";
                        String string5 = ((Properties)object).getProperty(string4);
                        if (string5 == null) {
                            DeviceFactory.this.errorReporter.warningReport("No devices list found: " + string4, null);
                            return null;
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string5);
                        int n = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            n = 0;
                            String string6 = stringTokenizer.nextToken();
                            String string7 = ((Properties)object).getProperty(string6 + ".name");
                            String string8 = ((Properties)object).getProperty(string6 + ".class");
                            String string9 = ((Properties)object).getProperty(string6 + ".params");
                            Object[] objectArray = new Object[n];
                            if (string9 != null && (n = Integer.parseInt(string9)) > 0) {
                                objectArray = new Object[n];
                                for (int i = 0; i < n; ++i) {
                                    string9 = ((Properties)object).getProperty(string6 + ".param." + i);
                                    if (string9 == null) continue;
                                    if (string9.equals("PARAM_CANVAS")) {
                                        objectArray[i] = DeviceFactory.this.canvas;
                                        continue;
                                    }
                                    if (string9.equals("PARAM_SURFACE")) {
                                        objectArray[i] = DeviceFactory.this.surface;
                                        continue;
                                    }
                                    DeviceFactory.this.errorReporter.warningReport("Unhandled param in device: " + string7, null);
                                }
                            }
                            Class<?> clazz = null;
                            Object e = null;
                            boolean bl = false;
                            try {
                                clazz = Class.forName(string8);
                                Constructor<?>[] constructorArray = clazz.getConstructors();
                                for (int i = 0; i < constructorArray.length; ++i) {
                                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                                    if (classArray.length != n) continue;
                                    e = constructorArray[i].newInstance(objectArray);
                                    bl = true;
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                DeviceFactory.this.errorReporter.warningReport("Error loading " + string7 + " at: " + string8, exception);
                            }
                            if (bl) {
                                arrayList.add(e);
                                continue;
                            }
                            DeviceFactory.this.errorReporter.warningReport("Cannot load " + string7 + " at: " + string8, null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.errorReporter.errorReport(LOAD_DEVICE_PROPERTIES_ERR_MSG, privilegedActionException);
        }
        return arrayList;
    }
}

