/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.awt.Rectangle;
import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceLayoutNode;

public abstract class BaseGroupLayout
extends BaseSurfaceLayoutNode {
    protected static final int NUM_FIELDS = 4;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;

    protected BaseGroupLayout() {
        super("GroupLayout");
        this.hasChanged = new boolean[4];
    }

    protected BaseGroupLayout(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceLayoutNodeType)vRMLNodeType);
    }

    public void setLocation(int n, int n2) {
        int n3 = n - (int)this.screenLocation[0];
        int n4 = n2 - (int)this.screenLocation[1];
        super.setLocation(n, n2);
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            int n5 = rectangle.x + n3;
            int n6 = rectangle.y + n4;
            vRMLSurfaceChildNodeType.setLocation(n5, n6);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f) {
            return;
        }
        this.updateManagedNodes();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseGroupLayout.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGroupLayout.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseGroupLayout.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseGroupLayout.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "children");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(3);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
    }
}

