// Unix replacement for Win32 kbhit() function
// Difference from Win32 is that this version only works
// when the return key is pressed, not any key

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <assert.h>
#include <errno.h>

int kbhit() {
	int ret,ret_read;
	char buf;

	ret = fcntl(1, F_SETFL, O_NONBLOCK);
//	assert(ret != -1);
	if (ret == -1){ 
//		perror("kbhit error!"); 
		return(0);
	}

	ret_read = read(1, &buf, 1);
	if (ret_read == -1){ 
//		perror("kbhit error!"); 
		return(0);
	}

	ret = fcntl(1, F_SETFL, 0);
//	assert(ret != -1);
	if (ret == -1){ 
//		perror("kbhit error!"); 
		return(0);
	}

	if (ret_read == -1) 
		return 0;
	else
		return buf;
}

