// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UHSUB_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UHSUB_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uhsub_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x3fff, 0xffff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x3fff, 0x3fff, 0xffff,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8,
  0xc040, 0xc040, 0xd99a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1,
  0xc040, 0xc040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1,
  0xc03f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001,
  0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xbfff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xaaab,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x999a,
  0xc040, 0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x8040,
  0xc040, 0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x803f,
  0xc03f, 0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0x803f,
  0xc03f, 0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0x803e,
  0xc03e, 0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x8008,
  0xaaea, 0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0x8001,
  0x99d9, 0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0x8001,
  0x807f, 0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0x8000,
  0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0x8000, 0x0000,
  0x807e, 0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000,
  0x807e, 0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff, 0xffff, 0xffff,
  0x8047, 0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff, 0xffff, 0xfff8,
  0x8041, 0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2,
  0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1,
  0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xbfff, 0xaaab,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xaaab, 0x999a,
  0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x999a, 0x8040,
  0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x8040, 0x8040,
  0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x803f, 0x803f,
  0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0x803f, 0x803f,
  0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0x803e, 0x8008,
  0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x8008, 0x8002,
  0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0x8001, 0x8001,
  0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0x8001, 0x8001,
  0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0x8001, 0x8001, 0x0001,
  0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0x8000, 0x0000, 0x0000,
  0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000,
  0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff, 0xffff, 0xffff, 0xfff9,
  0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2,
  0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2,
  0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0xc001,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0xc000, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0xaaac,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xbfff, 0xaaab, 0x999b,
  0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xaaab, 0x999a, 0x8041,
  0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x999a, 0x8040, 0x8040,
  0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x8040, 0x8040, 0x8040,
  0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x803f, 0x803f, 0x803f,
  0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0x803f, 0x803f, 0x8009,
  0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0x803e, 0x8008, 0x8002,
  0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x8008, 0x8002, 0x8002,
  0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0x8001, 0x8001, 0x8001,
  0xaaea, 0xc03d, 0xc03d, 0xc007, 0x8001, 0x8001, 0x8001, 0x0008,
  0xaae9, 0xc03d, 0xc007, 0xc001, 0x8001, 0x8001, 0x0001, 0x0007,
  0xaae9, 0xc006, 0xc000, 0xc000, 0x8000, 0x0000, 0x0000, 0x0007,
  0xaab2, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0xbfff, 0xbfff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9,
  0xaaab, 0xbfff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9,
  0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0xc008,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0xc001, 0xc007,
  0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0xc000, 0xc000, 0xaab3,
  0x0000, 0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0xaaac, 0x99a2,
  0xeaac, 0xffff, 0xffff, 0xffff, 0xbfff, 0xaaab, 0x999b, 0x8048,
  0xeaab, 0xffff, 0xffff, 0xffff, 0xaaab, 0x999a, 0x8041, 0x8047,
  0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x999a, 0x8040, 0x8040, 0x8047,
  0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x8040, 0x8040, 0x8040, 0x8046,
  0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x803f, 0x803f, 0x803f, 0x8010,
  0xd555, 0xd998, 0xc03f, 0xc03f, 0x803f, 0x803f, 0x8009, 0x8009,
  0xc444, 0xc03e, 0xc03e, 0xc03e, 0x803e, 0x8008, 0x8002, 0x8009,
  0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x8008, 0x8002, 0x8002, 0x8008,
  0xc03e, 0xc03e, 0xc03e, 0x8008, 0x8002, 0x8002, 0x8008, 0x003e,
  0xc03d, 0xc03d, 0xc007, 0x8001, 0x8001, 0x8001, 0x0008, 0x003e,
  0xc03d, 0xc007, 0xc001, 0x8001, 0x8001, 0x0001, 0x0007, 0x003d,
  0xc006, 0xc000, 0xc000, 0x8000, 0x0000, 0x0000, 0x0007, 0x0036,
  0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xbfff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff,
  0xbfff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff,
  0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5,
  0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594,
  0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040,
  0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f,
  0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f,
  0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0xc03e,
  0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0xc008, 0xc03e,
  0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0xc001, 0xc007, 0xaae9,
  0x1554, 0x0000, 0x0000, 0xc000, 0xc000, 0xc000, 0xaab3, 0x99d8,
  0x0000, 0x0000, 0x0000, 0xc000, 0xc000, 0xaaac, 0x99a2, 0x807e,
  0xffff, 0xffff, 0xffff, 0xbfff, 0xaaab, 0x999b, 0x8048, 0x807e,
  0xffff, 0xffff, 0xffff, 0xaaab, 0x999a, 0x8041, 0x8047, 0x807d,
  0xfffe, 0xfffe, 0xeaaa, 0x999a, 0x8040, 0x8040, 0x8047, 0x807d,
  0xfffe, 0xeaaa, 0xd999, 0x8040, 0x8040, 0x8040, 0x8046, 0x8046,
  0xeaa9, 0xd999, 0xc03f, 0x803f, 0x803f, 0x803f, 0x8010, 0x8040,
  0xd998, 0xc03f, 0xc03f, 0x803f, 0x803f, 0x8009, 0x8009, 0x803f,
  0xc03e, 0xc03e, 0xc03e, 0x803e, 0x8008, 0x8002, 0x8009, 0x803f,
  0xc03e, 0xc03e, 0x803e, 0x8008, 0x8002, 0x8009, 0x803f, 0x003f,
  0xc03e, 0xc03e, 0x8008, 0x8002, 0x8002, 0x8008, 0x003e, 0x003e,
  0xc03d, 0xc007, 0x8001, 0x8001, 0x8001, 0x0008, 0x003e, 0x003e,
  0xc007, 0xc001, 0x8001, 0x8001, 0x0001, 0x0007, 0x003d, 0x0037,
  0xc000, 0xc000, 0x8000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000,
  0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff,
  0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5,
  0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594,
  0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040,
  0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040,
  0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f,
  0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0xc03f,
  0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0xc03e, 0xc03e,
  0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0xc008, 0xc03e, 0xaaea,
  0x1554, 0x0001, 0xc001, 0xc001, 0xc001, 0xc007, 0xaae9, 0x99d9,
  0x0000, 0x0000, 0xc000, 0xc000, 0xc000, 0xaab3, 0x99d8, 0x807f,
  0x0000, 0x0000, 0xc000, 0xc000, 0xaaac, 0x99a2, 0x807e, 0x807e,
  0xffff, 0xffff, 0xbfff, 0xaaab, 0x999b, 0x8048, 0x807e, 0x807e,
  0xffff, 0xffff, 0xaaab, 0x999a, 0x8041, 0x8047, 0x807d, 0x807d,
  0xfffe, 0xeaaa, 0x999a, 0x8040, 0x8040, 0x8047, 0x807d, 0x8047,
  0xeaaa, 0xd999, 0x8040, 0x8040, 0x8040, 0x8046, 0x8046, 0x8040,
  0xd999, 0xc03f, 0x803f, 0x803f, 0x803f, 0x8010, 0x8040, 0x8040,
  0xc03f, 0xc03f, 0x803f, 0x803f, 0x8009, 0x8009, 0x803f, 0x803f,
  0xc03f, 0x803f, 0x803f, 0x8009, 0x8009, 0x803f, 0x803f, 0x003f,
  0xc03e, 0x803e, 0x8008, 0x8002, 0x8009, 0x803f, 0x003f, 0x003f,
  0xc03e, 0x8008, 0x8002, 0x8002, 0x8008, 0x003e, 0x003e, 0x003e,
  0xc007, 0x8001, 0x8001, 0x8001, 0x0008, 0x003e, 0x003e, 0x0037,
  0xc001, 0x8001, 0x8001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001,
  0xc000, 0x8000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000,
  0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6,
  0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595,
  0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041,
  0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040,
  0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040,
  0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0xc03f,
  0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0xc03f, 0xc03f,
  0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0xc03e, 0xc03e, 0xaaea,
  0x1555, 0xc001, 0xc001, 0xc001, 0xc008, 0xc03e, 0xaaea, 0x99d9,
  0x0001, 0xc001, 0xc001, 0xc001, 0xc007, 0xaae9, 0x99d9, 0x807f,
  0x0000, 0xc000, 0xc000, 0xc000, 0xaab3, 0x99d8, 0x807f, 0x807f,
  0x0000, 0xc000, 0xc000, 0xaaac, 0x99a2, 0x807e, 0x807e, 0x807e,
  0xffff, 0xbfff, 0xaaab, 0x999b, 0x8048, 0x807e, 0x807e, 0x807e,
  0xffff, 0xaaab, 0x999a, 0x8041, 0x8047, 0x807d, 0x807d, 0x8047,
  0xeaaa, 0x999a, 0x8040, 0x8040, 0x8047, 0x807d, 0x8047, 0x8041,
  0xd999, 0x8040, 0x8040, 0x8040, 0x8046, 0x8046, 0x8040, 0x8040,
  0xc03f, 0x803f, 0x803f, 0x803f, 0x8010, 0x8040, 0x8040, 0x8040,
  0x803f, 0x803f, 0x803f, 0x8010, 0x8040, 0x8040, 0x8040, 0x1999,
  0x803f, 0x803f, 0x8009, 0x8009, 0x803f, 0x803f, 0x003f, 0x1999,
  0x803e, 0x8008, 0x8002, 0x8009, 0x803f, 0x003f, 0x003f, 0x1998,
  0x8008, 0x8002, 0x8002, 0x8008, 0x003e, 0x003e, 0x003e, 0x1991,
  0x8001, 0x8001, 0x8001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b,
  0x8001, 0x8001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a,
  0x8000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef,
  0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b,
  0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a,
  0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a,
  0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0xd999,
  0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xd999,
  0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xc444,
  0xd555, 0xc002, 0xc002, 0xc008, 0xc03e, 0xc03e, 0xaaea, 0xb333,
  0xc001, 0xc001, 0xc001, 0xc008, 0xc03e, 0xaaea, 0x99d9, 0x99d9,
  0xc001, 0xc001, 0xc001, 0xc007, 0xaae9, 0x99d9, 0x807f, 0x99d9,
  0xc000, 0xc000, 0xc000, 0xaab3, 0x99d8, 0x807f, 0x807f, 0x99d8,
  0xc000, 0xc000, 0xaaac, 0x99a2, 0x807e, 0x807e, 0x807e, 0x99d8,
  0xbfff, 0xaaab, 0x999b, 0x8048, 0x807e, 0x807e, 0x807e, 0x99a1,
  0xaaab, 0x999a, 0x8041, 0x8047, 0x807d, 0x807d, 0x8047, 0x999b,
  0x999a, 0x8040, 0x8040, 0x8047, 0x807d, 0x8047, 0x8041, 0x999a,
  0x8040, 0x8040, 0x8040, 0x8046, 0x8046, 0x8040, 0x8040, 0x999a,
  0x8040, 0x8040, 0x8046, 0x8046, 0x8040, 0x8040, 0x999a, 0x2aaa,
  0x803f, 0x803f, 0x8010, 0x8040, 0x8040, 0x8040, 0x1999, 0x2aaa,
  0x803f, 0x8009, 0x8009, 0x803f, 0x803f, 0x003f, 0x1999, 0x2aa9,
  0x8008, 0x8002, 0x8009, 0x803f, 0x003f, 0x003f, 0x1998, 0x2aa2,
  0x8002, 0x8002, 0x8008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c,
  0x8001, 0x8001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b,
  0x8001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b,
  0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac,
  0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab,
  0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab,
  0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0xeaaa,
  0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0xd999, 0xeaaa,
  0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xd999, 0xd555,
  0xd556, 0xc002, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xc444, 0xc444,
  0xc002, 0xc002, 0xc008, 0xc03e, 0xc03e, 0xaaea, 0xb333, 0xaaea,
  0xc001, 0xc001, 0xc008, 0xc03e, 0xaaea, 0x99d9, 0x99d9, 0xaaea,
  0xc001, 0xc001, 0xc007, 0xaae9, 0x99d9, 0x807f, 0x99d9, 0xaae9,
  0xc000, 0xc000, 0xaab3, 0x99d8, 0x807f, 0x807f, 0x99d8, 0xaae9,
  0xc000, 0xaaac, 0x99a2, 0x807e, 0x807e, 0x807e, 0x99d8, 0xaab2,
  0xaaab, 0x999b, 0x8048, 0x807e, 0x807e, 0x807e, 0x99a1, 0xaaac,
  0x999a, 0x8041, 0x8047, 0x807d, 0x807d, 0x8047, 0x999b, 0xaaab,
  0x8040, 0x8040, 0x8047, 0x807d, 0x8047, 0x8041, 0x999a, 0xaaab,
  0x8040, 0x8047, 0x807d, 0x8047, 0x8041, 0x999a, 0xaaab, 0x3ffe,
  0x8040, 0x8046, 0x8046, 0x8040, 0x8040, 0x999a, 0x2aaa, 0x3ffe,
  0x803f, 0x8010, 0x8040, 0x8040, 0x8040, 0x1999, 0x2aaa, 0x3ffd,
  0x8009, 0x8009, 0x803f, 0x803f, 0x003f, 0x1999, 0x2aa9, 0x3ff6,
  0x8002, 0x8009, 0x803f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0,
  0x8002, 0x8008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf,
  0x8001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf,
  0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665,
  0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff,
  0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff,
  0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0xfffe,
  0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0xeaaa, 0xfffe,
  0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0xd999, 0xeaaa, 0xeaa9,
  0xd556, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xd999, 0xd555, 0xd998,
  0xc002, 0xc009, 0xc03f, 0xc03f, 0xc03f, 0xc444, 0xc444, 0xc03e,
  0xc002, 0xc008, 0xc03e, 0xc03e, 0xaaea, 0xb333, 0xaaea, 0xc03e,
  0xc001, 0xc008, 0xc03e, 0xaaea, 0x99d9, 0x99d9, 0xaaea, 0xc03d,
  0xc001, 0xc007, 0xaae9, 0x99d9, 0x807f, 0x99d9, 0xaae9, 0xc03d,
  0xc000, 0xaab3, 0x99d8, 0x807f, 0x807f, 0x99d8, 0xaae9, 0xc006,
  0xaaac, 0x99a2, 0x807e, 0x807e, 0x807e, 0x99d8, 0xaab2, 0xc000,
  0x999b, 0x8048, 0x807e, 0x807e, 0x807e, 0x99a1, 0xaaac, 0xbfff,
  0x8041, 0x8047, 0x807d, 0x807d, 0x8047, 0x999b, 0xaaab, 0xbfff,
  0x8047, 0x807d, 0x807d, 0x8047, 0x999b, 0xaaab, 0xbfff, 0x3fff,
  0x8047, 0x807d, 0x8047, 0x8041, 0x999a, 0xaaab, 0x3ffe, 0x3ffe,
  0x8046, 0x8046, 0x8040, 0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x3ffe,
  0x8010, 0x8040, 0x8040, 0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7,
  0x8009, 0x803f, 0x803f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0,
  0x8009, 0x803f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0,
  0x8008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf,
  0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665,
  0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554,
  0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff,
  0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff,
  0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe,
  0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa,
  0xd55d, 0xc040, 0xc040, 0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999,
  0xc009, 0xc03f, 0xc03f, 0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f,
  0xc009, 0xc03f, 0xc03f, 0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e,
  0xc008, 0xc03e, 0xc03e, 0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e,
  0xc008, 0xc03e, 0xaaea, 0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d,
  0xc007, 0xaae9, 0x99d9, 0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007,
  0xaab3, 0x99d8, 0x807f, 0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000,
  0x99a2, 0x807e, 0x807e, 0x807e, 0x99d8, 0xaab2, 0xc000, 0xc000,
  0x8048, 0x807e, 0x807e, 0x807e, 0x99a1, 0xaaac, 0xbfff, 0xbfff,
  0x807e, 0x807e, 0x807e, 0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff,
  0x807d, 0x807d, 0x8047, 0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff,
  0x807d, 0x8047, 0x8041, 0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe,
  0x8046, 0x8040, 0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7,
  0x8040, 0x8040, 0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1,
  0x803f, 0x803f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0,
  0x803f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0,
  0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666,
  0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555,
  0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001,
  0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff,
  0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff,
  0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa,
  0xd594, 0xc040, 0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999,
  0xc040, 0xc040, 0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f,
  0xc03f, 0xc03f, 0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f,
  0xc03f, 0xc03f, 0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e,
  0xc03e, 0xc03e, 0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e,
  0xc03e, 0xaaea, 0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007,
  0xaae9, 0x99d9, 0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001,
  0x99d8, 0x807f, 0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000,
  0x807e, 0x807e, 0x807e, 0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000,
  0x807e, 0x807e, 0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000, 0x4000,
  0x807e, 0x807e, 0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x3fff,
  0x807d, 0x8047, 0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x3fff,
  0x8047, 0x8041, 0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8,
  0x8040, 0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1,
  0x8040, 0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1,
  0x803f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x2666,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x1555,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0001,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x0001,
  0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xffff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xeaab,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0xd99a,
  0xc040, 0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0xc040,
  0xc040, 0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0xc03f,
  0xc03f, 0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0xc03f,
  0xc03f, 0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0xc03e,
  0xc03e, 0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0xc008,
  0xaaea, 0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0xc001,
  0x99d9, 0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0xc001,
  0x807f, 0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0xc000,
  0x807f, 0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0xc000, 0x4000,
  0x807e, 0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000, 0x4000, 0x4000,
  0x807e, 0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x3fff, 0x3fff,
  0x8047, 0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x3ff8,
  0x8041, 0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2,
  0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1,
  0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0, 0x2667,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x2666, 0x1556,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x1555, 0x0002,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0001, 0x0001,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x0001, 0x0001,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xffff, 0xeaab,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xeaab, 0xd99a,
  0xc041, 0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0xd99a, 0xc040,
  0xc040, 0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0xc040, 0xc040,
  0xc040, 0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0xc03f, 0xc03f,
  0xc03f, 0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0xc03f, 0xc03f,
  0xc03f, 0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0xc03e, 0xc008,
  0xaaea, 0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xc002,
  0x99d9, 0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0xc001, 0xc001,
  0x807f, 0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0xc001, 0xc001,
  0x99d9, 0xaae9, 0xc03d, 0xc007, 0xc001, 0xc001, 0xc001, 0x5555,
  0x99d8, 0xaae9, 0xc006, 0xc000, 0xc000, 0xc000, 0x4000, 0x5554,
  0x99d8, 0xaab2, 0xc000, 0xc000, 0xc000, 0x4000, 0x4000, 0x5554,
  0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x554d,
  0x999b, 0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x3ff8, 0x5516,
  0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2, 0x5516,
  0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1, 0x5515,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0, 0x2667, 0x2aaa,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x2666, 0x1556, 0x1556,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x1555, 0x0002, 0x1556,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0001, 0x0001, 0x1555,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x0001, 0x0001, 0x1555,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x1554,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0xffff, 0xffff, 0xeaab, 0xeeef,
  0xd99b, 0xeaab, 0xffff, 0xffff, 0xffff, 0xeaab, 0xd99a, 0xd595,
  0xd99a, 0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0xd99a, 0xc040, 0xd594,
  0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0xc040, 0xc040, 0xd594,
  0xd999, 0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0xc03f, 0xc03f, 0xd593,
  0xd999, 0xd555, 0xd998, 0xc03f, 0xc03f, 0xc03f, 0xc03f, 0xd55d,
  0xc444, 0xc444, 0xc03e, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xd556,
  0xb333, 0xaaea, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xc002, 0xd556,
  0x99d9, 0xaaea, 0xc03d, 0xc03d, 0xc007, 0xc001, 0xc001, 0xd555,
  0xaaea, 0xc03d, 0xc03d, 0xc007, 0xc001, 0xc001, 0xd555, 0x6666,
  0xaae9, 0xc03d, 0xc007, 0xc001, 0xc001, 0xc001, 0x5555, 0x6665,
  0xaae9, 0xc006, 0xc000, 0xc000, 0xc000, 0x4000, 0x5554, 0x6665,
  0xaab2, 0xc000, 0xc000, 0xc000, 0x4000, 0x4000, 0x5554, 0x665e,
  0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x554d, 0x6627,
  0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x3ff8, 0x5516, 0x6627,
  0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2, 0x5516, 0x6626,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1, 0x5515, 0x4ccc,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0, 0x2667, 0x2aaa, 0x2667,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x2666, 0x1556, 0x1556, 0x2667,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x1555, 0x0002, 0x1556, 0x2666,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0001, 0x0001, 0x1555, 0x2666,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0x0001, 0x0001, 0x1555, 0x2665,
  0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x1554, 0x1111,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaac, 0xffff, 0xffff, 0xffff, 0xffff, 0xeaab, 0xeeef, 0xe6a6,
  0xeaab, 0xffff, 0xffff, 0xffff, 0xeaab, 0xd99a, 0xd595, 0xe6a5,
  0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0xd99a, 0xc040, 0xd594, 0xe6a5,
  0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0xc040, 0xc040, 0xd594, 0xe6a4,
  0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0xc03f, 0xc03f, 0xd593, 0xe66e,
  0xd555, 0xd998, 0xc03f, 0xc03f, 0xc03f, 0xc03f, 0xd55d, 0xe667,
  0xc444, 0xc03e, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xd556, 0xe667,
  0xaaea, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xc002, 0xd556, 0xe666,
  0xc03e, 0xc03e, 0xc03e, 0xc008, 0xc002, 0xd556, 0xe666, 0x7fc0,
  0xc03d, 0xc03d, 0xc007, 0xc001, 0xc001, 0xd555, 0x6666, 0x7fbf,
  0xc03d, 0xc007, 0xc001, 0xc001, 0xc001, 0x5555, 0x6665, 0x7fbf,
  0xc006, 0xc000, 0xc000, 0xc000, 0x4000, 0x5554, 0x6665, 0x7fb8,
  0xc000, 0xc000, 0xc000, 0x4000, 0x4000, 0x5554, 0x665e, 0x7f81,
  0xbfff, 0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x554d, 0x6627, 0x7f81,
  0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x3ff8, 0x5516, 0x6627, 0x7f80,
  0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2, 0x5516, 0x6626, 0x6626,
  0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1, 0x5515, 0x4ccc, 0x5515,
  0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1,
  0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0, 0x2667, 0x2aaa, 0x2667, 0x3fc1,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2666, 0x1556, 0x1556, 0x2667, 0x3fc0,
  0x3fbf, 0x3fbf, 0x2666, 0x1555, 0x0002, 0x1556, 0x2666, 0x3fc0,
  0x3fbf, 0x2665, 0x1555, 0x0001, 0x0001, 0x1555, 0x2666, 0x3fbf,
  0x2665, 0x1554, 0x0001, 0x0001, 0x0001, 0x1555, 0x2665, 0x2a6b,
  0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x1554, 0x1111, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff,
  0xffff, 0xffff, 0xffff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff,
  0xfffe, 0xfffe, 0xeaaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe,
  0xfffe, 0xeaaa, 0xd999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8,
  0xeaa9, 0xd999, 0xc03f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1,
  0xd998, 0xc03f, 0xc03f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1,
  0xc03e, 0xc03e, 0xc03e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0,
  0xc03e, 0xc03e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0x7fc0,
  0xc03e, 0xc03e, 0xc008, 0xc002, 0xd556, 0xe666, 0x7fc0, 0x7fc0,
  0xc03d, 0xc007, 0xc001, 0xc001, 0xd555, 0x6666, 0x7fbf, 0x7fbf,
  0xc007, 0xc001, 0xc001, 0xc001, 0x5555, 0x6665, 0x7fbf, 0x7fb8,
  0xc000, 0xc000, 0xc000, 0x4000, 0x5554, 0x6665, 0x7fb8, 0x7f82,
  0xc000, 0xc000, 0x4000, 0x4000, 0x5554, 0x665e, 0x7f81, 0x7f81,
  0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x554d, 0x6627, 0x7f81, 0x7f81,
  0x3fff, 0x3fff, 0x3fff, 0x3ff8, 0x5516, 0x6627, 0x7f80, 0x6627,
  0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2, 0x5516, 0x6626, 0x6626, 0x5516,
  0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1, 0x5515, 0x4ccc, 0x5515, 0x3fc2,
  0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2667, 0x2aaa, 0x2667, 0x3fc1, 0x3fc1,
  0x3fc0, 0x3fc0, 0x2666, 0x1556, 0x1556, 0x2667, 0x3fc0, 0x3fc0,
  0x3fbf, 0x2666, 0x1555, 0x0002, 0x1556, 0x2666, 0x3fc0, 0x3fc0,
  0x2665, 0x1555, 0x0001, 0x0001, 0x1555, 0x2666, 0x3fbf, 0x2a6b,
  0x1554, 0x0001, 0x0001, 0x0001, 0x1555, 0x2665, 0x2a6b, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff,
  0xffff, 0xffff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff,
  0xfffe, 0xeaaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8,
  0xeaaa, 0xd999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2,
  0xd999, 0xc03f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1,
  0xc03f, 0xc03f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1,
  0xc03f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0x7fc1,
  0xc03e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0x7fc0, 0x7fc0,
  0xc03e, 0xc008, 0xc002, 0xd556, 0xe666, 0x7fc0, 0x7fc0, 0x7fc0,
  0xc007, 0xc001, 0xc001, 0xd555, 0x6666, 0x7fbf, 0x7fbf, 0x7fb9,
  0xc001, 0xc001, 0xc001, 0x5555, 0x6665, 0x7fbf, 0x7fb8, 0x7f82,
  0xc000, 0xc000, 0x4000, 0x5554, 0x6665, 0x7fb8, 0x7f82, 0x7f82,
  0xc000, 0x4000, 0x4000, 0x5554, 0x665e, 0x7f81, 0x7f81, 0x7f81,
  0x3fff, 0x3fff, 0x3fff, 0x554d, 0x6627, 0x7f81, 0x7f81, 0x6627,
  0x3fff, 0x3fff, 0x3ff8, 0x5516, 0x6627, 0x7f80, 0x6627, 0x5516,
  0x3ffe, 0x3ff8, 0x3fc2, 0x5516, 0x6626, 0x6626, 0x5516, 0x3fc2,
  0x3ff7, 0x3fc1, 0x3fc1, 0x5515, 0x4ccc, 0x5515, 0x3fc2, 0x3fc2,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1,
  0x3fc0, 0x3fc0, 0x2667, 0x2aaa, 0x2667, 0x3fc1, 0x3fc1, 0x3fc1,
  0x3fc0, 0x2666, 0x1556, 0x1556, 0x2667, 0x3fc0, 0x3fc0, 0x3fc0,
  0x2666, 0x1555, 0x0002, 0x1556, 0x2666, 0x3fc0, 0x3fc0, 0x2a6c,
  0x1555, 0x0001, 0x0001, 0x1555, 0x2666, 0x3fbf, 0x2a6b, 0x195b,
  0x0001, 0x0001, 0x0001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001,
  0x0000, 0x0000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff,
  0xffff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9,
  0xeaaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2,
  0xd999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2,
  0xc03f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1,
  0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0x7fc1,
  0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0x7fc1, 0x7fc1,
  0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0x7fc0, 0x7fc0, 0x7fc0,
  0xc008, 0xc002, 0xd556, 0xe666, 0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9,
  0xc001, 0xc001, 0xd555, 0x6666, 0x7fbf, 0x7fbf, 0x7fb9, 0x7f83,
  0xc001, 0xc001, 0x5555, 0x6665, 0x7fbf, 0x7fb8, 0x7f82, 0x7f82,
  0xc000, 0x4000, 0x5554, 0x6665, 0x7fb8, 0x7f82, 0x7f82, 0x7f82,
  0x4000, 0x4000, 0x5554, 0x665e, 0x7f81, 0x7f81, 0x7f81, 0x6628,
  0x3fff, 0x3fff, 0x554d, 0x6627, 0x7f81, 0x7f81, 0x6627, 0x5517,
  0x3fff, 0x3ff8, 0x5516, 0x6627, 0x7f80, 0x6627, 0x5516, 0x3fc3,
  0x3ff8, 0x3fc2, 0x5516, 0x6626, 0x6626, 0x5516, 0x3fc2, 0x3fc2,
  0x3fc1, 0x3fc1, 0x5515, 0x4ccc, 0x5515, 0x3fc2, 0x3fc2, 0x3fc2,
  0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1,
  0x3fc0, 0x2667, 0x2aaa, 0x2667, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1,
  0x2666, 0x1556, 0x1556, 0x2667, 0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c,
  0x1555, 0x0002, 0x1556, 0x2666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b,
  0x0001, 0x0001, 0x1555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001,
  0x0001, 0x0001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001,
  0x0000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9,
  0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3,
  0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2,
  0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2,
  0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0x7ff8,
  0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0x7fc1, 0x7ff7,
  0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0x7fc1, 0x7fc1, 0x7ff7,
  0xc008, 0xd556, 0xe667, 0xffc0, 0x7fc0, 0x7fc0, 0x7fc0, 0x7ff0,
  0xc002, 0xd556, 0xe666, 0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9, 0x7fb9,
  0xc001, 0xd555, 0x6666, 0x7fbf, 0x7fbf, 0x7fb9, 0x7f83, 0x7fb9,
  0xc001, 0x5555, 0x6665, 0x7fbf, 0x7fb8, 0x7f82, 0x7f82, 0x7fb8,
  0x4000, 0x5554, 0x6665, 0x7fb8, 0x7f82, 0x7f82, 0x7f82, 0x665e,
  0x4000, 0x5554, 0x665e, 0x7f81, 0x7f81, 0x7f81, 0x6628, 0x554d,
  0x3fff, 0x554d, 0x6627, 0x7f81, 0x7f81, 0x6627, 0x5517, 0x3ff9,
  0x3ff8, 0x5516, 0x6627, 0x7f80, 0x6627, 0x5516, 0x3fc3, 0x3ff9,
  0x3fc2, 0x5516, 0x6626, 0x6626, 0x5516, 0x3fc2, 0x3fc2, 0x3ff8,
  0x3fc1, 0x5515, 0x4ccc, 0x5515, 0x3fc2, 0x3fc2, 0x3fc2, 0x3ff8,
  0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x3ff7,
  0x2667, 0x2aaa, 0x2667, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x2aa3,
  0x1556, 0x1556, 0x2667, 0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992,
  0x0002, 0x1556, 0x2666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038,
  0x0001, 0x1555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037,
  0x0001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037,
  0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9,
  0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9,
  0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8,
  0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0x7ffe,
  0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0x7ff8, 0x7ffe,
  0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0x7fc1, 0x7ff7, 0x7ffd,
  0xd55d, 0xe667, 0xffc1, 0xffc1, 0x7fc1, 0x7fc1, 0x7ff7, 0x7ff6,
  0xd556, 0xe667, 0xffc0, 0x7fc0, 0x7fc0, 0x7fc0, 0x7ff0, 0x7fc0,
  0xd556, 0xe666, 0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9, 0x7fb9, 0x7fbf,
  0xd555, 0x6666, 0x7fbf, 0x7fbf, 0x7fb9, 0x7f83, 0x7fb9, 0x7fbf,
  0x5555, 0x6665, 0x7fbf, 0x7fb8, 0x7f82, 0x7f82, 0x7fb8, 0x6665,
  0x5554, 0x6665, 0x7fb8, 0x7f82, 0x7f82, 0x7f82, 0x665e, 0x5554,
  0x5554, 0x665e, 0x7f81, 0x7f81, 0x7f81, 0x6628, 0x554d, 0x4000,
  0x554d, 0x6627, 0x7f81, 0x7f81, 0x6627, 0x5517, 0x3ff9, 0x3fff,
  0x5516, 0x6627, 0x7f80, 0x6627, 0x5516, 0x3fc3, 0x3ff9, 0x3fff,
  0x5516, 0x6626, 0x6626, 0x5516, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe,
  0x5515, 0x4ccc, 0x5515, 0x3fc2, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe,
  0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x3ff7, 0x2aa9,
  0x2aaa, 0x2667, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998,
  0x1556, 0x2667, 0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e,
  0x1556, 0x2666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e,
  0x1555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d,
  0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d,
  0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff,
  0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff,
  0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff, 0x7fff,
  0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0x7ffe, 0x7ffe,
  0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0x7ff8, 0x7ffe, 0x7ffe,
  0xe66e, 0xffc1, 0xffc1, 0xffc1, 0x7fc1, 0x7ff7, 0x7ffd, 0x7ff7,
  0xe667, 0xffc1, 0xffc1, 0x7fc1, 0x7fc1, 0x7ff7, 0x7ff6, 0x7fc0,
  0xe667, 0xffc0, 0x7fc0, 0x7fc0, 0x7fc0, 0x7ff0, 0x7fc0, 0x7fc0,
  0xe666, 0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9, 0x7fb9, 0x7fbf, 0x7fbf,
  0x6666, 0x7fbf, 0x7fbf, 0x7fb9, 0x7f83, 0x7fb9, 0x7fbf, 0x6665,
  0x6665, 0x7fbf, 0x7fb8, 0x7f82, 0x7f82, 0x7fb8, 0x6665, 0x5554,
  0x6665, 0x7fb8, 0x7f82, 0x7f82, 0x7f82, 0x665e, 0x5554, 0x4000,
  0x665e, 0x7f81, 0x7f81, 0x7f81, 0x6628, 0x554d, 0x4000, 0x4000,
  0x6627, 0x7f81, 0x7f81, 0x6627, 0x5517, 0x3ff9, 0x3fff, 0x3fff,
  0x6627, 0x7f80, 0x6627, 0x5516, 0x3fc3, 0x3ff9, 0x3fff, 0x3fff,
  0x6626, 0x6626, 0x5516, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe, 0x3ffe,
  0x4ccc, 0x5515, 0x3fc2, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe, 0x2aaa,
  0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x3ff7, 0x2aa9, 0x1999,
  0x2667, 0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998, 0x003f,
  0x2667, 0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e, 0x003e,
  0x2666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e, 0x003e,
  0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d, 0x003d,
  0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d, 0x0007,
  0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff, 0xffff, 0x7fff,
  0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff, 0x7fff, 0x7fff,
  0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0x7ffe, 0x7ffe, 0x7ffe,
  0xffc8, 0xffc2, 0xffc2, 0xffc2, 0x7ff8, 0x7ffe, 0x7ffe, 0x7ff7,
  0xffc1, 0xffc1, 0xffc1, 0x7fc1, 0x7ff7, 0x7ffd, 0x7ff7, 0x7fc1,
  0xffc1, 0xffc1, 0x7fc1, 0x7fc1, 0x7ff7, 0x7ff6, 0x7fc0, 0x7fc0,
  0xffc0, 0x7fc0, 0x7fc0, 0x7fc0, 0x7ff0, 0x7fc0, 0x7fc0, 0x7fc0,
  0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9, 0x7fb9, 0x7fbf, 0x7fbf, 0x6666,
  0x7fbf, 0x7fbf, 0x7fb9, 0x7f83, 0x7fb9, 0x7fbf, 0x6665, 0x5555,
  0x7fbf, 0x7fb8, 0x7f82, 0x7f82, 0x7fb8, 0x6665, 0x5554, 0x4001,
  0x7fb8, 0x7f82, 0x7f82, 0x7f82, 0x665e, 0x5554, 0x4000, 0x4000,
  0x7f81, 0x7f81, 0x7f81, 0x6628, 0x554d, 0x4000, 0x4000, 0x4000,
  0x7f81, 0x7f81, 0x6627, 0x5517, 0x3ff9, 0x3fff, 0x3fff, 0x3fff,
  0x7f80, 0x6627, 0x5516, 0x3fc3, 0x3ff9, 0x3fff, 0x3fff, 0x3fff,
  0x6626, 0x5516, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe, 0x3ffe, 0x2aaa,
  0x5515, 0x3fc2, 0x3fc2, 0x3fc2, 0x3ff8, 0x3ffe, 0x2aaa, 0x1999,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x3ff7, 0x2aa9, 0x1999, 0x003f,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998, 0x003f, 0x003f,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e, 0x003e, 0x003e,
  0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e, 0x003e, 0x003e,
  0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d, 0x003d, 0x0007,
  0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d, 0x0007, 0x0001,
  0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uhsub_8H = 576;

#endif  // VIXL_SIM_UHSUB_8H_TRACE_AARCH64_H_
