// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABA_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UABA_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uaba_4S[] = {
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x007f7e01, 0x007ffd02, 0x00000021,
  0x007f7f00, 0x00007f01, 0x007ffd01, 0x00000022,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000040,
  0x00007dff, 0x00007eff, 0x007ffce2, 0x0000009d,
  0x00007dfe, 0x00007ee1, 0x007ffc85, 0x0000009e,
  0x00007de0, 0x00007e84, 0x007ffc84, 0x0000009f,
  0x00007d83, 0x00007e83, 0x007ffc83, 0x0000801d,
  0x00007d82, 0x00007e82, 0x007f7d05, 0x0000801e,
  0x00007d81, 0x000000fe, 0x007f7d04, 0x0000801f,
  0x000001fd, 0x000000ff, 0x007f7d03, 0x33333353,
  0x000001fe, 0x00000100, 0x32b33635, 0x55555575,
  0x000001ff, 0x3332b434, 0x54d55857, 0x8000001d,
  0x3332b533, 0x5554d656, 0x7f8002ff, 0x8000001e,
  0x5554d755, 0x7fff80fe, 0x7f800300, 0x8000001f,
  0x7fff81fd, 0x7fff80ff, 0x7f800301, 0x80000020,
  0x7fff81fe, 0x7fff8100, 0x7f800302, 0x80000021,
  0x7fff81ff, 0x7fff8101, 0x7f800303, 0xaaaaaaca,
  0x7fff8200, 0x7fff8102, 0xaa2aadac, 0xccccccec,
  0x7fff8201, 0xaaaa2bab, 0xcc4ccfce, 0xffff8020,
  0xaaaa2caa, 0xcccc4dcd, 0xff7f8302, 0xffff8021,
  0xcccc4ecc, 0xffff0101, 0xff7f8303, 0xffff8022,
  0xffff0200, 0xffff0102, 0xff7f8304, 0xffff8023,
  0xffff0201, 0xffff0103, 0xff7f8305, 0xffffffa0,
  0xffff0202, 0xffff0104, 0xff800282, 0xffffffa1,
  0xffff0203, 0xffff8081, 0xff800283, 0xffffffa2,
  0xffff8180, 0xffff8082, 0xff800284, 0xffffffa3,
  0xffff8181, 0xffff8083, 0xff800285, 0x00000000,
  0xffff8182, 0xffff8084, 0xff8002e2, 0x0000001d,
  0xffff8183, 0xffff80e1, 0xff8002ff, 0x0000001e,
  0xffff81e0, 0xffff80fe, 0xff800300, 0x0000001f,
  0xffff80fd, 0xff8002ff, 0x00000001, 0x00000021,
  0xffff80fe, 0xff800300, 0x00000002, 0x00000020,
  0xffff80ff, 0x007ffd01, 0x00000003, 0x00000021,
  0x00007f00, 0x007ffd00, 0x00000004, 0x0000003f,
  0x00007eff, 0x007ffcff, 0x00000022, 0x0000009c,
  0x00007efe, 0x007ffce1, 0x0000007f, 0x0000009d,
  0x00007ee0, 0x007ffc84, 0x00000080, 0x0000009e,
  0x00007e83, 0x007ffc83, 0x00000081, 0x0000801c,
  0x00007e82, 0x007ffc82, 0x00007fff, 0x0000801d,
  0x00007e81, 0x007f7d04, 0x00008000, 0x0000801e,
  0x000000fd, 0x007f7d03, 0x00008001, 0x33333352,
  0x000000fe, 0x007f7d02, 0x33333335, 0x55555574,
  0x000000ff, 0x32b33634, 0x55555557, 0x8000001c,
  0x3332b433, 0x54d55856, 0x7fffffff, 0x8000001d,
  0x5554d655, 0x7f8002fe, 0x80000000, 0x8000001e,
  0x7fff80fd, 0x7f8002ff, 0x80000001, 0x8000001f,
  0x7fff80fe, 0x7f800300, 0x80000002, 0x80000020,
  0x7fff80ff, 0x7f800301, 0x80000003, 0xaaaaaac9,
  0x7fff8100, 0x7f800302, 0xaaaaaaac, 0xcccccceb,
  0x7fff8101, 0xaa2aadab, 0xccccccce, 0xffff801f,
  0xaaaa2baa, 0xcc4ccfcd, 0xffff8002, 0xffff8020,
  0xcccc4dcc, 0xff7f8301, 0xffff8003, 0xffff8021,
  0xffff0100, 0xff7f8302, 0xffff8004, 0xffff8022,
  0xffff0101, 0xff7f8303, 0xffff8005, 0xffffff9f,
  0xffff0102, 0xff7f8304, 0xffffff82, 0xffffffa0,
  0xffff0103, 0xff800281, 0xffffff83, 0xffffffa1,
  0xffff8080, 0xff800282, 0xffffff84, 0xffffffa2,
  0xffff8081, 0xff800283, 0xffffff85, 0xffffffff,
  0xffff8082, 0xff800284, 0xffffffe2, 0x0000001c,
  0xffff8083, 0xff8002e1, 0xffffffff, 0x0000001d,
  0xffff80e0, 0xff8002fe, 0x00000000, 0x0000001e,
  0xff8002fd, 0xffffffff, 0x00000000, 0x00000022,
  0xff8002fe, 0x00000000, 0x00000003, 0x00000021,
  0xff8002ff, 0x00000001, 0x00000002, 0x00000020,
  0x007ffd00, 0x00000002, 0x00000003, 0x0000003e,
  0x007ffcff, 0x00000003, 0x00000021, 0x0000009b,
  0x007ffcfe, 0x00000021, 0x0000007e, 0x0000009c,
  0x007ffce0, 0x0000007e, 0x0000007f, 0x0000009d,
  0x007ffc83, 0x0000007f, 0x00000080, 0x0000801b,
  0x007ffc82, 0x00000080, 0x00007ffe, 0x0000801c,
  0x007ffc81, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x007f7d03, 0x00007fff, 0x00008000, 0x33333351,
  0x007f7d02, 0x00008000, 0x33333334, 0x55555573,
  0x007f7d01, 0x33333334, 0x55555556, 0x8000001b,
  0x32b33633, 0x55555556, 0x7ffffffe, 0x8000001c,
  0x54d55855, 0x7ffffffe, 0x7fffffff, 0x8000001d,
  0x7f8002fd, 0x7fffffff, 0x80000000, 0x8000001e,
  0x7f8002fe, 0x80000000, 0x80000001, 0x8000001f,
  0x7f8002ff, 0x80000001, 0x80000002, 0xaaaaaac8,
  0x7f800300, 0x80000002, 0xaaaaaaab, 0xccccccea,
  0x7f800301, 0xaaaaaaab, 0xcccccccd, 0xffff801e,
  0xaa2aadaa, 0xcccccccd, 0xffff8001, 0xffff801f,
  0xcc4ccfcc, 0xffff8001, 0xffff8002, 0xffff8020,
  0xff7f8300, 0xffff8002, 0xffff8003, 0xffff8021,
  0xff7f8301, 0xffff8003, 0xffff8004, 0xffffff9e,
  0xff7f8302, 0xffff8004, 0xffffff81, 0xffffff9f,
  0xff7f8303, 0xffffff81, 0xffffff82, 0xffffffa0,
  0xff800280, 0xffffff82, 0xffffff83, 0xffffffa1,
  0xff800281, 0xffffff83, 0xffffff84, 0xfffffffe,
  0xff800282, 0xffffff84, 0xffffffe1, 0x0000001b,
  0xff800283, 0xffffffe1, 0xfffffffe, 0x0000001c,
  0xff8002e0, 0xfffffffe, 0xffffffff, 0x0000001d,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000040,
  0xfffffffe, 0xffffffff, 0x00000004, 0x0000003f,
  0xffffffff, 0x00000002, 0x00000003, 0x0000003e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x7fffffff,
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000001,
  0x7fffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffc, 0xfffffffd, 0xffffffe1, 0x0000009d,
  0xfffffffd, 0xfffffffe, 0x00000022, 0x0000009c,
  0xfffffffe, 0x00000003, 0x00000021, 0x0000009b,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x0000001f, 0x0000005f, 0x00000021,
  0x0000001f, 0x0000007c, 0x00000060, 0x00000022,
  0x0000007c, 0x0000007d, 0x00000061, 0x00007fa0,
  0x0000007d, 0x0000007e, 0x00007fdf, 0x00007fa1,
  0x0000007e, 0x00007ffc, 0x00007fe0, 0x00007fa2,
  0x00007ffc, 0x00007ffd, 0x00007fe1, 0x333332d6,
  0x00007ffd, 0x00007ffe, 0x33333315, 0x555554f8,
  0x00007ffe, 0x33333332, 0x55555537, 0x7fffffa0,
  0x33333332, 0x55555554, 0x7fffffdf, 0x7fffffa1,
  0x55555554, 0x7ffffffc, 0x7fffffe0, 0x7fffffa2,
  0x7ffffffc, 0x7ffffffd, 0x7fffffe1, 0x7fffffa3,
  0x7ffffffd, 0x7ffffffe, 0x7fffffe2, 0x7fffffa4,
  0x7ffffffe, 0x7fffffff, 0x7fffffe3, 0xaaaaaa4d,
  0x7fffffff, 0x80000000, 0xaaaaaa8c, 0xcccccc6f,
  0x80000000, 0xaaaaaaa9, 0xccccccae, 0xffff7fa3,
  0xaaaaaaa9, 0xcccccccb, 0xffff7fe2, 0xffff7fa4,
  0xcccccccb, 0xffff7fff, 0xffff7fe3, 0xffff7fa5,
  0xffff7fff, 0xffff8000, 0xffff7fe4, 0xffff7fa6,
  0xffff8000, 0xffff8001, 0xffff7fe5, 0xffffff23,
  0xffff8001, 0xffff8002, 0xffffff62, 0xffffff24,
  0xffff8002, 0xffffff7f, 0xffffff63, 0xffffff25,
  0xffffff7f, 0xffffff80, 0xffffff64, 0xffffff26,
  0xffffff80, 0xffffff81, 0xffffff65, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffffc2, 0xffffffa0,
  0xffffff82, 0xffffffdf, 0xffffffdf, 0xffffffa1,
  0xffffffdf, 0xfffffffc, 0xffffffe0, 0xffffffa2,
  0xfffffffb, 0xffffffdf, 0xffffff84, 0x0000009e,
  0xfffffffc, 0xffffffe0, 0x0000007f, 0x0000009d,
  0xfffffffd, 0x00000021, 0x0000007e, 0x0000009c,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000001, 0x0000001f, 0x0000005f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000001e, 0x0000005e, 0x00000003, 0x00000021,
  0x0000007b, 0x0000005f, 0x00000004, 0x00007f9f,
  0x0000007c, 0x00000060, 0x00007f82, 0x00007fa0,
  0x0000007d, 0x00007fde, 0x00007f83, 0x00007fa1,
  0x00007ffb, 0x00007fdf, 0x00007f84, 0x333332d5,
  0x00007ffc, 0x00007fe0, 0x333332b8, 0x555554f7,
  0x00007ffd, 0x33333314, 0x555554da, 0x7fffff9f,
  0x33333331, 0x55555536, 0x7fffff82, 0x7fffffa0,
  0x55555553, 0x7fffffde, 0x7fffff83, 0x7fffffa1,
  0x7ffffffb, 0x7fffffdf, 0x7fffff84, 0x7fffffa2,
  0x7ffffffc, 0x7fffffe0, 0x7fffff85, 0x7fffffa3,
  0x7ffffffd, 0x7fffffe1, 0x7fffff86, 0xaaaaaa4c,
  0x7ffffffe, 0x7fffffe2, 0xaaaaaa2f, 0xcccccc6e,
  0x7fffffff, 0xaaaaaa8b, 0xcccccc51, 0xffff7fa2,
  0xaaaaaaa8, 0xccccccad, 0xffff7f85, 0xffff7fa3,
  0xccccccca, 0xffff7fe1, 0xffff7f86, 0xffff7fa4,
  0xffff7ffe, 0xffff7fe2, 0xffff7f87, 0xffff7fa5,
  0xffff7fff, 0xffff7fe3, 0xffff7f88, 0xffffff22,
  0xffff8000, 0xffff7fe4, 0xffffff05, 0xffffff23,
  0xffff8001, 0xffffff61, 0xffffff06, 0xffffff24,
  0xffffff7e, 0xffffff62, 0xffffff07, 0xffffff25,
  0xffffff7f, 0xffffff63, 0xffffff08, 0xffffff82,
  0xffffff80, 0xffffff64, 0xffffff65, 0xffffff9f,
  0xffffff81, 0xffffffc1, 0xffffff82, 0xffffffa0,
  0xffffffde, 0xffffffde, 0xffffff83, 0xffffffa1,
  0xffffffdd, 0xffffff82, 0xffffff83, 0x0000009f,
  0xffffffde, 0xffffff83, 0x00000080, 0x0000009e,
  0xffffffdf, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000001f, 0x0000007c, 0x00000060, 0x00000022,
  0x0000001e, 0x0000005e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000005d, 0x00000002, 0x00000003, 0x00007f9e,
  0x0000005e, 0x00000003, 0x00007f81, 0x00007f9f,
  0x0000005f, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00007fdd, 0x00007f82, 0x00007f83, 0x333332d4,
  0x00007fde, 0x00007f83, 0x333332b7, 0x555554f6,
  0x00007fdf, 0x333332b7, 0x555554d9, 0x7fffff9e,
  0x33333313, 0x555554d9, 0x7fffff81, 0x7fffff9f,
  0x55555535, 0x7fffff81, 0x7fffff82, 0x7fffffa0,
  0x7fffffdd, 0x7fffff82, 0x7fffff83, 0x7fffffa1,
  0x7fffffde, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fffffdf, 0x7fffff84, 0x7fffff85, 0xaaaaaa4b,
  0x7fffffe0, 0x7fffff85, 0xaaaaaa2e, 0xcccccc6d,
  0x7fffffe1, 0xaaaaaa2e, 0xcccccc50, 0xffff7fa1,
  0xaaaaaa8a, 0xcccccc50, 0xffff7f84, 0xffff7fa2,
  0xccccccac, 0xffff7f84, 0xffff7f85, 0xffff7fa3,
  0xffff7fe0, 0xffff7f85, 0xffff7f86, 0xffff7fa4,
  0xffff7fe1, 0xffff7f86, 0xffff7f87, 0xffffff21,
  0xffff7fe2, 0xffff7f87, 0xffffff04, 0xffffff22,
  0xffff7fe3, 0xffffff04, 0xffffff05, 0xffffff23,
  0xffffff60, 0xffffff05, 0xffffff06, 0xffffff24,
  0xffffff61, 0xffffff06, 0xffffff07, 0xffffff81,
  0xffffff62, 0xffffff07, 0xffffff64, 0xffffff9e,
  0xffffff63, 0xffffff64, 0xffffff81, 0xffffff9f,
  0xffffffc0, 0xffffff81, 0xffffff82, 0xffffffa0,
  0xffffff80, 0xffffff81, 0xffffff82, 0x0000801d,
  0xffffff81, 0xffffff82, 0x00000081, 0x0000801c,
  0xffffff82, 0x0000007f, 0x00000080, 0x0000801b,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007c, 0x0000007d, 0x00000061, 0x00007fa0,
  0x0000007b, 0x0000005f, 0x00000004, 0x00007f9f,
  0x0000005d, 0x00000002, 0x00000003, 0x00007f9e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00007f80, 0x00000021,
  0x00000002, 0x00007f80, 0x00007f81, 0x00000022,
  0x00007f80, 0x00007f81, 0x00007f82, 0x3332b356,
  0x00007f81, 0x00007f82, 0x333332b6, 0x5554d578,
  0x00007f82, 0x333332b6, 0x555554d8, 0x7fff8020,
  0x333332b6, 0x555554d8, 0x7fffff80, 0x7fff8021,
  0x555554d8, 0x7fffff80, 0x7fffff81, 0x7fff8022,
  0x7fffff80, 0x7fffff81, 0x7fffff82, 0x7fff8023,
  0x7fffff81, 0x7fffff82, 0x7fffff83, 0x7fff8024,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0xaaaa2acd,
  0x7fffff83, 0x7fffff84, 0xaaaaaa2d, 0xcccc4cef,
  0x7fffff84, 0xaaaaaa2d, 0xcccccc4f, 0xffff0023,
  0xaaaaaa2d, 0xcccccc4f, 0xffff7f83, 0xffff0024,
  0xcccccc4f, 0xffff7f83, 0xffff7f84, 0xffff0025,
  0xffff7f83, 0xffff7f84, 0xffff7f85, 0xffff0026,
  0xffff7f84, 0xffff7f85, 0xffff7f86, 0xffff7fa3,
  0xffff7f85, 0xffff7f86, 0xffffff03, 0xffff7fa4,
  0xffff7f86, 0xffffff03, 0xffffff04, 0xffff7fa5,
  0xffffff03, 0xffffff04, 0xffffff05, 0xffff7fa6,
  0xffffff04, 0xffffff05, 0xffffff06, 0xffff8003,
  0xffffff05, 0xffffff06, 0xffffff63, 0xffff8020,
  0xffffff06, 0xffffff63, 0xffffff80, 0xffff8021,
  0xffffff63, 0xffffff80, 0xffffff81, 0xffff8022,
  0xffffff7f, 0xffffff80, 0xffff8004, 0x0000801e,
  0xffffff80, 0xffffff81, 0x00007fff, 0x0000801d,
  0xffffff81, 0x00000080, 0x00007ffe, 0x0000801c,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007d, 0x0000007e, 0x00007fdf, 0x00007fa1,
  0x0000007c, 0x00000060, 0x00007f82, 0x00007fa0,
  0x0000005e, 0x00000003, 0x00007f81, 0x00007f9f,
  0x00000001, 0x00000002, 0x00007f80, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00007f7f, 0x00000003, 0x00000021,
  0x00007f7f, 0x00007f80, 0x00000004, 0x3332b355,
  0x00007f80, 0x00007f81, 0x3332b338, 0x5554d577,
  0x00007f81, 0x333332b5, 0x5554d55a, 0x7fff801f,
  0x333332b5, 0x555554d7, 0x7fff8002, 0x7fff8020,
  0x555554d7, 0x7fffff7f, 0x7fff8003, 0x7fff8021,
  0x7fffff7f, 0x7fffff80, 0x7fff8004, 0x7fff8022,
  0x7fffff80, 0x7fffff81, 0x7fff8005, 0x7fff8023,
  0x7fffff81, 0x7fffff82, 0x7fff8006, 0xaaaa2acc,
  0x7fffff82, 0x7fffff83, 0xaaaa2aaf, 0xcccc4cee,
  0x7fffff83, 0xaaaaaa2c, 0xcccc4cd1, 0xffff0022,
  0xaaaaaa2c, 0xcccccc4e, 0xffff0005, 0xffff0023,
  0xcccccc4e, 0xffff7f82, 0xffff0006, 0xffff0024,
  0xffff7f82, 0xffff7f83, 0xffff0007, 0xffff0025,
  0xffff7f83, 0xffff7f84, 0xffff0008, 0xffff7fa2,
  0xffff7f84, 0xffff7f85, 0xffff7f85, 0xffff7fa3,
  0xffff7f85, 0xffffff02, 0xffff7f86, 0xffff7fa4,
  0xffffff02, 0xffffff03, 0xffff7f87, 0xffff7fa5,
  0xffffff03, 0xffffff04, 0xffff7f88, 0xffff8002,
  0xffffff04, 0xffffff05, 0xffff7fe5, 0xffff801f,
  0xffffff05, 0xffffff62, 0xffff8002, 0xffff8020,
  0xffffff62, 0xffffff7f, 0xffff8003, 0xffff8021,
  0xffffff7e, 0xffff8002, 0xffff8003, 0x0000801f,
  0xffffff7f, 0xffff8003, 0x00008000, 0x0000801e,
  0xffffff80, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007e, 0x00007ffc, 0x00007fe0, 0x00007fa2,
  0x0000007d, 0x00007fde, 0x00007f83, 0x00007fa1,
  0x0000005f, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00000002, 0x00007f80, 0x00007f81, 0x00000022,
  0x00000001, 0x00007f7f, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007f7e, 0x00000002, 0x00000003, 0x3332b354,
  0x00007f7f, 0x00000003, 0x3332b337, 0x5554d576,
  0x00007f80, 0x3332b337, 0x5554d559, 0x7fff801e,
  0x333332b4, 0x5554d559, 0x7fff8001, 0x7fff801f,
  0x555554d6, 0x7fff8001, 0x7fff8002, 0x7fff8020,
  0x7fffff7e, 0x7fff8002, 0x7fff8003, 0x7fff8021,
  0x7fffff7f, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x7fffff80, 0x7fff8004, 0x7fff8005, 0xaaaa2acb,
  0x7fffff81, 0x7fff8005, 0xaaaa2aae, 0xcccc4ced,
  0x7fffff82, 0xaaaa2aae, 0xcccc4cd0, 0xffff0021,
  0xaaaaaa2b, 0xcccc4cd0, 0xffff0004, 0xffff0022,
  0xcccccc4d, 0xffff0004, 0xffff0005, 0xffff0023,
  0xffff7f81, 0xffff0005, 0xffff0006, 0xffff0024,
  0xffff7f82, 0xffff0006, 0xffff0007, 0xffff7fa1,
  0xffff7f83, 0xffff0007, 0xffff7f84, 0xffff7fa2,
  0xffff7f84, 0xffff7f84, 0xffff7f85, 0xffff7fa3,
  0xffffff01, 0xffff7f85, 0xffff7f86, 0xffff7fa4,
  0xffffff02, 0xffff7f86, 0xffff7f87, 0xffff8001,
  0xffffff03, 0xffff7f87, 0xffff7fe4, 0xffff801e,
  0xffffff04, 0xffff7fe4, 0xffff8001, 0xffff801f,
  0xffffff61, 0xffff8001, 0xffff8002, 0xffff8020,
  0xffff8000, 0xffff8001, 0xffff8002, 0x33333353,
  0xffff8001, 0xffff8002, 0x00008001, 0x33333352,
  0xffff8002, 0x00007fff, 0x00008000, 0x33333351,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffc, 0x00007ffd, 0x00007fe1, 0x333332d6,
  0x00007ffb, 0x00007fdf, 0x00007f84, 0x333332d5,
  0x00007fdd, 0x00007f82, 0x00007f83, 0x333332d4,
  0x00007f80, 0x00007f81, 0x00007f82, 0x3332b356,
  0x00007f7f, 0x00007f80, 0x00000004, 0x3332b355,
  0x00007f7e, 0x00000002, 0x00000003, 0x3332b354,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x3332b336, 0x22222242,
  0x00000002, 0x3332b336, 0x5554d558, 0x4cccccea,
  0x3332b336, 0x5554d558, 0x7fff8000, 0x4ccccceb,
  0x5554d558, 0x7fff8000, 0x7fff8001, 0x4cccccec,
  0x7fff8000, 0x7fff8001, 0x7fff8002, 0x4ccccced,
  0x7fff8001, 0x7fff8002, 0x7fff8003, 0x4cccccee,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x77777797,
  0x7fff8003, 0x7fff8004, 0xaaaa2aad, 0x999999b9,
  0x7fff8004, 0xaaaa2aad, 0xcccc4ccf, 0xcccc4ced,
  0xaaaa2aad, 0xcccc4ccf, 0xffff0003, 0xcccc4cee,
  0xcccc4ccf, 0xffff0003, 0xffff0004, 0xcccc4cef,
  0xffff0003, 0xffff0004, 0xffff0005, 0xcccc4cf0,
  0xffff0004, 0xffff0005, 0xffff0006, 0xcccccc6d,
  0xffff0005, 0xffff0006, 0xffff7f83, 0xcccccc6e,
  0xffff0006, 0xffff7f83, 0xffff7f84, 0xcccccc6f,
  0xffff7f83, 0xffff7f84, 0xffff7f85, 0xcccccc70,
  0xffff7f84, 0xffff7f85, 0xffff7f86, 0xcccccccd,
  0xffff7f85, 0xffff7f86, 0xffff7fe3, 0xccccccea,
  0xffff7f86, 0xffff7fe3, 0xffff8000, 0xcccccceb,
  0xffff7fe3, 0xffff8000, 0xffff8001, 0xccccccec,
  0xffff7fff, 0xffff8000, 0xccccccce, 0x55555575,
  0xffff8000, 0xffff8001, 0x33333335, 0x55555574,
  0xffff8001, 0x00008000, 0x33333334, 0x55555573,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007ffd, 0x00007ffe, 0x33333315, 0x555554f8,
  0x00007ffc, 0x00007fe0, 0x333332b8, 0x555554f7,
  0x00007fde, 0x00007f83, 0x333332b7, 0x555554f6,
  0x00007f81, 0x00007f82, 0x333332b6, 0x5554d578,
  0x00007f80, 0x00007f81, 0x3332b338, 0x5554d577,
  0x00007f7f, 0x00000003, 0x3332b337, 0x5554d576,
  0x00000001, 0x00000002, 0x3332b336, 0x22222242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x3332b335, 0x22222224, 0x2aaaaac8,
  0x3332b335, 0x5554d557, 0x4ccccccc, 0x2aaaaac9,
  0x5554d557, 0x7fff7fff, 0x4ccccccd, 0x2aaaaaca,
  0x7fff7fff, 0x7fff8000, 0x4cccccce, 0x2aaaaacb,
  0x7fff8000, 0x7fff8001, 0x4ccccccf, 0x2aaaaacc,
  0x7fff8001, 0x7fff8002, 0x4cccccd0, 0x55555575,
  0x7fff8002, 0x7fff8003, 0x77777779, 0x77777797,
  0x7fff8003, 0xaaaa2aac, 0x9999999b, 0xaaaa2acb,
  0xaaaa2aac, 0xcccc4cce, 0xcccc4ccf, 0xaaaa2acc,
  0xcccc4cce, 0xffff0002, 0xcccc4cd0, 0xaaaa2acd,
  0xffff0002, 0xffff0003, 0xcccc4cd1, 0xaaaa2ace,
  0xffff0003, 0xffff0004, 0xcccc4cd2, 0xaaaaaa4b,
  0xffff0004, 0xffff0005, 0xcccccc4f, 0xaaaaaa4c,
  0xffff0005, 0xffff7f82, 0xcccccc50, 0xaaaaaa4d,
  0xffff7f82, 0xffff7f83, 0xcccccc51, 0xaaaaaa4e,
  0xffff7f83, 0xffff7f84, 0xcccccc52, 0xaaaaaaab,
  0xffff7f84, 0xffff7f85, 0xccccccaf, 0xaaaaaac8,
  0xffff7f85, 0xffff7fe2, 0xcccccccc, 0xaaaaaac9,
  0xffff7fe2, 0xffff7fff, 0xcccccccd, 0xaaaaaaca,
  0xffff7ffe, 0xcccccccc, 0xaaaaaaac, 0x8000001d,
  0xffff7fff, 0xcccccccd, 0x55555557, 0x8000001c,
  0xffff8000, 0x33333334, 0x55555556, 0x8000001b,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x00007ffe, 0x33333332, 0x55555537, 0x7fffffa0,
  0x00007ffd, 0x33333314, 0x555554da, 0x7fffff9f,
  0x00007fdf, 0x333332b7, 0x555554d9, 0x7fffff9e,
  0x00007f82, 0x333332b6, 0x555554d8, 0x7fff8020,
  0x00007f81, 0x333332b5, 0x5554d55a, 0x7fff801f,
  0x00007f80, 0x3332b337, 0x5554d559, 0x7fff801e,
  0x00000002, 0x3332b336, 0x5554d558, 0x4cccccea,
  0x00000001, 0x3332b335, 0x22222224, 0x2aaaaac8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x3332b334, 0x22222223, 0x2aaaaaaa, 0x00000021,
  0x5554d556, 0x4ccccccb, 0x2aaaaaab, 0x00000022,
  0x7fff7ffe, 0x4ccccccc, 0x2aaaaaac, 0x00000023,
  0x7fff7fff, 0x4ccccccd, 0x2aaaaaad, 0x00000024,
  0x7fff8000, 0x4cccccce, 0x2aaaaaae, 0x2aaaaacd,
  0x7fff8001, 0x4ccccccf, 0x55555557, 0x4cccccef,
  0x7fff8002, 0x77777778, 0x77777779, 0x7fff8023,
  0xaaaa2aab, 0x9999999a, 0xaaaa2aad, 0x7fff8024,
  0xcccc4ccd, 0xcccc4cce, 0xaaaa2aae, 0x7fff8025,
  0xffff0001, 0xcccc4ccf, 0xaaaa2aaf, 0x7fff8026,
  0xffff0002, 0xcccc4cd0, 0xaaaa2ab0, 0x7fffffa3,
  0xffff0003, 0xcccc4cd1, 0xaaaaaa2d, 0x7fffffa4,
  0xffff0004, 0xcccccc4e, 0xaaaaaa2e, 0x7fffffa5,
  0xffff7f81, 0xcccccc4f, 0xaaaaaa2f, 0x7fffffa6,
  0xffff7f82, 0xcccccc50, 0xaaaaaa30, 0x80000003,
  0xffff7f83, 0xcccccc51, 0xaaaaaa8d, 0x80000020,
  0xffff7f84, 0xccccccae, 0xaaaaaaaa, 0x80000021,
  0xffff7fe1, 0xcccccccb, 0xaaaaaaab, 0x80000022,
  0xccccccca, 0xaaaaaaaa, 0x80000004, 0x8000001e,
  0xcccccccb, 0xaaaaaaab, 0x7fffffff, 0x8000001d,
  0xcccccccc, 0x55555556, 0x7ffffffe, 0x8000001c,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x33333332, 0x55555554, 0x7fffffdf, 0x7fffffa1,
  0x33333331, 0x55555536, 0x7fffff82, 0x7fffffa0,
  0x33333313, 0x555554d9, 0x7fffff81, 0x7fffff9f,
  0x333332b6, 0x555554d8, 0x7fffff80, 0x7fff8021,
  0x333332b5, 0x555554d7, 0x7fff8002, 0x7fff8020,
  0x333332b4, 0x5554d559, 0x7fff8001, 0x7fff801f,
  0x3332b336, 0x5554d558, 0x7fff8000, 0x4ccccceb,
  0x3332b335, 0x5554d557, 0x4ccccccc, 0x2aaaaac9,
  0x3332b334, 0x22222223, 0x2aaaaaaa, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x22222222, 0x2aaaaaa9, 0x00000003, 0x00000021,
  0x4cccccca, 0x2aaaaaaa, 0x00000004, 0x00000022,
  0x4ccccccb, 0x2aaaaaab, 0x00000005, 0x00000023,
  0x4ccccccc, 0x2aaaaaac, 0x00000006, 0x2aaaaacc,
  0x4ccccccd, 0x2aaaaaad, 0x2aaaaaaf, 0x4cccccee,
  0x4cccccce, 0x55555556, 0x4cccccd1, 0x7fff8022,
  0x77777777, 0x77777778, 0x7fff8005, 0x7fff8023,
  0x99999999, 0xaaaa2aac, 0x7fff8006, 0x7fff8024,
  0xcccc4ccd, 0xaaaa2aad, 0x7fff8007, 0x7fff8025,
  0xcccc4cce, 0xaaaa2aae, 0x7fff8008, 0x7fffffa2,
  0xcccc4ccf, 0xaaaa2aaf, 0x7fffff85, 0x7fffffa3,
  0xcccc4cd0, 0xaaaaaa2c, 0x7fffff86, 0x7fffffa4,
  0xcccccc4d, 0xaaaaaa2d, 0x7fffff87, 0x7fffffa5,
  0xcccccc4e, 0xaaaaaa2e, 0x7fffff88, 0x80000002,
  0xcccccc4f, 0xaaaaaa2f, 0x7fffffe5, 0x8000001f,
  0xcccccc50, 0xaaaaaa8c, 0x80000002, 0x80000020,
  0xccccccad, 0xaaaaaaa9, 0x80000003, 0x80000021,
  0xaaaaaaa8, 0x80000002, 0x80000003, 0x8000001f,
  0xaaaaaaa9, 0x80000003, 0x80000000, 0x8000001e,
  0xaaaaaaaa, 0x7ffffffe, 0x7fffffff, 0x8000001d,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x7fffffff,
  0x55555554, 0x7ffffffc, 0x7fffffe0, 0x7fffffa2,
  0x55555553, 0x7fffffde, 0x7fffff83, 0x7fffffa1,
  0x55555535, 0x7fffff81, 0x7fffff82, 0x7fffffa0,
  0x555554d8, 0x7fffff80, 0x7fffff81, 0x7fff8022,
  0x555554d7, 0x7fffff7f, 0x7fff8003, 0x7fff8021,
  0x555554d6, 0x7fff8001, 0x7fff8002, 0x7fff8020,
  0x5554d558, 0x7fff8000, 0x7fff8001, 0x4cccccec,
  0x5554d557, 0x7fff7fff, 0x4ccccccd, 0x2aaaaaca,
  0x5554d556, 0x4ccccccb, 0x2aaaaaab, 0x00000022,
  0x22222222, 0x2aaaaaa9, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x2aaaaaa8, 0x00000002, 0x00000003, 0x00000021,
  0x2aaaaaa9, 0x00000003, 0x00000004, 0x00000022,
  0x2aaaaaaa, 0x00000004, 0x00000005, 0x2aaaaacb,
  0x2aaaaaab, 0x00000005, 0x2aaaaaae, 0x4ccccced,
  0x2aaaaaac, 0x2aaaaaae, 0x4cccccd0, 0x7fff8021,
  0x55555555, 0x4cccccd0, 0x7fff8004, 0x7fff8022,
  0x77777777, 0x7fff8004, 0x7fff8005, 0x7fff8023,
  0xaaaa2aab, 0x7fff8005, 0x7fff8006, 0x7fff8024,
  0xaaaa2aac, 0x7fff8006, 0x7fff8007, 0x7fffffa1,
  0xaaaa2aad, 0x7fff8007, 0x7fffff84, 0x7fffffa2,
  0xaaaa2aae, 0x7fffff84, 0x7fffff85, 0x7fffffa3,
  0xaaaaaa2b, 0x7fffff85, 0x7fffff86, 0x7fffffa4,
  0xaaaaaa2c, 0x7fffff86, 0x7fffff87, 0x80000001,
  0xaaaaaa2d, 0x7fffff87, 0x7fffffe4, 0x8000001e,
  0xaaaaaa2e, 0x7fffffe4, 0x80000001, 0x8000001f,
  0xaaaaaa8b, 0x80000001, 0x80000002, 0x80000020,
  0x80000000, 0x80000001, 0x80000002, 0x80000020,
  0x80000001, 0x80000002, 0x80000001, 0x8000001f,
  0x80000002, 0x7fffffff, 0x80000000, 0x8000001e,
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffc, 0x7ffffffd, 0x7fffffe1, 0x7fffffa3,
  0x7ffffffb, 0x7fffffdf, 0x7fffff84, 0x7fffffa2,
  0x7fffffdd, 0x7fffff82, 0x7fffff83, 0x7fffffa1,
  0x7fffff80, 0x7fffff81, 0x7fffff82, 0x7fff8023,
  0x7fffff7f, 0x7fffff80, 0x7fff8004, 0x7fff8022,
  0x7fffff7e, 0x7fff8002, 0x7fff8003, 0x7fff8021,
  0x7fff8000, 0x7fff8001, 0x7fff8002, 0x4ccccced,
  0x7fff7fff, 0x7fff8000, 0x4cccccce, 0x2aaaaacb,
  0x7fff7ffe, 0x4ccccccc, 0x2aaaaaac, 0x00000023,
  0x4cccccca, 0x2aaaaaaa, 0x00000004, 0x00000022,
  0x2aaaaaa8, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x00000021,
  0x00000002, 0x00000003, 0x00000004, 0x2aaaaaca,
  0x00000003, 0x00000004, 0x2aaaaaad, 0x4cccccec,
  0x00000004, 0x2aaaaaad, 0x4ccccccf, 0x7fff8020,
  0x2aaaaaad, 0x4ccccccf, 0x7fff8003, 0x7fff8021,
  0x4ccccccf, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x7fff8003, 0x7fff8004, 0x7fff8005, 0x7fff8023,
  0x7fff8004, 0x7fff8005, 0x7fff8006, 0x7fffffa0,
  0x7fff8005, 0x7fff8006, 0x7fffff83, 0x7fffffa1,
  0x7fff8006, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fffff83, 0x7fffff84, 0x7fffff85, 0x7fffffa3,
  0x7fffff84, 0x7fffff85, 0x7fffff86, 0x80000000,
  0x7fffff85, 0x7fffff86, 0x7fffffe3, 0x8000001d,
  0x7fffff86, 0x7fffffe3, 0x80000000, 0x8000001e,
  0x7fffffe3, 0x80000000, 0x80000001, 0x8000001f,
  0x7fffffff, 0x80000000, 0x80000001, 0x80000021,
  0x80000000, 0x80000001, 0x80000002, 0x80000020,
  0x80000001, 0x80000000, 0x80000001, 0x8000001f,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000001,
  0x7ffffffd, 0x7ffffffe, 0x7fffffe2, 0x7fffffa4,
  0x7ffffffc, 0x7fffffe0, 0x7fffff85, 0x7fffffa3,
  0x7fffffde, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fffff81, 0x7fffff82, 0x7fffff83, 0x7fff8024,
  0x7fffff80, 0x7fffff81, 0x7fff8005, 0x7fff8023,
  0x7fffff7f, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x7fff8001, 0x7fff8002, 0x7fff8003, 0x4cccccee,
  0x7fff8000, 0x7fff8001, 0x4ccccccf, 0x2aaaaacc,
  0x7fff7fff, 0x4ccccccd, 0x2aaaaaad, 0x00000024,
  0x4ccccccb, 0x2aaaaaab, 0x00000005, 0x00000023,
  0x2aaaaaa9, 0x00000003, 0x00000004, 0x00000022,
  0x00000001, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x2aaaaac9,
  0x00000002, 0x00000003, 0x2aaaaaac, 0x4ccccceb,
  0x00000003, 0x2aaaaaac, 0x4cccccce, 0x7fff801f,
  0x2aaaaaac, 0x4cccccce, 0x7fff8002, 0x7fff8020,
  0x4cccccce, 0x7fff8002, 0x7fff8003, 0x7fff8021,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x7fff8003, 0x7fff8004, 0x7fff8005, 0x7fffff9f,
  0x7fff8004, 0x7fff8005, 0x7fffff82, 0x7fffffa0,
  0x7fff8005, 0x7fffff82, 0x7fffff83, 0x7fffffa1,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fffff83, 0x7fffff84, 0x7fffff85, 0x7fffffff,
  0x7fffff84, 0x7fffff85, 0x7fffffe2, 0x8000001c,
  0x7fffff85, 0x7fffffe2, 0x7fffffff, 0x8000001d,
  0x7fffffe2, 0x7fffffff, 0x80000000, 0x8000001e,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0xaaaaaaca,
  0x7fffffff, 0x80000000, 0x80000003, 0xaaaaaac9,
  0x80000000, 0x80000001, 0x80000002, 0xaaaaaac8,
  0x7fffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x7ffffffe, 0x7fffffff, 0x7fffffe3, 0xaaaaaa4d,
  0x7ffffffd, 0x7fffffe1, 0x7fffff86, 0xaaaaaa4c,
  0x7fffffdf, 0x7fffff84, 0x7fffff85, 0xaaaaaa4b,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0xaaaa2acd,
  0x7fffff81, 0x7fffff82, 0x7fff8006, 0xaaaa2acc,
  0x7fffff80, 0x7fff8004, 0x7fff8005, 0xaaaa2acb,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x77777797,
  0x7fff8001, 0x7fff8002, 0x4cccccd0, 0x55555575,
  0x7fff8000, 0x4cccccce, 0x2aaaaaae, 0x2aaaaacd,
  0x4ccccccc, 0x2aaaaaac, 0x00000006, 0x2aaaaacc,
  0x2aaaaaaa, 0x00000004, 0x00000005, 0x2aaaaacb,
  0x00000002, 0x00000003, 0x00000004, 0x2aaaaaca,
  0x00000001, 0x00000002, 0x00000003, 0x2aaaaac9,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x2aaaaaab, 0x22222242,
  0x00000002, 0x2aaaaaab, 0x4ccccccd, 0x5554d576,
  0x2aaaaaab, 0x4ccccccd, 0x7fff8001, 0x5554d577,
  0x4ccccccd, 0x7fff8001, 0x7fff8002, 0x5554d578,
  0x7fff8001, 0x7fff8002, 0x7fff8003, 0x5554d579,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x555554f6,
  0x7fff8003, 0x7fff8004, 0x7fffff81, 0x555554f7,
  0x7fff8004, 0x7fffff81, 0x7fffff82, 0x555554f8,
  0x7fffff81, 0x7fffff82, 0x7fffff83, 0x555554f9,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0x55555556,
  0x7fffff83, 0x7fffff84, 0x7fffffe1, 0x55555573,
  0x7fffff84, 0x7fffffe1, 0x7ffffffe, 0x55555574,
  0x7fffffe1, 0x7ffffffe, 0x7fffffff, 0x55555575,
  0x7ffffffd, 0x7ffffffe, 0x55555557, 0xccccccec,
  0x7ffffffe, 0x7fffffff, 0xaaaaaaac, 0xcccccceb,
  0x7fffffff, 0x80000002, 0xaaaaaaab, 0xccccccea,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x7fffffff, 0x80000000, 0xaaaaaa8c, 0xcccccc6f,
  0x7ffffffe, 0x7fffffe2, 0xaaaaaa2f, 0xcccccc6e,
  0x7fffffe0, 0x7fffff85, 0xaaaaaa2e, 0xcccccc6d,
  0x7fffff83, 0x7fffff84, 0xaaaaaa2d, 0xcccc4cef,
  0x7fffff82, 0x7fffff83, 0xaaaa2aaf, 0xcccc4cee,
  0x7fffff81, 0x7fff8005, 0xaaaa2aae, 0xcccc4ced,
  0x7fff8003, 0x7fff8004, 0xaaaa2aad, 0x999999b9,
  0x7fff8002, 0x7fff8003, 0x77777779, 0x77777797,
  0x7fff8001, 0x4ccccccf, 0x55555557, 0x4cccccef,
  0x4ccccccd, 0x2aaaaaad, 0x2aaaaaaf, 0x4cccccee,
  0x2aaaaaab, 0x00000005, 0x2aaaaaae, 0x4ccccced,
  0x00000003, 0x00000004, 0x2aaaaaad, 0x4cccccec,
  0x00000002, 0x00000003, 0x2aaaaaac, 0x4ccccceb,
  0x00000001, 0x00000002, 0x2aaaaaab, 0x22222242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x2aaaaaaa, 0x22222224, 0x3332b354,
  0x2aaaaaaa, 0x4ccccccc, 0x5554d558, 0x3332b355,
  0x4ccccccc, 0x7fff8000, 0x5554d559, 0x3332b356,
  0x7fff8000, 0x7fff8001, 0x5554d55a, 0x3332b357,
  0x7fff8001, 0x7fff8002, 0x5554d55b, 0x333332d4,
  0x7fff8002, 0x7fff8003, 0x555554d8, 0x333332d5,
  0x7fff8003, 0x7fffff80, 0x555554d9, 0x333332d6,
  0x7fffff80, 0x7fffff81, 0x555554da, 0x333332d7,
  0x7fffff81, 0x7fffff82, 0x555554db, 0x33333334,
  0x7fffff82, 0x7fffff83, 0x55555538, 0x33333351,
  0x7fffff83, 0x7fffffe0, 0x55555555, 0x33333352,
  0x7fffffe0, 0x7ffffffd, 0x55555556, 0x33333353,
  0x7ffffffc, 0x55555555, 0x33333335, 0xffff8020,
  0x7ffffffd, 0x55555556, 0xccccccce, 0xffff801f,
  0x7ffffffe, 0xaaaaaaab, 0xcccccccd, 0xffff801e,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000000, 0xaaaaaaa9, 0xccccccae, 0xffff7fa3,
  0x7fffffff, 0xaaaaaa8b, 0xcccccc51, 0xffff7fa2,
  0x7fffffe1, 0xaaaaaa2e, 0xcccccc50, 0xffff7fa1,
  0x7fffff84, 0xaaaaaa2d, 0xcccccc4f, 0xffff0023,
  0x7fffff83, 0xaaaaaa2c, 0xcccc4cd1, 0xffff0022,
  0x7fffff82, 0xaaaa2aae, 0xcccc4cd0, 0xffff0021,
  0x7fff8004, 0xaaaa2aad, 0xcccc4ccf, 0xcccc4ced,
  0x7fff8003, 0xaaaa2aac, 0x9999999b, 0xaaaa2acb,
  0x7fff8002, 0x77777778, 0x77777779, 0x7fff8023,
  0x4cccccce, 0x55555556, 0x4cccccd1, 0x7fff8022,
  0x2aaaaaac, 0x2aaaaaae, 0x4cccccd0, 0x7fff8021,
  0x00000004, 0x2aaaaaad, 0x4ccccccf, 0x7fff8020,
  0x00000003, 0x2aaaaaac, 0x4cccccce, 0x7fff801f,
  0x00000002, 0x2aaaaaab, 0x4ccccccd, 0x5554d576,
  0x00000001, 0x2aaaaaaa, 0x22222224, 0x3332b354,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x2aaaaaa9, 0x22222223, 0x3332b336, 0x00000021,
  0x4ccccccb, 0x5554d557, 0x3332b337, 0x00000022,
  0x7fff7fff, 0x5554d558, 0x3332b338, 0x00000023,
  0x7fff8000, 0x5554d559, 0x3332b339, 0x00007fa0,
  0x7fff8001, 0x5554d55a, 0x333332b6, 0x00007fa1,
  0x7fff8002, 0x555554d7, 0x333332b7, 0x00007fa2,
  0x7fffff7f, 0x555554d8, 0x333332b8, 0x00007fa3,
  0x7fffff80, 0x555554d9, 0x333332b9, 0x00008000,
  0x7fffff81, 0x555554da, 0x33333316, 0x0000801d,
  0x7fffff82, 0x55555537, 0x33333333, 0x0000801e,
  0x7fffffdf, 0x55555554, 0x33333334, 0x0000801f,
  0x55555553, 0x33333333, 0x00008001, 0xffff8021,
  0x55555554, 0x33333334, 0xffff8002, 0xffff8020,
  0x55555555, 0xcccccccd, 0xffff8001, 0xffff801f,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaa9, 0xcccccccb, 0xffff7fe2, 0xffff7fa4,
  0xaaaaaaa8, 0xccccccad, 0xffff7f85, 0xffff7fa3,
  0xaaaaaa8a, 0xcccccc50, 0xffff7f84, 0xffff7fa2,
  0xaaaaaa2d, 0xcccccc4f, 0xffff7f83, 0xffff0024,
  0xaaaaaa2c, 0xcccccc4e, 0xffff0005, 0xffff0023,
  0xaaaaaa2b, 0xcccc4cd0, 0xffff0004, 0xffff0022,
  0xaaaa2aad, 0xcccc4ccf, 0xffff0003, 0xcccc4cee,
  0xaaaa2aac, 0xcccc4cce, 0xcccc4ccf, 0xaaaa2acc,
  0xaaaa2aab, 0x9999999a, 0xaaaa2aad, 0x7fff8024,
  0x77777777, 0x77777778, 0x7fff8005, 0x7fff8023,
  0x55555555, 0x4cccccd0, 0x7fff8004, 0x7fff8022,
  0x2aaaaaad, 0x4ccccccf, 0x7fff8003, 0x7fff8021,
  0x2aaaaaac, 0x4cccccce, 0x7fff8002, 0x7fff8020,
  0x2aaaaaab, 0x4ccccccd, 0x7fff8001, 0x5554d577,
  0x2aaaaaaa, 0x4ccccccc, 0x5554d558, 0x3332b355,
  0x2aaaaaa9, 0x22222223, 0x3332b336, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x22222222, 0x3332b335, 0x00000003, 0x00000021,
  0x5554d556, 0x3332b336, 0x00000004, 0x00000022,
  0x5554d557, 0x3332b337, 0x00000005, 0x00007f9f,
  0x5554d558, 0x3332b338, 0x00007f82, 0x00007fa0,
  0x5554d559, 0x333332b5, 0x00007f83, 0x00007fa1,
  0x555554d6, 0x333332b6, 0x00007f84, 0x00007fa2,
  0x555554d7, 0x333332b7, 0x00007f85, 0x00007fff,
  0x555554d8, 0x333332b8, 0x00007fe2, 0x0000801c,
  0x555554d9, 0x33333315, 0x00007fff, 0x0000801d,
  0x55555536, 0x33333332, 0x00008000, 0x0000801e,
  0x33333331, 0x00007fff, 0x00008000, 0xffff8022,
  0x33333332, 0x00008000, 0xffff8003, 0xffff8021,
  0x33333333, 0xffff8001, 0xffff8002, 0xffff8020,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccb, 0xffff7fff, 0xffff7fe3, 0xffff7fa5,
  0xccccccca, 0xffff7fe1, 0xffff7f86, 0xffff7fa4,
  0xccccccac, 0xffff7f84, 0xffff7f85, 0xffff7fa3,
  0xcccccc4f, 0xffff7f83, 0xffff7f84, 0xffff0025,
  0xcccccc4e, 0xffff7f82, 0xffff0006, 0xffff0024,
  0xcccccc4d, 0xffff0004, 0xffff0005, 0xffff0023,
  0xcccc4ccf, 0xffff0003, 0xffff0004, 0xcccc4cef,
  0xcccc4cce, 0xffff0002, 0xcccc4cd0, 0xaaaa2acd,
  0xcccc4ccd, 0xcccc4cce, 0xaaaa2aae, 0x7fff8025,
  0x99999999, 0xaaaa2aac, 0x7fff8006, 0x7fff8024,
  0x77777777, 0x7fff8004, 0x7fff8005, 0x7fff8023,
  0x4ccccccf, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x4cccccce, 0x7fff8002, 0x7fff8003, 0x7fff8021,
  0x4ccccccd, 0x7fff8001, 0x7fff8002, 0x5554d578,
  0x4ccccccc, 0x7fff8000, 0x5554d559, 0x3332b356,
  0x4ccccccb, 0x5554d557, 0x3332b337, 0x00000022,
  0x22222222, 0x3332b335, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x3332b334, 0x00000002, 0x00000003, 0x00000021,
  0x3332b335, 0x00000003, 0x00000004, 0x00007f9e,
  0x3332b336, 0x00000004, 0x00007f81, 0x00007f9f,
  0x3332b337, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x333332b4, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x333332b5, 0x00007f83, 0x00007f84, 0x00007ffe,
  0x333332b6, 0x00007f84, 0x00007fe1, 0x0000801b,
  0x333332b7, 0x00007fe1, 0x00007ffe, 0x0000801c,
  0x33333314, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0xffff8023,
  0x00007ffe, 0x00007fff, 0xffff8004, 0xffff8022,
  0x00007fff, 0xffff8002, 0xffff8003, 0xffff8021,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff7fff, 0xffff8000, 0xffff7fe4, 0xffff7fa6,
  0xffff7ffe, 0xffff7fe2, 0xffff7f87, 0xffff7fa5,
  0xffff7fe0, 0xffff7f85, 0xffff7f86, 0xffff7fa4,
  0xffff7f83, 0xffff7f84, 0xffff7f85, 0xffff0026,
  0xffff7f82, 0xffff7f83, 0xffff0007, 0xffff0025,
  0xffff7f81, 0xffff0005, 0xffff0006, 0xffff0024,
  0xffff0003, 0xffff0004, 0xffff0005, 0xcccc4cf0,
  0xffff0002, 0xffff0003, 0xcccc4cd1, 0xaaaa2ace,
  0xffff0001, 0xcccc4ccf, 0xaaaa2aaf, 0x7fff8026,
  0xcccc4ccd, 0xaaaa2aad, 0x7fff8007, 0x7fff8025,
  0xaaaa2aab, 0x7fff8005, 0x7fff8006, 0x7fff8024,
  0x7fff8003, 0x7fff8004, 0x7fff8005, 0x7fff8023,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x7fff8022,
  0x7fff8001, 0x7fff8002, 0x7fff8003, 0x5554d579,
  0x7fff8000, 0x7fff8001, 0x5554d55a, 0x3332b357,
  0x7fff7fff, 0x5554d558, 0x3332b338, 0x00000023,
  0x5554d556, 0x3332b336, 0x00000004, 0x00000022,
  0x3332b334, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x00007f9d,
  0x00000002, 0x00000003, 0x00007f80, 0x00007f9e,
  0x00000003, 0x00007f80, 0x00007f81, 0x00007f9f,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00007f81, 0x00007f82, 0x00007f83, 0x00007ffd,
  0x00007f82, 0x00007f83, 0x00007fe0, 0x0000801a,
  0x00007f83, 0x00007fe0, 0x00007ffd, 0x0000801b,
  0x00007fe0, 0x00007ffd, 0x00007ffe, 0x0000801c,
  0x00007ffc, 0x00007ffd, 0x00007ffe, 0xffffffa0,
  0x00007ffd, 0x00007ffe, 0xffff8005, 0xffffff9f,
  0x00007ffe, 0xffff8003, 0xffff8004, 0xffffff9e,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8000, 0xffff8001, 0xffff7fe5, 0xffffff23,
  0xffff7fff, 0xffff7fe3, 0xffff7f88, 0xffffff22,
  0xffff7fe1, 0xffff7f86, 0xffff7f87, 0xffffff21,
  0xffff7f84, 0xffff7f85, 0xffff7f86, 0xffff7fa3,
  0xffff7f83, 0xffff7f84, 0xffff0008, 0xffff7fa2,
  0xffff7f82, 0xffff0006, 0xffff0007, 0xffff7fa1,
  0xffff0004, 0xffff0005, 0xffff0006, 0xcccccc6d,
  0xffff0003, 0xffff0004, 0xcccc4cd2, 0xaaaaaa4b,
  0xffff0002, 0xcccc4cd0, 0xaaaa2ab0, 0x7fffffa3,
  0xcccc4cce, 0xaaaa2aae, 0x7fff8008, 0x7fffffa2,
  0xaaaa2aac, 0x7fff8006, 0x7fff8007, 0x7fffffa1,
  0x7fff8004, 0x7fff8005, 0x7fff8006, 0x7fffffa0,
  0x7fff8003, 0x7fff8004, 0x7fff8005, 0x7fffff9f,
  0x7fff8002, 0x7fff8003, 0x7fff8004, 0x555554f6,
  0x7fff8001, 0x7fff8002, 0x5554d55b, 0x333332d4,
  0x7fff8000, 0x5554d559, 0x3332b339, 0x00007fa0,
  0x5554d557, 0x3332b337, 0x00000005, 0x00007f9f,
  0x3332b335, 0x00000003, 0x00000004, 0x00007f9e,
  0x00000001, 0x00000002, 0x00000003, 0x00007f9d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00007f7f, 0x00000021,
  0x00000002, 0x00007f7f, 0x00007f80, 0x00000022,
  0x00007f7f, 0x00007f80, 0x00007f81, 0x00000023,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00000080,
  0x00007f81, 0x00007f82, 0x00007fdf, 0x0000009d,
  0x00007f82, 0x00007fdf, 0x00007ffc, 0x0000009e,
  0x00007fdf, 0x00007ffc, 0x00007ffd, 0x0000009f,
  0x00007ffb, 0x00007ffc, 0x00000081, 0xffffffa1,
  0x00007ffc, 0x00007ffd, 0xffffff82, 0xffffffa0,
  0x00007ffd, 0xffff8004, 0xffffff81, 0xffffff9f,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8001, 0xffff8002, 0xffffff62, 0xffffff24,
  0xffff8000, 0xffff7fe4, 0xffffff05, 0xffffff23,
  0xffff7fe2, 0xffff7f87, 0xffffff04, 0xffffff22,
  0xffff7f85, 0xffff7f86, 0xffffff03, 0xffff7fa4,
  0xffff7f84, 0xffff7f85, 0xffff7f85, 0xffff7fa3,
  0xffff7f83, 0xffff0007, 0xffff7f84, 0xffff7fa2,
  0xffff0005, 0xffff0006, 0xffff7f83, 0xcccccc6e,
  0xffff0004, 0xffff0005, 0xcccccc4f, 0xaaaaaa4c,
  0xffff0003, 0xcccc4cd1, 0xaaaaaa2d, 0x7fffffa4,
  0xcccc4ccf, 0xaaaa2aaf, 0x7fffff85, 0x7fffffa3,
  0xaaaa2aad, 0x7fff8007, 0x7fffff84, 0x7fffffa2,
  0x7fff8005, 0x7fff8006, 0x7fffff83, 0x7fffffa1,
  0x7fff8004, 0x7fff8005, 0x7fffff82, 0x7fffffa0,
  0x7fff8003, 0x7fff8004, 0x7fffff81, 0x555554f7,
  0x7fff8002, 0x7fff8003, 0x555554d8, 0x333332d5,
  0x7fff8001, 0x5554d55a, 0x333332b6, 0x00007fa1,
  0x5554d558, 0x3332b338, 0x00007f82, 0x00007fa0,
  0x3332b336, 0x00000004, 0x00007f81, 0x00007f9f,
  0x00000002, 0x00000003, 0x00007f80, 0x00007f9e,
  0x00000001, 0x00000002, 0x00007f7f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00007f7e, 0x00000003, 0x00000021,
  0x00007f7e, 0x00007f7f, 0x00000004, 0x00000022,
  0x00007f7f, 0x00007f80, 0x00000005, 0x0000007f,
  0x00007f80, 0x00007f81, 0x00000062, 0x0000009c,
  0x00007f81, 0x00007fde, 0x0000007f, 0x0000009d,
  0x00007fde, 0x00007ffb, 0x00000080, 0x0000009e,
  0x00007ffa, 0x0000007f, 0x00000080, 0xffffffa2,
  0x00007ffb, 0x00000080, 0xffffff83, 0xffffffa1,
  0x00007ffc, 0xffffff81, 0xffffff82, 0xffffffa0,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8002, 0xffffff7f, 0xffffff63, 0xffffff25,
  0xffff8001, 0xffffff61, 0xffffff06, 0xffffff24,
  0xffff7fe3, 0xffffff04, 0xffffff05, 0xffffff23,
  0xffff7f86, 0xffffff03, 0xffffff04, 0xffff7fa5,
  0xffff7f85, 0xffffff02, 0xffff7f86, 0xffff7fa4,
  0xffff7f84, 0xffff7f84, 0xffff7f85, 0xffff7fa3,
  0xffff0006, 0xffff7f83, 0xffff7f84, 0xcccccc6f,
  0xffff0005, 0xffff7f82, 0xcccccc50, 0xaaaaaa4d,
  0xffff0004, 0xcccccc4e, 0xaaaaaa2e, 0x7fffffa5,
  0xcccc4cd0, 0xaaaaaa2c, 0x7fffff86, 0x7fffffa4,
  0xaaaa2aae, 0x7fffff84, 0x7fffff85, 0x7fffffa3,
  0x7fff8006, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fff8005, 0x7fffff82, 0x7fffff83, 0x7fffffa1,
  0x7fff8004, 0x7fffff81, 0x7fffff82, 0x555554f8,
  0x7fff8003, 0x7fffff80, 0x555554d9, 0x333332d6,
  0x7fff8002, 0x555554d7, 0x333332b7, 0x00007fa2,
  0x5554d559, 0x333332b5, 0x00007f83, 0x00007fa1,
  0x3332b337, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00000003, 0x00007f80, 0x00007f81, 0x00007f9f,
  0x00000002, 0x00007f7f, 0x00007f80, 0x00000022,
  0x00000001, 0x00007f7e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007f7d, 0x00000002, 0x00000003, 0x00000021,
  0x00007f7e, 0x00000003, 0x00000004, 0x0000007e,
  0x00007f7f, 0x00000004, 0x00000061, 0x0000009b,
  0x00007f80, 0x00000061, 0x0000007e, 0x0000009c,
  0x00007fdd, 0x0000007e, 0x0000007f, 0x0000009d,
  0x0000007d, 0x0000007e, 0x0000007f, 0xffffffa3,
  0x0000007e, 0x0000007f, 0xffffff84, 0xffffffa2,
  0x0000007f, 0xffffff82, 0xffffff83, 0xffffffa1,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff7f, 0xffffff80, 0xffffff64, 0xffffff26,
  0xffffff7e, 0xffffff62, 0xffffff07, 0xffffff25,
  0xffffff60, 0xffffff05, 0xffffff06, 0xffffff24,
  0xffffff03, 0xffffff04, 0xffffff05, 0xffff7fa6,
  0xffffff02, 0xffffff03, 0xffff7f87, 0xffff7fa5,
  0xffffff01, 0xffff7f85, 0xffff7f86, 0xffff7fa4,
  0xffff7f83, 0xffff7f84, 0xffff7f85, 0xcccccc70,
  0xffff7f82, 0xffff7f83, 0xcccccc51, 0xaaaaaa4e,
  0xffff7f81, 0xcccccc4f, 0xaaaaaa2f, 0x7fffffa6,
  0xcccccc4d, 0xaaaaaa2d, 0x7fffff87, 0x7fffffa5,
  0xaaaaaa2b, 0x7fffff85, 0x7fffff86, 0x7fffffa4,
  0x7fffff83, 0x7fffff84, 0x7fffff85, 0x7fffffa3,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0x7fffffa2,
  0x7fffff81, 0x7fffff82, 0x7fffff83, 0x555554f9,
  0x7fffff80, 0x7fffff81, 0x555554da, 0x333332d7,
  0x7fffff7f, 0x555554d8, 0x333332b8, 0x00007fa3,
  0x555554d6, 0x333332b6, 0x00007f84, 0x00007fa2,
  0x333332b4, 0x00007f82, 0x00007f83, 0x00007fa1,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00007f7f, 0x00007f80, 0x00007f81, 0x00000023,
  0x00007f7e, 0x00007f7f, 0x00000004, 0x00000022,
  0x00007f7d, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x0000007d,
  0x00000002, 0x00000003, 0x00000060, 0x0000009a,
  0x00000003, 0x00000060, 0x0000007d, 0x0000009b,
  0x00000060, 0x0000007d, 0x0000007e, 0x0000009c,
  0x0000007c, 0x0000007d, 0x0000007e, 0x00000000,
  0x0000007d, 0x0000007e, 0xffffff85, 0xffffffff,
  0x0000007e, 0xffffff83, 0xffffff84, 0xfffffffe,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff80, 0xffffff81, 0xffffff65, 0xffffff83,
  0xffffff7f, 0xffffff63, 0xffffff08, 0xffffff82,
  0xffffff61, 0xffffff06, 0xffffff07, 0xffffff81,
  0xffffff04, 0xffffff05, 0xffffff06, 0xffff8003,
  0xffffff03, 0xffffff04, 0xffff7f88, 0xffff8002,
  0xffffff02, 0xffff7f86, 0xffff7f87, 0xffff8001,
  0xffff7f84, 0xffff7f85, 0xffff7f86, 0xcccccccd,
  0xffff7f83, 0xffff7f84, 0xcccccc52, 0xaaaaaaab,
  0xffff7f82, 0xcccccc50, 0xaaaaaa30, 0x80000003,
  0xcccccc4e, 0xaaaaaa2e, 0x7fffff88, 0x80000002,
  0xaaaaaa2c, 0x7fffff86, 0x7fffff87, 0x80000001,
  0x7fffff84, 0x7fffff85, 0x7fffff86, 0x80000000,
  0x7fffff83, 0x7fffff84, 0x7fffff85, 0x7fffffff,
  0x7fffff82, 0x7fffff83, 0x7fffff84, 0x55555556,
  0x7fffff81, 0x7fffff82, 0x555554db, 0x33333334,
  0x7fffff80, 0x555554d9, 0x333332b9, 0x00008000,
  0x555554d7, 0x333332b7, 0x00007f85, 0x00007fff,
  0x333332b5, 0x00007f83, 0x00007f84, 0x00007ffe,
  0x00007f81, 0x00007f82, 0x00007f83, 0x00007ffd,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00000080,
  0x00007f7f, 0x00007f80, 0x00000005, 0x0000007f,
  0x00007f7e, 0x00000003, 0x00000004, 0x0000007e,
  0x00000001, 0x00000002, 0x00000003, 0x0000007d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x0000005f, 0x0000003d,
  0x00000002, 0x0000005f, 0x0000007c, 0x0000003e,
  0x0000005f, 0x0000007c, 0x0000007d, 0x0000003f,
  0x0000007b, 0x0000007c, 0x00000021, 0x0000001d,
  0x0000007c, 0x0000007d, 0xffffffe2, 0x0000001c,
  0x0000007d, 0xffffff84, 0xffffffe1, 0x0000001b,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff81, 0xffffff82, 0xffffffc2, 0xffffffa0,
  0xffffff80, 0xffffff64, 0xffffff65, 0xffffff9f,
  0xffffff62, 0xffffff07, 0xffffff64, 0xffffff9e,
  0xffffff05, 0xffffff06, 0xffffff63, 0xffff8020,
  0xffffff04, 0xffffff05, 0xffff7fe5, 0xffff801f,
  0xffffff03, 0xffff7f87, 0xffff7fe4, 0xffff801e,
  0xffff7f85, 0xffff7f86, 0xffff7fe3, 0xccccccea,
  0xffff7f84, 0xffff7f85, 0xccccccaf, 0xaaaaaac8,
  0xffff7f83, 0xcccccc51, 0xaaaaaa8d, 0x80000020,
  0xcccccc4f, 0xaaaaaa2f, 0x7fffffe5, 0x8000001f,
  0xaaaaaa2d, 0x7fffff87, 0x7fffffe4, 0x8000001e,
  0x7fffff85, 0x7fffff86, 0x7fffffe3, 0x8000001d,
  0x7fffff84, 0x7fffff85, 0x7fffffe2, 0x8000001c,
  0x7fffff83, 0x7fffff84, 0x7fffffe1, 0x55555573,
  0x7fffff82, 0x7fffff83, 0x55555538, 0x33333351,
  0x7fffff81, 0x555554da, 0x33333316, 0x0000801d,
  0x555554d8, 0x333332b8, 0x00007fe2, 0x0000801c,
  0x333332b6, 0x00007f84, 0x00007fe1, 0x0000801b,
  0x00007f82, 0x00007f83, 0x00007fe0, 0x0000801a,
  0x00007f81, 0x00007f82, 0x00007fdf, 0x0000009d,
  0x00007f80, 0x00007f81, 0x00000062, 0x0000009c,
  0x00007f7f, 0x00000004, 0x00000061, 0x0000009b,
  0x00000002, 0x00000003, 0x00000060, 0x0000009a,
  0x00000001, 0x00000002, 0x0000005f, 0x0000003d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x0000005e, 0x0000001f, 0x00000021,
  0x0000005e, 0x0000007b, 0x00000020, 0x00000022,
  0x0000007a, 0x0000001f, 0x00000004, 0x0000001e,
  0x0000007b, 0x00000020, 0xffffffff, 0x0000001d,
  0x0000007c, 0xffffffe1, 0xfffffffe, 0x0000001c,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff82, 0xffffffdf, 0xffffffdf, 0xffffffa1,
  0xffffff81, 0xffffffc1, 0xffffff82, 0xffffffa0,
  0xffffff63, 0xffffff64, 0xffffff81, 0xffffff9f,
  0xffffff06, 0xffffff63, 0xffffff80, 0xffff8021,
  0xffffff05, 0xffffff62, 0xffff8002, 0xffff8020,
  0xffffff04, 0xffff7fe4, 0xffff8001, 0xffff801f,
  0xffff7f86, 0xffff7fe3, 0xffff8000, 0xcccccceb,
  0xffff7f85, 0xffff7fe2, 0xcccccccc, 0xaaaaaac9,
  0xffff7f84, 0xccccccae, 0xaaaaaaaa, 0x80000021,
  0xcccccc50, 0xaaaaaa8c, 0x80000002, 0x80000020,
  0xaaaaaa2e, 0x7fffffe4, 0x80000001, 0x8000001f,
  0x7fffff86, 0x7fffffe3, 0x80000000, 0x8000001e,
  0x7fffff85, 0x7fffffe2, 0x7fffffff, 0x8000001d,
  0x7fffff84, 0x7fffffe1, 0x7ffffffe, 0x55555574,
  0x7fffff83, 0x7fffffe0, 0x55555555, 0x33333352,
  0x7fffff82, 0x55555537, 0x33333333, 0x0000801e,
  0x555554d9, 0x33333315, 0x00007fff, 0x0000801d,
  0x333332b7, 0x00007fe1, 0x00007ffe, 0x0000801c,
  0x00007f83, 0x00007fe0, 0x00007ffd, 0x0000801b,
  0x00007f82, 0x00007fdf, 0x00007ffc, 0x0000009e,
  0x00007f81, 0x00007fde, 0x0000007f, 0x0000009d,
  0x00007f80, 0x00000061, 0x0000007e, 0x0000009c,
  0x00000003, 0x00000060, 0x0000007d, 0x0000009b,
  0x00000002, 0x0000005f, 0x0000007c, 0x0000003e,
  0x00000001, 0x0000005e, 0x0000001f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000005d, 0x0000001e, 0x00000003, 0x00000021,
  0x0000001d, 0x00000002, 0x00000003, 0x0000001f,
  0x0000001e, 0x00000003, 0x00000000, 0x0000001e,
  0x0000001f, 0xfffffffe, 0xffffffff, 0x0000001d,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffdf, 0xfffffffc, 0xffffffe0, 0xffffffa2,
  0xffffffde, 0xffffffde, 0xffffff83, 0xffffffa1,
  0xffffffc0, 0xffffff81, 0xffffff82, 0xffffffa0,
  0xffffff63, 0xffffff80, 0xffffff81, 0xffff8022,
  0xffffff62, 0xffffff7f, 0xffff8003, 0xffff8021,
  0xffffff61, 0xffff8001, 0xffff8002, 0xffff8020,
  0xffff7fe3, 0xffff8000, 0xffff8001, 0xccccccec,
  0xffff7fe2, 0xffff7fff, 0xcccccccd, 0xaaaaaaca,
  0xffff7fe1, 0xcccccccb, 0xaaaaaaab, 0x80000022,
  0xccccccad, 0xaaaaaaa9, 0x80000003, 0x80000021,
  0xaaaaaa8b, 0x80000001, 0x80000002, 0x80000020,
  0x7fffffe3, 0x80000000, 0x80000001, 0x8000001f,
  0x7fffffe2, 0x7fffffff, 0x80000000, 0x8000001e,
  0x7fffffe1, 0x7ffffffe, 0x7fffffff, 0x55555575,
  0x7fffffe0, 0x7ffffffd, 0x55555556, 0x33333353,
  0x7fffffdf, 0x55555554, 0x33333334, 0x0000801f,
  0x55555536, 0x33333332, 0x00008000, 0x0000801e,
  0x33333314, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00007fe0, 0x00007ffd, 0x00007ffe, 0x0000801c,
  0x00007fdf, 0x00007ffc, 0x00007ffd, 0x0000009f,
  0x00007fde, 0x00007ffb, 0x00000080, 0x0000009e,
  0x00007fdd, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00000060, 0x0000007d, 0x0000007e, 0x0000009c,
  0x0000005f, 0x0000007c, 0x0000007d, 0x0000003f,
  0x0000005e, 0x0000007b, 0x00000020, 0x00000022,
  0x0000005d, 0x0000001e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
};
const unsigned kExpectedCount_NEON_uaba_4S = 961;

#endif  // VIXL_SIM_UABA_4S_TRACE_AARCH64_H_
