// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USRA_D_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_USRA_D_2OPIMM_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_usra_D_2OPIMM[] = {
  0x7fffffffffffffff,
  0xbffffffffffffffe,
  0xdffffffffffffffd,
  0xeffffffffffffffc,
  0xf7fffffffffffffb,
  0xfbfffffffffffffa,
  0xfdfffffffffffff9,
  0xfefffffffffffff8,
  0xff7ffffffffffff7,
  0xffbffffffffffff6,
  0xffdffffffffffff5,
  0xffeffffffffffff4,
  0xfff7fffffffffff3,
  0xfffbfffffffffff2,
  0xfffdfffffffffff1,
  0xfffefffffffffff0,
  0xffff7fffffffffef,
  0xffffbfffffffffee,
  0xffffdfffffffffed,
  0xffffefffffffffec,
  0xfffff7ffffffffeb,
  0xfffffbffffffffea,
  0xfffffdffffffffe9,
  0xfffffeffffffffe8,
  0xffffff7fffffffe7,
  0xffffffbfffffffe6,
  0xffffffdfffffffe5,
  0xffffffefffffffe4,
  0xfffffff7ffffffe3,
  0xfffffffbffffffe2,
  0xfffffffdffffffe1,
  0xfffffffeffffffe0,
  0xffffffff7fffffdf,
  0xffffffffbfffffde,
  0xffffffffdfffffdd,
  0xffffffffefffffdc,
  0xfffffffff7ffffdb,
  0xfffffffffbffffda,
  0xfffffffffdffffd9,
  0xfffffffffeffffd8,
  0xffffffffff7fffd7,
  0xffffffffffbfffd6,
  0xffffffffffdfffd5,
  0xffffffffffefffd4,
  0xfffffffffff7ffd3,
  0xfffffffffffbffd2,
  0xfffffffffffdffd1,
  0xfffffffffffeffd0,
  0xffffffffffff7fcf,
  0xffffffffffffbfce,
  0xffffffffffffdfcd,
  0xffffffffffffefcc,
  0xfffffffffffff7cb,
  0xfffffffffffffbca,
  0xfffffffffffffdc9,
  0xfffffffffffffec8,
  0xffffffffffffff47,
  0xffffffffffffff86,
  0xffffffffffffffa5,
  0xffffffffffffffb4,
  0xffffffffffffffbb,
  0xffffffffffffffbe,
  0xffffffffffffffbf,
  0xffffffffffffffbf,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000000,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000001,
  0x0000000000000020,
  0x0000000000000030,
  0x0000000000000038,
  0x000000000000003c,
  0x000000000000003e,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003f,
  0x000000000000003e,
  0x000000000000005d,
  0x000000000000006c,
  0x0000000000000073,
  0x0000000000000076,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x0000000000000077,
  0x000000000000003f,
  0x000000000000005e,
  0x000000000000006d,
  0x0000000000000074,
  0x0000000000000077,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x000000000000003f,
  0x000000000000005e,
  0x000000000000006d,
  0x0000000000000074,
  0x0000000000000077,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000000078,
  0x0000000000003ffe,
  0x0000000000005ffd,
  0x0000000000006ffc,
  0x00000000000077fb,
  0x0000000000007bfa,
  0x0000000000007df9,
  0x0000000000007ef8,
  0x0000000000007f77,
  0x0000000000007fb6,
  0x0000000000007fd5,
  0x0000000000007fe4,
  0x0000000000007feb,
  0x0000000000007fee,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000007fef,
  0x0000000000003fff,
  0x0000000000005ffe,
  0x0000000000006ffd,
  0x00000000000077fc,
  0x0000000000007bfb,
  0x0000000000007dfa,
  0x0000000000007ef9,
  0x0000000000007f78,
  0x0000000000007fb7,
  0x0000000000007fd6,
  0x0000000000007fe5,
  0x0000000000007fec,
  0x0000000000007fef,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000003fff,
  0x0000000000005ffe,
  0x0000000000006ffd,
  0x00000000000077fc,
  0x0000000000007bfb,
  0x0000000000007dfa,
  0x0000000000007ef9,
  0x0000000000007f78,
  0x0000000000007fb7,
  0x0000000000007fd6,
  0x0000000000007fe5,
  0x0000000000007fec,
  0x0000000000007fef,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x0000000000007ff0,
  0x000000003ffffffe,
  0x000000005ffffffd,
  0x000000006ffffffc,
  0x0000000077fffffb,
  0x000000007bfffffa,
  0x000000007dfffff9,
  0x000000007efffff8,
  0x000000007f7ffff7,
  0x000000007fbffff6,
  0x000000007fdffff5,
  0x000000007feffff4,
  0x000000007ff7fff3,
  0x000000007ffbfff2,
  0x000000007ffdfff1,
  0x000000007ffefff0,
  0x000000007fff7fef,
  0x000000007fffbfee,
  0x000000007fffdfed,
  0x000000007fffefec,
  0x000000007ffff7eb,
  0x000000007ffffbea,
  0x000000007ffffde9,
  0x000000007ffffee8,
  0x000000007fffff67,
  0x000000007fffffa6,
  0x000000007fffffc5,
  0x000000007fffffd4,
  0x000000007fffffdb,
  0x000000007fffffde,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000007fffffdf,
  0x000000003fffffff,
  0x000000005ffffffe,
  0x000000006ffffffd,
  0x0000000077fffffc,
  0x000000007bfffffb,
  0x000000007dfffffa,
  0x000000007efffff9,
  0x000000007f7ffff8,
  0x000000007fbffff7,
  0x000000007fdffff6,
  0x000000007feffff5,
  0x000000007ff7fff4,
  0x000000007ffbfff3,
  0x000000007ffdfff2,
  0x000000007ffefff1,
  0x000000007fff7ff0,
  0x000000007fffbfef,
  0x000000007fffdfee,
  0x000000007fffefed,
  0x000000007ffff7ec,
  0x000000007ffffbeb,
  0x000000007ffffdea,
  0x000000007ffffee9,
  0x000000007fffff68,
  0x000000007fffffa7,
  0x000000007fffffc6,
  0x000000007fffffd5,
  0x000000007fffffdc,
  0x000000007fffffdf,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000003fffffff,
  0x000000005ffffffe,
  0x000000006ffffffd,
  0x0000000077fffffc,
  0x000000007bfffffb,
  0x000000007dfffffa,
  0x000000007efffff9,
  0x000000007f7ffff8,
  0x000000007fbffff7,
  0x000000007fdffff6,
  0x000000007feffff5,
  0x000000007ff7fff4,
  0x000000007ffbfff3,
  0x000000007ffdfff2,
  0x000000007ffefff1,
  0x000000007fff7ff0,
  0x000000007fffbfef,
  0x000000007fffdfee,
  0x000000007fffefed,
  0x000000007ffff7ec,
  0x000000007ffffbeb,
  0x000000007ffffdea,
  0x000000007ffffee9,
  0x000000007fffff68,
  0x000000007fffffa7,
  0x000000007fffffc6,
  0x000000007fffffd5,
  0x000000007fffffdc,
  0x000000007fffffdf,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x000000007fffffe0,
  0x1999999999999999,
  0x2666666666666665,
  0x2ccccccccccccccb,
  0x2ffffffffffffffe,
  0x3199999999999997,
  0x3266666666666663,
  0x32ccccccccccccc9,
  0x32fffffffffffffc,
  0x3319999999999995,
  0x3326666666666661,
  0x332cccccccccccc7,
  0x332ffffffffffffa,
  0x3331999999999993,
  0x333266666666665f,
  0x3332ccccccccccc5,
  0x3332fffffffffff8,
  0x3333199999999991,
  0x333326666666665d,
  0x33332cccccccccc3,
  0x33332ffffffffff6,
  0x333331999999998f,
  0x333332666666665b,
  0x333332ccccccccc1,
  0x333332fffffffff4,
  0x333333199999998d,
  0x3333332666666659,
  0x3333332cccccccbf,
  0x3333332ffffffff2,
  0x333333319999998b,
  0x3333333266666657,
  0x33333332ccccccbd,
  0x33333332fffffff0,
  0x3333333319999989,
  0x3333333326666655,
  0x333333332cccccbb,
  0x333333332fffffee,
  0x3333333331999987,
  0x3333333332666653,
  0x3333333332ccccb9,
  0x3333333332ffffec,
  0x3333333333199985,
  0x3333333333266651,
  0x33333333332cccb7,
  0x33333333332fffea,
  0x3333333333319983,
  0x333333333332664f,
  0x333333333332ccb5,
  0x333333333332ffe8,
  0x3333333333331981,
  0x333333333333264d,
  0x3333333333332cb3,
  0x3333333333332fe6,
  0x333333333333317f,
  0x333333333333324b,
  0x33333333333332b1,
  0x33333333333332e4,
  0x33333333333332fd,
  0x3333333333333309,
  0x333333333333330f,
  0x3333333333333312,
  0x3333333333333313,
  0x3333333333333313,
  0x3333333333333313,
  0x3333333333333313,
  0x2aaaaaaaaaaaaaaa,
  0x3fffffffffffffff,
  0x4aaaaaaaaaaaaaa9,
  0x4ffffffffffffffe,
  0x52aaaaaaaaaaaaa8,
  0x53fffffffffffffd,
  0x54aaaaaaaaaaaaa7,
  0x54fffffffffffffc,
  0x552aaaaaaaaaaaa6,
  0x553ffffffffffffb,
  0x554aaaaaaaaaaaa5,
  0x554ffffffffffffa,
  0x5552aaaaaaaaaaa4,
  0x5553fffffffffff9,
  0x5554aaaaaaaaaaa3,
  0x5554fffffffffff8,
  0x55552aaaaaaaaaa2,
  0x55553ffffffffff7,
  0x55554aaaaaaaaaa1,
  0x55554ffffffffff6,
  0x555552aaaaaaaaa0,
  0x555553fffffffff5,
  0x555554aaaaaaaa9f,
  0x555554fffffffff4,
  0x5555552aaaaaaa9e,
  0x5555553ffffffff3,
  0x5555554aaaaaaa9d,
  0x5555554ffffffff2,
  0x55555552aaaaaa9c,
  0x55555553fffffff1,
  0x55555554aaaaaa9b,
  0x55555554fffffff0,
  0x555555552aaaaa9a,
  0x555555553fffffef,
  0x555555554aaaaa99,
  0x555555554fffffee,
  0x5555555552aaaa98,
  0x5555555553ffffed,
  0x5555555554aaaa97,
  0x5555555554ffffec,
  0x55555555552aaa96,
  0x55555555553fffeb,
  0x55555555554aaa95,
  0x55555555554fffea,
  0x555555555552aa94,
  0x555555555553ffe9,
  0x555555555554aa93,
  0x555555555554ffe8,
  0x5555555555552a92,
  0x5555555555553fe7,
  0x5555555555554a91,
  0x5555555555554fe6,
  0x5555555555555290,
  0x55555555555553e5,
  0x555555555555548f,
  0x55555555555554e4,
  0x555555555555550e,
  0x5555555555555523,
  0x555555555555552d,
  0x5555555555555532,
  0x5555555555555534,
  0x5555555555555535,
  0x5555555555555535,
  0x5555555555555535,
  0x3ffffffffffffffe,
  0x5ffffffffffffffd,
  0x6ffffffffffffffc,
  0x77fffffffffffffb,
  0x7bfffffffffffffa,
  0x7dfffffffffffff9,
  0x7efffffffffffff8,
  0x7f7ffffffffffff7,
  0x7fbffffffffffff6,
  0x7fdffffffffffff5,
  0x7feffffffffffff4,
  0x7ff7fffffffffff3,
  0x7ffbfffffffffff2,
  0x7ffdfffffffffff1,
  0x7ffefffffffffff0,
  0x7fff7fffffffffef,
  0x7fffbfffffffffee,
  0x7fffdfffffffffed,
  0x7fffefffffffffec,
  0x7ffff7ffffffffeb,
  0x7ffffbffffffffea,
  0x7ffffdffffffffe9,
  0x7ffffeffffffffe8,
  0x7fffff7fffffffe7,
  0x7fffffbfffffffe6,
  0x7fffffdfffffffe5,
  0x7fffffefffffffe4,
  0x7ffffff7ffffffe3,
  0x7ffffffbffffffe2,
  0x7ffffffdffffffe1,
  0x7ffffffeffffffe0,
  0x7fffffff7fffffdf,
  0x7fffffffbfffffde,
  0x7fffffffdfffffdd,
  0x7fffffffefffffdc,
  0x7ffffffff7ffffdb,
  0x7ffffffffbffffda,
  0x7ffffffffdffffd9,
  0x7ffffffffeffffd8,
  0x7fffffffff7fffd7,
  0x7fffffffffbfffd6,
  0x7fffffffffdfffd5,
  0x7fffffffffefffd4,
  0x7ffffffffff7ffd3,
  0x7ffffffffffbffd2,
  0x7ffffffffffdffd1,
  0x7ffffffffffeffd0,
  0x7fffffffffff7fcf,
  0x7fffffffffffbfce,
  0x7fffffffffffdfcd,
  0x7fffffffffffefcc,
  0x7ffffffffffff7cb,
  0x7ffffffffffffbca,
  0x7ffffffffffffdc9,
  0x7ffffffffffffec8,
  0x7fffffffffffff47,
  0x7fffffffffffff86,
  0x7fffffffffffffa5,
  0x7fffffffffffffb4,
  0x7fffffffffffffbb,
  0x7fffffffffffffbe,
  0x7fffffffffffffbf,
  0x7fffffffffffffbf,
  0x7fffffffffffffbf,
  0x3fffffffffffffff,
  0x5ffffffffffffffe,
  0x6ffffffffffffffd,
  0x77fffffffffffffc,
  0x7bfffffffffffffb,
  0x7dfffffffffffffa,
  0x7efffffffffffff9,
  0x7f7ffffffffffff8,
  0x7fbffffffffffff7,
  0x7fdffffffffffff6,
  0x7feffffffffffff5,
  0x7ff7fffffffffff4,
  0x7ffbfffffffffff3,
  0x7ffdfffffffffff2,
  0x7ffefffffffffff1,
  0x7fff7ffffffffff0,
  0x7fffbfffffffffef,
  0x7fffdfffffffffee,
  0x7fffefffffffffed,
  0x7ffff7ffffffffec,
  0x7ffffbffffffffeb,
  0x7ffffdffffffffea,
  0x7ffffeffffffffe9,
  0x7fffff7fffffffe8,
  0x7fffffbfffffffe7,
  0x7fffffdfffffffe6,
  0x7fffffefffffffe5,
  0x7ffffff7ffffffe4,
  0x7ffffffbffffffe3,
  0x7ffffffdffffffe2,
  0x7ffffffeffffffe1,
  0x7fffffff7fffffe0,
  0x7fffffffbfffffdf,
  0x7fffffffdfffffde,
  0x7fffffffefffffdd,
  0x7ffffffff7ffffdc,
  0x7ffffffffbffffdb,
  0x7ffffffffdffffda,
  0x7ffffffffeffffd9,
  0x7fffffffff7fffd8,
  0x7fffffffffbfffd7,
  0x7fffffffffdfffd6,
  0x7fffffffffefffd5,
  0x7ffffffffff7ffd4,
  0x7ffffffffffbffd3,
  0x7ffffffffffdffd2,
  0x7ffffffffffeffd1,
  0x7fffffffffff7fd0,
  0x7fffffffffffbfcf,
  0x7fffffffffffdfce,
  0x7fffffffffffefcd,
  0x7ffffffffffff7cc,
  0x7ffffffffffffbcb,
  0x7ffffffffffffdca,
  0x7ffffffffffffec9,
  0x7fffffffffffff48,
  0x7fffffffffffff87,
  0x7fffffffffffffa6,
  0x7fffffffffffffb5,
  0x7fffffffffffffbc,
  0x7fffffffffffffbf,
  0x7fffffffffffffc0,
  0x7fffffffffffffc0,
  0x7fffffffffffffc0,
  0x3fffffffffffffff,
  0x5ffffffffffffffe,
  0x6ffffffffffffffd,
  0x77fffffffffffffc,
  0x7bfffffffffffffb,
  0x7dfffffffffffffa,
  0x7efffffffffffff9,
  0x7f7ffffffffffff8,
  0x7fbffffffffffff7,
  0x7fdffffffffffff6,
  0x7feffffffffffff5,
  0x7ff7fffffffffff4,
  0x7ffbfffffffffff3,
  0x7ffdfffffffffff2,
  0x7ffefffffffffff1,
  0x7fff7ffffffffff0,
  0x7fffbfffffffffef,
  0x7fffdfffffffffee,
  0x7fffefffffffffed,
  0x7ffff7ffffffffec,
  0x7ffffbffffffffeb,
  0x7ffffdffffffffea,
  0x7ffffeffffffffe9,
  0x7fffff7fffffffe8,
  0x7fffffbfffffffe7,
  0x7fffffdfffffffe6,
  0x7fffffefffffffe5,
  0x7ffffff7ffffffe4,
  0x7ffffffbffffffe3,
  0x7ffffffdffffffe2,
  0x7ffffffeffffffe1,
  0x7fffffff7fffffe0,
  0x7fffffffbfffffdf,
  0x7fffffffdfffffde,
  0x7fffffffefffffdd,
  0x7ffffffff7ffffdc,
  0x7ffffffffbffffdb,
  0x7ffffffffdffffda,
  0x7ffffffffeffffd9,
  0x7fffffffff7fffd8,
  0x7fffffffffbfffd7,
  0x7fffffffffdfffd6,
  0x7fffffffffefffd5,
  0x7ffffffffff7ffd4,
  0x7ffffffffffbffd3,
  0x7ffffffffffdffd2,
  0x7ffffffffffeffd1,
  0x7fffffffffff7fd0,
  0x7fffffffffffbfcf,
  0x7fffffffffffdfce,
  0x7fffffffffffefcd,
  0x7ffffffffffff7cc,
  0x7ffffffffffffbcb,
  0x7ffffffffffffdca,
  0x7ffffffffffffec9,
  0x7fffffffffffff48,
  0x7fffffffffffff87,
  0x7fffffffffffffa6,
  0x7fffffffffffffb5,
  0x7fffffffffffffbc,
  0x7fffffffffffffbf,
  0x7fffffffffffffc0,
  0x7fffffffffffffc0,
  0x7fffffffffffffc0,
  0x4000000000000000,
  0x6000000000000000,
  0x7000000000000000,
  0x7800000000000000,
  0x7c00000000000000,
  0x7e00000000000000,
  0x7f00000000000000,
  0x7f80000000000000,
  0x7fc0000000000000,
  0x7fe0000000000000,
  0x7ff0000000000000,
  0x7ff8000000000000,
  0x7ffc000000000000,
  0x7ffe000000000000,
  0x7fff000000000000,
  0x7fff800000000000,
  0x7fffc00000000000,
  0x7fffe00000000000,
  0x7ffff00000000000,
  0x7ffff80000000000,
  0x7ffffc0000000000,
  0x7ffffe0000000000,
  0x7fffff0000000000,
  0x7fffff8000000000,
  0x7fffffc000000000,
  0x7fffffe000000000,
  0x7ffffff000000000,
  0x7ffffff800000000,
  0x7ffffffc00000000,
  0x7ffffffe00000000,
  0x7fffffff00000000,
  0x7fffffff80000000,
  0x7fffffffc0000000,
  0x7fffffffe0000000,
  0x7ffffffff0000000,
  0x7ffffffff8000000,
  0x7ffffffffc000000,
  0x7ffffffffe000000,
  0x7fffffffff000000,
  0x7fffffffff800000,
  0x7fffffffffc00000,
  0x7fffffffffe00000,
  0x7ffffffffff00000,
  0x7ffffffffff80000,
  0x7ffffffffffc0000,
  0x7ffffffffffe0000,
  0x7fffffffffff0000,
  0x7fffffffffff8000,
  0x7fffffffffffc000,
  0x7fffffffffffe000,
  0x7ffffffffffff000,
  0x7ffffffffffff800,
  0x7ffffffffffffc00,
  0x7ffffffffffffe00,
  0x7fffffffffffff00,
  0x7fffffffffffff80,
  0x7fffffffffffffc0,
  0x7fffffffffffffe0,
  0x7ffffffffffffff0,
  0x7ffffffffffffff8,
  0x7ffffffffffffffc,
  0x7ffffffffffffffe,
  0x7fffffffffffffff,
  0x7fffffffffffffff,
  0x4000000000000000,
  0x6000000000000000,
  0x7000000000000000,
  0x7800000000000000,
  0x7c00000000000000,
  0x7e00000000000000,
  0x7f00000000000000,
  0x7f80000000000000,
  0x7fc0000000000000,
  0x7fe0000000000000,
  0x7ff0000000000000,
  0x7ff8000000000000,
  0x7ffc000000000000,
  0x7ffe000000000000,
  0x7fff000000000000,
  0x7fff800000000000,
  0x7fffc00000000000,
  0x7fffe00000000000,
  0x7ffff00000000000,
  0x7ffff80000000000,
  0x7ffffc0000000000,
  0x7ffffe0000000000,
  0x7fffff0000000000,
  0x7fffff8000000000,
  0x7fffffc000000000,
  0x7fffffe000000000,
  0x7ffffff000000000,
  0x7ffffff800000000,
  0x7ffffffc00000000,
  0x7ffffffe00000000,
  0x7fffffff00000000,
  0x7fffffff80000000,
  0x7fffffffc0000000,
  0x7fffffffe0000000,
  0x7ffffffff0000000,
  0x7ffffffff8000000,
  0x7ffffffffc000000,
  0x7ffffffffe000000,
  0x7fffffffff000000,
  0x7fffffffff800000,
  0x7fffffffffc00000,
  0x7fffffffffe00000,
  0x7ffffffffff00000,
  0x7ffffffffff80000,
  0x7ffffffffffc0000,
  0x7ffffffffffe0000,
  0x7fffffffffff0000,
  0x7fffffffffff8000,
  0x7fffffffffffc000,
  0x7fffffffffffe000,
  0x7ffffffffffff000,
  0x7ffffffffffff800,
  0x7ffffffffffffc00,
  0x7ffffffffffffe00,
  0x7fffffffffffff00,
  0x7fffffffffffff80,
  0x7fffffffffffffc0,
  0x7fffffffffffffe0,
  0x7ffffffffffffff0,
  0x7ffffffffffffff8,
  0x7ffffffffffffffc,
  0x7ffffffffffffffe,
  0x7fffffffffffffff,
  0x7fffffffffffffff,
  0x4000000000000001,
  0x6000000000000001,
  0x7000000000000001,
  0x7800000000000001,
  0x7c00000000000001,
  0x7e00000000000001,
  0x7f00000000000001,
  0x7f80000000000001,
  0x7fc0000000000001,
  0x7fe0000000000001,
  0x7ff0000000000001,
  0x7ff8000000000001,
  0x7ffc000000000001,
  0x7ffe000000000001,
  0x7fff000000000001,
  0x7fff800000000001,
  0x7fffc00000000001,
  0x7fffe00000000001,
  0x7ffff00000000001,
  0x7ffff80000000001,
  0x7ffffc0000000001,
  0x7ffffe0000000001,
  0x7fffff0000000001,
  0x7fffff8000000001,
  0x7fffffc000000001,
  0x7fffffe000000001,
  0x7ffffff000000001,
  0x7ffffff800000001,
  0x7ffffffc00000001,
  0x7ffffffe00000001,
  0x7fffffff00000001,
  0x7fffffff80000001,
  0x7fffffffc0000001,
  0x7fffffffe0000001,
  0x7ffffffff0000001,
  0x7ffffffff8000001,
  0x7ffffffffc000001,
  0x7ffffffffe000001,
  0x7fffffffff000001,
  0x7fffffffff800001,
  0x7fffffffffc00001,
  0x7fffffffffe00001,
  0x7ffffffffff00001,
  0x7ffffffffff80001,
  0x7ffffffffffc0001,
  0x7ffffffffffe0001,
  0x7fffffffffff0001,
  0x7fffffffffff8001,
  0x7fffffffffffc001,
  0x7fffffffffffe001,
  0x7ffffffffffff001,
  0x7ffffffffffff801,
  0x7ffffffffffffc01,
  0x7ffffffffffffe01,
  0x7fffffffffffff01,
  0x7fffffffffffff81,
  0x7fffffffffffffc1,
  0x7fffffffffffffe1,
  0x7ffffffffffffff1,
  0x7ffffffffffffff9,
  0x7ffffffffffffffd,
  0x7fffffffffffffff,
  0x8000000000000000,
  0x8000000000000000,
  0x4000000000000001,
  0x6000000000000001,
  0x7000000000000001,
  0x7800000000000001,
  0x7c00000000000001,
  0x7e00000000000001,
  0x7f00000000000001,
  0x7f80000000000001,
  0x7fc0000000000001,
  0x7fe0000000000001,
  0x7ff0000000000001,
  0x7ff8000000000001,
  0x7ffc000000000001,
  0x7ffe000000000001,
  0x7fff000000000001,
  0x7fff800000000001,
  0x7fffc00000000001,
  0x7fffe00000000001,
  0x7ffff00000000001,
  0x7ffff80000000001,
  0x7ffffc0000000001,
  0x7ffffe0000000001,
  0x7fffff0000000001,
  0x7fffff8000000001,
  0x7fffffc000000001,
  0x7fffffe000000001,
  0x7ffffff000000001,
  0x7ffffff800000001,
  0x7ffffffc00000001,
  0x7ffffffe00000001,
  0x7fffffff00000001,
  0x7fffffff80000001,
  0x7fffffffc0000001,
  0x7fffffffe0000001,
  0x7ffffffff0000001,
  0x7ffffffff8000001,
  0x7ffffffffc000001,
  0x7ffffffffe000001,
  0x7fffffffff000001,
  0x7fffffffff800001,
  0x7fffffffffc00001,
  0x7fffffffffe00001,
  0x7ffffffffff00001,
  0x7ffffffffff80001,
  0x7ffffffffffc0001,
  0x7ffffffffffe0001,
  0x7fffffffffff0001,
  0x7fffffffffff8001,
  0x7fffffffffffc001,
  0x7fffffffffffe001,
  0x7ffffffffffff001,
  0x7ffffffffffff801,
  0x7ffffffffffffc01,
  0x7ffffffffffffe01,
  0x7fffffffffffff01,
  0x7fffffffffffff81,
  0x7fffffffffffffc1,
  0x7fffffffffffffe1,
  0x7ffffffffffffff1,
  0x7ffffffffffffff9,
  0x7ffffffffffffffd,
  0x7fffffffffffffff,
  0x8000000000000000,
  0x8000000000000000,
  0x5555555555555555,
  0x7fffffffffffffff,
  0x9555555555555554,
  0x9ffffffffffffffe,
  0xa555555555555553,
  0xa7fffffffffffffd,
  0xa955555555555552,
  0xa9fffffffffffffc,
  0xaa55555555555551,
  0xaa7ffffffffffffb,
  0xaa95555555555550,
  0xaa9ffffffffffffa,
  0xaaa555555555554f,
  0xaaa7fffffffffff9,
  0xaaa955555555554e,
  0xaaa9fffffffffff8,
  0xaaaa55555555554d,
  0xaaaa7ffffffffff7,
  0xaaaa95555555554c,
  0xaaaa9ffffffffff6,
  0xaaaaa5555555554b,
  0xaaaaa7fffffffff5,
  0xaaaaa9555555554a,
  0xaaaaa9fffffffff4,
  0xaaaaaa5555555549,
  0xaaaaaa7ffffffff3,
  0xaaaaaa9555555548,
  0xaaaaaa9ffffffff2,
  0xaaaaaaa555555547,
  0xaaaaaaa7fffffff1,
  0xaaaaaaa955555546,
  0xaaaaaaa9fffffff0,
  0xaaaaaaaa55555545,
  0xaaaaaaaa7fffffef,
  0xaaaaaaaa95555544,
  0xaaaaaaaa9fffffee,
  0xaaaaaaaaa5555543,
  0xaaaaaaaaa7ffffed,
  0xaaaaaaaaa9555542,
  0xaaaaaaaaa9ffffec,
  0xaaaaaaaaaa555541,
  0xaaaaaaaaaa7fffeb,
  0xaaaaaaaaaa955540,
  0xaaaaaaaaaa9fffea,
  0xaaaaaaaaaaa5553f,
  0xaaaaaaaaaaa7ffe9,
  0xaaaaaaaaaaa9553e,
  0xaaaaaaaaaaa9ffe8,
  0xaaaaaaaaaaaa553d,
  0xaaaaaaaaaaaa7fe7,
  0xaaaaaaaaaaaa953c,
  0xaaaaaaaaaaaa9fe6,
  0xaaaaaaaaaaaaa53b,
  0xaaaaaaaaaaaaa7e5,
  0xaaaaaaaaaaaaa93a,
  0xaaaaaaaaaaaaa9e4,
  0xaaaaaaaaaaaaaa39,
  0xaaaaaaaaaaaaaa63,
  0xaaaaaaaaaaaaaa78,
  0xaaaaaaaaaaaaaa82,
  0xaaaaaaaaaaaaaa87,
  0xaaaaaaaaaaaaaa89,
  0xaaaaaaaaaaaaaa8a,
  0xaaaaaaaaaaaaaa8a,
  0x6666666666666666,
  0x9999999999999999,
  0xb333333333333332,
  0xbffffffffffffffe,
  0xc666666666666664,
  0xc999999999999997,
  0xcb33333333333330,
  0xcbfffffffffffffc,
  0xcc66666666666662,
  0xcc99999999999995,
  0xccb333333333332e,
  0xccbffffffffffffa,
  0xccc6666666666660,
  0xccc9999999999993,
  0xcccb33333333332c,
  0xcccbfffffffffff8,
  0xcccc66666666665e,
  0xcccc999999999991,
  0xccccb3333333332a,
  0xccccbffffffffff6,
  0xccccc6666666665c,
  0xccccc9999999998f,
  0xcccccb3333333328,
  0xcccccbfffffffff4,
  0xcccccc666666665a,
  0xcccccc999999998d,
  0xccccccb333333326,
  0xccccccbffffffff2,
  0xccccccc666666658,
  0xccccccc99999998b,
  0xcccccccb33333324,
  0xcccccccbfffffff0,
  0xcccccccc66666656,
  0xcccccccc99999989,
  0xccccccccb3333322,
  0xccccccccbfffffee,
  0xccccccccc6666654,
  0xccccccccc9999987,
  0xcccccccccb333320,
  0xcccccccccbffffec,
  0xcccccccccc666652,
  0xcccccccccc999985,
  0xccccccccccb3331e,
  0xccccccccccbfffea,
  0xccccccccccc66650,
  0xccccccccccc99983,
  0xcccccccccccb331c,
  0xcccccccccccbffe8,
  0xcccccccccccc664e,
  0xcccccccccccc9981,
  0xccccccccccccb31a,
  0xccccccccccccbfe6,
  0xccccccccccccc64c,
  0xccccccccccccc97f,
  0xcccccccccccccb18,
  0xcccccccccccccbe4,
  0xcccccccccccccc4a,
  0xcccccccccccccc7d,
  0xcccccccccccccc96,
  0xcccccccccccccca2,
  0xcccccccccccccca8,
  0xccccccccccccccab,
  0xccccccccccccccac,
  0xccccccccccccccac,
  0x7fffffffc0000000,
  0xbfffffffa0000000,
  0xdfffffff90000000,
  0xefffffff88000000,
  0xf7ffffff84000000,
  0xfbffffff82000000,
  0xfdffffff81000000,
  0xfeffffff80800000,
  0xff7fffff80400000,
  0xffbfffff80200000,
  0xffdfffff80100000,
  0xffefffff80080000,
  0xfff7ffff80040000,
  0xfffbffff80020000,
  0xfffdffff80010000,
  0xfffeffff80008000,
  0xffff7fff80004000,
  0xffffbfff80002000,
  0xffffdfff80001000,
  0xffffefff80000800,
  0xfffff7ff80000400,
  0xfffffbff80000200,
  0xfffffdff80000100,
  0xfffffeff80000080,
  0xffffff7f80000040,
  0xffffffbf80000020,
  0xffffffdf80000010,
  0xffffffef80000008,
  0xfffffff780000004,
  0xfffffffb80000002,
  0xfffffffd80000001,
  0xfffffffe80000000,
  0xfffffffeffffffff,
  0xffffffff3ffffffe,
  0xffffffff5ffffffd,
  0xffffffff6ffffffc,
  0xffffffff77fffffb,
  0xffffffff7bfffffa,
  0xffffffff7dfffff9,
  0xffffffff7efffff8,
  0xffffffff7f7ffff7,
  0xffffffff7fbffff6,
  0xffffffff7fdffff5,
  0xffffffff7feffff4,
  0xffffffff7ff7fff3,
  0xffffffff7ffbfff2,
  0xffffffff7ffdfff1,
  0xffffffff7ffefff0,
  0xffffffff7fff7fef,
  0xffffffff7fffbfee,
  0xffffffff7fffdfed,
  0xffffffff7fffefec,
  0xffffffff7ffff7eb,
  0xffffffff7ffffbea,
  0xffffffff7ffffde9,
  0xffffffff7ffffee8,
  0xffffffff7fffff67,
  0xffffffff7fffffa6,
  0xffffffff7fffffc5,
  0xffffffff7fffffd4,
  0xffffffff7fffffdb,
  0xffffffff7fffffde,
  0xffffffff7fffffdf,
  0xffffffff7fffffdf,
  0x7fffffffc0000000,
  0xbfffffffa0000000,
  0xdfffffff90000000,
  0xefffffff88000000,
  0xf7ffffff84000000,
  0xfbffffff82000000,
  0xfdffffff81000000,
  0xfeffffff80800000,
  0xff7fffff80400000,
  0xffbfffff80200000,
  0xffdfffff80100000,
  0xffefffff80080000,
  0xfff7ffff80040000,
  0xfffbffff80020000,
  0xfffdffff80010000,
  0xfffeffff80008000,
  0xffff7fff80004000,
  0xffffbfff80002000,
  0xffffdfff80001000,
  0xffffefff80000800,
  0xfffff7ff80000400,
  0xfffffbff80000200,
  0xfffffdff80000100,
  0xfffffeff80000080,
  0xffffff7f80000040,
  0xffffffbf80000020,
  0xffffffdf80000010,
  0xffffffef80000008,
  0xfffffff780000004,
  0xfffffffb80000002,
  0xfffffffd80000001,
  0xfffffffe80000000,
  0xfffffffeffffffff,
  0xffffffff3ffffffe,
  0xffffffff5ffffffd,
  0xffffffff6ffffffc,
  0xffffffff77fffffb,
  0xffffffff7bfffffa,
  0xffffffff7dfffff9,
  0xffffffff7efffff8,
  0xffffffff7f7ffff7,
  0xffffffff7fbffff6,
  0xffffffff7fdffff5,
  0xffffffff7feffff4,
  0xffffffff7ff7fff3,
  0xffffffff7ffbfff2,
  0xffffffff7ffdfff1,
  0xffffffff7ffefff0,
  0xffffffff7fff7fef,
  0xffffffff7fffbfee,
  0xffffffff7fffdfed,
  0xffffffff7fffefec,
  0xffffffff7ffff7eb,
  0xffffffff7ffffbea,
  0xffffffff7ffffde9,
  0xffffffff7ffffee8,
  0xffffffff7fffff67,
  0xffffffff7fffffa6,
  0xffffffff7fffffc5,
  0xffffffff7fffffd4,
  0xffffffff7fffffdb,
  0xffffffff7fffffde,
  0xffffffff7fffffdf,
  0xffffffff7fffffdf,
  0x7fffffffc0000001,
  0xbfffffffa0000001,
  0xdfffffff90000001,
  0xefffffff88000001,
  0xf7ffffff84000001,
  0xfbffffff82000001,
  0xfdffffff81000001,
  0xfeffffff80800001,
  0xff7fffff80400001,
  0xffbfffff80200001,
  0xffdfffff80100001,
  0xffefffff80080001,
  0xfff7ffff80040001,
  0xfffbffff80020001,
  0xfffdffff80010001,
  0xfffeffff80008001,
  0xffff7fff80004001,
  0xffffbfff80002001,
  0xffffdfff80001001,
  0xffffefff80000801,
  0xfffff7ff80000401,
  0xfffffbff80000201,
  0xfffffdff80000101,
  0xfffffeff80000081,
  0xffffff7f80000041,
  0xffffffbf80000021,
  0xffffffdf80000011,
  0xffffffef80000009,
  0xfffffff780000005,
  0xfffffffb80000003,
  0xfffffffd80000002,
  0xfffffffe80000001,
  0xffffffff00000000,
  0xffffffff3fffffff,
  0xffffffff5ffffffe,
  0xffffffff6ffffffd,
  0xffffffff77fffffc,
  0xffffffff7bfffffb,
  0xffffffff7dfffffa,
  0xffffffff7efffff9,
  0xffffffff7f7ffff8,
  0xffffffff7fbffff7,
  0xffffffff7fdffff6,
  0xffffffff7feffff5,
  0xffffffff7ff7fff4,
  0xffffffff7ffbfff3,
  0xffffffff7ffdfff2,
  0xffffffff7ffefff1,
  0xffffffff7fff7ff0,
  0xffffffff7fffbfef,
  0xffffffff7fffdfee,
  0xffffffff7fffefed,
  0xffffffff7ffff7ec,
  0xffffffff7ffffbeb,
  0xffffffff7ffffdea,
  0xffffffff7ffffee9,
  0xffffffff7fffff68,
  0xffffffff7fffffa7,
  0xffffffff7fffffc6,
  0xffffffff7fffffd5,
  0xffffffff7fffffdc,
  0xffffffff7fffffdf,
  0xffffffff7fffffe0,
  0xffffffff7fffffe0,
  0x7fffffffc0000001,
  0xbfffffffa0000001,
  0xdfffffff90000001,
  0xefffffff88000001,
  0xf7ffffff84000001,
  0xfbffffff82000001,
  0xfdffffff81000001,
  0xfeffffff80800001,
  0xff7fffff80400001,
  0xffbfffff80200001,
  0xffdfffff80100001,
  0xffefffff80080001,
  0xfff7ffff80040001,
  0xfffbffff80020001,
  0xfffdffff80010001,
  0xfffeffff80008001,
  0xffff7fff80004001,
  0xffffbfff80002001,
  0xffffdfff80001001,
  0xffffefff80000801,
  0xfffff7ff80000401,
  0xfffffbff80000201,
  0xfffffdff80000101,
  0xfffffeff80000081,
  0xffffff7f80000041,
  0xffffffbf80000021,
  0xffffffdf80000011,
  0xffffffef80000009,
  0xfffffff780000005,
  0xfffffffb80000003,
  0xfffffffd80000002,
  0xfffffffe80000001,
  0xffffffff00000000,
  0xffffffff3fffffff,
  0xffffffff5ffffffe,
  0xffffffff6ffffffd,
  0xffffffff77fffffc,
  0xffffffff7bfffffb,
  0xffffffff7dfffffa,
  0xffffffff7efffff9,
  0xffffffff7f7ffff8,
  0xffffffff7fbffff7,
  0xffffffff7fdffff6,
  0xffffffff7feffff5,
  0xffffffff7ff7fff4,
  0xffffffff7ffbfff3,
  0xffffffff7ffdfff2,
  0xffffffff7ffefff1,
  0xffffffff7fff7ff0,
  0xffffffff7fffbfef,
  0xffffffff7fffdfee,
  0xffffffff7fffefed,
  0xffffffff7ffff7ec,
  0xffffffff7ffffbeb,
  0xffffffff7ffffdea,
  0xffffffff7ffffee9,
  0xffffffff7fffff68,
  0xffffffff7fffffa7,
  0xffffffff7fffffc6,
  0xffffffff7fffffd5,
  0xffffffff7fffffdc,
  0xffffffff7fffffdf,
  0xffffffff7fffffe0,
  0xffffffff7fffffe0,
  0x7fffffffffffc000,
  0xbfffffffffffa000,
  0xdfffffffffff9000,
  0xefffffffffff8800,
  0xf7ffffffffff8400,
  0xfbffffffffff8200,
  0xfdffffffffff8100,
  0xfeffffffffff8080,
  0xff7fffffffff8040,
  0xffbfffffffff8020,
  0xffdfffffffff8010,
  0xffefffffffff8008,
  0xfff7ffffffff8004,
  0xfffbffffffff8002,
  0xfffdffffffff8001,
  0xfffeffffffff8000,
  0xffff7fffffff7fff,
  0xffffbfffffff7ffe,
  0xffffdfffffff7ffd,
  0xffffefffffff7ffc,
  0xfffff7ffffff7ffb,
  0xfffffbffffff7ffa,
  0xfffffdffffff7ff9,
  0xfffffeffffff7ff8,
  0xffffff7fffff7ff7,
  0xffffffbfffff7ff6,
  0xffffffdfffff7ff5,
  0xffffffefffff7ff4,
  0xfffffff7ffff7ff3,
  0xfffffffbffff7ff2,
  0xfffffffdffff7ff1,
  0xfffffffeffff7ff0,
  0xffffffff7fff7fef,
  0xffffffffbfff7fee,
  0xffffffffdfff7fed,
  0xffffffffefff7fec,
  0xfffffffff7ff7feb,
  0xfffffffffbff7fea,
  0xfffffffffdff7fe9,
  0xfffffffffeff7fe8,
  0xffffffffff7f7fe7,
  0xffffffffffbf7fe6,
  0xffffffffffdf7fe5,
  0xffffffffffef7fe4,
  0xfffffffffff77fe3,
  0xfffffffffffb7fe2,
  0xfffffffffffd7fe1,
  0xfffffffffffe7fe0,
  0xfffffffffffeffdf,
  0xffffffffffff3fde,
  0xffffffffffff5fdd,
  0xffffffffffff6fdc,
  0xffffffffffff77db,
  0xffffffffffff7bda,
  0xffffffffffff7dd9,
  0xffffffffffff7ed8,
  0xffffffffffff7f57,
  0xffffffffffff7f96,
  0xffffffffffff7fb5,
  0xffffffffffff7fc4,
  0xffffffffffff7fcb,
  0xffffffffffff7fce,
  0xffffffffffff7fcf,
  0xffffffffffff7fcf,
  0x7fffffffffffc000,
  0xbfffffffffffa000,
  0xdfffffffffff9000,
  0xefffffffffff8800,
  0xf7ffffffffff8400,
  0xfbffffffffff8200,
  0xfdffffffffff8100,
  0xfeffffffffff8080,
  0xff7fffffffff8040,
  0xffbfffffffff8020,
  0xffdfffffffff8010,
  0xffefffffffff8008,
  0xfff7ffffffff8004,
  0xfffbffffffff8002,
  0xfffdffffffff8001,
  0xfffeffffffff8000,
  0xffff7fffffff7fff,
  0xffffbfffffff7ffe,
  0xffffdfffffff7ffd,
  0xffffefffffff7ffc,
  0xfffff7ffffff7ffb,
  0xfffffbffffff7ffa,
  0xfffffdffffff7ff9,
  0xfffffeffffff7ff8,
  0xffffff7fffff7ff7,
  0xffffffbfffff7ff6,
  0xffffffdfffff7ff5,
  0xffffffefffff7ff4,
  0xfffffff7ffff7ff3,
  0xfffffffbffff7ff2,
  0xfffffffdffff7ff1,
  0xfffffffeffff7ff0,
  0xffffffff7fff7fef,
  0xffffffffbfff7fee,
  0xffffffffdfff7fed,
  0xffffffffefff7fec,
  0xfffffffff7ff7feb,
  0xfffffffffbff7fea,
  0xfffffffffdff7fe9,
  0xfffffffffeff7fe8,
  0xffffffffff7f7fe7,
  0xffffffffffbf7fe6,
  0xffffffffffdf7fe5,
  0xffffffffffef7fe4,
  0xfffffffffff77fe3,
  0xfffffffffffb7fe2,
  0xfffffffffffd7fe1,
  0xfffffffffffe7fe0,
  0xfffffffffffeffdf,
  0xffffffffffff3fde,
  0xffffffffffff5fdd,
  0xffffffffffff6fdc,
  0xffffffffffff77db,
  0xffffffffffff7bda,
  0xffffffffffff7dd9,
  0xffffffffffff7ed8,
  0xffffffffffff7f57,
  0xffffffffffff7f96,
  0xffffffffffff7fb5,
  0xffffffffffff7fc4,
  0xffffffffffff7fcb,
  0xffffffffffff7fce,
  0xffffffffffff7fcf,
  0xffffffffffff7fcf,
  0x7fffffffffffc001,
  0xbfffffffffffa001,
  0xdfffffffffff9001,
  0xefffffffffff8801,
  0xf7ffffffffff8401,
  0xfbffffffffff8201,
  0xfdffffffffff8101,
  0xfeffffffffff8081,
  0xff7fffffffff8041,
  0xffbfffffffff8021,
  0xffdfffffffff8011,
  0xffefffffffff8009,
  0xfff7ffffffff8005,
  0xfffbffffffff8003,
  0xfffdffffffff8002,
  0xfffeffffffff8001,
  0xffff7fffffff8000,
  0xffffbfffffff7fff,
  0xffffdfffffff7ffe,
  0xffffefffffff7ffd,
  0xfffff7ffffff7ffc,
  0xfffffbffffff7ffb,
  0xfffffdffffff7ffa,
  0xfffffeffffff7ff9,
  0xffffff7fffff7ff8,
  0xffffffbfffff7ff7,
  0xffffffdfffff7ff6,
  0xffffffefffff7ff5,
  0xfffffff7ffff7ff4,
  0xfffffffbffff7ff3,
  0xfffffffdffff7ff2,
  0xfffffffeffff7ff1,
  0xffffffff7fff7ff0,
  0xffffffffbfff7fef,
  0xffffffffdfff7fee,
  0xffffffffefff7fed,
  0xfffffffff7ff7fec,
  0xfffffffffbff7feb,
  0xfffffffffdff7fea,
  0xfffffffffeff7fe9,
  0xffffffffff7f7fe8,
  0xffffffffffbf7fe7,
  0xffffffffffdf7fe6,
  0xffffffffffef7fe5,
  0xfffffffffff77fe4,
  0xfffffffffffb7fe3,
  0xfffffffffffd7fe2,
  0xfffffffffffe7fe1,
  0xfffffffffffeffe0,
  0xffffffffffff3fdf,
  0xffffffffffff5fde,
  0xffffffffffff6fdd,
  0xffffffffffff77dc,
  0xffffffffffff7bdb,
  0xffffffffffff7dda,
  0xffffffffffff7ed9,
  0xffffffffffff7f58,
  0xffffffffffff7f97,
  0xffffffffffff7fb6,
  0xffffffffffff7fc5,
  0xffffffffffff7fcc,
  0xffffffffffff7fcf,
  0xffffffffffff7fd0,
  0xffffffffffff7fd0,
  0x7fffffffffffc001,
  0xbfffffffffffa001,
  0xdfffffffffff9001,
  0xefffffffffff8801,
  0xf7ffffffffff8401,
  0xfbffffffffff8201,
  0xfdffffffffff8101,
  0xfeffffffffff8081,
  0xff7fffffffff8041,
  0xffbfffffffff8021,
  0xffdfffffffff8011,
  0xffefffffffff8009,
  0xfff7ffffffff8005,
  0xfffbffffffff8003,
  0xfffdffffffff8002,
  0xfffeffffffff8001,
  0xffff7fffffff8000,
  0xffffbfffffff7fff,
  0xffffdfffffff7ffe,
  0xffffefffffff7ffd,
  0xfffff7ffffff7ffc,
  0xfffffbffffff7ffb,
  0xfffffdffffff7ffa,
  0xfffffeffffff7ff9,
  0xffffff7fffff7ff8,
  0xffffffbfffff7ff7,
  0xffffffdfffff7ff6,
  0xffffffefffff7ff5,
  0xfffffff7ffff7ff4,
  0xfffffffbffff7ff3,
  0xfffffffdffff7ff2,
  0xfffffffeffff7ff1,
  0xffffffff7fff7ff0,
  0xffffffffbfff7fef,
  0xffffffffdfff7fee,
  0xffffffffefff7fed,
  0xfffffffff7ff7fec,
  0xfffffffffbff7feb,
  0xfffffffffdff7fea,
  0xfffffffffeff7fe9,
  0xffffffffff7f7fe8,
  0xffffffffffbf7fe7,
  0xffffffffffdf7fe6,
  0xffffffffffef7fe5,
  0xfffffffffff77fe4,
  0xfffffffffffb7fe3,
  0xfffffffffffd7fe2,
  0xfffffffffffe7fe1,
  0xfffffffffffeffe0,
  0xffffffffffff3fdf,
  0xffffffffffff5fde,
  0xffffffffffff6fdd,
  0xffffffffffff77dc,
  0xffffffffffff7bdb,
  0xffffffffffff7dda,
  0xffffffffffff7ed9,
  0xffffffffffff7f58,
  0xffffffffffff7f97,
  0xffffffffffff7fb6,
  0xffffffffffff7fc5,
  0xffffffffffff7fcc,
  0xffffffffffff7fcf,
  0xffffffffffff7fd0,
  0xffffffffffff7fd0,
  0x7fffffffffffffc0,
  0xbfffffffffffffa0,
  0xdfffffffffffff90,
  0xefffffffffffff88,
  0xf7ffffffffffff84,
  0xfbffffffffffff82,
  0xfdffffffffffff81,
  0xfeffffffffffff80,
  0xff7fffffffffff7f,
  0xffbfffffffffff7e,
  0xffdfffffffffff7d,
  0xffefffffffffff7c,
  0xfff7ffffffffff7b,
  0xfffbffffffffff7a,
  0xfffdffffffffff79,
  0xfffeffffffffff78,
  0xffff7fffffffff77,
  0xffffbfffffffff76,
  0xffffdfffffffff75,
  0xffffefffffffff74,
  0xfffff7ffffffff73,
  0xfffffbffffffff72,
  0xfffffdffffffff71,
  0xfffffeffffffff70,
  0xffffff7fffffff6f,
  0xffffffbfffffff6e,
  0xffffffdfffffff6d,
  0xffffffefffffff6c,
  0xfffffff7ffffff6b,
  0xfffffffbffffff6a,
  0xfffffffdffffff69,
  0xfffffffeffffff68,
  0xffffffff7fffff67,
  0xffffffffbfffff66,
  0xffffffffdfffff65,
  0xffffffffefffff64,
  0xfffffffff7ffff63,
  0xfffffffffbffff62,
  0xfffffffffdffff61,
  0xfffffffffeffff60,
  0xffffffffff7fff5f,
  0xffffffffffbfff5e,
  0xffffffffffdfff5d,
  0xffffffffffefff5c,
  0xfffffffffff7ff5b,
  0xfffffffffffbff5a,
  0xfffffffffffdff59,
  0xfffffffffffeff58,
  0xffffffffffff7f57,
  0xffffffffffffbf56,
  0xffffffffffffdf55,
  0xffffffffffffef54,
  0xfffffffffffff753,
  0xfffffffffffffb52,
  0xfffffffffffffd51,
  0xfffffffffffffe50,
  0xfffffffffffffecf,
  0xffffffffffffff0e,
  0xffffffffffffff2d,
  0xffffffffffffff3c,
  0xffffffffffffff43,
  0xffffffffffffff46,
  0xffffffffffffff47,
  0xffffffffffffff47,
  0x7fffffffffffffc0,
  0xbfffffffffffffa0,
  0xdfffffffffffff90,
  0xefffffffffffff88,
  0xf7ffffffffffff84,
  0xfbffffffffffff82,
  0xfdffffffffffff81,
  0xfeffffffffffff80,
  0xff7fffffffffff7f,
  0xffbfffffffffff7e,
  0xffdfffffffffff7d,
  0xffefffffffffff7c,
  0xfff7ffffffffff7b,
  0xfffbffffffffff7a,
  0xfffdffffffffff79,
  0xfffeffffffffff78,
  0xffff7fffffffff77,
  0xffffbfffffffff76,
  0xffffdfffffffff75,
  0xffffefffffffff74,
  0xfffff7ffffffff73,
  0xfffffbffffffff72,
  0xfffffdffffffff71,
  0xfffffeffffffff70,
  0xffffff7fffffff6f,
  0xffffffbfffffff6e,
  0xffffffdfffffff6d,
  0xffffffefffffff6c,
  0xfffffff7ffffff6b,
  0xfffffffbffffff6a,
  0xfffffffdffffff69,
  0xfffffffeffffff68,
  0xffffffff7fffff67,
  0xffffffffbfffff66,
  0xffffffffdfffff65,
  0xffffffffefffff64,
  0xfffffffff7ffff63,
  0xfffffffffbffff62,
  0xfffffffffdffff61,
  0xfffffffffeffff60,
  0xffffffffff7fff5f,
  0xffffffffffbfff5e,
  0xffffffffffdfff5d,
  0xffffffffffefff5c,
  0xfffffffffff7ff5b,
  0xfffffffffffbff5a,
  0xfffffffffffdff59,
  0xfffffffffffeff58,
  0xffffffffffff7f57,
  0xffffffffffffbf56,
  0xffffffffffffdf55,
  0xffffffffffffef54,
  0xfffffffffffff753,
  0xfffffffffffffb52,
  0xfffffffffffffd51,
  0xfffffffffffffe50,
  0xfffffffffffffecf,
  0xffffffffffffff0e,
  0xffffffffffffff2d,
  0xffffffffffffff3c,
  0xffffffffffffff43,
  0xffffffffffffff46,
  0xffffffffffffff47,
  0xffffffffffffff47,
  0x7fffffffffffffc1,
  0xbfffffffffffffa1,
  0xdfffffffffffff91,
  0xefffffffffffff89,
  0xf7ffffffffffff85,
  0xfbffffffffffff83,
  0xfdffffffffffff82,
  0xfeffffffffffff81,
  0xff7fffffffffff80,
  0xffbfffffffffff7f,
  0xffdfffffffffff7e,
  0xffefffffffffff7d,
  0xfff7ffffffffff7c,
  0xfffbffffffffff7b,
  0xfffdffffffffff7a,
  0xfffeffffffffff79,
  0xffff7fffffffff78,
  0xffffbfffffffff77,
  0xffffdfffffffff76,
  0xffffefffffffff75,
  0xfffff7ffffffff74,
  0xfffffbffffffff73,
  0xfffffdffffffff72,
  0xfffffeffffffff71,
  0xffffff7fffffff70,
  0xffffffbfffffff6f,
  0xffffffdfffffff6e,
  0xffffffefffffff6d,
  0xfffffff7ffffff6c,
  0xfffffffbffffff6b,
  0xfffffffdffffff6a,
  0xfffffffeffffff69,
  0xffffffff7fffff68,
  0xffffffffbfffff67,
  0xffffffffdfffff66,
  0xffffffffefffff65,
  0xfffffffff7ffff64,
  0xfffffffffbffff63,
  0xfffffffffdffff62,
  0xfffffffffeffff61,
  0xffffffffff7fff60,
  0xffffffffffbfff5f,
  0xffffffffffdfff5e,
  0xffffffffffefff5d,
  0xfffffffffff7ff5c,
  0xfffffffffffbff5b,
  0xfffffffffffdff5a,
  0xfffffffffffeff59,
  0xffffffffffff7f58,
  0xffffffffffffbf57,
  0xffffffffffffdf56,
  0xffffffffffffef55,
  0xfffffffffffff754,
  0xfffffffffffffb53,
  0xfffffffffffffd52,
  0xfffffffffffffe51,
  0xfffffffffffffed0,
  0xffffffffffffff0f,
  0xffffffffffffff2e,
  0xffffffffffffff3d,
  0xffffffffffffff44,
  0xffffffffffffff47,
  0xffffffffffffff48,
  0xffffffffffffff48,
  0x7fffffffffffffc1,
  0xbfffffffffffffa1,
  0xdfffffffffffff91,
  0xefffffffffffff89,
  0xf7ffffffffffff85,
  0xfbffffffffffff83,
  0xfdffffffffffff82,
  0xfeffffffffffff81,
  0xff7fffffffffff80,
  0xffbfffffffffff7f,
  0xffdfffffffffff7e,
  0xffefffffffffff7d,
  0xfff7ffffffffff7c,
  0xfffbffffffffff7b,
  0xfffdffffffffff7a,
  0xfffeffffffffff79,
  0xffff7fffffffff78,
  0xffffbfffffffff77,
  0xffffdfffffffff76,
  0xffffefffffffff75,
  0xfffff7ffffffff74,
  0xfffffbffffffff73,
  0xfffffdffffffff72,
  0xfffffeffffffff71,
  0xffffff7fffffff70,
  0xffffffbfffffff6f,
  0xffffffdfffffff6e,
  0xffffffefffffff6d,
  0xfffffff7ffffff6c,
  0xfffffffbffffff6b,
  0xfffffffdffffff6a,
  0xfffffffeffffff69,
  0xffffffff7fffff68,
  0xffffffffbfffff67,
  0xffffffffdfffff66,
  0xffffffffefffff65,
  0xfffffffff7ffff64,
  0xfffffffffbffff63,
  0xfffffffffdffff62,
  0xfffffffffeffff61,
  0xffffffffff7fff60,
  0xffffffffffbfff5f,
  0xffffffffffdfff5e,
  0xffffffffffefff5d,
  0xfffffffffff7ff5c,
  0xfffffffffffbff5b,
  0xfffffffffffdff5a,
  0xfffffffffffeff59,
  0xffffffffffff7f58,
  0xffffffffffffbf57,
  0xffffffffffffdf56,
  0xffffffffffffef55,
  0xfffffffffffff754,
  0xfffffffffffffb53,
  0xfffffffffffffd52,
  0xfffffffffffffe51,
  0xfffffffffffffed0,
  0xffffffffffffff0f,
  0xffffffffffffff2e,
  0xffffffffffffff3d,
  0xffffffffffffff44,
  0xffffffffffffff47,
  0xffffffffffffff48,
  0xffffffffffffff48,
  0x7fffffffffffffe0,
  0xbfffffffffffffd0,
  0xdfffffffffffffc8,
  0xefffffffffffffc4,
  0xf7ffffffffffffc2,
  0xfbffffffffffffc1,
  0xfdffffffffffffc0,
  0xfeffffffffffffbf,
  0xff7fffffffffffbe,
  0xffbfffffffffffbd,
  0xffdfffffffffffbc,
  0xffefffffffffffbb,
  0xfff7ffffffffffba,
  0xfffbffffffffffb9,
  0xfffdffffffffffb8,
  0xfffeffffffffffb7,
  0xffff7fffffffffb6,
  0xffffbfffffffffb5,
  0xffffdfffffffffb4,
  0xffffefffffffffb3,
  0xfffff7ffffffffb2,
  0xfffffbffffffffb1,
  0xfffffdffffffffb0,
  0xfffffeffffffffaf,
  0xffffff7fffffffae,
  0xffffffbfffffffad,
  0xffffffdfffffffac,
  0xffffffefffffffab,
  0xfffffff7ffffffaa,
  0xfffffffbffffffa9,
  0xfffffffdffffffa8,
  0xfffffffeffffffa7,
  0xffffffff7fffffa6,
  0xffffffffbfffffa5,
  0xffffffffdfffffa4,
  0xffffffffefffffa3,
  0xfffffffff7ffffa2,
  0xfffffffffbffffa1,
  0xfffffffffdffffa0,
  0xfffffffffeffff9f,
  0xffffffffff7fff9e,
  0xffffffffffbfff9d,
  0xffffffffffdfff9c,
  0xffffffffffefff9b,
  0xfffffffffff7ff9a,
  0xfffffffffffbff99,
  0xfffffffffffdff98,
  0xfffffffffffeff97,
  0xffffffffffff7f96,
  0xffffffffffffbf95,
  0xffffffffffffdf94,
  0xffffffffffffef93,
  0xfffffffffffff792,
  0xfffffffffffffb91,
  0xfffffffffffffd90,
  0xfffffffffffffe8f,
  0xffffffffffffff0e,
  0xffffffffffffff4d,
  0xffffffffffffff6c,
  0xffffffffffffff7b,
  0xffffffffffffff82,
  0xffffffffffffff85,
  0xffffffffffffff86,
  0xffffffffffffff86,
  0x7ffffffffffffffe,
  0xbffffffffffffffd,
  0xdffffffffffffffc,
  0xeffffffffffffffb,
  0xf7fffffffffffffa,
  0xfbfffffffffffff9,
  0xfdfffffffffffff8,
  0xfefffffffffffff7,
  0xff7ffffffffffff6,
  0xffbffffffffffff5,
  0xffdffffffffffff4,
  0xffeffffffffffff3,
  0xfff7fffffffffff2,
  0xfffbfffffffffff1,
  0xfffdfffffffffff0,
  0xfffeffffffffffef,
  0xffff7fffffffffee,
  0xffffbfffffffffed,
  0xffffdfffffffffec,
  0xffffefffffffffeb,
  0xfffff7ffffffffea,
  0xfffffbffffffffe9,
  0xfffffdffffffffe8,
  0xfffffeffffffffe7,
  0xffffff7fffffffe6,
  0xffffffbfffffffe5,
  0xffffffdfffffffe4,
  0xffffffefffffffe3,
  0xfffffff7ffffffe2,
  0xfffffffbffffffe1,
  0xfffffffdffffffe0,
  0xfffffffeffffffdf,
  0xffffffff7fffffde,
  0xffffffffbfffffdd,
  0xffffffffdfffffdc,
  0xffffffffefffffdb,
  0xfffffffff7ffffda,
  0xfffffffffbffffd9,
  0xfffffffffdffffd8,
  0xfffffffffeffffd7,
  0xffffffffff7fffd6,
  0xffffffffffbfffd5,
  0xffffffffffdfffd4,
  0xffffffffffefffd3,
  0xfffffffffff7ffd2,
  0xfffffffffffbffd1,
  0xfffffffffffdffd0,
  0xfffffffffffeffcf,
  0xffffffffffff7fce,
  0xffffffffffffbfcd,
  0xffffffffffffdfcc,
  0xffffffffffffefcb,
  0xfffffffffffff7ca,
  0xfffffffffffffbc9,
  0xfffffffffffffdc8,
  0xfffffffffffffec7,
  0xffffffffffffff46,
  0xffffffffffffff85,
  0xffffffffffffffa4,
  0xffffffffffffffb3,
  0xffffffffffffffba,
  0xffffffffffffffbd,
  0xffffffffffffffbe,
  0xffffffffffffffbe,
  0x7fffffffffffffff,
  0xbffffffffffffffe,
  0xdffffffffffffffd,
  0xeffffffffffffffc,
  0xf7fffffffffffffb,
  0xfbfffffffffffffa,
  0xfdfffffffffffff9,
  0xfefffffffffffff8,
  0xff7ffffffffffff7,
  0xffbffffffffffff6,
  0xffdffffffffffff5,
  0xffeffffffffffff4,
  0xfff7fffffffffff3,
  0xfffbfffffffffff2,
  0xfffdfffffffffff1,
  0xfffefffffffffff0,
  0xffff7fffffffffef,
  0xffffbfffffffffee,
  0xffffdfffffffffed,
  0xffffefffffffffec,
  0xfffff7ffffffffeb,
  0xfffffbffffffffea,
  0xfffffdffffffffe9,
  0xfffffeffffffffe8,
  0xffffff7fffffffe7,
  0xffffffbfffffffe6,
  0xffffffdfffffffe5,
  0xffffffefffffffe4,
  0xfffffff7ffffffe3,
  0xfffffffbffffffe2,
  0xfffffffdffffffe1,
  0xfffffffeffffffe0,
  0xffffffff7fffffdf,
  0xffffffffbfffffde,
  0xffffffffdfffffdd,
  0xffffffffefffffdc,
  0xfffffffff7ffffdb,
  0xfffffffffbffffda,
  0xfffffffffdffffd9,
  0xfffffffffeffffd8,
  0xffffffffff7fffd7,
  0xffffffffffbfffd6,
  0xffffffffffdfffd5,
  0xffffffffffefffd4,
  0xfffffffffff7ffd3,
  0xfffffffffffbffd2,
  0xfffffffffffdffd1,
  0xfffffffffffeffd0,
  0xffffffffffff7fcf,
  0xffffffffffffbfce,
  0xffffffffffffdfcd,
  0xffffffffffffefcc,
  0xfffffffffffff7cb,
  0xfffffffffffffbca,
  0xfffffffffffffdc9,
  0xfffffffffffffec8,
  0xffffffffffffff47,
  0xffffffffffffff86,
  0xffffffffffffffa5,
  0xffffffffffffffb4,
  0xffffffffffffffbb,
  0xffffffffffffffbe,
  0xffffffffffffffbf,
  0xffffffffffffffbf,
};
const unsigned kExpectedCount_NEON_usra_D_2OPIMM = 2560;

#endif  // VIXL_SIM_USRA_D_2OPIMM_TRACE_AARCH64_H_
