/*
 * DVD Player plugin for VDR
 *
 * Copyright (C) 2001.2002 Andreas Schultz <aschultz@warp10.net>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <vdr/config.h>
#include "i18n.h"

const char *ISO639code[] = {
  // Language ISO 639 codes for DVD
    "en",
    "de",
    "sl",
    "it",
    "nl",
    "pt",
    "fr",
    "no",
    "fi",
    "pl",
    "es",
    "el",
    "se",
    "ro",
    "hu",
    "ca",
    "ru",
    "hr",
    "et",
    "da",
    "cs",
#if VDRVERSNUM >= 10502
    "tr",
#endif
};

const char *DvdLanguageCode[][2] = {
  // Language ISO 639 codes for DVD
    {"en", "English"},
    {"de", "Deutsch"},
    {"sl", "Slovenski"},
    {"it", "Italiano"},
    {"nl", "Nederlands"},
    {"pt", "Portugus"},
    {"fr", "Franais"},
    {"no", "Norsk"},
    {"fi", "suomi"},
    {"pl", "Polski"},
    {"es", "Espaol"},
    {"el", ""},
    {"se", "Svenska"},
    {"ro", "Romaneste"},
    {"hu", "Magyar"},
    {"ca", "Catal"},
    {"ru", "Русский"},
    {"hr", "Hrvatski"},
    {"et", "Eesti"},
    {"da", "Dansk"},
    {"cs", "Czech"},
    {"tr", "Trke"}
};

#if VDRVERSNUM < 10507
const tI18nPhrase DvdPhrases[] = {
    {
    "Plugin.DVD$DVD",                                       // English
        "DVD",                                              // Deutsch
        "DVD",                                              // Slovenski
        "DVD",                                              // Italiano
        "DVD",                                              // Nederlands
        "DVD",                                              // Portugus
        "DVD",                                              // Franais
        "DVD",                                              // Norsk
        "DVD",                                              // suomi
        "DVD",                                              // Polski
        "DVD",                                              // Espaol
        "DVD",                                              //  (Greek)
        "DVD",                                              // Svenska
        "DVD",                                              // Romaneste
        "DVD",                                              // Magyar
        "DVD",                                              // Catal
        " DVD",                                //  (Russian)
        "DVD",                                              // Hrvatski (Croatian)
        "DVD",                                              // Eesti
        "DVD",                                              // Dansk
        "DVD",                                              // Czech
#if VDRVERSNUM >= 10502
        "DVD",                                              // Trke
#endif
    },
    {
    "Plugin.DVD$turn VDR into an (almost) full featured DVD player",    // English
        "verwandelt VDR in einen (fast) vollstndigen DVD Spieler",     // Deutsch
        "spremeni VDR v (skoraj) popolen DVD predvajalnik",             // Slovenski
        "",                                                             // Italiano
        "Verander VDR in een (bijna) complete DVD-speler",              // Nederlands
        "",                                                             // Portugus
        "",                                                             // Franais
        "",                                                             // Norsk
        "DVD-soitin",                                                   // suomi
        "Zmienia VDR w odtwarzacz DVD",                                 // Polski
        "Convierte VDR en un reproductor DVD (casi) completo",          // Espaol
        "Metatropi tou VDR se ena (sxedon) olokliromeno DVD",           //  (Greek)
        "",                                                             // Svenska
        "",                                                             // Romaneste
        "",                                                             // Magyar
        "",                                                             // Catal
        " DVD",                                            //  (Russian)
        "",                                                             // Hrvatski (Croatian)
        "DVD-mngija",                                                  // Eesti
        "forvandler VDR til en (nsten) normal DVD afspiller",          // Dansk
        "Pemn VDR v plnohodnotn DVD pehrva",                     // Czech
#if VDRVERSNUM >= 10502
        "VDR'i (nerdeyse) tam DVD oynatcsna evirir"                 // Trke
#endif
    },
    {
    "Setup.DVD$Preferred menu language",                    // English
        "Bevorzugte Spache fr Mens",                      // Deutsch
        "Prednostni jezik za menije",                       // Slovenski
        "menu - linguaggio preferito",                      // Italiano
        "Taalkeuze voor menu",                              // Nederlands
        "",                                                 // Portugus
        "Langage prfr pour les menus",                   // Franais
        "",                                                 // Norsk
        "Haluttu valikkokieli",                             // suomi
        "Preferowany jzyk menu",                           // Polski
        "Idioma preferido para los mens",                  // Espaol
        "Protinomeni glossa gia menou",                     //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  ",                         //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Eelistatud menkeel",                             // Eesti
        "Foretrukket sprog for menuer",                     // Dansk
        "Preferovan jazyk menu",                           // Czech
#if VDRVERSNUM >= 10502
        "Menlerin dil tercihi"                             // Trke
#endif
    },
    {
    "Setup.DVD$Preferred audio language",                   // English
        "Bevorzugte Sprache fr Dialog",                    // Deutsch
        "Prednostni jezik za zvok",                         // Slovenski
        "audio - linguaggio preferito",                     // Italiano
        "Taalkeuze voor geluid",                            // Nederlands
        "",                                                 // Portugus
        "Langage prfr pour le son",                      // Franais
        "",                                                 // Norsk
        "Haluttu niraita",                                // suomi
        "Preferowany jzyk dwiku",                        // Polski
        "Idioma preferido para el sonido",                  // Espaol
        "Protinomeni glossa gia ton dialogo",               //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  ",                        //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Eelistatud audiokeel",                             // Eesti
        "Foretrukket sprog for lyd",                        // Dansk
        "Preferovan jazyk zvuku",                          // Czech
#if VDRVERSNUM >= 10502
        "Diyaloglarn dil tercihi"                          // Trke
#endif
    },
    {
    "Setup.DVD$Preferred subtitle language",                // English
        "Bevorzugte Spache fr Untertitel",                 // Deutsch
        "Prednostni jezik za podnapise",                    // Slovenski
        "sottotitoli - linguaggio preferito",               // Italiano
        "Taalkeuze voor ondertitels",                       // Nederlands
        "",                                                 // Portugus
        "Langage prfr pour les sous-titres",             // Franais
        "",                                                 // Norsk
        "Haluttu tekstityskieli",                           // suomi
        "Preferowany jzyk napisw",                        // Polski
        "Idioma preferido para los subttulos",             // Espaol
        "Protinomeni glossa ipotitlon",                     //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  ",                    //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Eelistatud subtiitritekeel",                       // Eesti
        "Foretrukket sprog for undertekster",               // Dansk
        "Preferovan jazyk titulk",                        // Czech
#if VDRVERSNUM >= 10502
        "Altyazlarn dil tercihi"                          // Trke
#endif
    },
    {
    "Setup.DVD$Player region code",                         // English
        "Regionalkode fr DVD Spieler",                     // Deutsch
        "Regionalna koda za predvajalnik",                  // Slovenski
        "region code del DVD player",                       // Italiano
        "Regiocode van Speler",                             // Nederlands
        "",                                                 // Portugus
        "Code rgion du lecteur",                           // Franais
        "",                                                 // Norsk
        "Soittimen aluekoodi",                              // suomi
        "Kod regionu odtwarzacza",                          // Polski
        "Cdigo de zona del lector",                        // Espaol
        "Kodikos Zonis DVD",                                //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        " ",                                         //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Mngija regioonikood",                             // Eesti
        "Afspillerens regions kode",                        // Dansk
        "Regionln kd pehrvae",                        // Czech
#if VDRVERSNUM >= 10502
        "DVD oynatcnn blge kodu"                        // Trke
#endif
    },
    {
    "Setup.DVD$Display subtitles",                          // English
        "Untertitel anzeigen",                              // Deutsch
        "Prikai podnapise",                                // Slovenski
        "Visualizza sottotitoli",                           // Italiano
        "Toon ondertitels",                                 // Nederlands
        "",                                                 // Portugus
        "Affiche les sous-titres",                          // Franais
        "",                                                 // Norsk
        "Nyt tekstitys",                                  // suomi
        "Wywietlaj napisy",                                // Polski
        "Mostrar subttulos",                               // Espaol
        "Endiksi ipotitlon",                                //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        " ",                              //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Subtiitrite kuvamine",                             // Eesti
        "Vis undertekster",                                 // Dansk
        "Zobrazovat titulky",                               // Czech
#if VDRVERSNUM >= 10502
        "Altyazlar gster"                                // Trke
#endif
    },
    {
    "Setup.DVD$Hide Mainmenu Entry",
        "Hauptmeneintrag verstecken",                      // Deutsch
        "Skrij galvni meni",                                // Slovenski
        "Nascondi voce men",                               // Italiano
        "Verberg vermelding in het hoofdmenu",              // Nederlands
        "",                                                 // Portugus
        "",                                                 // Franais
        "",                                                 // Norsk
        "Piilota valinta pvalikosta",                     // suomi
        "Ukryj pozycj w gwnym menu",                     // Polski
        "Ocultar entrada en el men principal",             // Espaol
        "Apokripsi sto vasiko menou",                       //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "    ",                    //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Peita peamen valikust",                          // Eesti
        "Skjul DVD i hovedmenuen",                          // Dansk
        "Skrt poloku v hlavnm menu",                     // Czech
#if VDRVERSNUM >= 10502
        "Ana mende sakla"                                  // Trke
#endif
    },
    {
    "Setup.DVD$ReadAHead",
        "ReadAHead",                                        // Deutsch
        "Beri vnaprej",                                       // Slovenski
        "ReadAHead",                                        // Italiano
        "Vooruit lezen",                                    // Nederlands
        "ReadAHead",                                        // Portugus
        "ReadAHead",                                        // Franais
        "ReadAHead",                                        // Norsk
        "ReadAHead-toiminto",                               // suomi
        "ReadAHead",                                        // Polski
        "Lectura anticipada",                               // Espaol
        "ReadAHead",                                        //  (Greek)
        "ReadAHead",                                        // Svenska
        "ReadAHead",                                        // Romaneste
        "ReadAHead",                                        // Magyar
        "ReadAHead",                                        // Catal
        " ",                               //  (Russian)
        "ReadAHead",                                        // Hrvatski (Croatian)
        "ReadAHead",                                        // Eesti
        "Ls forud",                                        // Dansk
        "Dopedn ten",                                   // Czech
#if VDRVERSNUM >= 10502
        "leri oku"                                         // Trke
#endif
    },
    {
    "Setup.DVD$Gain (analog)",
        "Verstrkung (analog)",                             // Deutsch
        "Ojaanje (analogno)",                              // Slovenski
        "Gain (analog)",                                    // Italiano
        "Versterking (analoog)",                            // Nederlands
        "Gain (analog)",                                    // Portugus
        "Gain (analog)",                                    // Franais
        "Gain (analog)",                                    // Norsk
        "nen vahvistus (analoginen)",                     // suomi
        "Zysk (analogowo)",                                 // Polski
        "Ganancia (analgico)",                             // Espaol
        "Gain (analogika)",                                 //  (Greek)
        "Gain (analog)",                                    // Svenska
        "Gain (analog)",                                    // Romaneste
        "Gain (analog)",                                    // Magyar
        "Gain (analog)",                                    // Catal
        " (.)",                               //  (Russian)
        "Gain (analog)",                                    // Hrvatski (Croatian)
        "Helivimendamine (analoog)",                       // Eesti
        "Forstrkning (analog)",                            // Dansk
        "Zeslen (analog)",                                // Czech
#if VDRVERSNUM >= 10502
        "Kuvvetlendirmek (analog)"                          // Trke
#endif
    },
    {
    "Error.DVD$Error opening DVD!",                         // English
        "Fehler beim ffnen der DVD!",                      // Deutsch
        "Napaka pri odpiranju DVD-ja!",                     // Slovenski
        "",                                                 // Italiano
        "Fout bij het openen van de DVD!",                  // Nederlands
        "",                                                 // Portugus
        "",                                                 // Franais
        "",                                                 // Norsk
        "DVD:n avaaminen eponnistui!",                     // suomi
        "Bd otwierania DVD!",                             // Polski
        "Error abriendo el DVD!",                          // Espaol
        "Lathos sto anigma tou DVD",                        //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  DVD!",                             //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "DVD avamine ebannestus!",                         // Eesti
        "Fejl ved bning af DVD!",                          // Dansk
        "Chyba pi otevrn DVD!",                         // Czech
#if VDRVERSNUM >= 10502
        "DVD al hatas!"                                // Trke
#endif
    },
    {
    "Error.DVD$Error fetching data from DVD!",              // English
        "Fehler beim lesen von der DVD!",                   // Deutsch
        "Napaka pri branju podatkov iz DVD-ja!",            // Slovenski
        "",                                                 // Italiano
        "Error bij het verkrijgen van data van de DVD!",    // Nederlands
        "",                                                 // Portugus
        "",                                                 // Franais
        "",                                                 // Norsk
        "DVD:n lukeminen eponnistui",                      // suomi
        "Bd pobierania danych z DVD!",                    // Polski
        "Error obteniendo datos del DVD!",                 // Espaol
        "Lathos sto diavasma tou DVD",                      //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  DVD!",                               //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Lugemine DVD-lt ebannestus!",                     // Eesti
        "Fejl ved hentning af data fra DVD!",               // Dansk
        "Chyba pi natn dat z DVD!",                    // Czech
#if VDRVERSNUM >= 10502
        "DVD okuma hatas!"                                 // Trke
#endif
    },
    {
    "Error.DVD$Current subtitle stream not seen!",          // English
        "Der ausgewhlte Untertitel ist nicht vorhanden!",  // Deutsch
        "Izbrani podnapisi niso prisotni!",                 // Slovenski
        "",                                                 // Italiano
        "De gekozen ondertiteling is niet beschikbaar!",    // Nederlands
        "",                                                 // Portugus
        "",                                                 // Franais
        "",                                                 // Norsk
        "Tekstitysraitaa ei havaita!",                      // suomi
        "Wybrane napisy nie istniej!",                     // Polski
        "Subttulos actuales no encontrados!",             // Espaol
        "O epilegmenos ipotitlos den iparxi",               //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "   !",          //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Subtiitriterada pole avastatud!",                  // Eesti
        "Valgte undertekst findes ikke!",                   // Dansk
        "Vybran titulky nejsou k dispozici!",              // Czech
#if VDRVERSNUM >= 10502
        "Seilen altyaz bulunamad!"                       // Trke
#endif
    },
    {
    "Error.DVD$Current audio track not seen!",              // English
        "Die ausgewhlte Audiospur ist nicht vorhanden!",   // Deutsch
        "Izbrani zvoni zapis ni prisoten!",                // Slovenski
        "",                                                 // Italiano
        "Het gekozen audiospoort is niet beschikbaar",      // Nederlands
        "",                                                 // Portugus
        "",                                                 // Franais
        "",                                                 // Norsk
        "niraitaa ei havaita!",                           // suomi
        "Wybrana cieka dwikowa nie istnieje!",          // Polski
        "Pista de audio actual no encontrada!",            // Espaol
        "I Epilegmeni desmi ixou den mpori na wrethi",      //  (Greek)
        "",                                                 // Svenska
        "",                                                 // Romaneste
        "",                                                 // Magyar
        "",                                                 // Catal
        "  !",                   //  (Russian)
        "",                                                 // Hrvatski (Croatian)
        "Audiorada pole avastatud!",                        // Eesti
        "Valgte lyd-spor findes ikke!",                     // Dansk
        "Vybran zvukov stopa nen k dispozici!",          // Czech
#if VDRVERSNUM >= 10502
        "Seilen audio ses bulunamad!"                     // Trke
#endif
    },
    { NULL }
};
#endif
