/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6
 * Jan 1999
 * ===========================
 *
 * Copyright (C) 1999, Salmaso Raffaele
 * Developed by Salmaso Raffaele <r.salmaso@flashnet.it>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdkthread.h"

VDKMutex::VDKMutex () {
    pthread_mutex_init (&mutex, (pthread_mutexattr_t *) 0);
};

VDKMutex::~VDKMutex () {
    pthread_mutex_destroy (&mutex);
};

VDKMutexEnum VDKMutex::Lock () {
    if (pthread_mutex_trylock (&mutex) != 0)
        return VDKMUTEX_ERROR;
    return VDKMUTEX_OK;
}

VDKMutexEnum VDKMutex::Release () {
    if (pthread_mutex_unlock (&mutex) != 0)
        return VDKMUTEX_ERROR;
    return VDKMUTEX_OK;
};

VDKMutexEnum VDKMutex::Wait (long time) {
    if (pthread_mutex_lock (&mutex) != 0)
        return VDKMUTEX_ERROR;
    return VDKMUTEX_OK;
}

VDKThread::VDKThread () {
    state = VDKTHREAD_IDLE;
}

VDKThread::~VDKThread () {
}

VDKThreadEnum VDKThread::Start (void * arg) 
{
  if (state != VDKTHREAD_IDLE)
    return VDKTHREAD_IS_YET_RUNNING;
  state = VDKTHREAD_RUNNING;
  if (arg == NULL) 
    {
      if (pthread_create (&id, (pthread_attr_t *) 0, 
			  VDKThread::EntryPoint, 
			  (void *)  this) != 0) 
	{
	  state = VDKTHREAD_IDLE;
	  return VDKTHREAD_CANNOT_CREATE;
        }
    } 
  else 
    {
      if (pthread_create (&id, (pthread_attr_t *) 0, 
			  (void * (*)(void *)) arg, 
			  NULL) != 0) {
	state = VDKTHREAD_IDLE;
	return VDKTHREAD_CANNOT_CREATE;
      }
    }
  
  return VDKTHREAD_RUNNING;
}

void * VDKThread::EntryPoint (void * arg) {
    VDKThread * thread = (VDKThread *) arg;
    thread->Execute ();
    return NULL;
}

void VDKThread::Execute () {
}

VDKThreadEnum VDKThread::Stop () {
    if (state == VDKTHREAD_RUNNING)
        if (pthread_cancel (id) == 0)
            state =VDKTHREAD_STOPPED;
    return state;
}

void VDKThread::Exit (void * status) {
    state = VDKTHREAD_EXITED;
    pthread_exit (status);
}

void * VDKThread::Wait () {
    void * status = 0;
    if (state != VDKTHREAD_IDLE) {
        pthread_join (id, &status);
        state = VDKTHREAD_IDLE;
    }
    return status;
}
