/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/fixed.h"
#include "vdk/forms.h"

VDKFixed::VDKFixed(VDKForm* owner)
  :VDKObjectContainer(owner)
{
widget = gtk_fixed_new();
}

VDKFixed::~VDKFixed()
{
}

void VDKFixed::Add(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{
  // here justify and exoand are used as x,y coordinates
  gtk_fixed_put( GTK_FIXED(widget), obj->Widget(), justify, expand );
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
}

void VDKFixed::Put(VDKObject* obj, int x, int y) 
{ 
  gtk_fixed_put( GTK_FIXED(widget), obj->Widget(), x, y ); 
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);

} 


  
