/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef EVJOBHANDLE_H
#define EVJOBHANDLE_H
#include <vdk/vdkobj.h>
#include <gdk/gdktypes.h>
/*
==============================================
         OBJECT_SIGNAL DISPATCHER ROUTINES
==============================================
*/
/*
OBJECT_SIGNALTableEntry:
Obj/Signal/Response method Table Entry
*/
template <class T>
class OBJECT_SIGNALTableEntry {
  public:
  typedef bool (T::*OBJPMF)(VDKObject* sender);
  int signal; /* signal type (see enum VDKSignal in vdkobj.h) */
  OBJPMF    Pmf;  /* pointer to <class T> member function */
  bool connected; /* connected flag, if false deny signal */
};

 
/*
Signal response function map declaration:
declare a static signal table for each object class
*/
#define DECLARE_OBJECT_SIGNAL_MAP(_OBJECT_SIGNALclass_)  \
private:\
static OBJECT_SIGNALTableEntry< _OBJECT_SIGNALclass_ > __OC_OBJ_Bentries[];\
typedef OBJECT_SIGNALTableEntry< _OBJECT_SIGNALclass_ >::OBJPMF _Member_;\
typedef _OBJECT_SIGNALclass_  _OBJECT_SIGNALmyclass_;\
protected:\
    virtual int  VDKObjectSignalResponseTableSize();\
public:\
    virtual int  VDKObjectSignalResponse(GtkWidget*,int signal,void*, bool);\
    virtual int  ObjectSignalDetach(int signal);\
    virtual bool ObjectSignalAttach(int slot);
/*
define form signal response function that in turn call
object signal response function
*/
#define DEFINE_OBJECT_SIGNAL_MAP(_OBJECT_SIGNALclass_,base)\
\
\
\
\
int _OBJECT_SIGNALclass_::VDKObjectSignalResponse(GtkWidget* mobj, int signal, void* obj, bool treated) \
{\
int t=0;\
VDKObject* vdkobj = static_cast<VDKObject*>(obj);\
						   /*bool treated = false;*/\
for(;__OC_OBJ_Bentries[t].signal >= 0 ;t++)\
  {\
     if( (__OC_OBJ_Bentries[t].signal == signal) )\
       {\
	 if (__OC_OBJ_Bentries[t].connected)\
	   {\
	   bool (_OBJECT_SIGNALclass_::*response)(VDKObject* sender)=\
                    __OC_OBJ_Bentries[t].Pmf;\
	    if(((*this).*response)(vdkobj))\
             treated = true;\
	   }\
	      /*break;*/\
       }\
   }\
if(treated) return 1;\
else return base::VDKObjectSignalResponse(mobj,signal,obj, treated); \
}\
\
\
\
int _OBJECT_SIGNALclass_::VDKObjectSignalResponseTableSize()\
{\
int t = 0;\
for(;__OC_OBJ_Bentries[t].signal >= 0;t++)\
   ;\
return t;\
}\
\
\
\
int _OBJECT_SIGNALclass_::ObjectSignalDetach(int signal)\
{\
int t=0;\
for(;__OC_OBJ_Bentries[t].signal>= 0 ;t++)\
  {\
     if((__OC_OBJ_Bentries[t].signal == signal) &&\
	__OC_OBJ_Bentries[t].connected != false)\
       {\
	 __OC_OBJ_Bentries[t].connected = false;\
         return t;\
       }\
   }\
return -1;\
}\
\
\
\
bool _OBJECT_SIGNALclass_::ObjectSignalAttach(int slot)\
{\
if( (slot >= 0) && (slot <= VDKObjectSignalResponseTableSize()) )\
     {\
     __OC_OBJ_Bentries[slot].connected = true;\
     return true;\
     }\
else\
     return false;\
}\
\
\
OBJECT_SIGNALTableEntry< _OBJECT_SIGNALclass_ > _OBJECT_SIGNALclass_::__OC_OBJ_Bentries[] = {
/*
fill static signal table
*/
#define ON_OBJECT_SIGNAL(_OBJECT_SIGNAL_,_member_)  \
  {_OBJECT_SIGNAL_,&(_OBJECT_SIGNALmyclass_::_member_),true}
/*
*/
#define END_OBJECT_SIGNAL_MAP ,{-1, NULL,false} };
/*
==============================================
         OBJECT_EVENT DISPATCHER ROUTINES
==============================================
*/
/*
OBJECT_EVENTTableEntry:
Event-ObjectCallback Table Entry
*/
template <class T>
class OBJECT_EVENTTableEntry {
 public:
  typedef bool (T::*OBJPMF)(VDKObject* sender, GdkEvent* event);
  GdkEventType event; /* event type (see enum VDKevent in vdkobj.h) */
  OBJPMF    Pmf;  /* pointer to <class T> member function */
  bool connected;
};
/*
Events response function map declaration:
declare a static events table for each form
*/
#define DECLARE_OBJECT_EVENT_MAP(_OBJECT_EVENTclass_)  \
private:\
static OBJECT_EVENTTableEntry< _OBJECT_EVENTclass_ > __OCBOBJECT_EVENTEntries[];\
typedef OBJECT_EVENTTableEntry< _OBJECT_EVENTclass_ >::OBJPMF _EvMember_;\
typedef _OBJECT_EVENTclass_  _OBJECT_EVENTmyclass_;\
protected:\
    virtual int VDKObjectEventResponseTableSize();\
public:\
    virtual int  VDKObjectEventResponse(GtkWidget* , GdkEvent* , void*, bool);\
    virtual int  ObjectEventDetach(VDKEvent event);\
    virtual bool ObjectEventAttach(int slot);
/*
define form OBJECT_EVENT response function that in turn call
object OBJECT_EVENT response function
*/
#define DEFINE_OBJECT_EVENT_MAP(_OBJECT_EVENTclass_,base)  \
int _OBJECT_EVENTclass_::VDKObjectEventResponse(GtkWidget* wid, GdkEvent* event, void* obj, bool treated) \
{\
int t=0;\
VDKObject* vdkobj = static_cast<VDKObject*>(obj);\
for(;__OCBOBJECT_EVENTEntries[t].event >= 0 ;t++)\
  {\
     if((__OCBOBJECT_EVENTEntries[t].event == ((GdkEventAny*)event)->type) )\
       {\
	  if (__OCBOBJECT_EVENTEntries[t].connected)\
	     {\
		bool (_OBJECT_EVENTclass_::*response)\
		 (VDKObject* , GdkEvent* )= \
		 __OCBOBJECT_EVENTEntries[t].Pmf;\
	       if(((*this).*response)(vdkobj,event))\
	         treated = true;\
	     }\
		/*break;*/\
       }\
   }\
if(treated) return 1;\
else return base::VDKObjectEventResponse(wid,event,obj, treated); \
}\
\
\
\
int _OBJECT_EVENTclass_::VDKObjectEventResponseTableSize()\
{\
int t = 0;\
for(;__OCBOBJECT_EVENTEntries[t].event>= 0;t++)\
   ;\
return t;\
}\
\
\
\
int _OBJECT_EVENTclass_::ObjectEventDetach(VDKEvent event)\
{\
int t=0;\
for(;__OCBOBJECT_EVENTEntries[t].event >= 0 ;t++)\
  {\
     if((__OCBOBJECT_EVENTEntries[t].event == (GdkEventType) event) &&\
	__OCBOBJECT_EVENTEntries[t].connected != false)\
       {\
	 __OCBOBJECT_EVENTEntries[t].connected = false;\
         return t;\
       }\
   }\
return -1;\
}\
\
\
\
bool _OBJECT_EVENTclass_::ObjectEventAttach(int slot)\
{\
if( (slot >= 0) && (slot <= VDKObjectEventResponseTableSize()) )\
     {\
     __OCBOBJECT_EVENTEntries[slot].connected = true;\
     return true;\
     }\
else\
     return false;\
}\
\
\
OBJECT_EVENTTableEntry< _OBJECT_EVENTclass_ > _OBJECT_EVENTclass_::__OCBOBJECT_EVENTEntries[] = {
/*
fill static OBJECT_EVENT table
*/
#define ON_OBJECT_EVENT(_OBJECT_EVENT_,_member_)  \
  {(GdkEventType) _OBJECT_EVENT_,&(_OBJECT_EVENTmyclass_::_member_),true}
/*
*/
#define END_OBJECT_EVENT_MAP ,{(GdkEventType) -1, NULL,false} };

#endif





