from _typeshed import Incomplete
from collections.abc import Sequence
from enum import Enum
from typing import Any, NamedTuple

from cryptography.hazmat.primitives.asymmetric.ed448 import Ed448PrivateKey as Ed448PrivateKey, Ed448PublicKey as Ed448PublicKey
from cryptography.hazmat.primitives.asymmetric.ed25519 import (
    Ed25519PrivateKey as Ed25519PrivateKey,
    Ed25519PublicKey as Ed25519PublicKey,
)
from cryptography.hazmat.primitives.asymmetric.x448 import X448PrivateKey as X448PrivateKey, X448PublicKey as X448PublicKey
from cryptography.hazmat.primitives.asymmetric.x25519 import (
    X25519PrivateKey as X25519PrivateKey,
    X25519PublicKey as X25519PublicKey,
)
from jwcrypto.common import JWException

class UnimplementedOKPCurveKey:
    @classmethod
    def generate(cls) -> None: ...
    @classmethod
    def from_public_bytes(cls, *args) -> None: ...
    @classmethod
    def from_private_bytes(cls, *args) -> None: ...

ImplementedOkpCurves: Sequence[str]
priv_bytes: Incomplete

JWKTypesRegistry: Incomplete

class ParmType(Enum):
    name = "A string with a name"  # pyright: ignore[reportAssignmentType]
    b64 = "Base64url Encoded"
    b64u = "Base64urlUint Encoded"
    unsupported = "Unsupported Parameter"

class JWKParameter(NamedTuple):
    description: Incomplete
    public: Incomplete
    required: Incomplete
    type: Incomplete

JWKValuesRegistry: Incomplete
JWKParamsRegistry: Incomplete
JWKEllipticCurveRegistry: Incomplete
JWKUseRegistry: Incomplete
JWKOperationsRegistry: Incomplete
JWKpycaCurveMap: Incomplete
IANANamedInformationHashAlgorithmRegistry: Incomplete

class InvalidJWKType(JWException):
    value: Incomplete
    def __init__(self, value: Incomplete | None = None) -> None: ...

class InvalidJWKUsage(JWException):
    value: Incomplete
    use: Incomplete
    def __init__(self, use, value) -> None: ...

class InvalidJWKOperation(JWException):
    op: Incomplete
    values: Incomplete
    def __init__(self, operation, values) -> None: ...

class InvalidJWKValue(JWException): ...

class JWK(dict[str, Any]):
    def __init__(self, **kwargs) -> None: ...
    @classmethod
    def generate(cls, **kwargs): ...
    def generate_key(self, **params) -> None: ...
    def import_key(self, **kwargs) -> None: ...
    @classmethod
    def from_json(cls, key): ...
    def export(self, private_key: bool = True, as_dict: bool = False): ...
    def export_public(self, as_dict: bool = False): ...
    def export_private(self, as_dict: bool = False): ...
    def export_symmetric(self, as_dict: bool = False): ...
    def public(self): ...
    @property
    def has_public(self) -> bool: ...
    @property
    def has_private(self) -> bool: ...
    @property
    def is_symmetric(self) -> bool: ...
    @property
    def key_type(self): ...
    @property
    def key_id(self): ...
    @property
    def key_curve(self): ...
    def get_curve(self, arg): ...
    def get_op_key(self, operation: Incomplete | None = None, arg: Incomplete | None = None): ...
    def import_from_pyca(self, key) -> None: ...
    def import_from_pem(self, data, password: Incomplete | None = None, kid: Incomplete | None = None) -> None: ...
    def export_to_pem(self, private_key: bool = False, password: bool = False): ...
    @classmethod
    def from_pyca(cls, key): ...
    @classmethod
    def from_pem(cls, data, password: Incomplete | None = None): ...
    def thumbprint(self, hashalg=...): ...
    def thumbprint_uri(self, hname: str = "sha-256"): ...
    @classmethod
    def from_password(cls, password): ...
    def setdefault(self, key: str, default: Incomplete | None = None): ...

class JWKSet(dict[str, Any]):
    def add(self, elem) -> None: ...
    def export(self, private_keys: bool = True, as_dict: bool = False): ...
    def import_keyset(self, keyset) -> None: ...
    @classmethod
    def from_json(cls, keyset): ...
    def get_key(self, kid): ...
    def get_keys(self, kid): ...
    def setdefault(self, key: str, default: Incomplete | None = None): ...
