#[macro_use]
extern crate pretty_assertions;

extern crate nom;
extern crate tls_parser;

mod certificate_transparency {
    use tls_parser::*;

    static SCT_LIST: &[u8] = &[
        0x00, 0xf0, 0x00, 0x76, 0x00, 0xf6, 0x5c, 0x94, 0x2f, 0xd1, 0x77, 0x30, 0x22, 0x14, 0x54,
        0x18, 0x08, 0x30, 0x94, 0x56, 0x8e, 0xe3, 0x4d, 0x13, 0x19, 0x33, 0xbf, 0xdf, 0x0c, 0x2f,
        0x20, 0x0b, 0xcc, 0x4e, 0xf1, 0x64, 0xe3, 0x00, 0x00, 0x01, 0x72, 0x53, 0x4b, 0x97, 0xa5,
        0x00, 0x00, 0x04, 0x03, 0x00, 0x47, 0x30, 0x45, 0x02, 0x21, 0x00, 0xc6, 0x2d, 0xa9, 0x45,
        0xd2, 0x81, 0xfd, 0xda, 0x9f, 0xf3, 0xf8, 0xa4, 0x18, 0xb4, 0x4d, 0x2f, 0x7c, 0x23, 0x60,
        0xb5, 0x6a, 0xb9, 0x51, 0x88, 0x9c, 0x38, 0x1b, 0x36, 0xf8, 0xa9, 0xf2, 0x1d, 0x02, 0x20,
        0x00, 0xe2, 0xfc, 0xde, 0xbc, 0x91, 0x08, 0x29, 0x46, 0x86, 0x08, 0x89, 0x5b, 0x62, 0xd4,
        0x45, 0x3e, 0x91, 0xdd, 0x39, 0x76, 0xb7, 0xa6, 0xe4, 0xae, 0xd4, 0xd2, 0x38, 0x50, 0xe9,
        0xc7, 0xd0, 0x00, 0x76, 0x00, 0x5c, 0xdc, 0x43, 0x92, 0xfe, 0xe6, 0xab, 0x45, 0x44, 0xb1,
        0x5e, 0x9a, 0xd4, 0x56, 0xe6, 0x10, 0x37, 0xfb, 0xd5, 0xfa, 0x47, 0xdc, 0xa1, 0x73, 0x94,
        0xb2, 0x5e, 0xe6, 0xf6, 0xc7, 0x0e, 0xca, 0x00, 0x00, 0x01, 0x72, 0x53, 0x4b, 0x97, 0xa0,
        0x00, 0x00, 0x04, 0x03, 0x00, 0x47, 0x30, 0x45, 0x02, 0x20, 0x35, 0x6c, 0x91, 0x1f, 0xb3,
        0x22, 0x79, 0xf2, 0x65, 0x95, 0x53, 0xcf, 0x3a, 0x36, 0xd7, 0xac, 0xde, 0xa1, 0xf4, 0xb1,
        0xa9, 0x2e, 0xdd, 0x46, 0x0d, 0x96, 0xff, 0x1b, 0xda, 0x93, 0x4e, 0xe8, 0x02, 0x21, 0x00,
        0xee, 0xed, 0x93, 0x37, 0xba, 0x12, 0xdb, 0x44, 0x67, 0x7e, 0x09, 0xa4, 0x5f, 0xd6, 0x66,
        0x6c, 0x7b, 0x02, 0xb8, 0x63, 0x1f, 0xb6, 0xbf, 0x91, 0x53, 0x95, 0xb6, 0xf9, 0xd6, 0xfd,
        0x45, 0x2d,
    ];

    #[test]
    fn test_ct_parse_signed_certificate_timestamp_list() {
        let empty = &b""[..];
        let res = parse_ct_signed_certificate_timestamp_list(SCT_LIST).unwrap();
        let id1 = &[
            0xf6, 0x5c, 0x94, 0x2f, 0xd1, 0x77, 0x30, 0x22, 0x14, 0x54, 0x18, 0x08, 0x30, 0x94,
            0x56, 0x8e, 0xe3, 0x4d, 0x13, 0x19, 0x33, 0xbf, 0xdf, 0x0c, 0x2f, 0x20, 0x0b, 0xcc,
            0x4e, 0xf1, 0x64, 0xe3,
        ];
        let id2 = &[
            0x5c, 0xdc, 0x43, 0x92, 0xfe, 0xe6, 0xab, 0x45, 0x44, 0xb1, 0x5e, 0x9a, 0xd4, 0x56,
            0xe6, 0x10, 0x37, 0xfb, 0xd5, 0xfa, 0x47, 0xdc, 0xa1, 0x73, 0x94, 0xb2, 0x5e, 0xe6,
            0xf6, 0xc7, 0x0e, 0xca,
        ];
        let signature1 = DigitallySigned {
            alg: Some(SignatureAndHashAlgorithm {
                hash: HashAlgorithm::Sha256,
                sign: SignAlgorithm::Ecdsa,
            }),
            data: &[
                0x30, 0x45, 0x02, 0x21, 0x00, 0xc6, 0x2d, 0xa9, 0x45, 0xd2, 0x81, 0xfd, 0xda, 0x9f,
                0xf3, 0xf8, 0xa4, 0x18, 0xb4, 0x4d, 0x2f, 0x7c, 0x23, 0x60, 0xb5, 0x6a, 0xb9, 0x51,
                0x88, 0x9c, 0x38, 0x1b, 0x36, 0xf8, 0xa9, 0xf2, 0x1d, 0x02, 0x20, 0x00, 0xe2, 0xfc,
                0xde, 0xbc, 0x91, 0x08, 0x29, 0x46, 0x86, 0x08, 0x89, 0x5b, 0x62, 0xd4, 0x45, 0x3e,
                0x91, 0xdd, 0x39, 0x76, 0xb7, 0xa6, 0xe4, 0xae, 0xd4, 0xd2, 0x38, 0x50, 0xe9, 0xc7,
                0xd0,
            ],
        };
        let signature2 = DigitallySigned {
            alg: Some(SignatureAndHashAlgorithm {
                hash: HashAlgorithm::Sha256,
                sign: SignAlgorithm::Ecdsa,
            }),
            data: &[
                0x30, 0x45, 0x02, 0x20, 0x35, 0x6c, 0x91, 0x1f, 0xb3, 0x22, 0x79, 0xf2, 0x65, 0x95,
                0x53, 0xcf, 0x3a, 0x36, 0xd7, 0xac, 0xde, 0xa1, 0xf4, 0xb1, 0xa9, 0x2e, 0xdd, 0x46,
                0x0d, 0x96, 0xff, 0x1b, 0xda, 0x93, 0x4e, 0xe8, 0x02, 0x21, 0x00, 0xee, 0xed, 0x93,
                0x37, 0xba, 0x12, 0xdb, 0x44, 0x67, 0x7e, 0x09, 0xa4, 0x5f, 0xd6, 0x66, 0x6c, 0x7b,
                0x02, 0xb8, 0x63, 0x1f, 0xb6, 0xbf, 0x91, 0x53, 0x95, 0xb6, 0xf9, 0xd6, 0xfd, 0x45,
                0x2d,
            ],
        };
        assert_eq!(
            res,
            (
                empty,
                vec![
                    SignedCertificateTimestamp {
                        version: CtVersion::V1,
                        id: CtLogID { key_id: id1 },
                        timestamp: 1590535362469,
                        extensions: CtExtensions(empty),
                        signature: signature1
                    },
                    SignedCertificateTimestamp {
                        version: CtVersion::V1,
                        id: CtLogID { key_id: id2 },
                        timestamp: 1590535362464,
                        extensions: CtExtensions(empty),
                        signature: signature2
                    }
                ]
            )
        );
    }
}
