/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.OperationType;
import java.util.NoSuchElementException;

public class Operation
implements ADQLOperand {
    private ADQLOperand leftOperand;
    private OperationType operation;
    private ADQLOperand rightOperand;
    private TextPosition position = null;

    public Operation(ADQLOperand leftOp, OperationType op, ADQLOperand rightOp) throws NullPointerException, UnsupportedOperationException {
        this.setLeftOperand(leftOp);
        if (op == null) {
            throw new NullPointerException("Impossible to build an Operation without an operation type (SUM, SUB, MULT or DIV)!");
        }
        this.operation = op;
        this.setRightOperand(rightOp);
        this.position = null;
    }

    public Operation(Operation toCopy) throws Exception {
        this.leftOperand = (ADQLOperand)toCopy.leftOperand.getCopy();
        this.operation = toCopy.operation;
        this.rightOperand = (ADQLOperand)toCopy.rightOperand.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return this.operation.getFeatureDescription();
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand newLeftOperand) throws NullPointerException, UnsupportedOperationException {
        if (newLeftOperand == null) {
            throw new NullPointerException("Impossible to update an Operation with a left operand equals to NULL!");
        }
        if (!newLeftOperand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to update an Operation because the left operand is not numeric (" + newLeftOperand.toADQL() + ")!");
        }
        this.leftOperand = newLeftOperand;
        this.position = null;
    }

    public final OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(OperationType newOperation) {
        if (newOperation != null) {
            this.operation = newOperation;
        }
    }

    public final ADQLOperand getRightOperand() {
        return this.rightOperand;
    }

    public void setRightOperand(ADQLOperand newRightOperand) throws NullPointerException, UnsupportedOperationException {
        if (newRightOperand == null) {
            throw new NullPointerException("Impossible to update an Operation with a right operand equals to NULL!");
        }
        if (!newRightOperand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to update an Operation because the right operand is not numeric (" + newRightOperand.toADQL() + ")!");
        }
        this.rightOperand = newRightOperand;
        this.position = null;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Operation(this);
    }

    @Override
    public String getName() {
        return this.operation.name();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ADQLOperand operand = null;

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    this.operand = Operation.this.leftOperand;
                } else if (this.index == 1) {
                    this.operand = Operation.this.rightOperand;
                } else {
                    throw new NoSuchElementException();
                }
                return this.operand;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand && ((ADQLOperand)replacer).isNumeric()) {
                    if (this.index == 0) {
                        Operation.this.leftOperand = (ADQLOperand)replacer;
                    } else if (this.index == 1) {
                        Operation.this.rightOperand = (ADQLOperand)replacer;
                    }
                    Operation.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the operand \"" + this.operand.toADQL() + "\" by \"" + replacer.toADQL() + "\" in the operation \"" + Operation.this.toADQL() + "\" because the replacer is not an ADQLOperand or is not numeric!");
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove one operand (" + this.operand.toADQL() + ") of an operation (" + Operation.this.toADQL() + "). However you can replace the whole operation by the remaining operand.");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.leftOperand.toADQL() + this.operation.toADQL() + this.rightOperand.toADQL();
    }
}

