/*
 * Copyright © 2021 Keith Packard <keithp@keithp.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#pragma once


#define SNEK_I2C_READ	0x01
#define SNEK_I2C_WRITE	0x00

/* High level API */
void
snek_i2c_put(uint8_t addr, uint8_t reg, uint8_t val);

uint8_t
snek_i2c_get(uint8_t addr, uint8_t reg);

/* Low level API */

void
snek_i2c_start(uint8_t addr);

uint8_t
snek_i2c_read_ack(void);

uint8_t
snek_i2c_read_nak(void);

void
snek_i2c_write(uint8_t val);

void
snek_i2c_stop(void);
