// -*- Mode: Go; indent-tabs-mode: t -*-

/*
 * Copyright (C) 2022 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// info produces information about assertions to include in /usr/lib/snapd/info.
package main

import (
	"encoding/json"
	"fmt"

	"github.com/snapcore/snapd/asserts"
)

func main() {
	maxFormats := asserts.MaxSupportedFormats(1)
	b, err := json.Marshal(maxFormats)
	if err != nil {
		panic(fmt.Sprintf("cannot json marshal asserts info: %v", err))
	}
	fmt.Printf("SNAPD_ASSERTS_FORMATS='%s'\n", b)
}
