"""Add MUC.history_filled

Also drop caps_ver_bare column that should never have been added.

Revision ID: 82a4af84b679
Revises: 2461390c0af2
Create Date: 2024-07-22 07:01:05.352737

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "82a4af84b679"
down_revision: Union[str, None] = "2461390c0af2"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("contact", schema=None) as batch_op:
        batch_op.drop_column("caps_ver_bare")

    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "history_filled",
                sa.Boolean(),
                nullable=False,
                server_default=sa.False_(),  # manually added
            )
        )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.drop_column("history_filled")

    with op.batch_alter_table("contact", schema=None) as batch_op:
        batch_op.add_column(sa.Column("caps_ver_bare", sa.VARCHAR(), nullable=True))

    # ### end Alembic commands ###
