// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Paul Bignier
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- XCOS TEST -->
// <-- NO CHECK REF -->
//

assert_checktrue(importXcosDiagram("SCI/modules/xcos/tests/unit_tests/Solvers/ODE/IPendulum.zcos"));

// Importing a function used by the diagram
exec("SCI/modules/xcos/demos/setw.sci", -1);

CVode_val_ref = [
-0.0227915    0.0307594  -0.9543050    0.0201381  -1.0730676  -1.
-0.0197164    0.0312202  -0.9533119   -0.0000256  -1.0777036  -1.
-0.0165213    0.0325962  -0.9542269   -0.0177130  -1.0823414  -1.
-0.0132332    0.0329347  -0.9567362   -0.0318341  -1.0868049  -1.
-0.0099822    0.0318753  -0.9604665   -0.0421799  -1.0909528  -1.
-0.0068999    0.0295920  -0.9650512   -0.0489345  -1.0946824  -1.
-0.0040504    0.0269587  -0.9702015   -0.0533494  -1.0979233  -1.
-0.0015593    0.0227394  -0.9756016   -0.0541501  -1.1006336  -1.
0.0004864    0.0181779  -0.9809467   -0.0523918  -1.1028044  -1.
0.0020816    0.0137832  -0.9860190   -0.0488045  -1.1044527  -1.
0.0032551    0.0097721  -0.9906651   -0.0439566  -1.1056138  -1.
0.0045380    0.0135493  -0.9950621   -0.0426360  -1.1063262  -1.
0.0057121    0.0093744  -0.9990293   -0.0362660  -1.1066162  -1.
0.0063728    0.0038864  -1.0022687   -0.0284691  -1.1065444  -1.
0.0065159   -0.0008130  -1.0047241   -0.0207391  -1.1061879  -1.
0.0062518   -0.0042459  -1.0064382   -0.0137017  -1.1056237  -1.
0.0051706   -0.014412   -1.007129    -0.0018149  -1.1049356  -1.
0.0037090   -0.0139594  -1.0070254    0.0031673  -1.1042238  -1.
0.0024626   -0.0108371  -1.0065914    0.0051986  -1.1035413  -1.
0.0015416   -0.0076733  -1.0060276    0.0059356  -1.1029098  -1. ];
CVode_time_ref = (0:.1:29.9)';

for i=1:4

    scs_m.props.tol(6) = i; // Solver
    try scicos_simulate(scs_m); catch disp(lasterror()); end; // CVode

    assert_checkalmostequal(res.values($-19:$, :), CVode_val_ref, [], 1d-4);
    assert_checkalmostequal(res.time, CVode_time_ref);

end
