// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - SCILAB ENTERPRISES - Simon GARESTE
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- CLI SHELL MODE -->

msgerr = msprintf(gettext("%s: Wrong number of input argument(s): %d expected.\n"), "h5isType", 1);
assert_checkerror("h5isType()",msgerr,77);
assert_checkfalse(h5isType("42"));
assert_checkfalse(h5isType(42));

w = "testing";
x = list(1, "hello");
y = [1 2;3 4];
z = 1;
save(TMPDIR + "/w.sod", "w");
save(TMPDIR + "/x.sod", "x");
save(TMPDIR + "/y.sod", "y");
save(TMPDIR + "/z.sod", "z");

a = h5open(TMPDIR + "/w.sod", "r");
assert_checkfalse(h5isType(a));
assert_checkfalse(h5isType(a.root));
assert_checkfalse(h5isType(a.root.w));
assert_checktrue(h5isType(a.root.w.type));
h5close(a)

b = h5open(TMPDIR + "/x.sod", "r");
assert_checkfalse(h5isType(b));
assert_checkfalse(h5isType(b.root));
assert_checkfalse(h5isType(b.root.x));
assert_checktrue(h5isType(b.root.x("0").type));
h5close(b)

c = h5open(TMPDIR + "/y.sod", "r");
assert_checkfalse(h5isType(c));
assert_checkfalse(h5isType(c.root));
assert_checkfalse(h5isType(c.root.y));
assert_checktrue(h5isType(c.root.y.type));
h5close(c)

d = h5open(TMPDIR + "/z.sod", "r");
assert_checkfalse(h5isType(d));
assert_checkfalse(h5isType(d.root));
assert_checkfalse(h5isType(d.root.z));
assert_checktrue(h5isType(d.root.z.type));
h5close(d)
