// Autogenerated file - DO NOT EDIT
use std::sync::Arc;

use crate::{Kind, Oid, Type};

#[derive(PartialEq, Eq, Debug, Hash)]
pub struct Other {
    pub name: String,
    pub oid: Oid,
    pub kind: Kind,
    pub schema: String,
}

#[derive(PartialEq, Eq, Clone, Debug, Hash)]
pub enum Inner {
    Bool,
    Bytea,
    Char,
    Name,
    Int8,
    Int2,
    Int2Vector,
    Int4,
    Regproc,
    Text,
    Oid,
    Tid,
    Xid,
    Cid,
    OidVector,
    PgDdlCommand,
    Json,
    Xml,
    XmlArray,
    PgNodeTree,
    JsonArray,
    TableAmHandler,
    Xid8Array,
    IndexAmHandler,
    Point,
    Lseg,
    Path,
    Box,
    Polygon,
    Line,
    LineArray,
    Cidr,
    CidrArray,
    Float4,
    Float8,
    Unknown,
    Circle,
    CircleArray,
    Macaddr8,
    Macaddr8Array,
    Money,
    MoneyArray,
    Macaddr,
    Inet,
    BoolArray,
    ByteaArray,
    CharArray,
    NameArray,
    Int2Array,
    Int2VectorArray,
    Int4Array,
    RegprocArray,
    TextArray,
    TidArray,
    XidArray,
    CidArray,
    OidVectorArray,
    BpcharArray,
    VarcharArray,
    Int8Array,
    PointArray,
    LsegArray,
    PathArray,
    BoxArray,
    Float4Array,
    Float8Array,
    PolygonArray,
    OidArray,
    Aclitem,
    AclitemArray,
    MacaddrArray,
    InetArray,
    Bpchar,
    Varchar,
    Date,
    Time,
    Timestamp,
    TimestampArray,
    DateArray,
    TimeArray,
    Timestamptz,
    TimestamptzArray,
    Interval,
    IntervalArray,
    NumericArray,
    CstringArray,
    Timetz,
    TimetzArray,
    Bit,
    BitArray,
    Varbit,
    VarbitArray,
    Numeric,
    Refcursor,
    RefcursorArray,
    Regprocedure,
    Regoper,
    Regoperator,
    Regclass,
    Regtype,
    RegprocedureArray,
    RegoperArray,
    RegoperatorArray,
    RegclassArray,
    RegtypeArray,
    Record,
    Cstring,
    Any,
    Anyarray,
    Void,
    Trigger,
    LanguageHandler,
    Internal,
    Anyelement,
    RecordArray,
    Anynonarray,
    TxidSnapshotArray,
    Uuid,
    UuidArray,
    TxidSnapshot,
    FdwHandler,
    PgLsn,
    PgLsnArray,
    TsmHandler,
    PgNdistinct,
    PgDependencies,
    Anyenum,
    TsVector,
    Tsquery,
    GtsVector,
    TsVectorArray,
    GtsVectorArray,
    TsqueryArray,
    Regconfig,
    RegconfigArray,
    Regdictionary,
    RegdictionaryArray,
    Jsonb,
    JsonbArray,
    AnyRange,
    EventTrigger,
    Int4Range,
    Int4RangeArray,
    NumRange,
    NumRangeArray,
    TsRange,
    TsRangeArray,
    TstzRange,
    TstzRangeArray,
    DateRange,
    DateRangeArray,
    Int8Range,
    Int8RangeArray,
    Jsonpath,
    JsonpathArray,
    Regnamespace,
    RegnamespaceArray,
    Regrole,
    RegroleArray,
    Regcollation,
    RegcollationArray,
    PgMcvList,
    PgSnapshot,
    PgSnapshotArray,
    Xid8,
    Anycompatible,
    Anycompatiblearray,
    Anycompatiblenonarray,
    AnycompatibleRange,
    Other(Arc<Other>),
}

impl Inner {
    pub fn from_oid(oid: Oid) -> Option<Inner> {
        match oid {
            16 => Some(Inner::Bool),
            17 => Some(Inner::Bytea),
            18 => Some(Inner::Char),
            19 => Some(Inner::Name),
            20 => Some(Inner::Int8),
            21 => Some(Inner::Int2),
            22 => Some(Inner::Int2Vector),
            23 => Some(Inner::Int4),
            24 => Some(Inner::Regproc),
            25 => Some(Inner::Text),
            26 => Some(Inner::Oid),
            27 => Some(Inner::Tid),
            28 => Some(Inner::Xid),
            29 => Some(Inner::Cid),
            30 => Some(Inner::OidVector),
            32 => Some(Inner::PgDdlCommand),
            114 => Some(Inner::Json),
            142 => Some(Inner::Xml),
            143 => Some(Inner::XmlArray),
            194 => Some(Inner::PgNodeTree),
            199 => Some(Inner::JsonArray),
            269 => Some(Inner::TableAmHandler),
            271 => Some(Inner::Xid8Array),
            325 => Some(Inner::IndexAmHandler),
            600 => Some(Inner::Point),
            601 => Some(Inner::Lseg),
            602 => Some(Inner::Path),
            603 => Some(Inner::Box),
            604 => Some(Inner::Polygon),
            628 => Some(Inner::Line),
            629 => Some(Inner::LineArray),
            650 => Some(Inner::Cidr),
            651 => Some(Inner::CidrArray),
            700 => Some(Inner::Float4),
            701 => Some(Inner::Float8),
            705 => Some(Inner::Unknown),
            718 => Some(Inner::Circle),
            719 => Some(Inner::CircleArray),
            774 => Some(Inner::Macaddr8),
            775 => Some(Inner::Macaddr8Array),
            790 => Some(Inner::Money),
            791 => Some(Inner::MoneyArray),
            829 => Some(Inner::Macaddr),
            869 => Some(Inner::Inet),
            1000 => Some(Inner::BoolArray),
            1001 => Some(Inner::ByteaArray),
            1002 => Some(Inner::CharArray),
            1003 => Some(Inner::NameArray),
            1005 => Some(Inner::Int2Array),
            1006 => Some(Inner::Int2VectorArray),
            1007 => Some(Inner::Int4Array),
            1008 => Some(Inner::RegprocArray),
            1009 => Some(Inner::TextArray),
            1010 => Some(Inner::TidArray),
            1011 => Some(Inner::XidArray),
            1012 => Some(Inner::CidArray),
            1013 => Some(Inner::OidVectorArray),
            1014 => Some(Inner::BpcharArray),
            1015 => Some(Inner::VarcharArray),
            1016 => Some(Inner::Int8Array),
            1017 => Some(Inner::PointArray),
            1018 => Some(Inner::LsegArray),
            1019 => Some(Inner::PathArray),
            1020 => Some(Inner::BoxArray),
            1021 => Some(Inner::Float4Array),
            1022 => Some(Inner::Float8Array),
            1027 => Some(Inner::PolygonArray),
            1028 => Some(Inner::OidArray),
            1033 => Some(Inner::Aclitem),
            1034 => Some(Inner::AclitemArray),
            1040 => Some(Inner::MacaddrArray),
            1041 => Some(Inner::InetArray),
            1042 => Some(Inner::Bpchar),
            1043 => Some(Inner::Varchar),
            1082 => Some(Inner::Date),
            1083 => Some(Inner::Time),
            1114 => Some(Inner::Timestamp),
            1115 => Some(Inner::TimestampArray),
            1182 => Some(Inner::DateArray),
            1183 => Some(Inner::TimeArray),
            1184 => Some(Inner::Timestamptz),
            1185 => Some(Inner::TimestamptzArray),
            1186 => Some(Inner::Interval),
            1187 => Some(Inner::IntervalArray),
            1231 => Some(Inner::NumericArray),
            1263 => Some(Inner::CstringArray),
            1266 => Some(Inner::Timetz),
            1270 => Some(Inner::TimetzArray),
            1560 => Some(Inner::Bit),
            1561 => Some(Inner::BitArray),
            1562 => Some(Inner::Varbit),
            1563 => Some(Inner::VarbitArray),
            1700 => Some(Inner::Numeric),
            1790 => Some(Inner::Refcursor),
            2201 => Some(Inner::RefcursorArray),
            2202 => Some(Inner::Regprocedure),
            2203 => Some(Inner::Regoper),
            2204 => Some(Inner::Regoperator),
            2205 => Some(Inner::Regclass),
            2206 => Some(Inner::Regtype),
            2207 => Some(Inner::RegprocedureArray),
            2208 => Some(Inner::RegoperArray),
            2209 => Some(Inner::RegoperatorArray),
            2210 => Some(Inner::RegclassArray),
            2211 => Some(Inner::RegtypeArray),
            2249 => Some(Inner::Record),
            2275 => Some(Inner::Cstring),
            2276 => Some(Inner::Any),
            2277 => Some(Inner::Anyarray),
            2278 => Some(Inner::Void),
            2279 => Some(Inner::Trigger),
            2280 => Some(Inner::LanguageHandler),
            2281 => Some(Inner::Internal),
            2283 => Some(Inner::Anyelement),
            2287 => Some(Inner::RecordArray),
            2776 => Some(Inner::Anynonarray),
            2949 => Some(Inner::TxidSnapshotArray),
            2950 => Some(Inner::Uuid),
            2951 => Some(Inner::UuidArray),
            2970 => Some(Inner::TxidSnapshot),
            3115 => Some(Inner::FdwHandler),
            3220 => Some(Inner::PgLsn),
            3221 => Some(Inner::PgLsnArray),
            3310 => Some(Inner::TsmHandler),
            3361 => Some(Inner::PgNdistinct),
            3402 => Some(Inner::PgDependencies),
            3500 => Some(Inner::Anyenum),
            3614 => Some(Inner::TsVector),
            3615 => Some(Inner::Tsquery),
            3642 => Some(Inner::GtsVector),
            3643 => Some(Inner::TsVectorArray),
            3644 => Some(Inner::GtsVectorArray),
            3645 => Some(Inner::TsqueryArray),
            3734 => Some(Inner::Regconfig),
            3735 => Some(Inner::RegconfigArray),
            3769 => Some(Inner::Regdictionary),
            3770 => Some(Inner::RegdictionaryArray),
            3802 => Some(Inner::Jsonb),
            3807 => Some(Inner::JsonbArray),
            3831 => Some(Inner::AnyRange),
            3838 => Some(Inner::EventTrigger),
            3904 => Some(Inner::Int4Range),
            3905 => Some(Inner::Int4RangeArray),
            3906 => Some(Inner::NumRange),
            3907 => Some(Inner::NumRangeArray),
            3908 => Some(Inner::TsRange),
            3909 => Some(Inner::TsRangeArray),
            3910 => Some(Inner::TstzRange),
            3911 => Some(Inner::TstzRangeArray),
            3912 => Some(Inner::DateRange),
            3913 => Some(Inner::DateRangeArray),
            3926 => Some(Inner::Int8Range),
            3927 => Some(Inner::Int8RangeArray),
            4072 => Some(Inner::Jsonpath),
            4073 => Some(Inner::JsonpathArray),
            4089 => Some(Inner::Regnamespace),
            4090 => Some(Inner::RegnamespaceArray),
            4096 => Some(Inner::Regrole),
            4097 => Some(Inner::RegroleArray),
            4191 => Some(Inner::Regcollation),
            4192 => Some(Inner::RegcollationArray),
            5017 => Some(Inner::PgMcvList),
            5038 => Some(Inner::PgSnapshot),
            5039 => Some(Inner::PgSnapshotArray),
            5069 => Some(Inner::Xid8),
            5077 => Some(Inner::Anycompatible),
            5078 => Some(Inner::Anycompatiblearray),
            5079 => Some(Inner::Anycompatiblenonarray),
            5080 => Some(Inner::AnycompatibleRange),
            _ => None,
        }
    }

    pub fn oid(&self) -> Oid {
        match *self {
            Inner::Bool => 16,
            Inner::Bytea => 17,
            Inner::Char => 18,
            Inner::Name => 19,
            Inner::Int8 => 20,
            Inner::Int2 => 21,
            Inner::Int2Vector => 22,
            Inner::Int4 => 23,
            Inner::Regproc => 24,
            Inner::Text => 25,
            Inner::Oid => 26,
            Inner::Tid => 27,
            Inner::Xid => 28,
            Inner::Cid => 29,
            Inner::OidVector => 30,
            Inner::PgDdlCommand => 32,
            Inner::Json => 114,
            Inner::Xml => 142,
            Inner::XmlArray => 143,
            Inner::PgNodeTree => 194,
            Inner::JsonArray => 199,
            Inner::TableAmHandler => 269,
            Inner::Xid8Array => 271,
            Inner::IndexAmHandler => 325,
            Inner::Point => 600,
            Inner::Lseg => 601,
            Inner::Path => 602,
            Inner::Box => 603,
            Inner::Polygon => 604,
            Inner::Line => 628,
            Inner::LineArray => 629,
            Inner::Cidr => 650,
            Inner::CidrArray => 651,
            Inner::Float4 => 700,
            Inner::Float8 => 701,
            Inner::Unknown => 705,
            Inner::Circle => 718,
            Inner::CircleArray => 719,
            Inner::Macaddr8 => 774,
            Inner::Macaddr8Array => 775,
            Inner::Money => 790,
            Inner::MoneyArray => 791,
            Inner::Macaddr => 829,
            Inner::Inet => 869,
            Inner::BoolArray => 1000,
            Inner::ByteaArray => 1001,
            Inner::CharArray => 1002,
            Inner::NameArray => 1003,
            Inner::Int2Array => 1005,
            Inner::Int2VectorArray => 1006,
            Inner::Int4Array => 1007,
            Inner::RegprocArray => 1008,
            Inner::TextArray => 1009,
            Inner::TidArray => 1010,
            Inner::XidArray => 1011,
            Inner::CidArray => 1012,
            Inner::OidVectorArray => 1013,
            Inner::BpcharArray => 1014,
            Inner::VarcharArray => 1015,
            Inner::Int8Array => 1016,
            Inner::PointArray => 1017,
            Inner::LsegArray => 1018,
            Inner::PathArray => 1019,
            Inner::BoxArray => 1020,
            Inner::Float4Array => 1021,
            Inner::Float8Array => 1022,
            Inner::PolygonArray => 1027,
            Inner::OidArray => 1028,
            Inner::Aclitem => 1033,
            Inner::AclitemArray => 1034,
            Inner::MacaddrArray => 1040,
            Inner::InetArray => 1041,
            Inner::Bpchar => 1042,
            Inner::Varchar => 1043,
            Inner::Date => 1082,
            Inner::Time => 1083,
            Inner::Timestamp => 1114,
            Inner::TimestampArray => 1115,
            Inner::DateArray => 1182,
            Inner::TimeArray => 1183,
            Inner::Timestamptz => 1184,
            Inner::TimestamptzArray => 1185,
            Inner::Interval => 1186,
            Inner::IntervalArray => 1187,
            Inner::NumericArray => 1231,
            Inner::CstringArray => 1263,
            Inner::Timetz => 1266,
            Inner::TimetzArray => 1270,
            Inner::Bit => 1560,
            Inner::BitArray => 1561,
            Inner::Varbit => 1562,
            Inner::VarbitArray => 1563,
            Inner::Numeric => 1700,
            Inner::Refcursor => 1790,
            Inner::RefcursorArray => 2201,
            Inner::Regprocedure => 2202,
            Inner::Regoper => 2203,
            Inner::Regoperator => 2204,
            Inner::Regclass => 2205,
            Inner::Regtype => 2206,
            Inner::RegprocedureArray => 2207,
            Inner::RegoperArray => 2208,
            Inner::RegoperatorArray => 2209,
            Inner::RegclassArray => 2210,
            Inner::RegtypeArray => 2211,
            Inner::Record => 2249,
            Inner::Cstring => 2275,
            Inner::Any => 2276,
            Inner::Anyarray => 2277,
            Inner::Void => 2278,
            Inner::Trigger => 2279,
            Inner::LanguageHandler => 2280,
            Inner::Internal => 2281,
            Inner::Anyelement => 2283,
            Inner::RecordArray => 2287,
            Inner::Anynonarray => 2776,
            Inner::TxidSnapshotArray => 2949,
            Inner::Uuid => 2950,
            Inner::UuidArray => 2951,
            Inner::TxidSnapshot => 2970,
            Inner::FdwHandler => 3115,
            Inner::PgLsn => 3220,
            Inner::PgLsnArray => 3221,
            Inner::TsmHandler => 3310,
            Inner::PgNdistinct => 3361,
            Inner::PgDependencies => 3402,
            Inner::Anyenum => 3500,
            Inner::TsVector => 3614,
            Inner::Tsquery => 3615,
            Inner::GtsVector => 3642,
            Inner::TsVectorArray => 3643,
            Inner::GtsVectorArray => 3644,
            Inner::TsqueryArray => 3645,
            Inner::Regconfig => 3734,
            Inner::RegconfigArray => 3735,
            Inner::Regdictionary => 3769,
            Inner::RegdictionaryArray => 3770,
            Inner::Jsonb => 3802,
            Inner::JsonbArray => 3807,
            Inner::AnyRange => 3831,
            Inner::EventTrigger => 3838,
            Inner::Int4Range => 3904,
            Inner::Int4RangeArray => 3905,
            Inner::NumRange => 3906,
            Inner::NumRangeArray => 3907,
            Inner::TsRange => 3908,
            Inner::TsRangeArray => 3909,
            Inner::TstzRange => 3910,
            Inner::TstzRangeArray => 3911,
            Inner::DateRange => 3912,
            Inner::DateRangeArray => 3913,
            Inner::Int8Range => 3926,
            Inner::Int8RangeArray => 3927,
            Inner::Jsonpath => 4072,
            Inner::JsonpathArray => 4073,
            Inner::Regnamespace => 4089,
            Inner::RegnamespaceArray => 4090,
            Inner::Regrole => 4096,
            Inner::RegroleArray => 4097,
            Inner::Regcollation => 4191,
            Inner::RegcollationArray => 4192,
            Inner::PgMcvList => 5017,
            Inner::PgSnapshot => 5038,
            Inner::PgSnapshotArray => 5039,
            Inner::Xid8 => 5069,
            Inner::Anycompatible => 5077,
            Inner::Anycompatiblearray => 5078,
            Inner::Anycompatiblenonarray => 5079,
            Inner::AnycompatibleRange => 5080,
            Inner::Other(ref u) => u.oid,
        }
    }

    pub fn kind(&self) -> &Kind {
        match *self {
            Inner::Bool => &Kind::Simple,
            Inner::Bytea => &Kind::Simple,
            Inner::Char => &Kind::Simple,
            Inner::Name => &Kind::Simple,
            Inner::Int8 => &Kind::Simple,
            Inner::Int2 => &Kind::Simple,
            Inner::Int2Vector => &Kind::Array(Type(Inner::Int2)),
            Inner::Int4 => &Kind::Simple,
            Inner::Regproc => &Kind::Simple,
            Inner::Text => &Kind::Simple,
            Inner::Oid => &Kind::Simple,
            Inner::Tid => &Kind::Simple,
            Inner::Xid => &Kind::Simple,
            Inner::Cid => &Kind::Simple,
            Inner::OidVector => &Kind::Array(Type(Inner::Oid)),
            Inner::PgDdlCommand => &Kind::Pseudo,
            Inner::Json => &Kind::Simple,
            Inner::Xml => &Kind::Simple,
            Inner::XmlArray => &Kind::Array(Type(Inner::Xml)),
            Inner::PgNodeTree => &Kind::Simple,
            Inner::JsonArray => &Kind::Array(Type(Inner::Json)),
            Inner::TableAmHandler => &Kind::Pseudo,
            Inner::Xid8Array => &Kind::Array(Type(Inner::Xid8)),
            Inner::IndexAmHandler => &Kind::Pseudo,
            Inner::Point => &Kind::Simple,
            Inner::Lseg => &Kind::Simple,
            Inner::Path => &Kind::Simple,
            Inner::Box => &Kind::Simple,
            Inner::Polygon => &Kind::Simple,
            Inner::Line => &Kind::Simple,
            Inner::LineArray => &Kind::Array(Type(Inner::Line)),
            Inner::Cidr => &Kind::Simple,
            Inner::CidrArray => &Kind::Array(Type(Inner::Cidr)),
            Inner::Float4 => &Kind::Simple,
            Inner::Float8 => &Kind::Simple,
            Inner::Unknown => &Kind::Simple,
            Inner::Circle => &Kind::Simple,
            Inner::CircleArray => &Kind::Array(Type(Inner::Circle)),
            Inner::Macaddr8 => &Kind::Simple,
            Inner::Macaddr8Array => &Kind::Array(Type(Inner::Macaddr8)),
            Inner::Money => &Kind::Simple,
            Inner::MoneyArray => &Kind::Array(Type(Inner::Money)),
            Inner::Macaddr => &Kind::Simple,
            Inner::Inet => &Kind::Simple,
            Inner::BoolArray => &Kind::Array(Type(Inner::Bool)),
            Inner::ByteaArray => &Kind::Array(Type(Inner::Bytea)),
            Inner::CharArray => &Kind::Array(Type(Inner::Char)),
            Inner::NameArray => &Kind::Array(Type(Inner::Name)),
            Inner::Int2Array => &Kind::Array(Type(Inner::Int2)),
            Inner::Int2VectorArray => &Kind::Array(Type(Inner::Int2Vector)),
            Inner::Int4Array => &Kind::Array(Type(Inner::Int4)),
            Inner::RegprocArray => &Kind::Array(Type(Inner::Regproc)),
            Inner::TextArray => &Kind::Array(Type(Inner::Text)),
            Inner::TidArray => &Kind::Array(Type(Inner::Tid)),
            Inner::XidArray => &Kind::Array(Type(Inner::Xid)),
            Inner::CidArray => &Kind::Array(Type(Inner::Cid)),
            Inner::OidVectorArray => &Kind::Array(Type(Inner::OidVector)),
            Inner::BpcharArray => &Kind::Array(Type(Inner::Bpchar)),
            Inner::VarcharArray => &Kind::Array(Type(Inner::Varchar)),
            Inner::Int8Array => &Kind::Array(Type(Inner::Int8)),
            Inner::PointArray => &Kind::Array(Type(Inner::Point)),
            Inner::LsegArray => &Kind::Array(Type(Inner::Lseg)),
            Inner::PathArray => &Kind::Array(Type(Inner::Path)),
            Inner::BoxArray => &Kind::Array(Type(Inner::Box)),
            Inner::Float4Array => &Kind::Array(Type(Inner::Float4)),
            Inner::Float8Array => &Kind::Array(Type(Inner::Float8)),
            Inner::PolygonArray => &Kind::Array(Type(Inner::Polygon)),
            Inner::OidArray => &Kind::Array(Type(Inner::Oid)),
            Inner::Aclitem => &Kind::Simple,
            Inner::AclitemArray => &Kind::Array(Type(Inner::Aclitem)),
            Inner::MacaddrArray => &Kind::Array(Type(Inner::Macaddr)),
            Inner::InetArray => &Kind::Array(Type(Inner::Inet)),
            Inner::Bpchar => &Kind::Simple,
            Inner::Varchar => &Kind::Simple,
            Inner::Date => &Kind::Simple,
            Inner::Time => &Kind::Simple,
            Inner::Timestamp => &Kind::Simple,
            Inner::TimestampArray => &Kind::Array(Type(Inner::Timestamp)),
            Inner::DateArray => &Kind::Array(Type(Inner::Date)),
            Inner::TimeArray => &Kind::Array(Type(Inner::Time)),
            Inner::Timestamptz => &Kind::Simple,
            Inner::TimestamptzArray => &Kind::Array(Type(Inner::Timestamptz)),
            Inner::Interval => &Kind::Simple,
            Inner::IntervalArray => &Kind::Array(Type(Inner::Interval)),
            Inner::NumericArray => &Kind::Array(Type(Inner::Numeric)),
            Inner::CstringArray => &Kind::Array(Type(Inner::Cstring)),
            Inner::Timetz => &Kind::Simple,
            Inner::TimetzArray => &Kind::Array(Type(Inner::Timetz)),
            Inner::Bit => &Kind::Simple,
            Inner::BitArray => &Kind::Array(Type(Inner::Bit)),
            Inner::Varbit => &Kind::Simple,
            Inner::VarbitArray => &Kind::Array(Type(Inner::Varbit)),
            Inner::Numeric => &Kind::Simple,
            Inner::Refcursor => &Kind::Simple,
            Inner::RefcursorArray => &Kind::Array(Type(Inner::Refcursor)),
            Inner::Regprocedure => &Kind::Simple,
            Inner::Regoper => &Kind::Simple,
            Inner::Regoperator => &Kind::Simple,
            Inner::Regclass => &Kind::Simple,
            Inner::Regtype => &Kind::Simple,
            Inner::RegprocedureArray => &Kind::Array(Type(Inner::Regprocedure)),
            Inner::RegoperArray => &Kind::Array(Type(Inner::Regoper)),
            Inner::RegoperatorArray => &Kind::Array(Type(Inner::Regoperator)),
            Inner::RegclassArray => &Kind::Array(Type(Inner::Regclass)),
            Inner::RegtypeArray => &Kind::Array(Type(Inner::Regtype)),
            Inner::Record => &Kind::Pseudo,
            Inner::Cstring => &Kind::Pseudo,
            Inner::Any => &Kind::Pseudo,
            Inner::Anyarray => &Kind::Pseudo,
            Inner::Void => &Kind::Pseudo,
            Inner::Trigger => &Kind::Pseudo,
            Inner::LanguageHandler => &Kind::Pseudo,
            Inner::Internal => &Kind::Pseudo,
            Inner::Anyelement => &Kind::Pseudo,
            Inner::RecordArray => &Kind::Pseudo,
            Inner::Anynonarray => &Kind::Pseudo,
            Inner::TxidSnapshotArray => &Kind::Array(Type(Inner::TxidSnapshot)),
            Inner::Uuid => &Kind::Simple,
            Inner::UuidArray => &Kind::Array(Type(Inner::Uuid)),
            Inner::TxidSnapshot => &Kind::Simple,
            Inner::FdwHandler => &Kind::Pseudo,
            Inner::PgLsn => &Kind::Simple,
            Inner::PgLsnArray => &Kind::Array(Type(Inner::PgLsn)),
            Inner::TsmHandler => &Kind::Pseudo,
            Inner::PgNdistinct => &Kind::Simple,
            Inner::PgDependencies => &Kind::Simple,
            Inner::Anyenum => &Kind::Pseudo,
            Inner::TsVector => &Kind::Simple,
            Inner::Tsquery => &Kind::Simple,
            Inner::GtsVector => &Kind::Simple,
            Inner::TsVectorArray => &Kind::Array(Type(Inner::TsVector)),
            Inner::GtsVectorArray => &Kind::Array(Type(Inner::GtsVector)),
            Inner::TsqueryArray => &Kind::Array(Type(Inner::Tsquery)),
            Inner::Regconfig => &Kind::Simple,
            Inner::RegconfigArray => &Kind::Array(Type(Inner::Regconfig)),
            Inner::Regdictionary => &Kind::Simple,
            Inner::RegdictionaryArray => &Kind::Array(Type(Inner::Regdictionary)),
            Inner::Jsonb => &Kind::Simple,
            Inner::JsonbArray => &Kind::Array(Type(Inner::Jsonb)),
            Inner::AnyRange => &Kind::Pseudo,
            Inner::EventTrigger => &Kind::Pseudo,
            Inner::Int4Range => &Kind::Range(Type(Inner::Int4)),
            Inner::Int4RangeArray => &Kind::Array(Type(Inner::Int4Range)),
            Inner::NumRange => &Kind::Range(Type(Inner::Numeric)),
            Inner::NumRangeArray => &Kind::Array(Type(Inner::NumRange)),
            Inner::TsRange => &Kind::Range(Type(Inner::Timestamp)),
            Inner::TsRangeArray => &Kind::Array(Type(Inner::TsRange)),
            Inner::TstzRange => &Kind::Range(Type(Inner::Timestamptz)),
            Inner::TstzRangeArray => &Kind::Array(Type(Inner::TstzRange)),
            Inner::DateRange => &Kind::Range(Type(Inner::Date)),
            Inner::DateRangeArray => &Kind::Array(Type(Inner::DateRange)),
            Inner::Int8Range => &Kind::Range(Type(Inner::Int8)),
            Inner::Int8RangeArray => &Kind::Array(Type(Inner::Int8Range)),
            Inner::Jsonpath => &Kind::Simple,
            Inner::JsonpathArray => &Kind::Array(Type(Inner::Jsonpath)),
            Inner::Regnamespace => &Kind::Simple,
            Inner::RegnamespaceArray => &Kind::Array(Type(Inner::Regnamespace)),
            Inner::Regrole => &Kind::Simple,
            Inner::RegroleArray => &Kind::Array(Type(Inner::Regrole)),
            Inner::Regcollation => &Kind::Simple,
            Inner::RegcollationArray => &Kind::Array(Type(Inner::Regcollation)),
            Inner::PgMcvList => &Kind::Simple,
            Inner::PgSnapshot => &Kind::Simple,
            Inner::PgSnapshotArray => &Kind::Array(Type(Inner::PgSnapshot)),
            Inner::Xid8 => &Kind::Simple,
            Inner::Anycompatible => &Kind::Pseudo,
            Inner::Anycompatiblearray => &Kind::Pseudo,
            Inner::Anycompatiblenonarray => &Kind::Pseudo,
            Inner::AnycompatibleRange => &Kind::Pseudo,
            Inner::Other(ref u) => &u.kind,
        }
    }

    pub fn name(&self) -> &str {
        match *self {
            Inner::Bool => "bool",
            Inner::Bytea => "bytea",
            Inner::Char => "char",
            Inner::Name => "name",
            Inner::Int8 => "int8",
            Inner::Int2 => "int2",
            Inner::Int2Vector => "int2vector",
            Inner::Int4 => "int4",
            Inner::Regproc => "regproc",
            Inner::Text => "text",
            Inner::Oid => "oid",
            Inner::Tid => "tid",
            Inner::Xid => "xid",
            Inner::Cid => "cid",
            Inner::OidVector => "oidvector",
            Inner::PgDdlCommand => "pg_ddl_command",
            Inner::Json => "json",
            Inner::Xml => "xml",
            Inner::XmlArray => "_xml",
            Inner::PgNodeTree => "pg_node_tree",
            Inner::JsonArray => "_json",
            Inner::TableAmHandler => "table_am_handler",
            Inner::Xid8Array => "_xid8",
            Inner::IndexAmHandler => "index_am_handler",
            Inner::Point => "point",
            Inner::Lseg => "lseg",
            Inner::Path => "path",
            Inner::Box => "box",
            Inner::Polygon => "polygon",
            Inner::Line => "line",
            Inner::LineArray => "_line",
            Inner::Cidr => "cidr",
            Inner::CidrArray => "_cidr",
            Inner::Float4 => "float4",
            Inner::Float8 => "float8",
            Inner::Unknown => "unknown",
            Inner::Circle => "circle",
            Inner::CircleArray => "_circle",
            Inner::Macaddr8 => "macaddr8",
            Inner::Macaddr8Array => "_macaddr8",
            Inner::Money => "money",
            Inner::MoneyArray => "_money",
            Inner::Macaddr => "macaddr",
            Inner::Inet => "inet",
            Inner::BoolArray => "_bool",
            Inner::ByteaArray => "_bytea",
            Inner::CharArray => "_char",
            Inner::NameArray => "_name",
            Inner::Int2Array => "_int2",
            Inner::Int2VectorArray => "_int2vector",
            Inner::Int4Array => "_int4",
            Inner::RegprocArray => "_regproc",
            Inner::TextArray => "_text",
            Inner::TidArray => "_tid",
            Inner::XidArray => "_xid",
            Inner::CidArray => "_cid",
            Inner::OidVectorArray => "_oidvector",
            Inner::BpcharArray => "_bpchar",
            Inner::VarcharArray => "_varchar",
            Inner::Int8Array => "_int8",
            Inner::PointArray => "_point",
            Inner::LsegArray => "_lseg",
            Inner::PathArray => "_path",
            Inner::BoxArray => "_box",
            Inner::Float4Array => "_float4",
            Inner::Float8Array => "_float8",
            Inner::PolygonArray => "_polygon",
            Inner::OidArray => "_oid",
            Inner::Aclitem => "aclitem",
            Inner::AclitemArray => "_aclitem",
            Inner::MacaddrArray => "_macaddr",
            Inner::InetArray => "_inet",
            Inner::Bpchar => "bpchar",
            Inner::Varchar => "varchar",
            Inner::Date => "date",
            Inner::Time => "time",
            Inner::Timestamp => "timestamp",
            Inner::TimestampArray => "_timestamp",
            Inner::DateArray => "_date",
            Inner::TimeArray => "_time",
            Inner::Timestamptz => "timestamptz",
            Inner::TimestamptzArray => "_timestamptz",
            Inner::Interval => "interval",
            Inner::IntervalArray => "_interval",
            Inner::NumericArray => "_numeric",
            Inner::CstringArray => "_cstring",
            Inner::Timetz => "timetz",
            Inner::TimetzArray => "_timetz",
            Inner::Bit => "bit",
            Inner::BitArray => "_bit",
            Inner::Varbit => "varbit",
            Inner::VarbitArray => "_varbit",
            Inner::Numeric => "numeric",
            Inner::Refcursor => "refcursor",
            Inner::RefcursorArray => "_refcursor",
            Inner::Regprocedure => "regprocedure",
            Inner::Regoper => "regoper",
            Inner::Regoperator => "regoperator",
            Inner::Regclass => "regclass",
            Inner::Regtype => "regtype",
            Inner::RegprocedureArray => "_regprocedure",
            Inner::RegoperArray => "_regoper",
            Inner::RegoperatorArray => "_regoperator",
            Inner::RegclassArray => "_regclass",
            Inner::RegtypeArray => "_regtype",
            Inner::Record => "record",
            Inner::Cstring => "cstring",
            Inner::Any => "any",
            Inner::Anyarray => "anyarray",
            Inner::Void => "void",
            Inner::Trigger => "trigger",
            Inner::LanguageHandler => "language_handler",
            Inner::Internal => "internal",
            Inner::Anyelement => "anyelement",
            Inner::RecordArray => "_record",
            Inner::Anynonarray => "anynonarray",
            Inner::TxidSnapshotArray => "_txid_snapshot",
            Inner::Uuid => "uuid",
            Inner::UuidArray => "_uuid",
            Inner::TxidSnapshot => "txid_snapshot",
            Inner::FdwHandler => "fdw_handler",
            Inner::PgLsn => "pg_lsn",
            Inner::PgLsnArray => "_pg_lsn",
            Inner::TsmHandler => "tsm_handler",
            Inner::PgNdistinct => "pg_ndistinct",
            Inner::PgDependencies => "pg_dependencies",
            Inner::Anyenum => "anyenum",
            Inner::TsVector => "tsvector",
            Inner::Tsquery => "tsquery",
            Inner::GtsVector => "gtsvector",
            Inner::TsVectorArray => "_tsvector",
            Inner::GtsVectorArray => "_gtsvector",
            Inner::TsqueryArray => "_tsquery",
            Inner::Regconfig => "regconfig",
            Inner::RegconfigArray => "_regconfig",
            Inner::Regdictionary => "regdictionary",
            Inner::RegdictionaryArray => "_regdictionary",
            Inner::Jsonb => "jsonb",
            Inner::JsonbArray => "_jsonb",
            Inner::AnyRange => "anyrange",
            Inner::EventTrigger => "event_trigger",
            Inner::Int4Range => "int4range",
            Inner::Int4RangeArray => "_int4range",
            Inner::NumRange => "numrange",
            Inner::NumRangeArray => "_numrange",
            Inner::TsRange => "tsrange",
            Inner::TsRangeArray => "_tsrange",
            Inner::TstzRange => "tstzrange",
            Inner::TstzRangeArray => "_tstzrange",
            Inner::DateRange => "daterange",
            Inner::DateRangeArray => "_daterange",
            Inner::Int8Range => "int8range",
            Inner::Int8RangeArray => "_int8range",
            Inner::Jsonpath => "jsonpath",
            Inner::JsonpathArray => "_jsonpath",
            Inner::Regnamespace => "regnamespace",
            Inner::RegnamespaceArray => "_regnamespace",
            Inner::Regrole => "regrole",
            Inner::RegroleArray => "_regrole",
            Inner::Regcollation => "regcollation",
            Inner::RegcollationArray => "_regcollation",
            Inner::PgMcvList => "pg_mcv_list",
            Inner::PgSnapshot => "pg_snapshot",
            Inner::PgSnapshotArray => "_pg_snapshot",
            Inner::Xid8 => "xid8",
            Inner::Anycompatible => "anycompatible",
            Inner::Anycompatiblearray => "anycompatiblearray",
            Inner::Anycompatiblenonarray => "anycompatiblenonarray",
            Inner::AnycompatibleRange => "anycompatiblerange",
            Inner::Other(ref u) => &u.name,
        }
    }
}
impl Type {
    /// BOOL - boolean, &#39;true&#39;/&#39;false&#39;
    pub const BOOL: Type = Type(Inner::Bool);

    /// BYTEA - variable-length string, binary values escaped
    pub const BYTEA: Type = Type(Inner::Bytea);

    /// CHAR - single character
    pub const CHAR: Type = Type(Inner::Char);

    /// NAME - 63-byte type for storing system identifiers
    pub const NAME: Type = Type(Inner::Name);

    /// INT8 - ~18 digit integer, 8-byte storage
    pub const INT8: Type = Type(Inner::Int8);

    /// INT2 - -32 thousand to 32 thousand, 2-byte storage
    pub const INT2: Type = Type(Inner::Int2);

    /// INT2VECTOR - array of int2, used in system tables
    pub const INT2_VECTOR: Type = Type(Inner::Int2Vector);

    /// INT4 - -2 billion to 2 billion integer, 4-byte storage
    pub const INT4: Type = Type(Inner::Int4);

    /// REGPROC - registered procedure
    pub const REGPROC: Type = Type(Inner::Regproc);

    /// TEXT - variable-length string, no limit specified
    pub const TEXT: Type = Type(Inner::Text);

    /// OID - object identifier&#40;oid&#41;, maximum 4 billion
    pub const OID: Type = Type(Inner::Oid);

    /// TID - &#40;block, offset&#41;, physical location of tuple
    pub const TID: Type = Type(Inner::Tid);

    /// XID - transaction id
    pub const XID: Type = Type(Inner::Xid);

    /// CID - command identifier type, sequence in transaction id
    pub const CID: Type = Type(Inner::Cid);

    /// OIDVECTOR - array of oids, used in system tables
    pub const OID_VECTOR: Type = Type(Inner::OidVector);

    /// PG_DDL_COMMAND - internal type for passing CollectedCommand
    pub const PG_DDL_COMMAND: Type = Type(Inner::PgDdlCommand);

    /// JSON - JSON stored as text
    pub const JSON: Type = Type(Inner::Json);

    /// XML - XML content
    pub const XML: Type = Type(Inner::Xml);

    /// XML&#91;&#93;
    pub const XML_ARRAY: Type = Type(Inner::XmlArray);

    /// PG_NODE_TREE - string representing an internal node tree
    pub const PG_NODE_TREE: Type = Type(Inner::PgNodeTree);

    /// JSON&#91;&#93;
    pub const JSON_ARRAY: Type = Type(Inner::JsonArray);

    /// TABLE_AM_HANDLER
    pub const TABLE_AM_HANDLER: Type = Type(Inner::TableAmHandler);

    /// XID8&#91;&#93;
    pub const XID8_ARRAY: Type = Type(Inner::Xid8Array);

    /// INDEX_AM_HANDLER - pseudo-type for the result of an index AM handler function
    pub const INDEX_AM_HANDLER: Type = Type(Inner::IndexAmHandler);

    /// POINT - geometric point &#39;&#40;x, y&#41;&#39;
    pub const POINT: Type = Type(Inner::Point);

    /// LSEG - geometric line segment &#39;&#40;pt1,pt2&#41;&#39;
    pub const LSEG: Type = Type(Inner::Lseg);

    /// PATH - geometric path &#39;&#40;pt1,...&#41;&#39;
    pub const PATH: Type = Type(Inner::Path);

    /// BOX - geometric box &#39;&#40;lower left,upper right&#41;&#39;
    pub const BOX: Type = Type(Inner::Box);

    /// POLYGON - geometric polygon &#39;&#40;pt1,...&#41;&#39;
    pub const POLYGON: Type = Type(Inner::Polygon);

    /// LINE - geometric line
    pub const LINE: Type = Type(Inner::Line);

    /// LINE&#91;&#93;
    pub const LINE_ARRAY: Type = Type(Inner::LineArray);

    /// CIDR - network IP address/netmask, network address
    pub const CIDR: Type = Type(Inner::Cidr);

    /// CIDR&#91;&#93;
    pub const CIDR_ARRAY: Type = Type(Inner::CidrArray);

    /// FLOAT4 - single-precision floating point number, 4-byte storage
    pub const FLOAT4: Type = Type(Inner::Float4);

    /// FLOAT8 - double-precision floating point number, 8-byte storage
    pub const FLOAT8: Type = Type(Inner::Float8);

    /// UNKNOWN - pseudo-type representing an undetermined type
    pub const UNKNOWN: Type = Type(Inner::Unknown);

    /// CIRCLE - geometric circle &#39;&#40;center,radius&#41;&#39;
    pub const CIRCLE: Type = Type(Inner::Circle);

    /// CIRCLE&#91;&#93;
    pub const CIRCLE_ARRAY: Type = Type(Inner::CircleArray);

    /// MACADDR8 - XX:XX:XX:XX:XX:XX:XX:XX, MAC address
    pub const MACADDR8: Type = Type(Inner::Macaddr8);

    /// MACADDR8&#91;&#93;
    pub const MACADDR8_ARRAY: Type = Type(Inner::Macaddr8Array);

    /// MONEY - monetary amounts, &#36;d,ddd.cc
    pub const MONEY: Type = Type(Inner::Money);

    /// MONEY&#91;&#93;
    pub const MONEY_ARRAY: Type = Type(Inner::MoneyArray);

    /// MACADDR - XX:XX:XX:XX:XX:XX, MAC address
    pub const MACADDR: Type = Type(Inner::Macaddr);

    /// INET - IP address/netmask, host address, netmask optional
    pub const INET: Type = Type(Inner::Inet);

    /// BOOL&#91;&#93;
    pub const BOOL_ARRAY: Type = Type(Inner::BoolArray);

    /// BYTEA&#91;&#93;
    pub const BYTEA_ARRAY: Type = Type(Inner::ByteaArray);

    /// CHAR&#91;&#93;
    pub const CHAR_ARRAY: Type = Type(Inner::CharArray);

    /// NAME&#91;&#93;
    pub const NAME_ARRAY: Type = Type(Inner::NameArray);

    /// INT2&#91;&#93;
    pub const INT2_ARRAY: Type = Type(Inner::Int2Array);

    /// INT2VECTOR&#91;&#93;
    pub const INT2_VECTOR_ARRAY: Type = Type(Inner::Int2VectorArray);

    /// INT4&#91;&#93;
    pub const INT4_ARRAY: Type = Type(Inner::Int4Array);

    /// REGPROC&#91;&#93;
    pub const REGPROC_ARRAY: Type = Type(Inner::RegprocArray);

    /// TEXT&#91;&#93;
    pub const TEXT_ARRAY: Type = Type(Inner::TextArray);

    /// TID&#91;&#93;
    pub const TID_ARRAY: Type = Type(Inner::TidArray);

    /// XID&#91;&#93;
    pub const XID_ARRAY: Type = Type(Inner::XidArray);

    /// CID&#91;&#93;
    pub const CID_ARRAY: Type = Type(Inner::CidArray);

    /// OIDVECTOR&#91;&#93;
    pub const OID_VECTOR_ARRAY: Type = Type(Inner::OidVectorArray);

    /// BPCHAR&#91;&#93;
    pub const BPCHAR_ARRAY: Type = Type(Inner::BpcharArray);

    /// VARCHAR&#91;&#93;
    pub const VARCHAR_ARRAY: Type = Type(Inner::VarcharArray);

    /// INT8&#91;&#93;
    pub const INT8_ARRAY: Type = Type(Inner::Int8Array);

    /// POINT&#91;&#93;
    pub const POINT_ARRAY: Type = Type(Inner::PointArray);

    /// LSEG&#91;&#93;
    pub const LSEG_ARRAY: Type = Type(Inner::LsegArray);

    /// PATH&#91;&#93;
    pub const PATH_ARRAY: Type = Type(Inner::PathArray);

    /// BOX&#91;&#93;
    pub const BOX_ARRAY: Type = Type(Inner::BoxArray);

    /// FLOAT4&#91;&#93;
    pub const FLOAT4_ARRAY: Type = Type(Inner::Float4Array);

    /// FLOAT8&#91;&#93;
    pub const FLOAT8_ARRAY: Type = Type(Inner::Float8Array);

    /// POLYGON&#91;&#93;
    pub const POLYGON_ARRAY: Type = Type(Inner::PolygonArray);

    /// OID&#91;&#93;
    pub const OID_ARRAY: Type = Type(Inner::OidArray);

    /// ACLITEM - access control list
    pub const ACLITEM: Type = Type(Inner::Aclitem);

    /// ACLITEM&#91;&#93;
    pub const ACLITEM_ARRAY: Type = Type(Inner::AclitemArray);

    /// MACADDR&#91;&#93;
    pub const MACADDR_ARRAY: Type = Type(Inner::MacaddrArray);

    /// INET&#91;&#93;
    pub const INET_ARRAY: Type = Type(Inner::InetArray);

    /// BPCHAR - char&#40;length&#41;, blank-padded string, fixed storage length
    pub const BPCHAR: Type = Type(Inner::Bpchar);

    /// VARCHAR - varchar&#40;length&#41;, non-blank-padded string, variable storage length
    pub const VARCHAR: Type = Type(Inner::Varchar);

    /// DATE - date
    pub const DATE: Type = Type(Inner::Date);

    /// TIME - time of day
    pub const TIME: Type = Type(Inner::Time);

    /// TIMESTAMP - date and time
    pub const TIMESTAMP: Type = Type(Inner::Timestamp);

    /// TIMESTAMP&#91;&#93;
    pub const TIMESTAMP_ARRAY: Type = Type(Inner::TimestampArray);

    /// DATE&#91;&#93;
    pub const DATE_ARRAY: Type = Type(Inner::DateArray);

    /// TIME&#91;&#93;
    pub const TIME_ARRAY: Type = Type(Inner::TimeArray);

    /// TIMESTAMPTZ - date and time with time zone
    pub const TIMESTAMPTZ: Type = Type(Inner::Timestamptz);

    /// TIMESTAMPTZ&#91;&#93;
    pub const TIMESTAMPTZ_ARRAY: Type = Type(Inner::TimestamptzArray);

    /// INTERVAL - &#64; &lt;number&gt; &lt;units&gt;, time interval
    pub const INTERVAL: Type = Type(Inner::Interval);

    /// INTERVAL&#91;&#93;
    pub const INTERVAL_ARRAY: Type = Type(Inner::IntervalArray);

    /// NUMERIC&#91;&#93;
    pub const NUMERIC_ARRAY: Type = Type(Inner::NumericArray);

    /// CSTRING&#91;&#93;
    pub const CSTRING_ARRAY: Type = Type(Inner::CstringArray);

    /// TIMETZ - time of day with time zone
    pub const TIMETZ: Type = Type(Inner::Timetz);

    /// TIMETZ&#91;&#93;
    pub const TIMETZ_ARRAY: Type = Type(Inner::TimetzArray);

    /// BIT - fixed-length bit string
    pub const BIT: Type = Type(Inner::Bit);

    /// BIT&#91;&#93;
    pub const BIT_ARRAY: Type = Type(Inner::BitArray);

    /// VARBIT - variable-length bit string
    pub const VARBIT: Type = Type(Inner::Varbit);

    /// VARBIT&#91;&#93;
    pub const VARBIT_ARRAY: Type = Type(Inner::VarbitArray);

    /// NUMERIC - numeric&#40;precision, decimal&#41;, arbitrary precision number
    pub const NUMERIC: Type = Type(Inner::Numeric);

    /// REFCURSOR - reference to cursor &#40;portal name&#41;
    pub const REFCURSOR: Type = Type(Inner::Refcursor);

    /// REFCURSOR&#91;&#93;
    pub const REFCURSOR_ARRAY: Type = Type(Inner::RefcursorArray);

    /// REGPROCEDURE - registered procedure &#40;with args&#41;
    pub const REGPROCEDURE: Type = Type(Inner::Regprocedure);

    /// REGOPER - registered operator
    pub const REGOPER: Type = Type(Inner::Regoper);

    /// REGOPERATOR - registered operator &#40;with args&#41;
    pub const REGOPERATOR: Type = Type(Inner::Regoperator);

    /// REGCLASS - registered class
    pub const REGCLASS: Type = Type(Inner::Regclass);

    /// REGTYPE - registered type
    pub const REGTYPE: Type = Type(Inner::Regtype);

    /// REGPROCEDURE&#91;&#93;
    pub const REGPROCEDURE_ARRAY: Type = Type(Inner::RegprocedureArray);

    /// REGOPER&#91;&#93;
    pub const REGOPER_ARRAY: Type = Type(Inner::RegoperArray);

    /// REGOPERATOR&#91;&#93;
    pub const REGOPERATOR_ARRAY: Type = Type(Inner::RegoperatorArray);

    /// REGCLASS&#91;&#93;
    pub const REGCLASS_ARRAY: Type = Type(Inner::RegclassArray);

    /// REGTYPE&#91;&#93;
    pub const REGTYPE_ARRAY: Type = Type(Inner::RegtypeArray);

    /// RECORD - pseudo-type representing any composite type
    pub const RECORD: Type = Type(Inner::Record);

    /// CSTRING - C-style string
    pub const CSTRING: Type = Type(Inner::Cstring);

    /// ANY - pseudo-type representing any type
    pub const ANY: Type = Type(Inner::Any);

    /// ANYARRAY - pseudo-type representing a polymorphic array type
    pub const ANYARRAY: Type = Type(Inner::Anyarray);

    /// VOID - pseudo-type for the result of a function with no real result
    pub const VOID: Type = Type(Inner::Void);

    /// TRIGGER - pseudo-type for the result of a trigger function
    pub const TRIGGER: Type = Type(Inner::Trigger);

    /// LANGUAGE_HANDLER - pseudo-type for the result of a language handler function
    pub const LANGUAGE_HANDLER: Type = Type(Inner::LanguageHandler);

    /// INTERNAL - pseudo-type representing an internal data structure
    pub const INTERNAL: Type = Type(Inner::Internal);

    /// ANYELEMENT - pseudo-type representing a polymorphic base type
    pub const ANYELEMENT: Type = Type(Inner::Anyelement);

    /// RECORD&#91;&#93;
    pub const RECORD_ARRAY: Type = Type(Inner::RecordArray);

    /// ANYNONARRAY - pseudo-type representing a polymorphic base type that is not an array
    pub const ANYNONARRAY: Type = Type(Inner::Anynonarray);

    /// TXID_SNAPSHOT&#91;&#93;
    pub const TXID_SNAPSHOT_ARRAY: Type = Type(Inner::TxidSnapshotArray);

    /// UUID - UUID datatype
    pub const UUID: Type = Type(Inner::Uuid);

    /// UUID&#91;&#93;
    pub const UUID_ARRAY: Type = Type(Inner::UuidArray);

    /// TXID_SNAPSHOT - txid snapshot
    pub const TXID_SNAPSHOT: Type = Type(Inner::TxidSnapshot);

    /// FDW_HANDLER - pseudo-type for the result of an FDW handler function
    pub const FDW_HANDLER: Type = Type(Inner::FdwHandler);

    /// PG_LSN - PostgreSQL LSN datatype
    pub const PG_LSN: Type = Type(Inner::PgLsn);

    /// PG_LSN&#91;&#93;
    pub const PG_LSN_ARRAY: Type = Type(Inner::PgLsnArray);

    /// TSM_HANDLER - pseudo-type for the result of a tablesample method function
    pub const TSM_HANDLER: Type = Type(Inner::TsmHandler);

    /// PG_NDISTINCT - multivariate ndistinct coefficients
    pub const PG_NDISTINCT: Type = Type(Inner::PgNdistinct);

    /// PG_DEPENDENCIES - multivariate dependencies
    pub const PG_DEPENDENCIES: Type = Type(Inner::PgDependencies);

    /// ANYENUM - pseudo-type representing a polymorphic base type that is an enum
    pub const ANYENUM: Type = Type(Inner::Anyenum);

    /// TSVECTOR - text representation for text search
    pub const TS_VECTOR: Type = Type(Inner::TsVector);

    /// TSQUERY - query representation for text search
    pub const TSQUERY: Type = Type(Inner::Tsquery);

    /// GTSVECTOR - GiST index internal text representation for text search
    pub const GTS_VECTOR: Type = Type(Inner::GtsVector);

    /// TSVECTOR&#91;&#93;
    pub const TS_VECTOR_ARRAY: Type = Type(Inner::TsVectorArray);

    /// GTSVECTOR&#91;&#93;
    pub const GTS_VECTOR_ARRAY: Type = Type(Inner::GtsVectorArray);

    /// TSQUERY&#91;&#93;
    pub const TSQUERY_ARRAY: Type = Type(Inner::TsqueryArray);

    /// REGCONFIG - registered text search configuration
    pub const REGCONFIG: Type = Type(Inner::Regconfig);

    /// REGCONFIG&#91;&#93;
    pub const REGCONFIG_ARRAY: Type = Type(Inner::RegconfigArray);

    /// REGDICTIONARY - registered text search dictionary
    pub const REGDICTIONARY: Type = Type(Inner::Regdictionary);

    /// REGDICTIONARY&#91;&#93;
    pub const REGDICTIONARY_ARRAY: Type = Type(Inner::RegdictionaryArray);

    /// JSONB - Binary JSON
    pub const JSONB: Type = Type(Inner::Jsonb);

    /// JSONB&#91;&#93;
    pub const JSONB_ARRAY: Type = Type(Inner::JsonbArray);

    /// ANYRANGE - pseudo-type representing a range over a polymorphic base type
    pub const ANY_RANGE: Type = Type(Inner::AnyRange);

    /// EVENT_TRIGGER - pseudo-type for the result of an event trigger function
    pub const EVENT_TRIGGER: Type = Type(Inner::EventTrigger);

    /// INT4RANGE - range of integers
    pub const INT4_RANGE: Type = Type(Inner::Int4Range);

    /// INT4RANGE&#91;&#93;
    pub const INT4_RANGE_ARRAY: Type = Type(Inner::Int4RangeArray);

    /// NUMRANGE - range of numerics
    pub const NUM_RANGE: Type = Type(Inner::NumRange);

    /// NUMRANGE&#91;&#93;
    pub const NUM_RANGE_ARRAY: Type = Type(Inner::NumRangeArray);

    /// TSRANGE - range of timestamps without time zone
    pub const TS_RANGE: Type = Type(Inner::TsRange);

    /// TSRANGE&#91;&#93;
    pub const TS_RANGE_ARRAY: Type = Type(Inner::TsRangeArray);

    /// TSTZRANGE - range of timestamps with time zone
    pub const TSTZ_RANGE: Type = Type(Inner::TstzRange);

    /// TSTZRANGE&#91;&#93;
    pub const TSTZ_RANGE_ARRAY: Type = Type(Inner::TstzRangeArray);

    /// DATERANGE - range of dates
    pub const DATE_RANGE: Type = Type(Inner::DateRange);

    /// DATERANGE&#91;&#93;
    pub const DATE_RANGE_ARRAY: Type = Type(Inner::DateRangeArray);

    /// INT8RANGE - range of bigints
    pub const INT8_RANGE: Type = Type(Inner::Int8Range);

    /// INT8RANGE&#91;&#93;
    pub const INT8_RANGE_ARRAY: Type = Type(Inner::Int8RangeArray);

    /// JSONPATH - JSON path
    pub const JSONPATH: Type = Type(Inner::Jsonpath);

    /// JSONPATH&#91;&#93;
    pub const JSONPATH_ARRAY: Type = Type(Inner::JsonpathArray);

    /// REGNAMESPACE - registered namespace
    pub const REGNAMESPACE: Type = Type(Inner::Regnamespace);

    /// REGNAMESPACE&#91;&#93;
    pub const REGNAMESPACE_ARRAY: Type = Type(Inner::RegnamespaceArray);

    /// REGROLE - registered role
    pub const REGROLE: Type = Type(Inner::Regrole);

    /// REGROLE&#91;&#93;
    pub const REGROLE_ARRAY: Type = Type(Inner::RegroleArray);

    /// REGCOLLATION - registered collation
    pub const REGCOLLATION: Type = Type(Inner::Regcollation);

    /// REGCOLLATION&#91;&#93;
    pub const REGCOLLATION_ARRAY: Type = Type(Inner::RegcollationArray);

    /// PG_MCV_LIST - multivariate MCV list
    pub const PG_MCV_LIST: Type = Type(Inner::PgMcvList);

    /// PG_SNAPSHOT - snapshot
    pub const PG_SNAPSHOT: Type = Type(Inner::PgSnapshot);

    /// PG_SNAPSHOT&#91;&#93;
    pub const PG_SNAPSHOT_ARRAY: Type = Type(Inner::PgSnapshotArray);

    /// XID8 - full transaction id
    pub const XID8: Type = Type(Inner::Xid8);

    /// ANYCOMPATIBLE - pseudo-type representing a polymorphic common type
    pub const ANYCOMPATIBLE: Type = Type(Inner::Anycompatible);

    /// ANYCOMPATIBLEARRAY - pseudo-type representing an array of polymorphic common type elements
    pub const ANYCOMPATIBLEARRAY: Type = Type(Inner::Anycompatiblearray);

    /// ANYCOMPATIBLENONARRAY - pseudo-type representing a polymorphic common type that is not an array
    pub const ANYCOMPATIBLENONARRAY: Type = Type(Inner::Anycompatiblenonarray);

    /// ANYCOMPATIBLERANGE - pseudo-type representing a range over a polymorphic common type
    pub const ANYCOMPATIBLE_RANGE: Type = Type(Inner::AnycompatibleRange);
}
