//! Precalculated small powers for 64-bit limbs.

// DECIMAL
pub(super) const POW5: [u64; 28] = [1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125, 6103515625, 30517578125, 152587890625, 762939453125, 3814697265625, 19073486328125, 95367431640625, 476837158203125, 2384185791015625, 11920928955078125, 59604644775390625, 298023223876953125, 1490116119384765625, 7450580596923828125];
pub(super) const POW10: [u64; 20] = [1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000, 10000000000, 100000000000, 1000000000000, 10000000000000, 100000000000000, 1000000000000000, 10000000000000000, 100000000000000000, 1000000000000000000, 10000000000000000000];

cfg_if! {
if #[cfg(feature = "radix")] {
// PRIME (EXCEPT 2)
pub(super) const POW3: [u64; 41] = [1, 3, 9, 27, 81, 243, 729, 2187, 6561, 19683, 59049, 177147, 531441, 1594323, 4782969, 14348907, 43046721, 129140163, 387420489, 1162261467, 3486784401, 10460353203, 31381059609, 94143178827, 282429536481, 847288609443, 2541865828329, 7625597484987, 22876792454961, 68630377364883, 205891132094649, 617673396283947, 1853020188851841, 5559060566555523, 16677181699666569, 50031545098999707, 150094635296999121, 450283905890997363, 1350851717672992089, 4052555153018976267, 12157665459056928801];
pub(super) const POW7: [u64; 23] = [1, 7, 49, 343, 2401, 16807, 117649, 823543, 5764801, 40353607, 282475249, 1977326743, 13841287201, 96889010407, 678223072849, 4747561509943, 33232930569601, 232630513987207, 1628413597910449, 11398895185373143, 79792266297612001, 558545864083284007, 3909821048582988049];
pub(super) const POW11: [u64; 19] = [1, 11, 121, 1331, 14641, 161051, 1771561, 19487171, 214358881, 2357947691, 25937424601, 285311670611, 3138428376721, 34522712143931, 379749833583241, 4177248169415651, 45949729863572161, 505447028499293771, 5559917313492231481];
pub(super) const POW13: [u64; 18] = [1, 13, 169, 2197, 28561, 371293, 4826809, 62748517, 815730721, 10604499373, 137858491849, 1792160394037, 23298085122481, 302875106592253, 3937376385699289, 51185893014090757, 665416609183179841, 8650415919381337933];
pub(super) const POW17: [u64; 16] = [1, 17, 289, 4913, 83521, 1419857, 24137569, 410338673, 6975757441, 118587876497, 2015993900449, 34271896307633, 582622237229761, 9904578032905937, 168377826559400929, 2862423051509815793];
pub(super) const POW19: [u64; 16] = [1, 19, 361, 6859, 130321, 2476099, 47045881, 893871739, 16983563041, 322687697779, 6131066257801, 116490258898219, 2213314919066161, 42052983462257059, 799006685782884121, 15181127029874798299];
pub(super) const POW23: [u64; 15] = [1, 23, 529, 12167, 279841, 6436343, 148035889, 3404825447, 78310985281, 1801152661463, 41426511213649, 952809757913927, 21914624432020321, 504036361936467383, 11592836324538749809];
pub(super) const POW29: [u64; 14] = [1, 29, 841, 24389, 707281, 20511149, 594823321, 17249876309, 500246412961, 14507145975869, 420707233300201, 12200509765705829, 353814783205469041, 10260628712958602189];
pub(super) const POW31: [u64; 13] = [1, 31, 961, 29791, 923521, 28629151, 887503681, 27512614111, 852891037441, 26439622160671, 819628286980801, 25408476896404831, 787662783788549761];

// NON-PRIME (AND 2)
pub(super) const POW2: [u64; 64] = [1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576, 2097152, 4194304, 8388608, 16777216, 33554432, 67108864, 134217728, 268435456, 536870912, 1073741824, 2147483648, 4294967296, 8589934592, 17179869184, 34359738368, 68719476736, 137438953472, 274877906944, 549755813888, 1099511627776, 2199023255552, 4398046511104, 8796093022208, 17592186044416, 35184372088832, 70368744177664, 140737488355328, 281474976710656, 562949953421312, 1125899906842624, 2251799813685248, 4503599627370496, 9007199254740992, 18014398509481984, 36028797018963968, 72057594037927936, 144115188075855872, 288230376151711744, 576460752303423488, 1152921504606846976, 2305843009213693952, 4611686018427387904, 9223372036854775808];
pub(super) const POW4: [u64; 32] = [1, 4, 16, 64, 256, 1024, 4096, 16384, 65536, 262144, 1048576, 4194304, 16777216, 67108864, 268435456, 1073741824, 4294967296, 17179869184, 68719476736, 274877906944, 1099511627776, 4398046511104, 17592186044416, 70368744177664, 281474976710656, 1125899906842624, 4503599627370496, 18014398509481984, 72057594037927936, 288230376151711744, 1152921504606846976, 4611686018427387904];
pub(super) const POW6: [u64; 25] = [1, 6, 36, 216, 1296, 7776, 46656, 279936, 1679616, 10077696, 60466176, 362797056, 2176782336, 13060694016, 78364164096, 470184984576, 2821109907456, 16926659444736, 101559956668416, 609359740010496, 3656158440062976, 21936950640377856, 131621703842267136, 789730223053602816, 4738381338321616896];
pub(super) const POW8: [u64; 22] = [1, 8, 64, 512, 4096, 32768, 262144, 2097152, 16777216, 134217728, 1073741824, 8589934592, 68719476736, 549755813888, 4398046511104, 35184372088832, 281474976710656, 2251799813685248, 18014398509481984, 144115188075855872, 1152921504606846976, 9223372036854775808];
pub(super) const POW9: [u64; 21] = [1, 9, 81, 729, 6561, 59049, 531441, 4782969, 43046721, 387420489, 3486784401, 31381059609, 282429536481, 2541865828329, 22876792454961, 205891132094649, 1853020188851841, 16677181699666569, 150094635296999121, 1350851717672992089, 12157665459056928801];
pub(super) const POW12: [u64; 18] = [1, 12, 144, 1728, 20736, 248832, 2985984, 35831808, 429981696, 5159780352, 61917364224, 743008370688, 8916100448256, 106993205379072, 1283918464548864, 15407021574586368, 184884258895036416, 2218611106740436992];
pub(super) const POW14: [u64; 17] = [1, 14, 196, 2744, 38416, 537824, 7529536, 105413504, 1475789056, 20661046784, 289254654976, 4049565169664, 56693912375296, 793714773254144, 11112006825558016, 155568095557812224, 2177953337809371136];
pub(super) const POW15: [u64; 17] = [1, 15, 225, 3375, 50625, 759375, 11390625, 170859375, 2562890625, 38443359375, 576650390625, 8649755859375, 129746337890625, 1946195068359375, 29192926025390625, 437893890380859375, 6568408355712890625];
pub(super) const POW16: [u64; 16] = [1, 16, 256, 4096, 65536, 1048576, 16777216, 268435456, 4294967296, 68719476736, 1099511627776, 17592186044416, 281474976710656, 4503599627370496, 72057594037927936, 1152921504606846976];
pub(super) const POW18: [u64; 16] = [1, 18, 324, 5832, 104976, 1889568, 34012224, 612220032, 11019960576, 198359290368, 3570467226624, 64268410079232, 1156831381426176, 20822964865671168, 374813367582081024, 6746640616477458432];
pub(super) const POW20: [u64; 15] = [1, 20, 400, 8000, 160000, 3200000, 64000000, 1280000000, 25600000000, 512000000000, 10240000000000, 204800000000000, 4096000000000000, 81920000000000000, 1638400000000000000];
pub(super) const POW21: [u64; 15] = [1, 21, 441, 9261, 194481, 4084101, 85766121, 1801088541, 37822859361, 794280046581, 16679880978201, 350277500542221, 7355827511386641, 154472377739119461, 3243919932521508681];
pub(super) const POW22: [u64; 15] = [1, 22, 484, 10648, 234256, 5153632, 113379904, 2494357888, 54875873536, 1207269217792, 26559922791424, 584318301411328, 12855002631049216, 282810057883082752, 6221821273427820544];
pub(super) const POW24: [u64; 14] = [1, 24, 576, 13824, 331776, 7962624, 191102976, 4586471424, 110075314176, 2641807540224, 63403380965376, 1521681143169024, 36520347436056576, 876488338465357824];
pub(super) const POW25: [u64; 14] = [1, 25, 625, 15625, 390625, 9765625, 244140625, 6103515625, 152587890625, 3814697265625, 95367431640625, 2384185791015625, 59604644775390625, 1490116119384765625];
pub(super) const POW26: [u64; 14] = [1, 26, 676, 17576, 456976, 11881376, 308915776, 8031810176, 208827064576, 5429503678976, 141167095653376, 3670344486987776, 95428956661682176, 2481152873203736576];
pub(super) const POW27: [u64; 14] = [1, 27, 729, 19683, 531441, 14348907, 387420489, 10460353203, 282429536481, 7625597484987, 205891132094649, 5559060566555523, 150094635296999121, 4052555153018976267];
pub(super) const POW28: [u64; 14] = [1, 28, 784, 21952, 614656, 17210368, 481890304, 13492928512, 377801998336, 10578455953408, 296196766695424, 8293509467471872, 232218265089212416, 6502111422497947648];
pub(super) const POW30: [u64; 14] = [1, 30, 900, 27000, 810000, 24300000, 729000000, 21870000000, 656100000000, 19683000000000, 590490000000000, 17714700000000000, 531441000000000000, 15943230000000000000];
pub(super) const POW32: [u64; 13] = [1, 32, 1024, 32768, 1048576, 33554432, 1073741824, 34359738368, 1099511627776, 35184372088832, 1125899906842624, 36028797018963968, 1152921504606846976];
pub(super) const POW33: [u64; 13] = [1, 33, 1089, 35937, 1185921, 39135393, 1291467969, 42618442977, 1406408618241, 46411484401953, 1531578985264449, 50542106513726817, 1667889514952984961];
pub(super) const POW34: [u64; 13] = [1, 34, 1156, 39304, 1336336, 45435424, 1544804416, 52523350144, 1785793904896, 60716992766464, 2064377754059776, 70188843638032384, 2386420683693101056];
pub(super) const POW35: [u64; 13] = [1, 35, 1225, 42875, 1500625, 52521875, 1838265625, 64339296875, 2251875390625, 78815638671875, 2758547353515625, 96549157373046875, 3379220508056640625];
pub(super) const POW36: [u64; 13] = [1, 36, 1296, 46656, 1679616, 60466176, 2176782336, 78364164096, 2821109907456, 101559956668416, 3656158440062976, 131621703842267136, 4738381338321616896];

}}  //cfg_if
