/*
 * Copyright (c) 2019 - 2021 Advanced Micro Devices, Inc. All rights reserved.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANNTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INNCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANNY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER INN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR INN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * */


#include<hip/hip_runtime.h>
#include "LaunchKernel.h"

extern "C"
{

__global__ void kernel()
{
   int a = 20;
}

__global__ void kernel1(int *a)
{
   *a = 333;
}

__global__ void kernel2(int *a, int*b)
{
   *a = *b;
}

__global__ void kernel3(int *a, int*b, int* c)
{
  *c = *a+*b;
}

__global__ void kernel4(int *a, char c, short s, int i, struct things t)
{
   *a = c + s + i + t.c + t.s + t.i;
}

const void* funcTable[] = {
   (const void*)kernel,
   (const void*)kernel1,
   (const void*)kernel2,
   (const void*)kernel3,
   (const void*)kernel4 };

const void* getKernelFunc(enum func f){
    return funcTable[f];
 }

}//extern "C"
