% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Date.R, R/POSIX.R, R/data.frame.R, R/irts.R,
%   R/matrix.R, R/timeDate.R, R/timeSeries.R, R/ts.R, R/xts.R, R/yearmon.R,
%   R/zoo.R
\name{as.xts.Date}
\alias{as.xts.Date}
\alias{as.xts.POSIXt}
\alias{as.xts.data.frame}
\alias{as.xts.irts}
\alias{as.xts.matrix}
\alias{as.xts.timeDate}
\alias{as.xts.timeSeries}
\alias{as.xts.ts}
\alias{as.xts}
\alias{xtsible}
\alias{as.xts.yearmon}
\alias{as.xts.yearqtr}
\alias{as.xts.zoo}
\title{Convert Objects To and From xts}
\usage{
\method{as.xts}{Date}(x, ...)

\method{as.xts}{POSIXt}(x, ...)

\method{as.xts}{data.frame}(
  x,
  order.by,
  dateFormat = "POSIXct",
  frequency = NULL,
  ...,
  .RECLASS = FALSE
)

\method{as.xts}{irts}(x, order.by, frequency = NULL, ..., .RECLASS = FALSE)

\method{as.xts}{matrix}(
  x,
  order.by,
  dateFormat = "POSIXct",
  frequency = NULL,
  ...,
  .RECLASS = FALSE
)

\method{as.xts}{timeDate}(x, ...)

\method{as.xts}{timeSeries}(
  x,
  dateFormat = "POSIXct",
  FinCenter,
  recordIDs,
  title,
  documentation,
  ...,
  .RECLASS = FALSE
)

\method{as.xts}{ts}(x, dateFormat, ..., .RECLASS = FALSE)

as.xts(x, ...)

xtsible(x)

\method{as.xts}{yearmon}(x, ...)

\method{as.xts}{yearqtr}(x, ...)

\method{as.xts}{zoo}(x, order.by = index(x), frequency = NULL, ..., .RECLASS = FALSE)
}
\arguments{
\item{x}{Data object to convert. See details for supported types.}

\item{\dots}{Additional parameters or attributes.}

\item{order.by, frequency}{See \link[zoo:zoo]{zoo} help.}

\item{dateFormat}{What class should the dates be converted to?}

\item{.RECLASS}{Should the conversion be reversible via \code{\link[=reclass]{reclass()}}?}

\item{FinCenter, recordIDs, title, documentation}{See \link[timeSeries:timeSeries]{timeSeries} help.}
}
\value{
An S3 object of class xts.
}
\description{
Conversion S3 methods to coerce data objects of arbitrary classes to xts
and back, without losing any attributes of the original format.
}
\details{
A simple and reliable way to convert many different objects into a uniform
format for use within \R.

\code{as.xts()} can convert objects of the following classes into an xts object:
object: \link[timeSeries:timeSeries]{timeSeries}, \link{ts}, \link{matrix}, \link{data.frame},
and \link[zoo:zoo]{zoo}. \code{xtsible()} safely checks whether an object can be converted to
an xts object.

Additional \code{name = value} pairs may be passed to the function to be added to
the new object. A special \code{\link[=print.xts]{print.xts()}} method ensures the attributes are
hidden from view, but will be available via \R's standard \code{attr()} function,
as well as the \code{\link[=xtsAttributes]{xtsAttributes()}} function.

When \code{.RECLASS = TRUE}, the returned xts object internally preserves all
relevant attribute/slot data from the input \code{x}. This allows for temporary
conversion to xts in order to use zoo and xts compatible methods. See
\code{\link[=reclass]{reclass()}} for details.
}
\examples{

\dontrun{
# timeSeries
library(timeSeries)
x <- timeSeries(1:10, 1:10)

str(as.xts(x))
str(reclass(as.xts(x)))
str(try.xts(x))
str(reclass(try.xts(x)))
}

}
\seealso{
\code{\link[=xts]{xts()}}, \code{\link[=reclass]{reclass()}}, \code{\link[zoo:zoo]{zoo()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
