% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R
\name{pull-requests}
\alias{pull-requests}
\alias{pr_init}
\alias{pr_resume}
\alias{pr_fetch}
\alias{pr_push}
\alias{pr_pull}
\alias{pr_merge_main}
\alias{pr_view}
\alias{pr_pause}
\alias{pr_finish}
\alias{pr_forget}
\title{Helpers for GitHub pull requests}
\usage{
pr_init(branch)

pr_resume(branch = NULL)

pr_fetch(number = NULL, target = c("source", "primary"))

pr_push()

pr_pull()

pr_merge_main()

pr_view(number = NULL, target = c("source", "primary"))

pr_pause()

pr_finish(number = NULL, target = c("source", "primary"))

pr_forget()
}
\arguments{
\item{branch}{Name of a new or existing local branch. If creating a new
branch, note this should usually consist of lower case letters, numbers,
and \code{-}.}

\item{number}{Number of PR.}

\item{target}{Which repo to target? This is only a question in the case of a
fork. In a fork, there is some slim chance that you want to consider pull
requests against your fork (the primary repo, i.e. \code{origin}) instead of
those against the source repo (i.e. \code{upstream}, which is the default).}
}
\description{
The \verb{pr_*} family of functions is designed to make working with GitHub pull
requests (PRs) as painless as possible for both contributors and package
maintainers.

To use the \verb{pr_*} functions, your project must be a Git repo and have one of
these GitHub remote configurations:
\itemize{
\item "ours": You can push to the GitHub remote configured as \code{origin} and it's
not a fork.
\item "fork": You can push to the GitHub remote configured as \code{origin}, it's a
fork, and its parent is configured as \code{upstream}. \code{origin} points to your
\strong{personal} copy and \code{upstream} points to the \strong{source repo}.
}

"Ours" and "fork" are two of several GitHub remote configurations examined in
\href{https://happygitwithr.com/common-remote-setups.html}{Common remote setups}
in Happy Git and GitHub for the useR.

The \href{https://usethis.r-lib.org/articles/articles/pr-functions.html}{Pull Request Helpers}
article walks through the process of making a pull request with the \verb{pr_*}
functions.

The \verb{pr_*} functions also use your Git/GitHub credentials to carry out
various remote operations; see below for more about auth. The \verb{pr_*}
functions also proactively check for agreement re: the default branch in your
local repo and the source repo. See \code{\link[=git_default_branch]{git_default_branch()}} for more.
}
\section{Git/GitHub Authentication}{

Many usethis functions, including those documented here, potentially interact
with GitHub in two different ways:
\itemize{
\item Via the GitHub REST API. Examples: create a repo, a fork, or a pull
request.
\item As a conventional Git remote. Examples: clone, fetch, or push.
}

Therefore two types of auth can happen and your credentials must be
discoverable. Which credentials do we mean?
\itemize{
\item A GitHub personal access token (PAT) must be discoverable by the gh
package, which is used for GitHub operations via the REST API. See
\code{\link[=gh_token_help]{gh_token_help()}} for more about getting and configuring a PAT.
\item If you use the HTTPS protocol for Git remotes, your PAT is also used for
Git operations, such as \verb{git push}. Usethis uses the gert package for this,
so the PAT must be discoverable by gert. Generally gert and gh will
discover and use the same PAT. This ability to "kill two birds with one
stone" is why HTTPS + PAT is our recommended auth strategy for those new
to Git and GitHub and PRs.
\item If you use SSH remotes, your SSH keys must also be discoverable, in
addition to your PAT. The public key must be added to your GitHub account.
}

Git/GitHub credential management is covered in a dedicated article:
\href{https://usethis.r-lib.org/articles/articles/git-credentials.html}{Managing Git(Hub) Credentials}
}

\section{For contributors}{

To contribute to a package, first use \code{create_from_github("OWNER/REPO")}.
This forks the source repository and checks out a local copy.

Next use \code{pr_init()} to create a branch for your PR. It is best practice to
never make commits to the default branch branch of a fork (usually named
\code{main} or \code{master}), because you do not own it. A pull request should always
come from a feature branch. It will be much easier to pull upstream changes
from the fork parent if you only allow yourself to work in feature branches.
It is also much easier for a maintainer to explore and extend your PR if you
create a feature branch.

Work locally, in your branch, making changes to files, and committing your
work. Once you're ready to create the PR, run \code{pr_push()} to push your local
branch to GitHub, and open a webpage that lets you initiate the PR (or draft
PR).

To learn more about the process of making a pull request, read the \href{https://usethis.r-lib.org/articles/articles/pr-functions.html}{Pull Request Helpers}
vignette.

If you are lucky, your PR will be perfect, and the maintainer will accept it.
You can then run \code{pr_finish()} to delete your PR branch. In most cases,
however, the maintainer will ask you to make some changes. Make the changes,
then run \code{pr_push()} to update your PR.

It's also possible that the maintainer will contribute some code to your PR:
to get those changes back onto your computer, run \code{pr_pull()}. It can also
happen that other changes have occurred in the package since you first
created your PR. You might need to merge the default branch (usually named
\code{main} or \code{master}) into your PR branch. Do that by running
\code{pr_merge_main()}: this makes sure that your PR is compatible with the
primary repo's main line of development. Both \code{pr_pull()} and
\code{pr_merge_main()} can result in merge conflicts, so be prepared to resolve
before continuing.
}

\section{For maintainers}{

To download a PR locally so that you can experiment with it, run
\code{pr_fetch()} and select the PR or, if you already know its number, call
\verb{pr_fetch(<pr_number>)}. If you make changes, run \code{pr_push()} to push them
back to GitHub. After you have merged the PR, run \code{pr_finish()} to delete the
local branch and remove the remote associated with the contributor's fork.
}

\section{Overview of all the functions}{

\itemize{
\item \code{pr_init()}: As a contributor, start work on a new PR by ensuring that
your local repo is up-to-date, then creating and checking out a new branch.
Nothing is pushed to or created on GitHub until you call \code{pr_push()}.
\item \code{pr_fetch()}: As a maintainer, review or contribute changes to an existing
PR by creating a local branch that tracks the remote PR. \code{pr_fetch()} does as
little work as possible, so you can also use it to resume work on an PR that
already has a local branch (where it will also ensure your local branch is
up-to-date). If called with no arguments, up to 9 open PRs are offered for
interactive selection.
\item \code{pr_resume()}: Resume work on a PR by switching to an existing local branch
and pulling any changes from its upstream tracking branch, if it has one. If
called with no arguments, up to 9 local branches are offered for interactive
selection, with a preference for branches connected to PRs and for branches
with recent activity.
\item \code{pr_push()}: The first time it's called, a PR branch is pushed to GitHub
and you're taken to a webpage where a new PR (or draft PR) can be created.
This also sets up the local branch to track its remote counterpart.
Subsequent calls to \code{pr_push()} make sure the local branch has all the remote
changes and, if so, pushes local changes, thereby updating the PR.
\item \code{pr_pull()}: Pulls changes from the local branch's remote tracking branch.
If a maintainer has extended your PR, this is how you bring those changes
back into your local work.
\item \code{pr_merge_main()}: Pulls changes from the default branch of the source repo
into the current local branch. This can be used when the local branch is the
default branch or when it's a PR branch.
\item \code{pr_pause()}: Makes sure you're up-to-date with any remote changes in the
PR. Then switches back to the default branch and pulls from the source repo.
Use \code{pr_resume()} with name of branch or use \code{pr_fetch()} to resume using PR
number.
\item \code{pr_view()}: Visits the PR associated with the current branch in the
browser (default) or the specific PR identified by \code{number}.
(FYI \code{\link[=browse_github_pulls]{browse_github_pulls()}} is a handy way to visit the list of all PRs for
the current project.)
\item \code{pr_forget()}: Does local clean up when the current branch is an actual or
notional PR that you want to abandon. Maybe you initiated it yourself, via
\code{pr_init()}, or you used \code{pr_fetch()} to explore a PR from GitHub. Only does
\emph{local} operations: does not update or delete any remote branches, nor does
it close any PRs. Alerts the user to any uncommitted or unpushed work that is
at risk of being lost. If user chooses to proceed, switches back to the
default branch, pulls changes from source repo, and deletes local PR branch.
Any associated Git remote is deleted, if the "forgotten" PR was the only
branch using it.
\item \code{pr_finish()}: Does post-PR clean up, but does NOT actually merge or close
a PR (maintainer should do this in the browser). If \code{number} is not given,
infers the PR from the upstream tracking branch of the current branch. If
\code{number} is given, it does not matter whether the PR exists locally. If PR
exists locally, alerts the user to uncommitted or unpushed changes, then
switches back to the default branch, pulls changes from source repo, and
deletes local PR branch. If the PR came from an external fork, any associated
Git remote is deleted, provided it's not in use by any other local branches.
If the PR has been merged and user has permission, deletes the remote branch
(this is the only remote operation that \code{pr_finish()} potentially does).
}
}

\examples{
\dontrun{
pr_fetch(123)
}
}
