test_that("basic skips work as expected", {
  expect_snapshot_skip(skip())

  expect_no_skip(skip_if(FALSE))
  expect_snapshot_skip(skip_if(TRUE))

  expect_no_skip(skip_if_not(TRUE))
  expect_snapshot_skip(skip_if_not(FALSE))

  expect_snapshot_skip(skip_empty())
})

test_that("autogenerated message is always single line", {
  a_very_long_argument_name <- FALSE

  cnd <- capture_condition(skip_if_not(
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name
  ))

  expect_length(cnd$message, 1)
  # ensure the message is not repeated, #1290
  expect_snapshot_output(cat(cnd$message))
})

# skip helpers ------------------------------------------------------------

test_that("skip_if_not_installed() works as expected", {
  local_mocked_bindings(package_version = function(x) "3.0.0")

  expect_snapshot_skip(skip_if_not_installed("doesntexist"))
  expect_snapshot_skip(skip_if_not_installed("testthat", "9999.9999.999"))
  expect_no_skip(skip_if_not_installed("testthat", "1.0.0"))
})

test_that("skip_if_not_installed() works as expected", {
  skip_if_not_installed("curl")
  skip_on_cran()

  expect_no_skip(skip_if_offline())

  local_mocked_bindings(has_internet = function(host) FALSE)
  expect_snapshot_skip(skip_if_offline())
})

test_that("skip_on_cran() works as expected", {
  skip_on_cran()

  withr::local_envvar(NOT_CRAN = "true")
  expect_no_skip(skip_on_cran())

  withr::local_envvar(NOT_CRAN = "false")
  local_mocked_bindings(interactive = function() FALSE)
  expect_snapshot_skip(skip_on_cran(), cran = TRUE)

  local_mocked_bindings(interactive = function() TRUE)
  expect_no_skip(skip_on_cran())
})

test_that("skip_on_ci() works as expected", {
  withr::local_envvar(CI = "false")
  expect_no_skip(skip_on_ci())

  withr::local_envvar(CI = "true")
  expect_snapshot_skip(skip_on_ci())
})

test_that("skip_on_covr() works as expected", {
  withr::local_envvar(R_COVR = "false")
  expect_no_skip(skip_on_covr())

  withr::local_envvar(R_COVR = "true")
  expect_snapshot_skip(skip_on_covr())
})

test_that("skip_on_bioc() works as expected", {
  expect_no_skip(skip_on_bioc())

  withr::local_envvar(IS_BIOC_BUILD_MACHINE = "true")
  expect_snapshot_skip(skip_on_bioc())
})

test_that("superseded CI skips still work", {
  expect_no_skip(skip_on_travis())
  expect_no_skip(skip_on_appveyor())

  withr::local_envvar(TRAVIS = "true", APPVEYOR = "true")
  expect_snapshot_skip(skip_on_travis())
  expect_snapshot_skip(skip_on_appveyor())
})

test_that("skip_if_translated() works as expected", {
  local_mocked_bindings(gettext = function(msg, ...) msg)
  expect_no_skip(skip_if_translated())

  local_mocked_bindings(gettext = function(msg, ...) toupper(msg))
  expect_snapshot_skip(skip_if_translated())
})

# skip_on_os() ------------------------------------------------------------

test_that("skip on os checks os names", {
  expect_snapshot(skip_on_os("amiga"), error = TRUE)
})

test_that("can skip on multiple oses", {
  local_mocked_bindings(system_os = function() "windows")

  expect_snapshot_skip(skip_on_os("windows"))
  expect_snapshot_skip(skip_on_os(c("windows", "linux")))
  expect_no_skip(skip_on_os("linux"))
  expect_no_skip(skip_on_os("mac"))
})

test_that("can refine os with arch", {
  local_mocked_bindings(
    system_os = function() "windows",
    system_arch = function() "i386"
  )

  expect_snapshot_skip(skip_on_os("windows"))
  expect_snapshot_skip(skip_on_os("windows", "i386"))
  expect_no_skip(skip_on_os("windows", "x86_64"))
  expect_no_skip(skip_on_os("linux", "i386"))
})
