% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrnonnorm.R
\name{mvrnonnorm}
\alias{mvrnonnorm}
\title{Generate Non-normal Data using Vale and Maurelli (1983) method}
\usage{
mvrnonnorm(n, mu, Sigma, skewness = NULL, kurtosis = NULL, empirical = FALSE)
}
\arguments{
\item{n}{Sample size}

\item{mu}{A mean vector. If elements are named, those will be used as
variable names in the returned data matrix.}

\item{Sigma}{A positive-definite symmetric matrix specifying the covariance
matrix of the variables. If rows or columns are named (and \code{mu} is
unnamed), those will be used as variable names in the returned data matrix.}

\item{skewness}{A vector of skewness of the variables}

\item{kurtosis}{A vector of excessive kurtosis of the variables}

\item{empirical}{If \code{TRUE}, \code{mu} and \code{Sigma} specify the
empirical rather than population mean and covariance matrix}
}
\value{
A data matrix
}
\description{
Generate Non-normal Data using Vale and Maurelli (1983) method. The function
is designed to be as similar as the popular \code{mvrnorm} function in the
\code{MASS} package. The codes are copied from \code{mvrnorm} function in
the \code{MASS} package for argument checking and \code{lavaan} package for
data generation using Vale and Maurelli (1983) method.
}
\examples{

set.seed(123)
mvrnonnorm(20, c(1, 2), matrix(c(10, 2, 2, 5), 2, 2),
	skewness = c(5, 2), kurtosis = c(3, 3))
## again, with variable names specified in mu
set.seed(123)
mvrnonnorm(20, c(a = 1, b = 2), matrix(c(10, 2, 2, 5), 2, 2),
	skewness = c(5, 2), kurtosis = c(3, 3))

}
\references{
Vale, C. D. & Maurelli, V. A. (1983). Simulating multivariate
nonormal distributions. \emph{Psychometrika, 48}(3), 465--471.
\doi{10.1007/BF02293687}
}
\author{
The original function is the \code{\link[lavaan]{simulateData}}
function written by Yves Rosseel in the \code{lavaan} package. The function
is adjusted for a convenient usage by Sunthud Pornprasertmanit
(\email{psunthud@gmail.com}). Terrence D. Jorgensen added the feature to
retain variable names from \code{mu} or \code{Sigma}.
}
