% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macos.R
\name{ps_apps}
\alias{ps_apps}
\title{List currently running applications}
\usage{
ps_apps()
}
\value{
A data frame with columns:
\itemize{
\item \code{pid}: integer process id.
\item \code{name}: process name.
\item \code{bundle_identifier}: bundle identifier, e.g. \code{com.apple.dock}.
\item \code{bundle_url}: bundle URL, a \verb{file://} URL to the app bundle.
\item \code{arch}: executable architecture, possible values are
arm64, i386, x86_64, ppc, ppc64.
\item \code{executable_url}: \verb{file://} URL to the executable file.
\item \code{launch_date}: launch time stamp, a \code{POSIXct} object, may be \code{NA}.
\item \code{finished_launching}: whether the app has finished launching.
\item \code{active}: whether the app is active.
\item \code{activation_policy}: one of the following values:
\itemize{
\item \code{regular}: the application is an ordinary app that appears in the
Dock and may have a user interface.
\item \code{accessory}: the application doesn’t appear in the Dock and
doesn’t have a menu bar, but it may be activated programmatically
or by clicking on one of its windows.
\item \code{prohibited}: the application doesn’t appear in the Dock and may
not create windows or be activated.
}
}
}
\description{
This function currently only works on macOS.
}
\examples{
\dontshow{if (ps_is_supported() && ps_os_type()[["MACOS"]] && !ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_apps()
\dontshow{\}) # examplesIf}
}
