% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{eccentricity}
\alias{eccentricity}
\title{Eccentricity of the vertices in a graph}
\usage{
eccentricity(graph, vids = V(graph), mode = c("all", "out", "in", "total"))
}
\arguments{
\item{graph}{The input graph, it can be directed or undirected.}

\item{vids}{The vertices for which the eccentricity is calculated.}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \code{in} then \emph{to}
it will be considered. If \code{all}, the default, then the corresponding
undirected graph will be used, edge directions will be ignored. This
argument is ignored for undirected graphs.}
}
\value{
\code{eccentricity} returns a numeric vector, containing the
eccentricity score of each given vertex.
}
\description{
The eccentricity of a vertex is its shortest path distance from the farthest
other node in the graph.
}
\details{
The eccentricity of a vertex is calculated by measuring the shortest
distance from (or to) the vertex, to (or from) all vertices in the graph,
and taking the maximum.

This implementation ignores vertex pairs that are in different components.
Isolate vertices have eccentricity zero.
}
\examples{
g <- make_star(10, mode="undirected")
eccentricity(g)
}
\references{
Harary, F. Graph Theory. Reading, MA: Addison-Wesley, p. 35,
1994.
}
\seealso{
\code{\link{radius}} for a related concept,
  \code{\link{distances}} for general shortest path calculations.
}
