% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{autofit}
\alias{autofit}
\title{Adjust cell widths and heights}
\usage{
autofit(
  x,
  add_w = 0.1,
  add_h = 0.1,
  part = c("body", "header"),
  unit = "in",
  hspans = "none"
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{add_w}{extra width to add in inches}

\item{add_h}{extra height to add in inches}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{unit}{unit for add_h and add_w, one of "in", "cm", "mm".}

\item{hspans}{specifies how cells that are horizontally are included in the calculation.
It must be one of the following values "none", "divided" or "included". If
"none", widths of horizontally spanned cells is set to 0 (then do not affect the
widths); if "divided", widths of horizontally spanned cells is divided by
the number of spanned cells; if "included", all widths (included horizontally
spanned cells) will be used in the calculation.}
}
\description{
compute and apply optimized widths and heights
(minimum estimated widths and heights for each table columns and rows
in inches returned by function \code{\link[=dim_pretty]{dim_pretty()}}).

This function is to be used when the table widths and heights
should be adjusted to fit the size of the content.

The function does not let you adjust a content that is too
wide in a paginated document. It simply calculates the width
of the columns so that each content has the minimum width
necessary to display the content on one line.

Note that this function is not related to 'Microsoft Word'
\emph{Autofit} feature.

There is an alternative to fixed-width layouts that works
well with HTML and Word output that can be set
with \code{set_table_properties(layout = "autofit")}, see
\code{\link[=set_table_properties]{set_table_properties()}}.
}
\examples{
ft_1 <- flextable(head(mtcars))
ft_1
ft_2 <- autofit(ft_1)
ft_2
}
\seealso{
Other functions for flextable size management: 
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
