#' NYC Regents exams scores 2010
#' 
#' Distribution of scores for New York City Regents algebra, global history, biology, English, and U.S. history exams. 
#' These data were used to make \href{http://graphics8.nytimes.com/images/2011/02/19/nyregion/19schoolsch/19schoolsch-popup.gif}{this New York Times plot}.
#' 
#' \itemize{
#' \item score. Test score from 0 to 100.
#'  \item integrated_algebra. Score frequency on Algebra exam.
#'  \item global_history. Score frequency on global history exam.
#'  \item living_environment.  Score frequency on biology exam.
#'  \item english. Score frequency on English exam.
#'  \item us_history. Score frequency on  U.S. history exam.
#' }
#'
#' @docType data
#'
#' @usage data(nyc_regents_scores)
#'
#' @format An object of class \code{"data.frame"}. 
#'
#' @keywords datasets
#'
#'
#' @source New York City Department of Education via Amanda Cox.
#'
#' @examples
#' data(nyc_regents_scores)
#' print(nyc_regents_scores)
"nyc_regents_scores"
