\name{modelMatrixMeth}
\alias{modelMatrixMeth}
\title{Construct Design Matrix for edgeR Analysis of Methylation Count Data}
\description{
Construct design matrix (aka model matrix) for edgeR analysis of methylation count data from sample level information.
}
\usage{
modelMatrixMeth(object, \dots)
}
\arguments{
  \item{object}{a sample-level design matrix or model formula or terms object.}
  \item{\dots}{any other arguments are passed to \code{\link{model.matrix}}.}
}

\details{
This function computes a design matrix for modeling methylated and unmethylated counts.
The resulting design matrix can be input to \code{glmFit} when analysing BS-seq methylation data using edgeR.

In BS-seq methylation analysis, each DNA sample generates two counts, a count of methylated reads and a count of unmethylated reads, for each genomic locus for each sample.
The function converts sample-level information about the treatment conditions to make an appropriate design matrix with two rows for each sample.
Counts are assumed to be ordered as methylated and then unmethylated by sample.

If \code{design.treatments <- model.matrix(object,\dots)} has \code{nsamples} rows and \code{p} columns, then \code{modelMatrixMeth(object, \dots)} has \code{2*nsamples} rows and \code{nsamples+p} columns.
See Chen et al (2017) for more information.
}

\value{
A numeric design matrix.
It has 2 rows for each sample and a column for each sample in addition to the columns generated by \code{model.matrix(object, \dots)}.
}

\seealso{
\code{\link[stats]{model.matrix}} in the stats package.
}

\references{
Chen, Y, Pal, B, Visvader, JE, Smyth, GK (2017).
Differential methylation analysis of reduced representation bisulfite sequencing experiments using edgeR.
\emph{F1000Research} 6, 2055.
\url{https://f1000research.com/articles/6-2055} 
}

\author{Gordon Smyth}

\examples{
Treatments <- gl(3,2,labels=c("A","B","C"))
modelMatrixMeth(~Treatments)

# Equivalent calling sequence:
design.treatments <- model.matrix(~Treatments)
modelMatrixMeth(design.treatments)
}

\concept{Differential methylation}
