# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class WebhookList(ListResource):

    def __init__(self, version, chat_service_sid):
        """
        Initialize the WebhookList

        :param Version version: Version that contains the resource
        :param chat_service_sid: The unique string that identifies the resource

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookList
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookList
        """
        super(WebhookList, self).__init__(version)

        # Path Solution
        self._solution = {'chat_service_sid': chat_service_sid, }

    def get(self):
        """
        Constructs a WebhookContext

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        """
        return WebhookContext(self._version, chat_service_sid=self._solution['chat_service_sid'], )

    def __call__(self):
        """
        Constructs a WebhookContext

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        """
        return WebhookContext(self._version, chat_service_sid=self._solution['chat_service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.WebhookList>'


class WebhookPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the WebhookPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param chat_service_sid: The unique string that identifies the resource

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookPage
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookPage
        """
        super(WebhookPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of WebhookInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        return WebhookInstance(self._version, payload, chat_service_sid=self._solution['chat_service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.WebhookPage>'


class WebhookContext(InstanceContext):

    def __init__(self, version, chat_service_sid):
        """
        Initialize the WebhookContext

        :param Version version: Version that contains the resource
        :param chat_service_sid: The unique ID of the `Conversation Service <https://www.twilio.com/docs/conversations/api/service-resource>`_ this conversation belongs to.

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        """
        super(WebhookContext, self).__init__(version)

        # Path Solution
        self._solution = {'chat_service_sid': chat_service_sid, }
        self._uri = '/Services/{chat_service_sid}/Configuration/Webhooks'.format(**self._solution)

    def update(self, pre_webhook_url=values.unset, post_webhook_url=values.unset,
               filters=values.unset, method=values.unset):
        """
        Update the WebhookInstance

        :param unicode pre_webhook_url: The absolute url the pre-event webhook request should be sent to.
        :param unicode post_webhook_url: The absolute url the post-event webhook request should be sent to.
        :param list[unicode] filters: The list of events that your configured webhook targets will receive. Events not configured here will not fire.
        :param unicode method: The HTTP method to be used when sending a webhook request

        :returns: The updated WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        data = values.of({
            'PreWebhookUrl': pre_webhook_url,
            'PostWebhookUrl': post_webhook_url,
            'Filters': serialize.map(filters, lambda e: e),
            'Method': method,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return WebhookInstance(self._version, payload, chat_service_sid=self._solution['chat_service_sid'], )

    def fetch(self):
        """
        Fetch the WebhookInstance

        :returns: The fetched WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return WebhookInstance(self._version, payload, chat_service_sid=self._solution['chat_service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.WebhookContext {}>'.format(context)


class WebhookInstance(InstanceResource):

    class Method(object):
        GET = "GET"
        POST = "POST"

    def __init__(self, version, payload, chat_service_sid):
        """
        Initialize the WebhookInstance

        :returns: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        super(WebhookInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'chat_service_sid': payload.get('chat_service_sid'),
            'pre_webhook_url': payload.get('pre_webhook_url'),
            'post_webhook_url': payload.get('post_webhook_url'),
            'filters': payload.get('filters'),
            'method': payload.get('method'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'chat_service_sid': chat_service_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: WebhookContext for this WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookContext
        """
        if self._context is None:
            self._context = WebhookContext(self._version, chat_service_sid=self._solution['chat_service_sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account responsible for this service.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def chat_service_sid(self):
        """
        :returns: The unique ID of the `Conversation Service <https://www.twilio.com/docs/conversations/api/service-resource>`_ this conversation belongs to.
        :rtype: unicode
        """
        return self._properties['chat_service_sid']

    @property
    def pre_webhook_url(self):
        """
        :returns: The absolute url the pre-event webhook request should be sent to.
        :rtype: unicode
        """
        return self._properties['pre_webhook_url']

    @property
    def post_webhook_url(self):
        """
        :returns: The absolute url the post-event webhook request should be sent to.
        :rtype: unicode
        """
        return self._properties['post_webhook_url']

    @property
    def filters(self):
        """
        :returns: The list of events that your configured webhook targets will receive. Events not configured here will not fire.
        :rtype: list[unicode]
        """
        return self._properties['filters']

    @property
    def method(self):
        """
        :returns: The HTTP method to be used when sending a webhook request
        :rtype: WebhookInstance.Method
        """
        return self._properties['method']

    @property
    def url(self):
        """
        :returns: An absolute URL for this webhook.
        :rtype: unicode
        """
        return self._properties['url']

    def update(self, pre_webhook_url=values.unset, post_webhook_url=values.unset,
               filters=values.unset, method=values.unset):
        """
        Update the WebhookInstance

        :param unicode pre_webhook_url: The absolute url the pre-event webhook request should be sent to.
        :param unicode post_webhook_url: The absolute url the post-event webhook request should be sent to.
        :param list[unicode] filters: The list of events that your configured webhook targets will receive. Events not configured here will not fire.
        :param unicode method: The HTTP method to be used when sending a webhook request

        :returns: The updated WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        return self._proxy.update(
            pre_webhook_url=pre_webhook_url,
            post_webhook_url=post_webhook_url,
            filters=filters,
            method=method,
        )

    def fetch(self):
        """
        Fetch the WebhookInstance

        :returns: The fetched WebhookInstance
        :rtype: twilio.rest.conversations.v1.service.configuration.webhook.WebhookInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.WebhookInstance {}>'.format(context)
