# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .._utils.model_base import Model as _Model, rest_field
from .._utils.utils import FileType

if TYPE_CHECKING:
    from .. import models as _models


class ActiveLearningFeedback(_Model):
    """Feedback for Active Learning.

    :ivar records: A list of Feedback Records for Active Learning.
    :vartype records: list[~azure.ai.language.questionanswering.authoring.models.FeedbackRecord]
    """

    records: Optional[list["_models.FeedbackRecord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Feedback Records for Active Learning."""

    @overload
    def __init__(
        self,
        *,
        records: Optional[list["_models.FeedbackRecord"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Assets(_Model):
    """All assets for this project.

    :ivar synonyms: Collection of synonyms.
    :vartype synonyms: list[~azure.ai.language.questionanswering.authoring.models.WordAlterations]
    :ivar qnas: List of QnA records to import.
    :vartype qnas: list[~azure.ai.language.questionanswering.authoring.models.ImportQnaRecord]
    """

    synonyms: Optional[list["_models.WordAlterations"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Collection of synonyms."""
    qnas: Optional[list["_models.ImportQnaRecord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of QnA records to import."""

    @overload
    def __init__(
        self,
        *,
        synonyms: Optional[list["_models.WordAlterations"]] = None,
        qnas: Optional[list["_models.ImportQnaRecord"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The error object.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", and "Warning".
    :vartype code: str or ~azure.ai.language.questionanswering.authoring.models.ErrorCode
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.questionanswering.authoring.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.authoring.models.InnerErrorModel
    """

    code: Union[str, "_models.ErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidArgument\", \"Unauthorized\", \"Forbidden\", \"NotFound\", \"ProjectNotFound\",
     \"OperationNotFound\", \"AzureCognitiveSearchNotFound\", \"AzureCognitiveSearchIndexNotFound\",
     \"TooManyRequests\", \"AzureCognitiveSearchThrottling\",
     \"AzureCognitiveSearchIndexLimitReached\", \"InternalServerError\", \"ServiceUnavailable\",
     \"Timeout\", \"QuotaExceeded\", \"Conflict\", and \"Warning\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the error."""
    details: Optional[list["_models.Error"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about
     the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[list["_models.Error"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.language.questionanswering.authoring.models.Error
    """

    error: "_models.Error" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.Error",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FeedbackRecord(_Model):
    """Feedback Record for Active Learning.

    :ivar user_id: Unique identifier of the user.
    :vartype user_id: str
    :ivar user_question: User suggested question for the QnA.
    :vartype user_question: str
    :ivar qna_id: Unique ID of the QnA.
    :vartype qna_id: int
    """

    user_id: Optional[str] = rest_field(name="userId", visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier of the user."""
    user_question: Optional[str] = rest_field(
        name="userQuestion", visibility=["read", "create", "update", "delete", "query"]
    )
    """User suggested question for the QnA."""
    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """Unique ID of the QnA."""

    @overload
    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        user_question: Optional[str] = None,
        qna_id: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImportFiles(_Model):
    """Collection of files containing project assets that need to be imported.

    :ivar files: Collection of files where the fileName is required. Required.
    :vartype files: list[~azure.ai.language.questionanswering.authoring._utils.utils.FileType]
    """

    files: list[FileType] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], is_multipart_file_input=True
    )
    """Collection of files where the fileName is required. Required."""

    @overload
    def __init__(
        self,
        *,
        files: list[FileType],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImportJobOptions(_Model):
    """Project assets that need to be imported.

    :ivar metadata: Parameters needed to create the project.
    :vartype metadata:
     ~azure.ai.language.questionanswering.authoring.models.QuestionAnsweringProject
    :ivar assets: All assets for this project.
    :vartype assets: ~azure.ai.language.questionanswering.authoring.models.Assets
    :ivar file_uri: Import data File URI.
    :vartype file_uri: str
    """

    metadata: Optional["_models.QuestionAnsweringProject"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters needed to create the project."""
    assets: Optional["_models.Assets"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """All assets for this project."""
    file_uri: Optional[str] = rest_field(name="fileUri", visibility=["read", "create", "update", "delete", "query"])
    """Import data File URI."""

    @overload
    def __init__(
        self,
        *,
        metadata: Optional["_models.QuestionAnsweringProject"] = None,
        assets: Optional["_models.Assets"] = None,
        file_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImportQnaRecord(_Model):
    """Import QnA Record.

    :ivar id: Unique ID for the QnA. Required.
    :vartype id: int
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar source: Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ .
    :vartype source: str
    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Context of a QnA.
    :vartype dialog: ~azure.ai.language.questionanswering.authoring.models.QnaDialog
    :ivar active_learning_suggestions: List of Active Learning suggestions for the QnA.
    :vartype active_learning_suggestions:
     list[~azure.ai.language.questionanswering.authoring.models.SuggestedQuestionsCluster]
    :ivar last_updated_date_time: Date-time when the QnA was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar source_display_name: Friendly name of the Source.
    :vartype source_display_name: str
    """

    id: int = rest_field(visibility=["read", "create"])
    """Unique ID for the QnA. Required."""
    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer text."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ ."""
    questions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of questions associated with the answer."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata associated with the answer, useful to categorize or filter question
     answers."""
    dialog: Optional["_models.QnaDialog"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Context of a QnA."""
    active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = rest_field(
        name="activeLearningSuggestions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Active Learning suggestions for the QnA."""
    last_updated_date_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date-time when the QnA was last updated."""
    source_display_name: Optional[str] = rest_field(
        name="sourceDisplayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Friendly name of the Source."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        answer: Optional[str] = None,
        source: Optional[str] = None,
        questions: Optional[list[str]] = None,
        metadata: Optional[dict[str, str]] = None,
        dialog: Optional["_models.QnaDialog"] = None,
        active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = None,
        last_updated_date_time: Optional[datetime.datetime] = None,
        source_display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerErrorModel(_Model):
    """An object containing more specific information about the error. As per
    Microsoft One API guidelines -
    `https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses
    <https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses>`_.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.language.questionanswering.authoring.models.InnerErrorCode
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.authoring.models.InnerErrorModel
    """

    code: Union[str, "_models.InnerErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidParameterValue\", \"KnowledgeBaseNotFound\", \"AzureCognitiveSearchNotFound\",
     \"AzureCognitiveSearchThrottling\", \"ExtractionFailure\", \"InvalidRequestBodyFormat\",
     \"EmptyRequest\", \"MissingInputDocuments\", \"InvalidDocument\", \"ModelVersionIncorrect\",
     \"InvalidDocumentBatch\", \"UnsupportedLanguageCode\", and \"InvalidCountryHint\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message. Required."""
    details: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error target."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about
     the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectDeployment(_Model):
    """Project deployment details.

    :ivar deployment_name: Name of the deployment. Required.
    :vartype deployment_name: str
    :ivar last_deployed_date_time: Represents the project last deployment date-time.
    :vartype last_deployed_date_time: ~datetime.datetime
    """

    deployment_name: str = rest_field(name="deploymentName", visibility=["read"])
    """Name of the deployment. Required."""
    last_deployed_date_time: Optional[datetime.datetime] = rest_field(
        name="lastDeployedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the project last deployment date-time."""

    @overload
    def __init__(
        self,
        *,
        last_deployed_date_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectSettings(_Model):
    """Configurable settings of the Project.

    :ivar default_answer: Default Answer response when no good match is found in the knowledge
     base.
    :vartype default_answer: str
    """

    default_answer: Optional[str] = rest_field(
        name="defaultAnswer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default Answer response when no good match is found in the knowledge base."""

    @overload
    def __init__(
        self,
        *,
        default_answer: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QnaDialog(_Model):
    """Dialog associated with QnA Record.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true,
     do not include this QnA as answer for queries without context; otherwise,
     ignores context and includes this QnA in answers.
    :vartype is_context_only: bool
    :ivar prompts: List of prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.questionanswering.authoring.models.QnaPrompt]
    """

    is_context_only: Optional[bool] = rest_field(
        name="isContextOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """To mark if a prompt is relevant only with a previous question or not. If true,
     do not include this QnA as answer for queries without context; otherwise,
     ignores context and includes this QnA in answers."""
    prompts: Optional[list["_models.QnaPrompt"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of prompts associated with the answer."""

    @overload
    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[list["_models.QnaPrompt"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QnaPrompt(_Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt. It is used for ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: ID of the QnA corresponding to the prompt.
    :vartype qna_id: int
    :ivar qna: QnA record. Either QnAId or QnA record needs to be present in a Prompt.
    :vartype qna: ~azure.ai.language.questionanswering.authoring.models.QnaRecord
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    display_order: Optional[int] = rest_field(
        name="displayOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index of the prompt. It is used for ordering of the prompts."""
    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """ID of the QnA corresponding to the prompt."""
    qna: Optional["_models.QnaRecord"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """QnA record. Either QnAId or QnA record needs to be present in a Prompt."""
    display_text: Optional[str] = rest_field(
        name="displayText", visibility=["read", "create", "update", "delete", "query"]
    )
    """Text displayed to represent a follow up question prompt."""

    @overload
    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        qna: Optional["_models.QnaRecord"] = None,
        display_text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QnaRecord(_Model):
    """QnA record.

    :ivar id: Unique ID for the QnA. Required.
    :vartype id: int
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar source: Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ .
    :vartype source: str
    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Context of a QnA.
    :vartype dialog: ~azure.ai.language.questionanswering.authoring.models.QnaDialog
    :ivar active_learning_suggestions: List of Active Learning suggestions for the QnA.
    :vartype active_learning_suggestions:
     list[~azure.ai.language.questionanswering.authoring.models.SuggestedQuestionsCluster]
    """

    id: int = rest_field(visibility=["read", "create"])
    """Unique ID for the QnA. Required."""
    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer text."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ ."""
    questions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of questions associated with the answer."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata associated with the answer, useful to categorize or filter question
     answers."""
    dialog: Optional["_models.QnaDialog"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Context of a QnA."""
    active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = rest_field(
        name="activeLearningSuggestions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Active Learning suggestions for the QnA."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        answer: Optional[str] = None,
        source: Optional[str] = None,
        questions: Optional[list[str]] = None,
        metadata: Optional[dict[str, str]] = None,
        dialog: Optional["_models.QnaDialog"] = None,
        active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QnaSourceRecord(_Model):
    """Custom source record with last updated date-time.

    :ivar display_name: Friendly name of the Source.
    :vartype display_name: str
    :ivar source: Unique source identifier. Name of the file if it's a 'file' source; otherwise,
     the complete URL if it's a 'url' source. Required.
    :vartype source: str
    :ivar source_uri: URI location for the file or url. Required.
    :vartype source_uri: str
    :ivar source_kind: Supported source types. Required. Known values are: "file" and "url".
    :vartype source_kind: str or ~azure.ai.language.questionanswering.authoring.models.SourceKind
    :ivar content_structure_kind: Content structure type for sources. "unstructured"
    :vartype content_structure_kind: str or
     ~azure.ai.language.questionanswering.authoring.models.SourceContentStructureKind
    :ivar last_updated_date_time: Date-time when the QnA was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Friendly name of the Source."""
    source: str = rest_field(visibility=["read", "create", "update"])
    """Unique source identifier. Name of the file if it's a 'file' source; otherwise,
     the complete URL if it's a 'url' source. Required."""
    source_uri: str = rest_field(name="sourceUri", visibility=["read", "create", "update", "delete", "query"])
    """URI location for the file or url. Required."""
    source_kind: Union[str, "_models.SourceKind"] = rest_field(
        name="sourceKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Supported source types. Required. Known values are: \"file\" and \"url\"."""
    content_structure_kind: Optional[Union[str, "_models.SourceContentStructureKind"]] = rest_field(
        name="contentStructureKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Content structure type for sources. \"unstructured\""""
    last_updated_date_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date-time when the QnA was last updated."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        source_uri: str,
        source_kind: Union[str, "_models.SourceKind"],
        display_name: Optional[str] = None,
        content_structure_kind: Optional[Union[str, "_models.SourceContentStructureKind"]] = None,
        last_updated_date_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringExportJobState(_Model):
    """Export job status, project metadata, and assets.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    :ivar result_url: URL to download the result of the Export Job. Required.
    :vartype result_url: str
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""
    result_url: str = rest_field(name="resultUrl", visibility=["read", "create", "update", "delete", "query"])
    """URL to download the result of the Export Job. Required."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        result_url: str,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringImportJobState(_Model):
    """Import job status, project metadata, and assets.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringProjectDeletionJobState(_Model):  # pylint: disable=name-too-long
    """Represents the state of a project deletion job.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringProjectDeploymentJobState(_Model):  # pylint: disable=name-too-long
    """Job state represents the job metadata and any errors.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringUpdateQnasJobState(_Model):  # pylint: disable=name-too-long
    """Job state represents the job metadata and any errors.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringAuthoringUpdateSourcesJobState(_Model):  # pylint: disable=name-too-long
    """Job state represents the job metadata and any errors.

    :ivar created_date_time: The creation date time of the job. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: The expiration date time of the job.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: The last date time the job was updated. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: Job Status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.language.questionanswering.authoring.models.JobStatus
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Job Status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\", \"failed\",
     \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.JobStatus"],
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringProject(_Model):
    """Represents the project.

    :ivar project_name: Name of the project. Required.
    :vartype project_name: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for
     English as default.
    :vartype language: str
    :ivar multilingual_resource: Resource enabled for multiple languages across projects or not.
    :vartype multilingual_resource: bool
    :ivar settings: Configurable settings of the Project.
    :vartype settings: ~azure.ai.language.questionanswering.authoring.models.ProjectSettings
    :ivar created_date_time: Project creation date-time.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified_date_time: Represents the project last modified date-time.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_deployed_date_time: Represents the project last deployment date-time.
    :vartype last_deployed_date_time: ~datetime.datetime
    :ivar configure_semantic_ranking: Represents if semantic ranking is configured.
    :vartype configure_semantic_ranking: bool
    """

    project_name: str = rest_field(name="projectName", visibility=["read"])
    """Name of the project. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the project."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Language of the text records. This is BCP-47 representation of a language. For
     example, use \"en\" for English; \"es\" for Spanish etc. If not set, use \"en\" for
     English as default."""
    multilingual_resource: Optional[bool] = rest_field(
        name="multilingualResource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource enabled for multiple languages across projects or not."""
    settings: Optional["_models.ProjectSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configurable settings of the Project."""
    created_date_time: Optional[datetime.datetime] = rest_field(
        name="createdDateTime", visibility=["read"], format="rfc3339"
    )
    """Project creation date-time."""
    last_modified_date_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedDateTime", visibility=["read"], format="rfc3339"
    )
    """Represents the project last modified date-time."""
    last_deployed_date_time: Optional[datetime.datetime] = rest_field(
        name="lastDeployedDateTime", visibility=["read"], format="rfc3339"
    )
    """Represents the project last deployment date-time."""
    configure_semantic_ranking: Optional[bool] = rest_field(
        name="configureSemanticRanking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents if semantic ranking is configured."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        language: Optional[str] = None,
        multilingual_resource: Optional[bool] = None,
        settings: Optional["_models.ProjectSettings"] = None,
        configure_semantic_ranking: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RetrieveQnaRecord(_Model):
    """QnA Record with last updated date-time.

    :ivar id: Unique ID for the QnA. Required.
    :vartype id: int
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar source: Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ .
    :vartype source: str
    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Context of a QnA.
    :vartype dialog: ~azure.ai.language.questionanswering.authoring.models.QnaDialog
    :ivar active_learning_suggestions: List of Active Learning suggestions for the QnA.
    :vartype active_learning_suggestions:
     list[~azure.ai.language.questionanswering.authoring.models.SuggestedQuestionsCluster]
    :ivar last_updated_date_time: Date-time when the QnA was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    """

    id: int = rest_field(visibility=["read", "create"])
    """Unique ID for the QnA. Required."""
    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer text."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source from which QnA was indexed e.g.
     `https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
     <https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs>`_ ."""
    questions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of questions associated with the answer."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata associated with the answer, useful to categorize or filter question
     answers."""
    dialog: Optional["_models.QnaDialog"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Context of a QnA."""
    active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = rest_field(
        name="activeLearningSuggestions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Active Learning suggestions for the QnA."""
    last_updated_date_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date-time when the QnA was last updated."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        answer: Optional[str] = None,
        source: Optional[str] = None,
        questions: Optional[list[str]] = None,
        metadata: Optional[dict[str, str]] = None,
        dialog: Optional["_models.QnaDialog"] = None,
        active_learning_suggestions: Optional[list["_models.SuggestedQuestionsCluster"]] = None,
        last_updated_date_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SuggestedQuestion(_Model):
    """Question suggested by the Active Learning feature.

    :ivar question: Question suggested by the Active Learning feature.
    :vartype question: str
    :ivar user_suggested_count: The number of times the question was suggested explicitly by the
     user.
    :vartype user_suggested_count: int
    :ivar auto_suggested_count: The number of times the question was suggested automatically by the
     Active
     Learning algorithm.
    :vartype auto_suggested_count: int
    """

    question: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Question suggested by the Active Learning feature."""
    user_suggested_count: Optional[int] = rest_field(
        name="userSuggestedCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of times the question was suggested explicitly by the user."""
    auto_suggested_count: Optional[int] = rest_field(
        name="autoSuggestedCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of times the question was suggested automatically by the Active
     Learning algorithm."""

    @overload
    def __init__(
        self,
        *,
        question: Optional[str] = None,
        user_suggested_count: Optional[int] = None,
        auto_suggested_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SuggestedQuestionsCluster(_Model):
    """Active Learning suggested questions cluster details.

    :ivar cluster_head: Question chosen as the head of suggested questions cluster by Active
     Learning
     clustering algorithm.
    :vartype cluster_head: str
    :ivar suggested_questions: List of all suggested questions for the QnA.
    :vartype suggested_questions:
     list[~azure.ai.language.questionanswering.authoring.models.SuggestedQuestion]
    """

    cluster_head: Optional[str] = rest_field(
        name="clusterHead", visibility=["read", "create", "update", "delete", "query"]
    )
    """Question chosen as the head of suggested questions cluster by Active Learning
     clustering algorithm."""
    suggested_questions: Optional[list["_models.SuggestedQuestion"]] = rest_field(
        name="suggestedQuestions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of all suggested questions for the QnA."""

    @overload
    def __init__(
        self,
        *,
        cluster_head: Optional[str] = None,
        suggested_questions: Optional[list["_models.SuggestedQuestion"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SynonymAssets(_Model):
    """Request payload for updating synonyms.

    :ivar value: The WordAlterations items on this page. Required.
    :vartype value: list[~azure.ai.language.questionanswering.authoring.models.WordAlterations]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    value: list["_models.WordAlterations"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The WordAlterations items on this page. Required."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The link to the next page of items."""

    @overload
    def __init__(
        self,
        *,
        value: list["_models.WordAlterations"],
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateQnaRecord(_Model):
    """QnA record to be updated.

    :ivar op: Update operation type for assets. Required. Known values are: "add", "delete", and
     "replace".
    :vartype op: str or ~azure.ai.language.questionanswering.authoring.models.UpdateOperationKind
    :ivar value: QnA record. Required.
    :vartype value: ~azure.ai.language.questionanswering.authoring.models.QnaRecord
    """

    op: Union[str, "_models.UpdateOperationKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Update operation type for assets. Required. Known values are: \"add\", \"delete\", and
     \"replace\"."""
    value: "_models.QnaRecord" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """QnA record. Required."""

    @overload
    def __init__(
        self,
        *,
        op: Union[str, "_models.UpdateOperationKind"],
        value: "_models.QnaRecord",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateQnaSourceRecord(_Model):
    """Update source record.

    :ivar display_name: Friendly name of the Source.
    :vartype display_name: str
    :ivar source: Unique source identifier. Name of the file if it's a 'file' source; otherwise,
     the complete URL if it's a 'url' source. Required.
    :vartype source: str
    :ivar source_uri: URI location for the file or url. Required.
    :vartype source_uri: str
    :ivar source_kind: Supported source types. Required. Known values are: "file" and "url".
    :vartype source_kind: str or ~azure.ai.language.questionanswering.authoring.models.SourceKind
    :ivar content_structure_kind: Content structure type for sources. "unstructured"
    :vartype content_structure_kind: str or
     ~azure.ai.language.questionanswering.authoring.models.SourceContentStructureKind
    :ivar refresh: Boolean flag used to refresh data from the Source.
    :vartype refresh: bool
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Friendly name of the Source."""
    source: str = rest_field(visibility=["read", "create", "update"])
    """Unique source identifier. Name of the file if it's a 'file' source; otherwise,
     the complete URL if it's a 'url' source. Required."""
    source_uri: str = rest_field(name="sourceUri", visibility=["read", "create", "update", "delete", "query"])
    """URI location for the file or url. Required."""
    source_kind: Union[str, "_models.SourceKind"] = rest_field(
        name="sourceKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Supported source types. Required. Known values are: \"file\" and \"url\"."""
    content_structure_kind: Optional[Union[str, "_models.SourceContentStructureKind"]] = rest_field(
        name="contentStructureKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Content structure type for sources. \"unstructured\""""
    refresh: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Boolean flag used to refresh data from the Source."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        source_uri: str,
        source_kind: Union[str, "_models.SourceKind"],
        display_name: Optional[str] = None,
        content_structure_kind: Optional[Union[str, "_models.SourceContentStructureKind"]] = None,
        refresh: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSourceFiles(_Model):
    """Collection of files containing project assets that need to be imported.

    :ivar files: Collection of files where the fileName is required. Required.
    :vartype files: list[~azure.ai.language.questionanswering.authoring._utils.utils.FileType]
    :ivar file_operations: Collection of file operations to perform during update of sources.
     Required.
    :vartype file_operations:
     list[~azure.ai.language.questionanswering.authoring.models.UpdateSourceFromFileOperationRecord]
    """

    files: list[FileType] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], is_multipart_file_input=True
    )
    """Collection of files where the fileName is required. Required."""
    file_operations: list["_models.UpdateSourceFromFileOperationRecord"] = rest_field(
        name="fileOperations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Collection of file operations to perform during update of sources. Required."""

    @overload
    def __init__(
        self,
        *,
        files: list[FileType],
        file_operations: list["_models.UpdateSourceFromFileOperationRecord"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSourceFromFileOperationRecord(_Model):
    """A single file operation for updating sources for a project. Used to add, remove or replace a
    source from a knowledgebase.

    :ivar operation: Update operation type for assets. Required. Known values are: "add", "delete",
     and "replace".
    :vartype operation: str or
     ~azure.ai.language.questionanswering.authoring.models.UpdateOperationKind
    :ivar file_display_name: Friendly name of the Source. If not provided, would be equal to
     fileSource.
    :vartype file_display_name: str
    :ivar file_name: This would be name of the file. This links to the fileName of the file being
     sent in multipart. Required.
    :vartype file_name: str
    :ivar refresh: Bool value for refresh.
    :vartype refresh: bool
    """

    operation: Union[str, "_models.UpdateOperationKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Update operation type for assets. Required. Known values are: \"add\", \"delete\", and
     \"replace\"."""
    file_display_name: Optional[str] = rest_field(
        name="fileDisplayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Friendly name of the Source. If not provided, would be equal to fileSource."""
    file_name: str = rest_field(name="fileName", visibility=["read", "create", "update", "delete", "query"])
    """This would be name of the file. This links to the fileName of the file being sent in multipart.
     Required."""
    refresh: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bool value for refresh."""

    @overload
    def __init__(
        self,
        *,
        operation: Union[str, "_models.UpdateOperationKind"],
        file_name: str,
        file_display_name: Optional[str] = None,
        refresh: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSourceRecord(_Model):
    """Source to be updated.

    :ivar op: Update operation type for assets. Required. Known values are: "add", "delete", and
     "replace".
    :vartype op: str or ~azure.ai.language.questionanswering.authoring.models.UpdateOperationKind
    :ivar value: Update source record. Required.
    :vartype value: ~azure.ai.language.questionanswering.authoring.models.UpdateQnaSourceRecord
    """

    op: Union[str, "_models.UpdateOperationKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Update operation type for assets. Required. Known values are: \"add\", \"delete\", and
     \"replace\"."""
    value: "_models.UpdateQnaSourceRecord" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Update source record. Required."""

    @overload
    def __init__(
        self,
        *,
        op: Union[str, "_models.UpdateOperationKind"],
        value: "_models.UpdateQnaSourceRecord",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WordAlterations(_Model):
    """Collection of word alterations.

    :ivar alterations: Collection of word alterations. Required.
    :vartype alterations: list[str]
    """

    alterations: list[str] = rest_field(visibility=["read", "create", "update"])
    """Collection of word alterations. Required."""

    @overload
    def __init__(
        self,
        *,
        alterations: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
