# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._source_control_configuration_client_enums import *


class BucketDefinition(msrest.serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration S3 bucket.
    :vartype url: str
    :ivar bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
    :vartype bucket_name: str
    :ivar insecure: Specify whether to use insecure communication when puling data from the S3
     bucket.
    :vartype insecure: bool
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: long
    :ivar access_key: Plaintext access key used to securely access the S3 bucket.
    :vartype access_key: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'bucket_name': {'key': 'bucketName', 'type': 'str'},
        'insecure': {'key': 'insecure', 'type': 'bool'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'local_auth_ref': {'key': 'localAuthRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        bucket_name: Optional[str] = None,
        insecure: Optional[bool] = True,
        timeout_in_seconds: Optional[int] = 600,
        sync_interval_in_seconds: Optional[int] = 600,
        access_key: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL to sync for the flux configuration S3 bucket.
        :paramtype url: str
        :keyword bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
        :paramtype bucket_name: str
        :keyword insecure: Specify whether to use insecure communication when puling data from the S3
         bucket.
        :paramtype insecure: bool
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: long
        :keyword access_key: Plaintext access key used to securely access the S3 bucket.
        :paramtype access_key: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super(BucketDefinition, self).__init__(**kwargs)
        self.url = url
        self.bucket_name = bucket_name
        self.insecure = insecure
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.access_key = access_key
        self.local_auth_ref = local_auth_ref


class BucketPatchDefinition(msrest.serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration S3 bucket.
    :vartype url: str
    :ivar bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
    :vartype bucket_name: str
    :ivar insecure: Specify whether to use insecure communication when puling data from the S3
     bucket.
    :vartype insecure: bool
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: long
    :ivar access_key: Plaintext access key used to securely access the S3 bucket.
    :vartype access_key: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'bucket_name': {'key': 'bucketName', 'type': 'str'},
        'insecure': {'key': 'insecure', 'type': 'bool'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'local_auth_ref': {'key': 'localAuthRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        bucket_name: Optional[str] = None,
        insecure: Optional[bool] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        access_key: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL to sync for the flux configuration S3 bucket.
        :paramtype url: str
        :keyword bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
        :paramtype bucket_name: str
        :keyword insecure: Specify whether to use insecure communication when puling data from the S3
         bucket.
        :paramtype insecure: bool
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: long
        :keyword access_key: Plaintext access key used to securely access the S3 bucket.
        :paramtype access_key: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super(BucketPatchDefinition, self).__init__(**kwargs)
        self.url = url
        self.bucket_name = bucket_name
        self.insecure = insecure
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.access_key = access_key
        self.local_auth_ref = local_auth_ref


class ComplianceStatus(msrest.serialization.Model):
    """Compliance Status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: The compliance state of the configuration. Possible values include:
     "Pending", "Compliant", "Noncompliant", "Installed", "Failed".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ComplianceStateType
    :ivar last_config_applied: Datetime the configuration was last applied.
    :vartype last_config_applied: ~datetime.datetime
    :ivar message: Message from when the configuration was applied.
    :vartype message: str
    :ivar message_level: Level of the message. Possible values include: "Error", "Warning",
     "Information".
    :vartype message_level: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.MessageLevelType
    """

    _validation = {
        'compliance_state': {'readonly': True},
    }

    _attribute_map = {
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'last_config_applied': {'key': 'lastConfigApplied', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'message_level': {'key': 'messageLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_config_applied: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        message_level: Optional[Union[str, "MessageLevelType"]] = None,
        **kwargs
    ):
        """
        :keyword last_config_applied: Datetime the configuration was last applied.
        :paramtype last_config_applied: ~datetime.datetime
        :keyword message: Message from when the configuration was applied.
        :paramtype message: str
        :keyword message_level: Level of the message. Possible values include: "Error", "Warning",
         "Information".
        :paramtype message_level: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.MessageLevelType
        """
        super(ComplianceStatus, self).__init__(**kwargs)
        self.compliance_state = None
        self.last_config_applied = last_config_applied
        self.message = message
        self.message_level = message_level


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class Extension(ProxyResource):
    """The Extension object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: Identity of the Extension resource.
    :vartype identity: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.Identity
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SystemData
    :ivar extension_type: Type of the Extension, of which this resource is an instance of.  It must
     be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
     Extension publisher.
    :vartype extension_type: str
    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: User-specified version of the extension for this extension to 'pin'. To use
     'version', autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar scope: Scope at which the extension is installed.
    :vartype scope: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.Scope
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar installed_version: Installed version of the extension.
    :vartype installed_version: str
    :ivar provisioning_state: Status of installation of this extension. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ProvisioningState
    :ivar statuses: Status from this extension.
    :vartype statuses: list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ExtensionStatus]
    :ivar error_info: Error information from the Agent - e.g. errors during installation.
    :vartype error_info: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorDetail
    :ivar custom_location_settings: Custom Location settings properties.
    :vartype custom_location_settings: dict[str, str]
    :ivar package_uri: Uri of the Helm package.
    :vartype package_uri: str
    :ivar aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
    :vartype aks_assigned_identity:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ExtensionPropertiesAksAssignedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'installed_version': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'error_info': {'readonly': True},
        'custom_location_settings': {'readonly': True},
        'package_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'extension_type': {'key': 'properties.extensionType', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'release_train': {'key': 'properties.releaseTrain', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'Scope'},
        'configuration_settings': {'key': 'properties.configurationSettings', 'type': '{str}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'installed_version': {'key': 'properties.installedVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ExtensionStatus]'},
        'error_info': {'key': 'properties.errorInfo', 'type': 'ErrorDetail'},
        'custom_location_settings': {'key': 'properties.customLocationSettings', 'type': '{str}'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'aks_assigned_identity': {'key': 'properties.aksAssignedIdentity', 'type': 'ExtensionPropertiesAksAssignedIdentity'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        extension_type: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = True,
        release_train: Optional[str] = "Stable",
        version: Optional[str] = None,
        scope: Optional["Scope"] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        statuses: Optional[List["ExtensionStatus"]] = None,
        aks_assigned_identity: Optional["ExtensionPropertiesAksAssignedIdentity"] = None,
        **kwargs
    ):
        """
        :keyword identity: Identity of the Extension resource.
        :paramtype identity: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.Identity
        :keyword extension_type: Type of the Extension, of which this resource is an instance of.  It
         must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
         Extension publisher.
        :paramtype extension_type: str
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: User-specified version of the extension for this extension to 'pin'. To use
         'version', autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword scope: Scope at which the extension is installed.
        :paramtype scope: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.Scope
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword statuses: Status from this extension.
        :paramtype statuses:
         list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ExtensionStatus]
        :keyword aks_assigned_identity: Identity of the Extension resource in an AKS cluster.
        :paramtype aks_assigned_identity:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ExtensionPropertiesAksAssignedIdentity
        """
        super(Extension, self).__init__(**kwargs)
        self.identity = identity
        self.system_data = None
        self.extension_type = extension_type
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.scope = scope
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings
        self.installed_version = None
        self.provisioning_state = None
        self.statuses = statuses
        self.error_info = None
        self.custom_location_settings = None
        self.package_uri = None
        self.aks_assigned_identity = aks_assigned_identity


class ExtensionPropertiesAksAssignedIdentity(msrest.serialization.Model):
    """Identity of the Extension resource in an AKS cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Possible values include: "SystemAssigned", "UserAssigned".
    :vartype type: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.AKSIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "AKSIdentityType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Possible values include: "SystemAssigned", "UserAssigned".
        :paramtype type: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.AKSIdentityType
        """
        super(ExtensionPropertiesAksAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ExtensionsList(msrest.serialization.Model):
    """Result of the request to list Extensions.  It contains a list of Extension objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extensions within a Kubernetes cluster.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.Extension]
    :ivar next_link: URL to get the next set of extension objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Extension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExtensionsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtensionStatus(msrest.serialization.Model):
    """Status from the extension.

    :ivar code: Status code provided by the Extension.
    :vartype code: str
    :ivar display_status: Short description of status of the extension.
    :vartype display_status: str
    :ivar level: Level of the status. Possible values include: "Error", "Warning", "Information".
     Default value: "Information".
    :vartype level: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.LevelType
    :ivar message: Detailed message of the status from the Extension.
    :vartype message: str
    :ivar time: DateLiteral (per ISO8601) noting the time of installation status.
    :vartype time: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Optional[Union[str, "LevelType"]] = "Information",
        message: Optional[str] = None,
        time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Status code provided by the Extension.
        :paramtype code: str
        :keyword display_status: Short description of status of the extension.
        :paramtype display_status: str
        :keyword level: Level of the status. Possible values include: "Error", "Warning",
         "Information". Default value: "Information".
        :paramtype level: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.LevelType
        :keyword message: Detailed message of the status from the Extension.
        :paramtype message: str
        :keyword time: DateLiteral (per ISO8601) noting the time of installation status.
        :paramtype time: str
        """
        super(ExtensionStatus, self).__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.level = level
        self.message = message
        self.time = time


class FluxConfiguration(ProxyResource):
    """The Flux Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SystemData
    :ivar scope: Scope at which the operator will be installed. Possible values include: "cluster",
     "namespace". Default value: "cluster".
    :vartype scope: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeType
    :ivar namespace: The namespace to which this configuration is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype namespace: str
    :ivar source_kind: Source Kind to pull the configuration data from. Possible values include:
     "GitRepository", "Bucket".
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.GitRepositoryDefinition
    :ivar bucket: Parameters to reconcile to the Bucket source kind type.
    :vartype bucket: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.BucketDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.KustomizationDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar statuses: Statuses of the Flux Kubernetes resources created by the fluxConfiguration or
     created by the managed objects provisioned by the fluxConfiguration.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectStatusDefinition]
    :ivar repository_public_key: Public Key associated with this fluxConfiguration (either
     generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar source_synced_commit_id: Branch and/or SHA of the source commit synced with the cluster.
    :vartype source_synced_commit_id: str
    :ivar source_updated_at: Datetime the fluxConfiguration synced its source on the cluster.
    :vartype source_updated_at: ~datetime.datetime
    :ivar status_updated_at: Datetime the fluxConfiguration synced its status on the cluster with
     Azure.
    :vartype status_updated_at: ~datetime.datetime
    :ivar compliance_state: Combined status of the Flux Kubernetes resources created by the
     fluxConfiguration or created by the managed objects. Possible values include: "Compliant",
     "Non-Compliant", "Pending", "Suspended", "Unknown". Default value: "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.FluxComplianceState
    :ivar provisioning_state: Status of the creation of the fluxConfiguration. Possible values
     include: "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ProvisioningState
    :ivar error_message: Error message returned to the user in the case of provisioning failure.
    :vartype error_message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'statuses': {'readonly': True},
        'repository_public_key': {'readonly': True},
        'source_synced_commit_id': {'readonly': True},
        'source_updated_at': {'readonly': True},
        'status_updated_at': {'readonly': True},
        'compliance_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'namespace': {'key': 'properties.namespace', 'type': 'str'},
        'source_kind': {'key': 'properties.sourceKind', 'type': 'str'},
        'suspend': {'key': 'properties.suspend', 'type': 'bool'},
        'git_repository': {'key': 'properties.gitRepository', 'type': 'GitRepositoryDefinition'},
        'bucket': {'key': 'properties.bucket', 'type': 'BucketDefinition'},
        'kustomizations': {'key': 'properties.kustomizations', 'type': '{KustomizationDefinition}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'statuses': {'key': 'properties.statuses', 'type': '[ObjectStatusDefinition]'},
        'repository_public_key': {'key': 'properties.repositoryPublicKey', 'type': 'str'},
        'source_synced_commit_id': {'key': 'properties.sourceSyncedCommitId', 'type': 'str'},
        'source_updated_at': {'key': 'properties.sourceUpdatedAt', 'type': 'iso-8601'},
        'status_updated_at': {'key': 'properties.statusUpdatedAt', 'type': 'iso-8601'},
        'compliance_state': {'key': 'properties.complianceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scope: Optional[Union[str, "ScopeType"]] = "cluster",
        namespace: Optional[str] = "default",
        source_kind: Optional[Union[str, "SourceKindType"]] = None,
        suspend: Optional[bool] = False,
        git_repository: Optional["GitRepositoryDefinition"] = None,
        bucket: Optional["BucketDefinition"] = None,
        kustomizations: Optional[Dict[str, "KustomizationDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword scope: Scope at which the operator will be installed. Possible values include:
         "cluster", "namespace". Default value: "cluster".
        :paramtype scope: str or ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeType
        :keyword namespace: The namespace to which this configuration is installed to. Maximum of 253
         lower case alphanumeric characters, hyphen and period only.
        :paramtype namespace: str
        :keyword source_kind: Source Kind to pull the configuration data from. Possible values include:
         "GitRepository", "Bucket".
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.GitRepositoryDefinition
        :keyword bucket: Parameters to reconcile to the Bucket source kind type.
        :paramtype bucket: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.BucketDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.KustomizationDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super(FluxConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.scope = scope
        self.namespace = namespace
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.bucket = bucket
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings
        self.statuses = None
        self.repository_public_key = None
        self.source_synced_commit_id = None
        self.source_updated_at = None
        self.status_updated_at = None
        self.compliance_state = None
        self.provisioning_state = None
        self.error_message = None


class FluxConfigurationPatch(msrest.serialization.Model):
    """The Flux Configuration Patch Request object.

    :ivar source_kind: Source Kind to pull the configuration data from. Possible values include:
     "GitRepository", "Bucket".
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.GitRepositoryPatchDefinition
    :ivar bucket: Parameters to reconcile to the Bucket source kind type.
    :vartype bucket: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.BucketPatchDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.KustomizationPatchDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        'source_kind': {'key': 'properties.sourceKind', 'type': 'str'},
        'suspend': {'key': 'properties.suspend', 'type': 'bool'},
        'git_repository': {'key': 'properties.gitRepository', 'type': 'GitRepositoryPatchDefinition'},
        'bucket': {'key': 'properties.bucket', 'type': 'BucketPatchDefinition'},
        'kustomizations': {'key': 'properties.kustomizations', 'type': '{KustomizationPatchDefinition}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        source_kind: Optional[Union[str, "SourceKindType"]] = None,
        suspend: Optional[bool] = None,
        git_repository: Optional["GitRepositoryPatchDefinition"] = None,
        bucket: Optional["BucketPatchDefinition"] = None,
        kustomizations: Optional[Dict[str, "KustomizationPatchDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword source_kind: Source Kind to pull the configuration data from. Possible values include:
         "GitRepository", "Bucket".
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.GitRepositoryPatchDefinition
        :keyword bucket: Parameters to reconcile to the Bucket source kind type.
        :paramtype bucket: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.BucketPatchDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.KustomizationPatchDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super(FluxConfigurationPatch, self).__init__(**kwargs)
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.bucket = bucket
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings


class FluxConfigurationsList(msrest.serialization.Model):
    """Result of the request to list Flux Configurations.  It contains a list of FluxConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Flux Configurations within a Kubernetes cluster.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.FluxConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FluxConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FluxConfigurationsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GitRepositoryDefinition(msrest.serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration git repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: long
    :ivar repository_ref: The source reference for the GitRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.RepositoryRefDefinition
    :ivar ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to
     access private git repositories over SSH.
    :vartype ssh_known_hosts: str
    :ivar https_user: Plaintext HTTPS username used to access private git repositories over HTTPS.
    :vartype https_user: str
    :ivar https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
     private git repositories over HTTPS.
    :vartype https_ca_cert: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'repository_ref': {'key': 'repositoryRef', 'type': 'RepositoryRefDefinition'},
        'ssh_known_hosts': {'key': 'sshKnownHosts', 'type': 'str'},
        'https_user': {'key': 'httpsUser', 'type': 'str'},
        'https_ca_cert': {'key': 'httpsCACert', 'type': 'str'},
        'local_auth_ref': {'key': 'localAuthRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: Optional[int] = 600,
        sync_interval_in_seconds: Optional[int] = 600,
        repository_ref: Optional["RepositoryRefDefinition"] = None,
        ssh_known_hosts: Optional[str] = None,
        https_user: Optional[str] = None,
        https_ca_cert: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL to sync for the flux configuration git repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: long
        :keyword repository_ref: The source reference for the GitRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.RepositoryRefDefinition
        :keyword ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required
         to access private git repositories over SSH.
        :paramtype ssh_known_hosts: str
        :keyword https_user: Plaintext HTTPS username used to access private git repositories over
         HTTPS.
        :paramtype https_user: str
        :keyword https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
         private git repositories over HTTPS.
        :paramtype https_ca_cert: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super(GitRepositoryDefinition, self).__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.ssh_known_hosts = ssh_known_hosts
        self.https_user = https_user
        self.https_ca_cert = https_ca_cert
        self.local_auth_ref = local_auth_ref


class GitRepositoryPatchDefinition(msrest.serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration git repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: long
    :ivar repository_ref: The source reference for the GitRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.RepositoryRefDefinition
    :ivar ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to
     access private git repositories over SSH.
    :vartype ssh_known_hosts: str
    :ivar https_user: Plaintext HTTPS username used to access private git repositories over HTTPS.
    :vartype https_user: str
    :ivar https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
     private git repositories over HTTPS.
    :vartype https_ca_cert: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'repository_ref': {'key': 'repositoryRef', 'type': 'RepositoryRefDefinition'},
        'ssh_known_hosts': {'key': 'sshKnownHosts', 'type': 'str'},
        'https_user': {'key': 'httpsUser', 'type': 'str'},
        'https_ca_cert': {'key': 'httpsCACert', 'type': 'str'},
        'local_auth_ref': {'key': 'localAuthRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        repository_ref: Optional["RepositoryRefDefinition"] = None,
        ssh_known_hosts: Optional[str] = None,
        https_user: Optional[str] = None,
        https_ca_cert: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL to sync for the flux configuration git repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: long
        :keyword repository_ref: The source reference for the GitRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.RepositoryRefDefinition
        :keyword ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required
         to access private git repositories over SSH.
        :paramtype ssh_known_hosts: str
        :keyword https_user: Plaintext HTTPS username used to access private git repositories over
         HTTPS.
        :paramtype https_user: str
        :keyword https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
         private git repositories over HTTPS.
        :paramtype https_ca_cert: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super(GitRepositoryPatchDefinition, self).__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.ssh_known_hosts = ssh_known_hosts
        self.https_user = https_user
        self.https_ca_cert = https_ca_cert
        self.local_auth_ref = local_auth_ref


class HelmOperatorProperties(msrest.serialization.Model):
    """Properties for Helm operator.

    :ivar chart_version: Version of the operator Helm chart.
    :vartype chart_version: str
    :ivar chart_values: Values override for the operator Helm chart.
    :vartype chart_values: str
    """

    _attribute_map = {
        'chart_version': {'key': 'chartVersion', 'type': 'str'},
        'chart_values': {'key': 'chartValues', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        chart_version: Optional[str] = None,
        chart_values: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword chart_version: Version of the operator Helm chart.
        :paramtype chart_version: str
        :keyword chart_values: Values override for the operator Helm chart.
        :paramtype chart_values: str
        """
        super(HelmOperatorProperties, self).__init__(**kwargs)
        self.chart_version = chart_version
        self.chart_values = chart_values


class HelmReleasePropertiesDefinition(msrest.serialization.Model):
    """Properties for HelmRelease objects.

    :ivar last_revision_applied: The revision number of the last released object change.
    :vartype last_revision_applied: long
    :ivar helm_chart_ref: The reference to the HelmChart object used as the source to this
     HelmRelease.
    :vartype helm_chart_ref:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectReferenceDefinition
    :ivar failure_count: Total number of times that the HelmRelease failed to install or upgrade.
    :vartype failure_count: long
    :ivar install_failure_count: Number of times that the HelmRelease failed to install.
    :vartype install_failure_count: long
    :ivar upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
    :vartype upgrade_failure_count: long
    """

    _attribute_map = {
        'last_revision_applied': {'key': 'lastRevisionApplied', 'type': 'long'},
        'helm_chart_ref': {'key': 'helmChartRef', 'type': 'ObjectReferenceDefinition'},
        'failure_count': {'key': 'failureCount', 'type': 'long'},
        'install_failure_count': {'key': 'installFailureCount', 'type': 'long'},
        'upgrade_failure_count': {'key': 'upgradeFailureCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        last_revision_applied: Optional[int] = None,
        helm_chart_ref: Optional["ObjectReferenceDefinition"] = None,
        failure_count: Optional[int] = None,
        install_failure_count: Optional[int] = None,
        upgrade_failure_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword last_revision_applied: The revision number of the last released object change.
        :paramtype last_revision_applied: long
        :keyword helm_chart_ref: The reference to the HelmChart object used as the source to this
         HelmRelease.
        :paramtype helm_chart_ref:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectReferenceDefinition
        :keyword failure_count: Total number of times that the HelmRelease failed to install or
         upgrade.
        :paramtype failure_count: long
        :keyword install_failure_count: Number of times that the HelmRelease failed to install.
        :paramtype install_failure_count: long
        :keyword upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
        :paramtype upgrade_failure_count: long
        """
        super(HelmReleasePropertiesDefinition, self).__init__(**kwargs)
        self.last_revision_applied = last_revision_applied
        self.helm_chart_ref = helm_chart_ref
        self.failure_count = failure_count
        self.install_failure_count = install_failure_count
        self.upgrade_failure_count = upgrade_failure_count


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. The only acceptable values to pass in are None and
         "SystemAssigned". The default value is None.
        :paramtype type: str
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class KustomizationDefinition(msrest.serialization.Model):
    """The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Kustomization, matching the key in the Kustomizations object map.
    :vartype name: str
    :ivar path: The path in the source reference to reconcile on the cluster.
    :vartype path: str
    :ivar depends_on: Specifies other Kustomizations that this Kustomization depends on. This
     Kustomization will not reconcile until all dependencies have completed their reconciliation.
    :vartype depends_on: list[str]
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
     cluster.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster.
    :vartype sync_interval_in_seconds: long
    :ivar retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster in the event of failure on reconciliation.
    :vartype retry_interval_in_seconds: long
    :ivar prune: Enable/disable garbage collections of Kubernetes objects created by this
     Kustomization.
    :vartype prune: bool
    :ivar force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails
     due to an immutable field change.
    :vartype force: bool
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[str]'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'long'},
        'prune': {'key': 'prune', 'type': 'bool'},
        'force': {'key': 'force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = "",
        depends_on: Optional[List[str]] = None,
        timeout_in_seconds: Optional[int] = 600,
        sync_interval_in_seconds: Optional[int] = 600,
        retry_interval_in_seconds: Optional[int] = None,
        prune: Optional[bool] = False,
        force: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword path: The path in the source reference to reconcile on the cluster.
        :paramtype path: str
        :keyword depends_on: Specifies other Kustomizations that this Kustomization depends on. This
         Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :paramtype depends_on: list[str]
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
         cluster.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster.
        :paramtype sync_interval_in_seconds: long
        :keyword retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster in the event of failure on reconciliation.
        :paramtype retry_interval_in_seconds: long
        :keyword prune: Enable/disable garbage collections of Kubernetes objects created by this
         Kustomization.
        :paramtype prune: bool
        :keyword force: Enable/disable re-creating Kubernetes resources on the cluster when patching
         fails due to an immutable field change.
        :paramtype force: bool
        """
        super(KustomizationDefinition, self).__init__(**kwargs)
        self.name = None
        self.path = path
        self.depends_on = depends_on
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.prune = prune
        self.force = force


class KustomizationPatchDefinition(msrest.serialization.Model):
    """The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.

    :ivar path: The path in the source reference to reconcile on the cluster.
    :vartype path: str
    :ivar depends_on: Specifies other Kustomizations that this Kustomization depends on. This
     Kustomization will not reconcile until all dependencies have completed their reconciliation.
    :vartype depends_on: list[str]
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
     cluster.
    :vartype timeout_in_seconds: long
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster.
    :vartype sync_interval_in_seconds: long
    :ivar retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster in the event of failure on reconciliation.
    :vartype retry_interval_in_seconds: long
    :ivar prune: Enable/disable garbage collections of Kubernetes objects created by this
     Kustomization.
    :vartype prune: bool
    :ivar force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails
     due to an immutable field change.
    :vartype force: bool
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[str]'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'sync_interval_in_seconds': {'key': 'syncIntervalInSeconds', 'type': 'long'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'long'},
        'prune': {'key': 'prune', 'type': 'bool'},
        'force': {'key': 'force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        depends_on: Optional[List[str]] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        retry_interval_in_seconds: Optional[int] = None,
        prune: Optional[bool] = None,
        force: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword path: The path in the source reference to reconcile on the cluster.
        :paramtype path: str
        :keyword depends_on: Specifies other Kustomizations that this Kustomization depends on. This
         Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :paramtype depends_on: list[str]
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
         cluster.
        :paramtype timeout_in_seconds: long
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster.
        :paramtype sync_interval_in_seconds: long
        :keyword retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster in the event of failure on reconciliation.
        :paramtype retry_interval_in_seconds: long
        :keyword prune: Enable/disable garbage collections of Kubernetes objects created by this
         Kustomization.
        :paramtype prune: bool
        :keyword force: Enable/disable re-creating Kubernetes resources on the cluster when patching
         fails due to an immutable field change.
        :paramtype force: bool
        """
        super(KustomizationPatchDefinition, self).__init__(**kwargs)
        self.path = path
        self.depends_on = depends_on
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.prune = prune
        self.force = force


class ObjectReferenceDefinition(msrest.serialization.Model):
    """Object reference to a Kubernetes object on a cluster.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar namespace: Namespace of the object.
    :vartype namespace: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the object.
        :paramtype name: str
        :keyword namespace: Namespace of the object.
        :paramtype namespace: str
        """
        super(ObjectReferenceDefinition, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace


class ObjectStatusConditionDefinition(msrest.serialization.Model):
    """Status condition of Kubernetes object.

    :ivar last_transition_time: Last time this status condition has changed.
    :vartype last_transition_time: ~datetime.datetime
    :ivar message: A more verbose description of the object status condition.
    :vartype message: str
    :ivar reason: Reason for the specified status condition type status.
    :vartype reason: str
    :ivar status: Status of the Kubernetes object condition type.
    :vartype status: str
    :ivar type: Object status condition type for this object.
    :vartype type: str
    """

    _attribute_map = {
        'last_transition_time': {'key': 'lastTransitionTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_transition_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        reason: Optional[str] = None,
        status: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword last_transition_time: Last time this status condition has changed.
        :paramtype last_transition_time: ~datetime.datetime
        :keyword message: A more verbose description of the object status condition.
        :paramtype message: str
        :keyword reason: Reason for the specified status condition type status.
        :paramtype reason: str
        :keyword status: Status of the Kubernetes object condition type.
        :paramtype status: str
        :keyword type: Object status condition type for this object.
        :paramtype type: str
        """
        super(ObjectStatusConditionDefinition, self).__init__(**kwargs)
        self.last_transition_time = last_transition_time
        self.message = message
        self.reason = reason
        self.status = status
        self.type = type


class ObjectStatusDefinition(msrest.serialization.Model):
    """Statuses of objects deployed by the user-specified kustomizations from the git repository.

    :ivar name: Name of the applied object.
    :vartype name: str
    :ivar namespace: Namespace of the applied object.
    :vartype namespace: str
    :ivar kind: Kind of the applied object.
    :vartype kind: str
    :ivar compliance_state: Compliance state of the applied object showing whether the applied
     object has come into a ready state on the cluster. Possible values include: "Compliant",
     "Non-Compliant", "Pending", "Suspended", "Unknown". Default value: "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.FluxComplianceState
    :ivar applied_by: Object reference to the Kustomization that applied this object.
    :vartype applied_by:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectReferenceDefinition
    :ivar status_conditions: List of Kubernetes object status conditions present on the cluster.
    :vartype status_conditions:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectStatusConditionDefinition]
    :ivar helm_release_properties: Additional properties that are provided from objects of the
     HelmRelease kind.
    :vartype helm_release_properties:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.HelmReleasePropertiesDefinition
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'applied_by': {'key': 'appliedBy', 'type': 'ObjectReferenceDefinition'},
        'status_conditions': {'key': 'statusConditions', 'type': '[ObjectStatusConditionDefinition]'},
        'helm_release_properties': {'key': 'helmReleaseProperties', 'type': 'HelmReleasePropertiesDefinition'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        kind: Optional[str] = None,
        compliance_state: Optional[Union[str, "FluxComplianceState"]] = "Unknown",
        applied_by: Optional["ObjectReferenceDefinition"] = None,
        status_conditions: Optional[List["ObjectStatusConditionDefinition"]] = None,
        helm_release_properties: Optional["HelmReleasePropertiesDefinition"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the applied object.
        :paramtype name: str
        :keyword namespace: Namespace of the applied object.
        :paramtype namespace: str
        :keyword kind: Kind of the applied object.
        :paramtype kind: str
        :keyword compliance_state: Compliance state of the applied object showing whether the applied
         object has come into a ready state on the cluster. Possible values include: "Compliant",
         "Non-Compliant", "Pending", "Suspended", "Unknown". Default value: "Unknown".
        :paramtype compliance_state: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.FluxComplianceState
        :keyword applied_by: Object reference to the Kustomization that applied this object.
        :paramtype applied_by:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectReferenceDefinition
        :keyword status_conditions: List of Kubernetes object status conditions present on the cluster.
        :paramtype status_conditions:
         list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ObjectStatusConditionDefinition]
        :keyword helm_release_properties: Additional properties that are provided from objects of the
         HelmRelease kind.
        :paramtype helm_release_properties:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.HelmReleasePropertiesDefinition
        """
        super(ObjectStatusDefinition, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.kind = kind
        self.compliance_state = compliance_state
        self.applied_by = applied_by
        self.status_conditions = status_conditions
        self.helm_release_properties = helm_release_properties


class OperationStatusList(msrest.serialization.Model):
    """The async operations in progress, in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of async operations in progress, in the cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.OperationStatusResult]
    :ivar next_link: URL to get the next set of Operation Result objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationStatusResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationStatusList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(msrest.serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Required. Operation status.
    :vartype status: str
    :ivar properties: Additional information, if available.
    :vartype properties: dict[str, str]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ErrorDetail
    """

    _validation = {
        'status': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,
        name: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Required. Operation status.
        :paramtype status: str
        :keyword properties: Additional information, if available.
        :paramtype properties: dict[str, str]
        """
        super(OperationStatusResult, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = None


class PatchExtension(msrest.serialization.Model):
    """The Extension Patch Request object.

    :ivar auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable,
     Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version of the extension for this extension, if it is 'pinned' to a specific
     version. autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'release_train': {'key': 'properties.releaseTrain', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'configuration_settings': {'key': 'properties.configurationSettings', 'type': '{str}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        auto_upgrade_minor_version: Optional[bool] = True,
        release_train: Optional[str] = "Stable",
        version: Optional[str] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword auto_upgrade_minor_version: Flag to note if this extension participates in auto
         upgrade of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
         Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version of the extension for this extension, if it is 'pinned' to a specific
         version. autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this extension.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super(PatchExtension, self).__init__(**kwargs)
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings


class RepositoryRefDefinition(msrest.serialization.Model):
    """The source reference for the GitRepository object.

    :ivar branch: The git repository branch name to checkout.
    :vartype branch: str
    :ivar tag: The git repository tag name to checkout. This takes precedence over branch.
    :vartype tag: str
    :ivar semver: The semver range used to match against git repository tags. This takes precedence
     over tag.
    :vartype semver: str
    :ivar commit: The commit SHA to checkout. This value must be combined with the branch name to
     be valid. This takes precedence over semver.
    :vartype commit: str
    """

    _attribute_map = {
        'branch': {'key': 'branch', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'semver': {'key': 'semver', 'type': 'str'},
        'commit': {'key': 'commit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        tag: Optional[str] = None,
        semver: Optional[str] = None,
        commit: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword branch: The git repository branch name to checkout.
        :paramtype branch: str
        :keyword tag: The git repository tag name to checkout. This takes precedence over branch.
        :paramtype tag: str
        :keyword semver: The semver range used to match against git repository tags. This takes
         precedence over tag.
        :paramtype semver: str
        :keyword commit: The commit SHA to checkout. This value must be combined with the branch name
         to be valid. This takes precedence over semver.
        :paramtype commit: str
        """
        super(RepositoryRefDefinition, self).__init__(**kwargs)
        self.branch = branch
        self.tag = tag
        self.semver = semver
        self.commit = commit


class ResourceProviderOperation(msrest.serialization.Model):
    """Supported operation of this resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name, in format of {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ResourceProviderOperationDisplay
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _validation = {
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["ResourceProviderOperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name, in format of {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ResourceProviderOperationDisplay
        """
        super(ResourceProviderOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = None
        self.origin = None


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Resource provider: Microsoft KubernetesConfiguration.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of this operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Resource provider: Microsoft KubernetesConfiguration.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of this operation.
        :paramtype description: str
        """
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(msrest.serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by this resource provider.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ResourceProviderOperation]
    :ivar next_link: URL to the next set of results, if any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ResourceProviderOperation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of operations supported by this resource provider.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ResourceProviderOperation]
        """
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Scope(msrest.serialization.Model):
    """Scope of the extension. It can be either Cluster or Namespace; but not both.

    :ivar cluster: Specifies that the scope of the extension is Cluster.
    :vartype cluster: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeCluster
    :ivar namespace: Specifies that the scope of the extension is Namespace.
    :vartype namespace: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeNamespace
    """

    _attribute_map = {
        'cluster': {'key': 'cluster', 'type': 'ScopeCluster'},
        'namespace': {'key': 'namespace', 'type': 'ScopeNamespace'},
    }

    def __init__(
        self,
        *,
        cluster: Optional["ScopeCluster"] = None,
        namespace: Optional["ScopeNamespace"] = None,
        **kwargs
    ):
        """
        :keyword cluster: Specifies that the scope of the extension is Cluster.
        :paramtype cluster: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeCluster
        :keyword namespace: Specifies that the scope of the extension is Namespace.
        :paramtype namespace: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ScopeNamespace
        """
        super(Scope, self).__init__(**kwargs)
        self.cluster = cluster
        self.namespace = namespace


class ScopeCluster(msrest.serialization.Model):
    """Specifies that the scope of the extension is Cluster.

    :ivar release_namespace: Namespace where the extension Release must be placed, for a Cluster
     scoped extension.  If this namespace does not exist, it will be created.
    :vartype release_namespace: str
    """

    _attribute_map = {
        'release_namespace': {'key': 'releaseNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        release_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword release_namespace: Namespace where the extension Release must be placed, for a Cluster
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype release_namespace: str
        """
        super(ScopeCluster, self).__init__(**kwargs)
        self.release_namespace = release_namespace


class ScopeNamespace(msrest.serialization.Model):
    """Specifies that the scope of the extension is Namespace.

    :ivar target_namespace: Namespace where the extension will be created for an Namespace scoped
     extension.  If this namespace does not exist, it will be created.
    :vartype target_namespace: str
    """

    _attribute_map = {
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_namespace: Namespace where the extension will be created for an Namespace
         scoped extension.  If this namespace does not exist, it will be created.
        :paramtype target_namespace: str
        """
        super(ScopeNamespace, self).__init__(**kwargs)
        self.target_namespace = target_namespace


class SourceControlConfiguration(ProxyResource):
    """The SourceControl Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SystemData
    :ivar repository_url: Url of the SourceControl Repository.
    :vartype repository_url: str
    :ivar operator_namespace: The namespace to which this operator is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype operator_namespace: str
    :ivar operator_instance_name: Instance name of the operator - identifying the specific
     configuration.
    :vartype operator_instance_name: str
    :ivar operator_type: Type of the operator. Possible values include: "Flux".
    :vartype operator_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.OperatorType
    :ivar operator_params: Any Parameters for the Operator instance in string format.
    :vartype operator_params: str
    :ivar configuration_protected_settings: Name-value pairs of protected configuration settings
     for the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar operator_scope: Scope at which the operator will be installed. Possible values include:
     "cluster", "namespace". Default value: "cluster".
    :vartype operator_scope: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.OperatorScopeType
    :ivar repository_public_key: Public Key associated with this SourceControl configuration
     (either generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH keys
     required to access private Git instances.
    :vartype ssh_known_hosts_contents: str
    :ivar enable_helm_operator: Option to enable Helm Operator for this git configuration.
    :vartype enable_helm_operator: bool
    :ivar helm_operator_properties: Properties for Helm operator.
    :vartype helm_operator_properties:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.HelmOperatorProperties
    :ivar provisioning_state: The provisioning state of the resource provider. Possible values
     include: "Accepted", "Deleting", "Running", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ProvisioningStateType
    :ivar compliance_status: Compliance Status of the Configuration.
    :vartype compliance_status:
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.ComplianceStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'repository_public_key': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'compliance_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'operator_namespace': {'key': 'properties.operatorNamespace', 'type': 'str'},
        'operator_instance_name': {'key': 'properties.operatorInstanceName', 'type': 'str'},
        'operator_type': {'key': 'properties.operatorType', 'type': 'str'},
        'operator_params': {'key': 'properties.operatorParams', 'type': 'str'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'operator_scope': {'key': 'properties.operatorScope', 'type': 'str'},
        'repository_public_key': {'key': 'properties.repositoryPublicKey', 'type': 'str'},
        'ssh_known_hosts_contents': {'key': 'properties.sshKnownHostsContents', 'type': 'str'},
        'enable_helm_operator': {'key': 'properties.enableHelmOperator', 'type': 'bool'},
        'helm_operator_properties': {'key': 'properties.helmOperatorProperties', 'type': 'HelmOperatorProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'compliance_status': {'key': 'properties.complianceStatus', 'type': 'ComplianceStatus'},
    }

    def __init__(
        self,
        *,
        repository_url: Optional[str] = None,
        operator_namespace: Optional[str] = "default",
        operator_instance_name: Optional[str] = None,
        operator_type: Optional[Union[str, "OperatorType"]] = None,
        operator_params: Optional[str] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        operator_scope: Optional[Union[str, "OperatorScopeType"]] = "cluster",
        ssh_known_hosts_contents: Optional[str] = None,
        enable_helm_operator: Optional[bool] = None,
        helm_operator_properties: Optional["HelmOperatorProperties"] = None,
        **kwargs
    ):
        """
        :keyword repository_url: Url of the SourceControl Repository.
        :paramtype repository_url: str
        :keyword operator_namespace: The namespace to which this operator is installed to. Maximum of
         253 lower case alphanumeric characters, hyphen and period only.
        :paramtype operator_namespace: str
        :keyword operator_instance_name: Instance name of the operator - identifying the specific
         configuration.
        :paramtype operator_instance_name: str
        :keyword operator_type: Type of the operator. Possible values include: "Flux".
        :paramtype operator_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.OperatorType
        :keyword operator_params: Any Parameters for the Operator instance in string format.
        :paramtype operator_params: str
        :keyword configuration_protected_settings: Name-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword operator_scope: Scope at which the operator will be installed. Possible values
         include: "cluster", "namespace". Default value: "cluster".
        :paramtype operator_scope: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.OperatorScopeType
        :keyword ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH
         keys required to access private Git instances.
        :paramtype ssh_known_hosts_contents: str
        :keyword enable_helm_operator: Option to enable Helm Operator for this git configuration.
        :paramtype enable_helm_operator: bool
        :keyword helm_operator_properties: Properties for Helm operator.
        :paramtype helm_operator_properties:
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.HelmOperatorProperties
        """
        super(SourceControlConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.repository_url = repository_url
        self.operator_namespace = operator_namespace
        self.operator_instance_name = operator_instance_name
        self.operator_type = operator_type
        self.operator_params = operator_params
        self.configuration_protected_settings = configuration_protected_settings
        self.operator_scope = operator_scope
        self.repository_public_key = None
        self.ssh_known_hosts_contents = ssh_known_hosts_contents
        self.enable_helm_operator = enable_helm_operator
        self.helm_operator_properties = helm_operator_properties
        self.provisioning_state = None
        self.compliance_status = None


class SourceControlConfigurationList(msrest.serialization.Model):
    """Result of the request to list Source Control Configurations.  It contains a list of SourceControlConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Source Control Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.SourceControlConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControlConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SourceControlConfigurationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_03_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
