/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import h.ST_Agattr_s;
import h.ST_Agclos_s;
import h.ST_Agdatadict_s;
import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_Agedgepair_s;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_Agraphinfo_t;
import h.ST_Agsubnode_s;
import h.ST_Agsym_s;
import h.ST_bezier;
import h.ST_dtdata_s;
import h.ST_dthold_s;
import h.ST_path;
import h.ST_pointf;
import h.ST_splines;
import smetana.core.CArrayOfStar;
import smetana.core.CFunction;
import smetana.core.CString;
import smetana.core.Macro;
import smetana.core.UnsupportedStarStruct;
import smetana.core.__ptr__;
import smetana.core.debug.SmetanaDebug;
import smetana.core.jmp_buf;
import smetana.core.size_t;

public class JUtils {
    public static int USHRT_MAX = 65535;

    public static size_t sizeof(Class cl) {
        return new size_t(cl);
    }

    public static size_t sizeof(String name, int sz) {
        throw new UnsupportedOperationException();
    }

    public static int strcmp(CString s1, CString s2) {
        return s1.strcmp(s2);
    }

    public static int strncmp(CString s1, CString s2, int n) {
        return s1.strcmp(s2, n);
    }

    public static CString strstr(CString s1, CString s2) {
        throw new UnsupportedOperationException("s1=" + s1 + " s2=" + s2);
    }

    public static void strncpy(CString destination, CString source, int nb) {
        destination.copyFrom(source, nb);
    }

    public static CString strchr(CString str, char c) {
        return str.strchr(c);
    }

    public static int strtol(CString str, CString[] endptr, int base) {
        if (base != 10) {
            throw new IllegalArgumentException();
        }
        CString end = str;
        int result = Integer.parseInt(end.getContent());
        endptr[0] = end.plus_(("" + result).length());
        return result;
    }

    public static double strtod(CString str, CString[] endptr) {
        double result = Double.parseDouble(str.getContent());
        return result;
    }

    public static double atof(CString str) {
        return Double.parseDouble(str.getContent());
    }

    public static int memcmp(__ptr__ s1, __ptr__ s2, int sz) {
        throw new UnsupportedOperationException("s1=" + s1 + " s2=" + s2 + " sz=" + sz);
    }

    public static void memset(__ptr__ obj, int value, size_t nbytes) {
        if (value != 0) {
            throw new UnsupportedOperationException();
        }
    }

    public static int strlen(CString s) {
        return s.length();
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double atan2(double a, double b) {
        return Math.atan2(a, b);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static boolean isdigit(char c) {
        return Character.isDigit(c);
    }

    public static int atoi(CString s) {
        return Integer.parseInt(s.getContent());
    }

    public static char tolower(char c) {
        return Character.toLowerCase(c);
    }

    public static CString getenv(CString var) {
        return null;
    }

    public static void LOG(String s) {
    }

    public static void LOG2(String s) {
    }

    public static boolean EQ(Object o1, Object o2) {
        boolean result = JUtils.EQ_(o1, o2);
        if (o1 instanceof UnsupportedStarStruct && o2 instanceof UnsupportedStarStruct) {
            UnsupportedStarStruct ooo1 = (UnsupportedStarStruct)o1;
            UnsupportedStarStruct ooo2 = (UnsupportedStarStruct)o2;
            if (ooo1.UID == ooo2.UID != result) {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private static boolean EQ_(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o2 == null && o1 != null) {
            return false;
        }
        if (o1 instanceof CString && o2 instanceof CString) {
            return ((CString)o1).isSameThan((CString)o2);
        }
        if (o1 instanceof CArrayOfStar && o2 instanceof CArrayOfStar) {
            return ((CArrayOfStar)o1).comparePointer_((CArrayOfStar)o2) == 0;
        }
        if (o1 instanceof __ptr__ && o2 instanceof __ptr__) {
            return ((__ptr__)o1).isSameThan((__ptr__)o2);
        }
        System.err.println("o1=" + o1.getClass() + " " + o1);
        System.err.println("o2=" + o2.getClass() + " " + o2);
        throw new UnsupportedOperationException();
    }

    public static boolean NEQ(Object o1, Object o2) {
        return !JUtils.EQ(o1, o2);
    }

    public static void qsort1(CArrayOfStar array, int nb, CFunction compare) {
        boolean change;
        SmetanaDebug.LOG("qsort1 " + nb);
        do {
            change = false;
            for (int i = 0; i < nb - 1; ++i) {
                CArrayOfStar element1 = array.plus_(i);
                CArrayOfStar element2 = array.plus_(i + 1);
                Integer cmp = (Integer)compare.exe(element1, element2);
                if (cmp <= 0) continue;
                change = true;
                array._swap(i, i + 1);
            }
        } while (change);
        SmetanaDebug.LOG("qsort1 ok");
    }

    public static void qsort2(int[] array, int nb, CFunction compare) {
        boolean change;
        SmetanaDebug.LOG("qsort2 " + nb);
        do {
            change = false;
            for (int i = 0; i < nb - 1; ++i) {
                Integer element1 = array[i];
                Integer element2 = array[i + 1];
                Integer cmp = (Integer)compare.exe(element1, element2);
                if (cmp <= 0) continue;
                change = true;
                int tmp = array[i];
                array[i] = array[i + 1];
                array[i + 1] = tmp;
            }
        } while (change);
        SmetanaDebug.LOG("qsort2 ok");
    }

    public static int setjmp(jmp_buf jmp) {
        jmp.saveCallingEnvironment();
        return 0;
    }

    public static void printDebugEdge(ST_Agedge_s e) {
        System.err.println("*********** PRINT EDGE ********** ");
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(e).castTo(ST_Agedgeinfo_t.class);
        ST_splines splines = data.spl;
        ST_bezier list = splines.list.get__(0);
        System.err.println("splines.size=" + splines.size);
        JUtils.printDebugBezier(splines.list.get__(0));
    }

    private static String pointftoString(ST_pointf point) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(point.x);
        sb.append(" ; ");
        sb.append(point.y);
        sb.append(")");
        return sb.toString();
    }

    private static void printDebugBezier(ST_bezier bezier) {
        System.err.println("bezier.size=" + bezier.size);
        System.err.println("bezier.sflag=" + bezier.sflag);
        System.err.println("splines.eflag=" + bezier.eflag);
        System.err.println("bezier.sp=" + JUtils.pointftoString(bezier.sp));
        System.err.println("bezier.ep=" + JUtils.pointftoString(bezier.ep));
        for (int i = 0; i < bezier.size; ++i) {
            ST_pointf pt = bezier.list.get__(i);
            System.err.println("pt=" + JUtils.pointftoString(pt));
        }
    }

    public static __ptr__ create(Class theClass, __ptr__ parent) {
        if (theClass == ST_Agedgepair_s.class) {
            return new ST_Agedgepair_s();
        }
        if (theClass == ST_Agsym_s.class) {
            return new ST_Agsym_s();
        }
        if (theClass == ST_dthold_s.class) {
            return new ST_dthold_s();
        }
        if (theClass == ST_path.class) {
            return new ST_path();
        }
        if (theClass == ST_Agedgeinfo_t.class) {
            return new ST_Agedgeinfo_t();
        }
        if (theClass == ST_Agnodeinfo_t.class) {
            return new ST_Agnodeinfo_t();
        }
        if (theClass == ST_Agraphinfo_t.class) {
            return new ST_Agraphinfo_t();
        }
        if (theClass == ST_Agattr_s.class) {
            return new ST_Agattr_s();
        }
        if (theClass == ST_Agdatadict_s.class) {
            return new ST_Agdatadict_s();
        }
        if (theClass == ST_dtdata_s.class) {
            return new ST_dtdata_s();
        }
        if (theClass == ST_Agraph_s.class) {
            return new ST_Agraph_s();
        }
        if (theClass == ST_Agsubnode_s.class) {
            return new ST_Agsubnode_s();
        }
        if (theClass == ST_Agnode_s.class) {
            return new ST_Agnode_s();
        }
        if (theClass == ST_Agclos_s.class) {
            return new ST_Agclos_s();
        }
        throw new UnsupportedOperationException(theClass.toString());
    }
}

