/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCircleLine
extends Extremity {
    private final Point2D contact;
    private final double angle;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityCircleLine(Point2D p1, double angle) {
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
    }

    @Override
    public void drawU(UGraphic ug) {
        double thickness = ug.getParam().getStroke().getThickness();
        double radius = 4.0 + thickness - 1.0;
        double lineHeight = 4.0 + thickness - 1.0;
        int xWing = 4;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        Point2D.Double middle = new Point2D.Double(0.0, 0.0);
        Point2D.Double base = new Point2D.Double(-4.0 - radius - 3.0, 0.0);
        Point2D.Double circleBase = new Point2D.Double(-4.0 - radius - 3.0, 0.0);
        Point2D.Double lineTop = new Point2D.Double(-4.0, -lineHeight);
        Point2D.Double lineBottom = new Point2D.Double(-4.0, lineHeight);
        rotate.transform(lineTop, lineTop);
        rotate.transform(lineBottom, lineBottom);
        rotate.transform(base, base);
        rotate.transform(circleBase, circleBase);
        ExtremityCircleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
        UStroke stroke = new UStroke(thickness);
        ug.apply(new UTranslate(this.contact.getX() + ((Point2D)circleBase).getX() - radius, this.contact.getY() + ((Point2D)circleBase).getY() - radius)).apply(stroke).draw(new UEllipse(2.0 * radius, 2.0 * radius));
        ExtremityCircleLine.drawLine(ug.apply(stroke), this.contact.getX(), this.contact.getY(), lineTop, lineBottom);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

